/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.template.java;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.text.templates.Template;

public enum CodeSnippetTemplate {
    SYSOUT("org.eclipse.jdt.ls.templates.sysout", "java-statements", "System.out.println($${0});", "print to standard out"),
    SYSERR("org.eclipse.jdt.ls.templates.syserr", "java-statements", "System.err.println($${0});", "print to standard err"),
    SYSTRACE("org.eclipse.jdt.ls.templates.systrace", "java-statements", "System.out.println(\"${enclosing_type}.${enclosing_method}()\");", "print current method to standard out"),
    FOREACH("org.eclipse.jdt.ls.templates.for_array", "java-statements", "for ($${1:${iterable_type}} $${2:${iterable_element}} : $${3:${iterable}}) {\n\t$$TM_SELECTED_TEXT$${0}\n}", "iterate over an array or Iterable"),
    FORI("org.eclipse.jdt.ls.templates.for_iterable", "java-statements", "for ($${1:int} $${2:${index}} = $${3:0}; $${2:${index}} < $${4:${array}.length}; $${2:${index}}++) {\n\t$$TM_SELECTED_TEXT$${0}\n}", "iterate over array"),
    WHILE("org.eclipse.jdt.ls.templates.while_condition", "java-statements", "while ($${1:${condition:var(boolean)}}) {\n\t$$TM_SELECTED_TEXT$${0}\n}", "while statement"),
    DOWHILE("org.eclipse.jdt.ls.templates.do", "java-statements", "do {\n\t$$TM_SELECTED_TEXT$${0}\n} while ($${1:${condition:var(boolean)}});", "do-while statement"),
    IF("org.eclipse.jdt.ls.templates.if", "java-statements", "if ($${1:${condition:var(boolean)}}) {\n\t$$TM_SELECTED_TEXT$${0}\n}", "if statement"),
    IFELSE("org.eclipse.jdt.ls.templates.ifelse", "java-statements", "if ($${1:${condition:var(boolean)}}) {\n\t$${2}\n} else {\n\t$${0}\n}", "if-else statement"),
    IFNULL("org.eclipse.jdt.ls.templates.ifnull", "java-statements", "if ($${1:${name:var}} == null) {\n\t$$TM_SELECTED_TEXT$${0}\n}", "if statement checking for null"),
    IFNOTNULL("org.eclipse.jdt.ls.templates.ifnotnull", "java-statements", "if ($${1:${name:var}} != null) {\n\t$$TM_SELECTED_TEXT$${0}\n}", "if statement checking for not null"),
    SWITCH("org.eclipse.jdt.ls.templates.switch", "java-statements", "switch ($${1:${key:var}}) {\n\tcase $${2:value}:\n\t\t$${0}\n\t\tbreak;\n\n\tdefault:\n\t\tbreak;\n}", "switch statement"),
    TRY_CATCH("org.eclipse.jdt.ls.templates.trycatch", "java-statements", "try {\n\t$$TM_SELECTED_TEXT$${1}\n} catch ($${2:Exception} $${3:e}) {\n\t$${0}// TODO: handle exception\n}", "try/catch block"),
    TRY_RESOURCES("org.eclipse.jdt.ls.templates.tryresources", "java-statements", "try ($${1}) {\n\t$$TM_SELECTED_TEXT$${2}\n} catch ($${3:Exception} $${4:e}) {\n\t$${0}// TODO: handle exception\n}", "try/catch block with resources"),
    CTOR("org.eclipse.jdt.ls.templates.ctor", "java-members", "$${1|public,protected,private|} ${enclosing_simple_type}($${2}) {\n\t$${3:super();}$${0}\n}", "constructor"),
    METHOD("org.eclipse.jdt.ls.templates.method", "java-members", "$${1|public,protected,private|}$${2| , static |}$${3:void} $${4:name}($${5}) {\n\t$${0}\n}", "method"),
    STATIC_METHOD("org.eclipse.jdt.ls.templates.staticmethod", "java-members", "$${1|public,private|} static $${2:void} $${3:name}($${4}) {\n\t$${0}\n}", "static method"),
    FIELD("org.eclipse.jdt.ls.templates.field", "java-members", "$${1|public,protected,private|} $${2:String} $${3:name};", "field"),
    MAIN("org.eclipse.jdt.ls.templates.main", "java-members", "public static void main(String[] args) {\n\t$${0}\n}", "public static main method"),
    NEW("org.eclipse.jdt.ls.templates.new", "java", "$${1:Object} $${2:foo} = new $${1}($${3});\n$${0}", "create new object"),
    SOUT("org.eclipse.jdt.ls.templates.sout", "java-statements", "System.out.println($${0});", "print to standard out"),
    SERR("org.eclipse.jdt.ls.templates.serr", "java-statements", "System.err.println($${0});", "print to standard err"),
    SOUTM("org.eclipse.jdt.ls.templates.soutm", "java-statements", "System.out.println(\"${enclosing_type}.${enclosing_method}()\");", "print current method to standard out"),
    ITER("org.eclipse.jdt.ls.templates.iter", "java-statements", "for ($${1:${iterable_type}} $${2:${iterable_element}} : $${3:${iterable}}) {\n\t$$TM_SELECTED_TEXT$${0}\n}", "iterate over an array or Iterable"),
    PSVM("org.eclipse.jdt.ls.templates.psvm", "java-members", "public static void main(String[] args) {\n\t$${0}\n}", "public static main method"),
    SYS_OUT("org.eclipse.jdt.ls.templates.sys_out", "System.out.println()", "java-statements", "System.out.println($${0});", "print to standard out"),
    SYS_ERR("org.eclipse.jdt.ls.templates.sys_err", "System.err.println()", "java-statements", "System.err.println($${0});", "print to standard err"),
    PUBLIC_MAIN("org.eclipse.jdt.ls.templates.publicmain", "public static void main(String[] args)", "java-members", "public static void main(String[] args) {\n\t$${0}\n}", "public static main method");

    private final String templateId;
    private final String contextType;
    private final String defaultContent;
    private final String description;
    private String displayName = null;

    private CodeSnippetTemplate(String templatesId, String contextType, String defaultContent, String description) {
        this.templateId = templatesId;
        this.contextType = contextType;
        this.defaultContent = defaultContent;
        this.description = description;
    }

    private CodeSnippetTemplate(String templatesId, String displayName, String contextType, String defaultContent, String description) {
        this(templatesId, contextType, defaultContent, description);
        this.displayName = displayName;
    }

    public Template createTemplate() {
        return new Template(this.getDisplayName(), this.description, this.contextType, this.defaultContent, false);
    }

    public String getId() {
        return this.templateId;
    }

    public String getDisplayName() {
        return StringUtils.isNotBlank((CharSequence)this.displayName) ? this.displayName : this.name().toLowerCase();
    }
}

