/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader.buddy;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.buddy.IBuddyPolicy;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.FrameworkWiring;

public class GlobalPolicy
implements IBuddyPolicy {
    private FrameworkWiring frameworkWiring;

    public GlobalPolicy(FrameworkWiring frameworkWiring) {
        this.frameworkWiring = frameworkWiring;
    }

    @Override
    public Class<?> loadClass(String name) {
        return this.getExportingBundles(BundleLoader.getPackageName(name)).stream().findFirst().map(b -> b.findClassNoParentNoException(name)).orElse(null);
    }

    @Override
    public URL loadResource(String name) {
        return this.getExportingBundles(BundleLoader.getResourcePackageName(name)).stream().findFirst().map(b -> b.findResource(name)).orElse(null);
    }

    @Override
    public Enumeration<URL> loadResources(String name) {
        Enumeration<URL> results = null;
        Collection<BundleLoader> exporters = this.getExportingBundles(name);
        for (BundleLoader exporter : exporters) {
            try {
                results = BundleLoader.compoundEnumerations(results, exporter.findResources(name));
            }
            catch (IOException iOException) {}
        }
        return results;
    }

    private Collection<BundleLoader> getExportingBundles(String pkgName) {
        ArrayList<BundleLoader> result = new ArrayList<BundleLoader>();
        String filter = "(osgi.wiring.package=" + pkgName + ")";
        Map<String, String> directives = Collections.singletonMap("filter", filter);
        Map<String, Boolean> attributes = Collections.singletonMap("org.eclipse.osgi.container.synthetic", Boolean.TRUE);
        Collection<BundleCapability> packages = this.frameworkWiring.findProviders(ModuleContainer.createRequirement("osgi.wiring.package", directives, attributes));
        for (BundleCapability pkg : packages) {
            ModuleWiring wiring = (ModuleWiring)pkg.getRevision().getWiring();
            if (wiring == null) continue;
            if ((pkg.getRevision().getTypes() & 1) != 0) {
                if (wiring == null) continue;
                for (ModuleWire hostWire : wiring.getRequiredModuleWires("osgi.wiring.host")) {
                    result.add((BundleLoader)hostWire.getProviderWiring().getModuleLoader());
                }
                continue;
            }
            result.add((BundleLoader)wiring.getModuleLoader());
        }
        return result;
    }
}

