/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core;

import ch.epfl.scala.bsp4j.BuildClient;
import com.microsoft.java.bs.core.internal.gradle.GradleApiConnector;
import com.microsoft.java.bs.core.internal.log.LogHandler;
import com.microsoft.java.bs.core.internal.log.TelemetryHandler;
import com.microsoft.java.bs.core.internal.managers.BuildTargetManager;
import com.microsoft.java.bs.core.internal.managers.PreferenceManager;
import com.microsoft.java.bs.core.internal.server.GradleBuildServer;
import com.microsoft.java.bs.core.internal.services.BuildTargetService;
import com.microsoft.java.bs.core.internal.services.LifecycleService;
import com.microsoft.java.bs.core.internal.transport.NamedPipeStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.jsonrpc.Launcher;

public class Launcher {
    public static final Logger LOGGER = Logger.getLogger("GradleBuildServerLogger");
    public static final String PROP_PLUGIN_DIR = "plugin.dir";

    public static void main(String[] args) {
        Launcher.checkRequiredProperties();
        Map<String, String> params = Launcher.parseArgs(args);
        String pipePath = params.get("pipe");
        org.eclipse.lsp4j.jsonrpc.Launcher<BuildClient> launcher = StringUtils.isNotBlank((CharSequence)pipePath) ? Launcher.createLauncherUsingPipe(pipePath) : Launcher.createLauncherUsingStdIo();
        Launcher.setupLoggers((BuildClient)launcher.getRemoteProxy());
        launcher.startListening();
    }

    private static org.eclipse.lsp4j.jsonrpc.Launcher<BuildClient> createLauncherUsingPipe(String pipePath) {
        NamedPipeStream pipeStream = new NamedPipeStream(pipePath);
        try {
            return Launcher.createLauncher(pipeStream.getOutputStream(), pipeStream.getInputStream());
        }
        catch (IOException e) {
            throw new IllegalStateException("Error initializing the named pipe", e);
        }
    }

    private static org.eclipse.lsp4j.jsonrpc.Launcher<BuildClient> createLauncherUsingStdIo() {
        return Launcher.createLauncher(System.out, System.in);
    }

    private static org.eclipse.lsp4j.jsonrpc.Launcher<BuildClient> createLauncher(OutputStream outputStream, InputStream inputStream) {
        BuildTargetManager buildTargetManager = new BuildTargetManager();
        PreferenceManager preferenceManager = new PreferenceManager();
        GradleApiConnector connector = new GradleApiConnector(preferenceManager);
        LifecycleService lifecycleService = new LifecycleService(connector, preferenceManager);
        BuildTargetService buildTargetService = new BuildTargetService(buildTargetManager, connector, preferenceManager);
        GradleBuildServer gradleBuildServer = new GradleBuildServer(lifecycleService, buildTargetService);
        org.eclipse.lsp4j.jsonrpc.Launcher launcher = new Launcher.Builder().setOutput(outputStream).setInput(inputStream).setLocalService((Object)gradleBuildServer).setRemoteInterface(BuildClient.class).setExecutorService(Executors.newCachedThreadPool()).create();
        BuildClient client = (BuildClient)launcher.getRemoteProxy();
        lifecycleService.setClient(client);
        buildTargetService.setClient(client);
        return launcher;
    }

    private static void checkRequiredProperties() {
        if (System.getProperty(PROP_PLUGIN_DIR) == null) {
            throw new IllegalStateException("The property 'plugin.dir' is not set");
        }
    }

    private static void setupLoggers(BuildClient client) {
        LOGGER.setUseParentHandlers(false);
        LogHandler logHandler = new LogHandler(client);
        logHandler.setLevel(Level.FINE);
        LOGGER.addHandler(logHandler);
        if (System.getProperty("disableServerTelemetry") == null) {
            TelemetryHandler telemetryHandler = new TelemetryHandler(client);
            telemetryHandler.setLevel(Level.INFO);
            LOGGER.addHandler(telemetryHandler);
        }
    }

    public static Map<String, String> parseArgs(String[] args) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String arg : args) {
            int index;
            if (!arg.startsWith("--") || (index = arg.indexOf(61)) == -1) continue;
            String key = arg.substring(2, index);
            String value = arg.substring(index + 1);
            paramMap.put(key, value);
        }
        return paramMap;
    }
}

