/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.RefactoringScanner;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

class TextMatchUpdater {
    private static final String TEXT_EDIT_LABEL = RefactoringCoreMessages.TextMatchUpdater_update;
    private static final GroupCategorySet TEXTUAL_MATCHES = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.textualMatches", RefactoringCoreMessages.TextMatchUpdater_textualMatches_name, RefactoringCoreMessages.TextMatchUpdater_textualMatches_description));
    private final IJavaSearchScope fScope;
    private final TextChangeManager fManager;
    private final SearchResultGroup[] fReferences;
    private final boolean fOnlyQualified;
    private final RefactoringScanner fScanner;
    private final String fNewName;
    private final int fCurrentNameLength;

    private TextMatchUpdater(TextChangeManager manager, IJavaSearchScope scope, String currentName, String currentQualifier, String newName, SearchResultGroup[] references, boolean onlyQualified) {
        Assert.isNotNull((Object)manager);
        Assert.isNotNull((Object)scope);
        Assert.isNotNull((Object)references);
        this.fManager = manager;
        this.fScope = scope;
        this.fReferences = references;
        this.fOnlyQualified = onlyQualified;
        this.fNewName = newName;
        this.fCurrentNameLength = currentName.length();
        this.fScanner = new RefactoringScanner(currentName, currentQualifier);
    }

    static void perform(IProgressMonitor pm, IJavaSearchScope scope, String currentName, String currentQualifier, String newName, TextChangeManager manager, SearchResultGroup[] references, boolean onlyQualified) throws JavaModelException {
        new TextMatchUpdater(manager, scope, currentName, currentQualifier, newName, references, onlyQualified).updateTextMatches(pm);
    }

    static void perform(IProgressMonitor pm, IJavaSearchScope scope, ITextUpdating processor, TextChangeManager manager, SearchResultGroup[] references) throws JavaModelException {
        new TextMatchUpdater(manager, scope, processor.getCurrentElementName(), processor.getCurrentElementQualifier(), processor.getNewElementName(), references, false).updateTextMatches(pm);
    }

    private void updateTextMatches(IProgressMonitor pm) throws JavaModelException {
        try {
            IProject[] projectsInScope = this.getProjectsInScope();
            pm.beginTask("", projectsInScope.length);
            IProject[] iProjectArray = projectsInScope;
            int n = projectsInScope.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.addTextMatches((IResource)project, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                ++n2;
            }
        }
        finally {
            pm.done();
        }
    }

    private IProject[] getProjectsInScope() {
        IPath[] enclosingProjects = this.fScope.enclosingProjectsAndJars();
        HashSet<IPath> enclosingProjectSet = new HashSet<IPath>(Arrays.asList(enclosingProjects));
        ArrayList<IProject> projectsInScope = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (enclosingProjectSet.contains(project.getFullPath())) {
                projectsInScope.add(project);
            }
            ++n2;
        }
        return projectsInScope.toArray(new IProject[projectsInScope.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private void addTextMatches(IResource resource, IProgressMonitor pm) throws JavaModelException {
        block15: {
            try {
                task = RefactoringCoreMessages.TextMatchUpdater_searching + String.valueOf(resource.getFullPath());
                if (!(resource instanceof IFile)) ** GOTO lbl14
                element = JavaCore.create((IResource)resource);
                if (!(element instanceof ICompilationUnit)) {
                    return;
                }
                if (!element.exists()) {
                    return;
                }
                if (!this.fScope.encloses(element)) {
                    return;
                }
                try {
                    this.addCuTextMatches((ICompilationUnit)element);
                    break block15;
lbl14:
                    // 1 sources

                    if (resource instanceof IContainer) {
                        members = ((IContainer)resource).members();
                        pm.beginTask(task, members.length);
                        pm.subTask(task);
                        var8_8 = members;
                        var7_9 = members.length;
                        var6_10 = 0;
                        while (var6_10 < var7_9) {
                            member = var8_8[var6_10];
                            if (pm.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            this.addTextMatches(member, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                            ++var6_10;
                        }
                    }
                }
                catch (JavaModelException e) {
                    throw e;
                }
                catch (CoreException e) {
                    throw new JavaModelException(e);
                }
            }
            finally {
                pm.done();
            }
        }
    }

    private void addCuTextMatches(ICompilationUnit cu) throws JavaModelException {
        this.fScanner.scan(cu);
        Set<RefactoringScanner.TextMatch> matches = this.fScanner.getMatches();
        if (matches.isEmpty()) {
            return;
        }
        this.removeReferences(cu, matches);
        if (!matches.isEmpty()) {
            this.addTextUpdates(cu, matches);
        }
    }

    private void removeReferences(ICompilationUnit cu, Set<RefactoringScanner.TextMatch> matches) {
        SearchResultGroup[] searchResultGroupArray = this.fReferences;
        int n = this.fReferences.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup group = searchResultGroupArray[n2];
            if (cu.equals(group.getCompilationUnit())) {
                this.removeReferences(matches, group);
            }
            ++n2;
        }
    }

    private void removeReferences(Set<RefactoringScanner.TextMatch> matches, SearchResultGroup group) {
        SearchMatch[] searchMatchArray = group.getSearchResults();
        int n = searchMatchArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchMatch searchResult = searchMatchArray[n2];
            int unqualifiedStart = searchResult.getOffset() + searchResult.getLength() - this.fCurrentNameLength;
            Iterator<RefactoringScanner.TextMatch> iter = matches.iterator();
            while (iter.hasNext()) {
                RefactoringScanner.TextMatch element = iter.next();
                if (element.getStartPosition() != unqualifiedStart) continue;
                iter.remove();
            }
            ++n2;
        }
    }

    private void addTextUpdates(ICompilationUnit cu, Set<RefactoringScanner.TextMatch> matches) {
        for (RefactoringScanner.TextMatch match : matches) {
            if (!match.isQualified() && this.fOnlyQualified) continue;
            int matchStart = match.getStartPosition();
            ReplaceEdit edit = new ReplaceEdit(matchStart, this.fCurrentNameLength, this.fNewName);
            try {
                TextChangeCompatibility.addTextEdit((TextChange)this.fManager.get(cu), (String)TEXT_EDIT_LABEL, (TextEdit)edit, (GroupCategorySet)TEXTUAL_MATCHES);
            }
            catch (MalformedTreeException malformedTreeException) {
                // empty catch block
            }
        }
    }
}

