/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.semantictokens;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExportsDirective;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.ModulePackageAccess;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.OpensDirective;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.internal.core.dom.util.DOMASTUtil;
import org.eclipse.jdt.ls.core.internal.semantictokens.TokenModifier;
import org.eclipse.jdt.ls.core.internal.semantictokens.TokenType;
import org.eclipse.lsp4j.SemanticTokens;

public class SemanticTokensVisitor
extends ASTVisitor {
    private CompilationUnit cu;
    private final IScanner scanner;
    private List<SemanticToken> tokens;
    private int staticModifiers = 0;

    public SemanticTokensVisitor(CompilationUnit cu) {
        super(true);
        this.cu = cu;
        this.scanner = this.createScanner(cu);
        this.tokens = new ArrayList<SemanticToken>();
    }

    public SemanticTokens getSemanticTokens() {
        return new SemanticTokens(this.encodedTokens());
    }

    private List<Integer> encodedTokens() {
        int numTokens = this.tokens.size();
        ArrayList<Integer> data = new ArrayList<Integer>(numTokens * 5);
        int currentLine = 0;
        int currentColumn = 0;
        int i = 0;
        while (i < numTokens) {
            SemanticToken token = this.tokens.get(i);
            int line = this.cu.getLineNumber(token.getOffset()) - 1;
            int column = this.cu.getColumnNumber(token.getOffset());
            int deltaLine = line - currentLine;
            if (deltaLine != 0) {
                currentLine = line;
                currentColumn = 0;
            }
            int deltaColumn = column - currentColumn;
            currentColumn = column;
            if (deltaLine != 0 || deltaColumn != 0) {
                int tokenTypeIndex = token.getTokenType().ordinal();
                int tokenModifiers = token.getTokenModifiers();
                data.add(deltaLine);
                data.add(deltaColumn);
                data.add(token.getLength());
                data.add(tokenTypeIndex);
                data.add(tokenModifiers);
            }
            ++i;
        }
        return data;
    }

    private void addToken(int offset, int length, TokenType tokenType, int modifiers) {
        this.tokens.add(new SemanticToken(offset, length, tokenType, modifiers | this.staticModifiers));
    }

    private void addToken(ASTNode node, TokenType tokenType, int modifiers) {
        this.addToken(node.getStartPosition(), node.getLength(), tokenType, modifiers);
    }

    private void addToken(ASTNode node, TokenType tokenType) {
        this.addToken(node, tokenType, 0);
    }

    public boolean visit(TypeLiteral node) {
        this.acceptNode((ASTNode)node.getType());
        if (node.getLength() == node.getType().getLength() + 6) {
            int offset = node.getStartPosition() + node.getLength() - 5;
            this.addToken(offset, 5, TokenType.KEYWORD, 0);
        }
        return false;
    }

    public boolean visit(Javadoc node) {
        this.staticModifiers |= TokenModifier.DOCUMENTATION.bitmask;
        return super.visit(node);
    }

    public void endVisit(Javadoc node) {
        this.staticModifiers &= TokenModifier.DOCUMENTATION.inverseBitmask;
        super.endVisit(node);
    }

    public boolean visit(TagElement node) {
        if (node.getTagName() != null) {
            int offset = node.isNested() ? node.getStartPosition() + 1 : node.getStartPosition();
            this.addToken(offset, node.getTagName().length(), TokenType.KEYWORD, 0);
        }
        this.acceptNodeList(node.fragments());
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        this.acceptNode((ASTNode)node.getJavadoc());
        this.acceptNodeList(node.annotations());
        this.addTokenToSimpleNamesOfName(node.getName(), TokenType.NAMESPACE);
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        this.staticModifiers |= TokenModifier.IMPORT_DECLARATION.bitmask;
        IBinding binding = node.resolveBinding();
        if (binding == null || binding instanceof IPackageBinding) {
            this.addTokenToSimpleNamesOfName(node.getName(), TokenType.NAMESPACE);
        } else {
            this.nonPackageNameOfImportDeclarationVisitor(node.getName());
        }
        this.staticModifiers &= TokenModifier.IMPORT_DECLARATION.inverseBitmask;
        return false;
    }

    private void nonPackageNameOfImportDeclarationVisitor(Name nonPackageName) {
        if (nonPackageName instanceof SimpleName) {
            nonPackageName.accept((ASTVisitor)this);
        } else {
            QualifiedName qualifiedName = (QualifiedName)nonPackageName;
            Name qualifier = qualifiedName.getQualifier();
            if (this.hasPackageQualifier(qualifiedName)) {
                this.addTokenToSimpleNamesOfName(qualifier, TokenType.NAMESPACE);
            } else {
                this.nonPackageNameOfImportDeclarationVisitor(qualifier);
            }
            qualifiedName.getName().accept((ASTVisitor)this);
        }
    }

    private boolean hasPackageQualifier(QualifiedName qualifiedName) {
        IBinding qualifierBinding = qualifiedName.getQualifier().resolveBinding();
        if (qualifierBinding != null) {
            return qualifierBinding instanceof IPackageBinding;
        }
        IBinding binding = qualifiedName.resolveBinding();
        return binding instanceof IPackageBinding || binding instanceof ITypeBinding;
    }

    public boolean visit(Modifier node) {
        this.addToken((ASTNode)node, TokenType.MODIFIER);
        return false;
    }

    public boolean visit(SimpleName node) {
        IBinding binding = node.resolveBinding();
        TokenType tokenType = TokenType.getApplicableType(binding);
        if (tokenType != null) {
            int modifiers = TokenModifier.checkJavaModifiers(binding) | TokenModifier.checkConstructor(binding) | TokenModifier.checkGeneric(binding) | TokenModifier.checkDeclaration(node);
            this.addToken((ASTNode)node, tokenType, modifiers);
        }
        return false;
    }

    public boolean visit(ModuleDeclaration node) {
        this.acceptJavdocOfModuleDeclaration(node);
        this.acceptNodeList(node.annotations());
        this.addTokenToSimpleNamesOfName(node.getName(), TokenType.NAMESPACE);
        this.acceptNodeList(node.moduleStatements());
        return false;
    }

    private void acceptJavdocOfModuleDeclaration(ModuleDeclaration moduleDeclaration) {
        for (Comment comment : this.castNodeList(this.cu.getCommentList())) {
            if (comment.getStartPosition() != moduleDeclaration.getStartPosition()) continue;
            comment.accept((ASTVisitor)this);
            break;
        }
    }

    public boolean visit(RequiresDirective node) {
        this.addTokenToSimpleNamesOfName(node.getName(), TokenType.NAMESPACE);
        return false;
    }

    public boolean visit(ExportsDirective node) {
        this.modulePackageAccessVisitor((ModulePackageAccess)node);
        return false;
    }

    public boolean visit(OpensDirective node) {
        this.modulePackageAccessVisitor((ModulePackageAccess)node);
        return false;
    }

    private void modulePackageAccessVisitor(ModulePackageAccess modulePackageAccess) {
        this.acceptNode((ASTNode)modulePackageAccess.getName());
        this.visitNodeList(modulePackageAccess.modules(), module -> this.addTokenToSimpleNamesOfName((Name)module, TokenType.NAMESPACE));
    }

    public boolean visit(ParameterizedType node) {
        this.acceptNode((ASTNode)node.getType());
        this.visitNodeList(node.typeArguments(), this::typeArgumentVisitor);
        return false;
    }

    public boolean visit(MethodInvocation node) {
        this.acceptNode((ASTNode)node.getExpression());
        this.visitNodeList(node.typeArguments(), this::typeArgumentVisitor);
        this.acceptNode((ASTNode)node.getName());
        this.acceptNodeList(node.arguments());
        return false;
    }

    private void typeArgumentVisitor(Type typeArgument) {
        this.visitSimpleNameOfType(typeArgument, simpleName -> {
            IBinding binding = simpleName.resolveBinding();
            TokenType tokenType = TokenType.getApplicableType(binding);
            if (tokenType != null) {
                int modifiers = TokenModifier.checkJavaModifiers(binding) | TokenModifier.checkGeneric(binding) | TokenModifier.TYPE_ARGUMENT.bitmask;
                this.addToken(simpleName, tokenType, modifiers);
            }
        });
    }

    public boolean visit(ClassInstanceCreation node) {
        this.acceptNode((ASTNode)node.getExpression());
        this.visitNodeList(node.typeArguments(), this::typeArgumentVisitor);
        this.visitSimpleNameOfType(node.getType(), simpleName -> {
            TokenType tokenType = TokenType.getApplicableType((IBinding)node.resolveTypeBinding());
            if (tokenType != null) {
                IMethodBinding constructorBinding = node.resolveConstructorBinding();
                int modifiers = TokenModifier.checkJavaModifiers((IBinding)constructorBinding) | TokenModifier.checkGeneric((IBinding)constructorBinding) | TokenModifier.CONSTRUCTOR.bitmask;
                this.addToken(simpleName, tokenType, modifiers);
            }
        });
        this.acceptNodeList(node.arguments());
        this.acceptNode((ASTNode)node.getAnonymousClassDeclaration());
        return false;
    }

    public boolean visit(RecordDeclaration node) {
        this.acceptNode((ASTNode)node.getJavadoc());
        this.acceptNodeList(node.modifiers());
        this.addToken(node.getRestrictedIdentifierStartPosition(), 6, TokenType.MODIFIER, 0);
        this.acceptNode((ASTNode)node.getName());
        this.acceptNodeList(node.typeParameters());
        this.acceptNodeList(node.recordComponents());
        this.acceptNodeList(node.superInterfaceTypes());
        this.acceptNodeList(node.bodyDeclarations());
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        this.acceptNode((ASTNode)node.getJavadoc());
        this.acceptNodeList(node.modifiers());
        this.tokenizeGapBeforeTypeDeclarationName(node, (scannerToken, tokenOffset, tokenLength) -> {
            switch (scannerToken) {
                case 165: 
                case 180: {
                    this.addToken(tokenOffset, tokenLength, TokenType.MODIFIER, 0);
                    break;
                }
            }
        });
        this.acceptNode((ASTNode)node.getName());
        this.acceptNodeList(node.typeParameters());
        this.acceptNode((ASTNode)node.getSuperclassType());
        this.acceptNodeList(node.superInterfaceTypes());
        this.acceptNodeList(node.bodyDeclarations());
        if (DOMASTUtil.isFeatureSupportedinAST((AST)this.cu.getAST(), (int)512)) {
            this.acceptNodeList(node.permittedTypes());
        }
        return false;
    }

    private IScanner createScanner(CompilationUnit cu) {
        String source;
        ITypeRoot typeRoot = cu.getTypeRoot();
        if (typeRoot == null) {
            return null;
        }
        IJavaProject javaProject = typeRoot.getJavaProject();
        if (javaProject == null) {
            return null;
        }
        try {
            source = typeRoot.getSource();
        }
        catch (JavaModelException e) {
            return null;
        }
        if (source == null) {
            return null;
        }
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        boolean enablePreview = "enabled".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", true));
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)sourceLevel, (String)complianceLevel, (boolean)enablePreview);
        scanner.setSource(source.toCharArray());
        return scanner;
    }

    private int getNextValidToken(IScanner scanner) {
        while (true) {
            try {
                return scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                continue;
            }
            break;
        }
    }

    private void tokenizeWithScanner(int startPosition, int endPosition, ScannerTokenVisitor tokenVisitor) {
        if (this.scanner == null) {
            return;
        }
        this.scanner.resetTo(startPosition, endPosition - 1);
        int token = this.getNextValidToken(this.scanner);
        while (token != 158) {
            int tokenOffset = this.scanner.getCurrentTokenStartPosition();
            int tokenLength = this.scanner.getCurrentTokenEndPosition() - tokenOffset + 1;
            tokenVisitor.visit(token, tokenOffset, tokenLength);
            token = this.getNextValidToken(this.scanner);
        }
    }

    private void tokenizeGapBeforeTypeDeclarationName(TypeDeclaration typeDeclaration, ScannerTokenVisitor tokenVisitor) {
        int gapBeforeNameStart = this.getEndPosition(typeDeclaration.modifiers());
        if (gapBeforeNameStart == -1) {
            gapBeforeNameStart = this.getEndPosition((ASTNode)typeDeclaration.getJavadoc());
        }
        if (gapBeforeNameStart == -1) {
            gapBeforeNameStart = typeDeclaration.getStartPosition();
        }
        int gapBeforeNameEnd = typeDeclaration.getName().getStartPosition();
        this.tokenizeWithScanner(gapBeforeNameStart, gapBeforeNameEnd, tokenVisitor);
    }

    private <T extends ASTNode> List<T> castNodeList(List<?> nodeList) {
        return nodeList;
    }

    private <T extends ASTNode> void visitNodeList(List<?> nodeList, NodeVisitor<T> visitor) {
        if (nodeList != null) {
            for (ASTNode node : this.castNodeList(nodeList)) {
                visitor.visit(node);
            }
        }
    }

    private void acceptNodeList(List<?> nodeList) {
        if (nodeList != null) {
            for (ASTNode node : this.castNodeList(nodeList)) {
                node.accept((ASTVisitor)this);
            }
        }
    }

    private void acceptNode(ASTNode node) {
        if (node != null) {
            node.accept((ASTVisitor)this);
        }
    }

    private int getEndPosition(List<?> nodeList) {
        if (nodeList != null && !nodeList.isEmpty()) {
            ASTNode lastNode = (ASTNode)nodeList.get(nodeList.size() - 1);
            return lastNode.getStartPosition() + lastNode.getLength();
        }
        return -1;
    }

    private int getEndPosition(ASTNode node) {
        if (node != null) {
            return node.getStartPosition() + node.getLength();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private void visitSimpleNamesOfName(Name name, NodeVisitor<SimpleName> visitor) {
        if (name == null) {
            return;
        }
        Name name2 = name;
        if (name2 instanceof SimpleName) {
            void simpleName;
            SimpleName simpleName2 = (SimpleName)name2;
            SimpleName cfr_ignored_0 = (SimpleName)name2;
            visitor.visit((SimpleName)simpleName);
        } else {
            Name name3 = name;
            if (name3 instanceof QualifiedName) {
                void qualifiedName;
                QualifiedName qualifiedName2 = (QualifiedName)name3;
                QualifiedName cfr_ignored_1 = (QualifiedName)name3;
                this.visitSimpleNamesOfName(qualifiedName.getQualifier(), visitor);
                visitor.visit(qualifiedName.getName());
            }
        }
    }

    private void addTokenToSimpleNamesOfName(Name name, TokenType tokenType) {
        this.visitSimpleNamesOfName(name, simpleName -> this.addToken(simpleName, tokenType));
    }

    /*
     * WARNING - void declaration
     */
    private void visitSimpleNameOfType(Type type, NodeVisitor<SimpleName> visitor) {
        if (type == null) {
            return;
        }
        Type type2 = type;
        if (type2 instanceof SimpleType) {
            Name simpleTypeName;
            void simpleType;
            SimpleType simpleType2 = (SimpleType)type2;
            SimpleType cfr_ignored_0 = (SimpleType)type2;
            this.acceptNodeList(simpleType.annotations());
            Name name = simpleTypeName = simpleType.getName();
            if (name instanceof SimpleName) {
                void simpleName;
                SimpleName simpleName2 = (SimpleName)name;
                SimpleName cfr_ignored_1 = (SimpleName)name;
                visitor.visit((SimpleName)simpleName);
            } else {
                Name name2 = simpleTypeName;
                if (name2 instanceof QualifiedName) {
                    void qualifiedName;
                    QualifiedName qualifiedName2 = (QualifiedName)name2;
                    QualifiedName cfr_ignored_2 = (QualifiedName)name2;
                    qualifiedName.getQualifier().accept((ASTVisitor)this);
                    visitor.visit(qualifiedName.getName());
                }
            }
        } else {
            Type type3 = type;
            if (type3 instanceof QualifiedType) {
                void qualifiedType;
                QualifiedType simpleTypeName = (QualifiedType)type3;
                QualifiedType cfr_ignored_3 = (QualifiedType)type3;
                qualifiedType.getQualifier().accept((ASTVisitor)this);
                this.acceptNodeList(qualifiedType.annotations());
                visitor.visit(qualifiedType.getName());
            } else {
                Type type4 = type;
                if (type4 instanceof NameQualifiedType) {
                    void nameQualifiedType;
                    NameQualifiedType nameQualifiedType2 = (NameQualifiedType)type4;
                    NameQualifiedType cfr_ignored_4 = (NameQualifiedType)type4;
                    nameQualifiedType.getQualifier().accept((ASTVisitor)this);
                    this.acceptNodeList(nameQualifiedType.annotations());
                    visitor.visit(nameQualifiedType.getName());
                } else {
                    Type type5 = type;
                    if (type5 instanceof ParameterizedType) {
                        void parameterizedType;
                        ParameterizedType parameterizedType2 = (ParameterizedType)type5;
                        ParameterizedType cfr_ignored_5 = (ParameterizedType)type5;
                        this.visitSimpleNameOfType(parameterizedType.getType(), visitor);
                        this.visitNodeList(parameterizedType.typeArguments(), this::typeArgumentVisitor);
                    } else {
                        type.accept((ASTVisitor)this);
                    }
                }
            }
        }
    }

    @FunctionalInterface
    private static interface NodeVisitor<T extends ASTNode> {
        public void visit(T var1);
    }

    @FunctionalInterface
    private static interface ScannerTokenVisitor {
        public void visit(int var1, int var2, int var3);
    }

    private class SemanticToken {
        private final TokenType tokenType;
        private final int tokenModifiers;
        private final int offset;
        private final int length;

        public SemanticToken(int offset, int length, TokenType tokenType, int tokenModifiers) {
            this.offset = offset;
            this.length = length;
            this.tokenType = tokenType;
            this.tokenModifiers = tokenModifiers;
        }

        public TokenType getTokenType() {
            return this.tokenType;
        }

        public int getTokenModifiers() {
            return this.tokenModifiers;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }
    }
}

