/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class SideEffectChecker
extends ASTVisitor {
    boolean fSideEffect;
    ASTNode fExpression;
    private static final int THRESHOLD = 2500;
    private String fEnclosingMethodSignature;
    private static HashSet<String> MARKEDMETHODSET = new HashSet();

    static {
        String[] methodNames = new String[]{"java.lang.System.currentTimeMillis", "java.lang.System.nanoTime", "java.io.PrintStream.print", "java.io.PrintStream.printf", "java.io.PrintStream.println"};
        MARKEDMETHODSET.addAll(Arrays.asList(methodNames));
    }

    public SideEffectChecker(ASTNode astNode, String enclosingMethodSignature) {
        this.fExpression = astNode;
        this.fSideEffect = false;
        this.fEnclosingMethodSignature = enclosingMethodSignature;
    }

    public boolean hasSideEffect() {
        return this.fSideEffect;
    }

    public boolean preVisit2(ASTNode node) {
        if (this.hasSideEffect()) {
            return false;
        }
        if (this.selfModied(node)) {
            this.fSideEffect = true;
            return false;
        }
        if (node instanceof MethodInvocation) {
            MethodInvocation node2 = (MethodInvocation)node;
            IMethodBinding resolveMethodBinding = node2.resolveMethodBinding();
            if (MARKEDMETHODSET.contains(this.getQualifiedName(resolveMethodBinding)) || resolveMethodBinding == null) {
                this.fSideEffect = true;
                return false;
            }
            if (resolveMethodBinding.getMethodDeclaration() != null && this.fEnclosingMethodSignature != null && this.fEnclosingMethodSignature.equals(resolveMethodBinding.getMethodDeclaration().getKey())) {
                return super.preVisit2(node);
            }
            MethodDeclaration md = this.findFunctionDefinition(resolveMethodBinding.getDeclaringClass(), resolveMethodBinding);
            if (md != null && md.getLength() < 2500) {
                MethodVisitor mv = new MethodVisitor();
                md.accept((ASTVisitor)mv);
                this.fSideEffect = mv.hasUpdateNoTemp() ? true : this.fSideEffect;
            }
        }
        return super.preVisit2(node);
    }

    private String getQualifiedName(IMethodBinding imb) {
        if (imb == null || imb.getDeclaringClass() == null) {
            return null;
        }
        return imb.getDeclaringClass().getQualifiedName() + "." + imb.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MethodDeclaration findFunctionDefinition(ITypeBinding iTypeBinding, IMethodBinding methodBinding) {
        if (methodBinding == null || iTypeBinding == null) {
            this.fSideEffect = true;
            return null;
        }
        if (!(iTypeBinding.getJavaElement() instanceof IType)) {
            return null;
        }
        IType it = (IType)iTypeBinding.getJavaElement();
        try {
            block9: {
                MethodDeclaration md;
                IClasspathEntry cpEntry;
                IJavaElement root = it.getAncestor(3);
                if (root instanceof IPackageFragmentRoot && (cpEntry = ((IPackageFragmentRoot)root).getRawClasspathEntry()).getEntryKind() == 5 && cpEntry.getPath().toString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                    return null;
                }
                ITypeHierarchy ith = it.newTypeHierarchy(iTypeBinding.getJavaElement().getJavaProject(), null);
                IMethod iMethod = (IMethod)methodBinding.getJavaElement();
                if (iMethod == null || ith == null) {
                    this.fSideEffect = true;
                    return null;
                }
                ArrayList<IType> iTypes = new ArrayList<IType>();
                SideEffectChecker.findTypes(it, ith, iTypes);
                Iterator<IType> iterator = iTypes.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.fSideEffect = true;
                        return null;
                    }
                    IType t = iterator.next();
                    IMethod tmp = JavaModelUtil.findMethod(iMethod.getElementName(), iMethod.getParameterTypes(), false, t);
                    if (tmp == null) continue;
                    ICompilationUnit icu = tmp.getCompilationUnit();
                    if (icu == null || icu.getSource() == null) {
                        return null;
                    }
                    ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
                    parser.setKind(8);
                    parser.setSource(icu);
                    parser.setResolveBindings(true);
                    CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
                    ASTNode perform = NodeFinder.perform((ASTNode)compilationUnit, (ISourceRange)tmp.getSourceRange());
                    if (!(perform instanceof MethodDeclaration) || ((MethodDeclaration)perform).resolveBinding() == null) break block9;
                    md = (MethodDeclaration)perform;
                    if (!Modifier.isAbstract((int)md.resolveBinding().getModifiers())) break;
                }
                return md;
            }
            this.fSideEffect = true;
            return null;
        }
        catch (JavaModelException javaModelException) {
            this.fSideEffect = true;
            return null;
        }
    }

    private static void findTypes(IType it, ITypeHierarchy ith, ArrayList<IType> iTypes) {
        iTypes.add(it);
        IType[] iTypeArray = ith.getAllSubtypes(it);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType i = iTypeArray[n2];
            iTypes.add(i);
            ++n2;
        }
    }

    private boolean selfModied(ASTNode node) {
        if (node instanceof Assignment) {
            Assignment node2 = (Assignment)node;
            ASTMatcher match = new ASTMatcher();
            if (!this.getOriginalExpression(node2.getRightHandSide()).subtreeMatch(match, (Object)this.getOriginalExpression(node2.getLeftHandSide()))) {
                AssignmentVisitor visitor = new AssignmentVisitor(node2.getLeftHandSide());
                node2.getRightHandSide().accept((ASTVisitor)visitor);
                if (visitor.hasDepend()) {
                    return true;
                }
            }
        } else if (node instanceof PrefixExpression) {
            PrefixExpression node2 = (PrefixExpression)node;
            if (ASTNodes.hasOperator(node2, PrefixExpression.Operator.INCREMENT, PrefixExpression.Operator.DECREMENT)) {
                return true;
            }
        } else if (node instanceof PostfixExpression) {
            return true;
        }
        return false;
    }

    private Expression getOriginalExpression(Expression expr) {
        while (expr instanceof ParenthesizedExpression || expr instanceof CastExpression) {
            if (expr instanceof ParenthesizedExpression) {
                ParenthesizedExpression pe = (ParenthesizedExpression)expr;
                expr = pe.getExpression();
                continue;
            }
            CastExpression ce = (CastExpression)expr;
            expr = ce.getExpression();
        }
        return expr;
    }

    class AssignmentVisitor
    extends ASTVisitor {
        boolean depend;
        Expression lValue;

        public boolean hasDepend() {
            return this.depend;
        }

        public AssignmentVisitor(Expression lValue) {
            this.lValue = lValue;
            this.depend = false;
        }

        public boolean preVisit2(ASTNode node) {
            if (this.depend) {
                return false;
            }
            if (node.subtreeMatch(new ASTMatcher(), (Object)this.lValue)) {
                this.depend = true;
            }
            return super.preVisit2(node);
        }
    }

    class MethodVisitor
    extends ASTVisitor {
        boolean updateNoTemp = false;

        public boolean hasUpdateNoTemp() {
            return this.updateNoTemp;
        }

        public boolean preVisit2(ASTNode node) {
            MethodInvocation mi;
            if (this.updateNoTemp) {
                return false;
            }
            if (node instanceof MethodInvocation && MARKEDMETHODSET.contains(SideEffectChecker.this.getQualifiedName((mi = (MethodInvocation)node).resolveMethodBinding()))) {
                this.updateNoTemp = true;
                return false;
            }
            Expression operand = null;
            if (node instanceof Assignment) {
                Assignment node2 = (Assignment)node;
                operand = SideEffectChecker.this.getOriginalExpression(node2.getLeftHandSide());
                if (!this.isNoTemp(operand)) {
                    return super.preVisit2(node);
                }
                if (!SideEffectChecker.this.getOriginalExpression(node2.getRightHandSide()).subtreeMatch(new ASTMatcher(), (Object)operand) || node2.getOperator() != Assignment.Operator.ASSIGN) {
                    AssignmentVisitor visitor = new AssignmentVisitor(node2.getLeftHandSide());
                    node2.getRightHandSide().accept((ASTVisitor)visitor);
                    if (visitor.hasDepend()) {
                        this.updateNoTemp = true;
                        return true;
                    }
                }
                return super.preVisit2(node);
            }
            if (node instanceof PrefixExpression) {
                PrefixExpression node2 = (PrefixExpression)node;
                if (ASTNodes.hasOperator(node2, PrefixExpression.Operator.INCREMENT, PrefixExpression.Operator.DECREMENT)) {
                    operand = node2.getOperand();
                }
            } else if (node instanceof PostfixExpression) {
                PostfixExpression node2 = (PostfixExpression)node;
                operand = node2.getOperand();
            }
            if (operand != null && this.isNoTemp(operand)) {
                this.updateNoTemp = true;
            }
            return super.preVisit2(node);
        }

        private boolean isNoTemp(Expression e) {
            IVariableBinding ivb = null;
            Expression expr = SideEffectChecker.this.getOriginalExpression(e);
            if (expr instanceof SimpleName) {
                SimpleName sn = (SimpleName)expr;
                if (sn.resolveBinding() instanceof IVariableBinding) {
                    ivb = (IVariableBinding)sn.resolveBinding();
                }
            } else if (expr instanceof FieldAccess) {
                FieldAccess fa = (FieldAccess)expr;
                ivb = fa.resolveFieldBinding();
            } else {
                if (expr instanceof QualifiedName) {
                    QualifiedName qn = (QualifiedName)expr;
                    if (qn.resolveBinding() instanceof IVariableBinding) {
                        ivb = (IVariableBinding)qn.resolveBinding();
                    }
                    return ivb != null && Modifier.isStatic((int)ivb.getModifiers()) || this.isNoTemp((Expression)qn.getQualifier());
                }
                if (expr instanceof ArrayAccess) {
                    ArrayAccess aa = (ArrayAccess)expr;
                    return this.isNoTemp(aa.getArray());
                }
            }
            return ivb != null && (ivb.isField() || Modifier.isStatic((int)ivb.getModifiers()));
        }
    }
}

