"use strict";
// *****************************************************************************
// Copyright (C) 2022 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ValidatedPreferenceProxy = void 0;
const inversify_1 = require("inversify");
const _1 = require(".");
const injectable_preference_proxy_1 = require("./injectable-preference-proxy");
const preference_language_override_service_1 = require("./preference-language-override-service");
let ValidatedPreferenceProxy = class ValidatedPreferenceProxy extends injectable_preference_proxy_1.InjectablePreferenceProxy {
    constructor() {
        super(...arguments);
        this.validPreferences = new Map();
    }
    handlePreferenceChanges(changes) {
        var _a, _b;
        if (this.schema) {
            ;
            const overrideTracker = new Map();
            for (const change of Object.values(changes)) {
                const overridden = this.preferences.overriddenPreferenceName(change.preferenceName);
                if (this.isRelevantChange(change, overridden)) {
                    let doSet = false;
                    const baseName = (_a = overridden === null || overridden === void 0 ? void 0 : overridden.preferenceName) !== null && _a !== void 0 ? _a : change.preferenceName;
                    const tracker = (_b = overrideTracker.get(baseName)) !== null && _b !== void 0 ? _b : (doSet = true, { value: undefined, overrides: [] });
                    if (overridden) {
                        tracker.overrides.push(overridden);
                    }
                    else {
                        tracker.value = change.newValue;
                    }
                    if (doSet) {
                        overrideTracker.set(baseName, tracker);
                    }
                }
            }
            for (const [baseName, tracker] of overrideTracker.entries()) {
                const configuredValue = tracker.value;
                const validatedValue = this.ensureValid(baseName, () => configuredValue, true);
                if (baseName in changes && this.isRelevantChange(changes[baseName])) {
                    const { domain, oldValue, preferenceName, scope } = changes[baseName];
                    this.fireChangeEvent(this.buildNewChangeEvent({ domain, oldValue, preferenceName, scope, newValue: validatedValue }));
                }
                for (const override of tracker.overrides) {
                    const name = this.preferences.overridePreferenceName(override);
                    const { domain, oldValue, preferenceName, scope } = changes[name];
                    const newValue = changes[name].newValue === configuredValue ? validatedValue : this.ensureValid(name, () => changes[name].newValue, true);
                    this.fireChangeEvent(this.buildNewChangeEvent({ domain, oldValue, preferenceName, scope, newValue }, override));
                }
            }
        }
    }
    getValue(preferenceIdentifier, defaultValue, resourceUri = this.resourceUri) {
        const preferenceName = preference_language_override_service_1.OverridePreferenceName.is(preferenceIdentifier) ? this.preferences.overridePreferenceName(preferenceIdentifier) : preferenceIdentifier;
        return this.ensureValid(preferenceName, () => { var _a; return ((_a = super.getValue(preferenceIdentifier, defaultValue, resourceUri)) !== null && _a !== void 0 ? _a : defaultValue); }, false);
    }
    ensureValid(preferenceName, getCandidate, isChange) {
        if (!isChange && this.validPreferences.has(preferenceName)) {
            return this.validPreferences.get(preferenceName);
        }
        const candidate = getCandidate();
        const valid = this.validator.validateByName(preferenceName, candidate);
        this.validPreferences.set(preferenceName, valid);
        return valid;
    }
    dispose() {
        super.dispose();
        if (this.options.isDisposable) {
            this.validPreferences.clear();
        }
    }
};
__decorate([
    (0, inversify_1.inject)(_1.PreferenceValidationService),
    __metadata("design:type", _1.PreferenceValidationService)
], ValidatedPreferenceProxy.prototype, "validator", void 0);
ValidatedPreferenceProxy = __decorate([
    (0, inversify_1.injectable)()
], ValidatedPreferenceProxy);
exports.ValidatedPreferenceProxy = ValidatedPreferenceProxy;
//# sourceMappingURL=validated-preference-proxy.js.map