/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.applications;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.applications.InformationExporter;
import org.eclipse.titanium.markers.export.XlsProblemExporter;

public class ExportAllCodeSmellsForProject
extends InformationExporter {
    private String projectName;

    @Override
    protected boolean checkParameters(String[] args) {
        if (args.length < 2 || args.length > 3) {
            System.out.println("This application takes as parameter the location of the resulting .XLS files the name of the project to be checked and optionally the date to be inserted into the file.");
            return false;
        }
        this.projectName = args[1];
        return true;
    }

    @Override
    protected void exportInformationForProject(String[] args, IProject project, IProgressMonitor monitor) {
        XlsProblemExporter exporter = new XlsProblemExporter(project);
        try {
            Date date = args.length == 2 ? Calendar.getInstance().getTime() : new SimpleDateFormat("yyyy_MM_dd").parse(args[2]);
            exporter.exportMarkers(monitor, args[0] + project.getName() + ".xls", date);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)("Error while exporting to excel " + args[0] + project.getName() + ".xls"), (Throwable)e);
        }
    }

    @Override
    protected List<IProject> getProjectsToHandle() {
        if (this.projectName == null) {
            return new ArrayList<IProject>();
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        IProject foundProject = null;
        for (IProject project : projects) {
            if (!this.projectName.equals(project.getName())) continue;
            foundProject = project;
        }
        if (foundProject == null) {
            System.out.println("There is no project with name `" + this.projectName + "' in the workspace.");
            return new ArrayList<IProject>();
        }
        if (!foundProject.isAccessible()) {
            System.out.println("There project `" + this.projectName + "' is not accessible.");
            return new ArrayList<IProject>();
        }
        ArrayList<IProject> result = new ArrayList<IProject>();
        result.add(foundProject);
        return result;
    }
}

