/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.titanium.metrics.utils.ModuleMetricsWrapper;

public final class WrapperStore {
    private static Map<IProject, ModuleMetricsWrapper> wrappers = new HashMap<IProject, ModuleMetricsWrapper>();
    private static final IResourceChangeListener PROJECT_CLOSE_LISTENER = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 2: 
                case 4: {
                    WrapperStore.deleteWrapper(event.getResource().getProject());
                    break;
                }
            }
        }
    };

    private WrapperStore() {
    }

    public static ModuleMetricsWrapper getWrapper(IProject project) {
        ModuleMetricsWrapper ret = wrappers.get(project);
        if (ret == null) {
            ret = new ModuleMetricsWrapper(project);
            wrappers.put(project, ret);
        }
        return ret;
    }

    public static void clearStore() {
        wrappers = new HashMap<IProject, ModuleMetricsWrapper>();
    }

    public static void deleteWrapper(IProject project) {
        wrappers.remove(project);
    }

    static {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(PROJECT_CLOSE_LISTENER);
    }
}

