/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.groups.GroupLaunchConfigurationDelegate;
import org.eclipse.debug.internal.core.groups.GroupLaunchElement;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.cfg.ConfigFileHandler;
import org.eclipse.titan.common.utils.StringUtils;
import org.eclipse.titan.designer.consoles.TITANConsole;
import org.eclipse.titan.executor.designerconnection.DynamicLinkingHelper;

public final class LaunchConfigurationUtil {
    private static final String MAIN_SINGLE = "org.eclipse.titan.{0}.generated.Single_main";
    private static final String MAIN_PARALLEL = "org.eclipse.titan.{0}.generated.Parallel_main";
    private static final String PATH_PREFIX = "java_src";
    private static final String GROUP_LAUNCH_CONFIGURATION_ID = "org.eclipse.debug.core.groups.GroupLaunchConfigurationType";
    private static final String LAUNCH_CONFIGURATION_LIST_ATTR = "org.eclipse.titan.executor.linkedLaunchConfigurations";

    public static ILaunchConfiguration createGroupLaunchConfiguration(ILaunchConfiguration configMC, ILaunchConfiguration configHC) throws CoreException {
        if (configMC == null || configHC == null) {
            return null;
        }
        boolean singleMode = configMC.getAttribute("org.eclipse.titan.executor.singleModeJavaExecutor", false);
        String projectName = configMC.getAttribute("org.eclipse.titan.executor.projectName", "");
        String configFile = configMC.getAttribute("org.eclipse.titan.executor.configurationFilePath", "");
        if (singleMode || projectName.isEmpty() || configFile.isEmpty()) {
            return null;
        }
        String configurationName = LaunchConfigurationUtil.getLinkedGroupLaunchConfigurationName(configMC);
        if (configurationName.isEmpty()) {
            configurationName = projectName + "-" + configFile.replace("/", "-") + "-Parallel-Java";
        }
        ILaunchConfiguration config = LaunchConfigurationUtil.findGroupLaunchConfigurationByName(configurationName);
        ILaunchConfigurationWorkingCopy wc = null;
        wc = config != null ? config.getWorkingCopy() : LaunchConfigurationUtil.getGroupLaunchConfigurationType().newInstance(null, LaunchConfigurationUtil.getLaunchManager().generateLaunchConfigurationName(configurationName));
        IProject project = DynamicLinkingHelper.getProject(projectName);
        wc.setMappedResources(new IResource[]{project});
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("org.eclipse.debug.ui.launchGroup.run");
        wc.setAttribute("org.eclipse.debug.ui.favoriteGroups", list);
        List<GroupLaunchElement> configList = LaunchConfigurationUtil.createGroupLaunchElements(configMC.getName(), configHC.getName(), true);
        GroupLaunchConfigurationDelegate.storeLaunchElements((ILaunchConfigurationWorkingCopy)wc, configList);
        config = wc.doSave();
        return config;
    }

    public static ILaunchConfiguration createJavaAppLaunchConfiguration(ILaunchConfiguration configuration) throws CoreException {
        if (configuration == null) {
            return null;
        }
        boolean singleMode = configuration.getAttribute("org.eclipse.titan.executor.singleModeJavaExecutor", false);
        String projectName = configuration.getAttribute("org.eclipse.titan.executor.projectName", "");
        String configFile = configuration.getAttribute("org.eclipse.titan.executor.configurationFilePath", "");
        if (projectName.isEmpty() || configFile.isEmpty()) {
            return null;
        }
        IProject project = DynamicLinkingHelper.getProject(projectName);
        if (project == null) {
            return null;
        }
        String mainType = "";
        String configurationName = LaunchConfigurationUtil.getLinkedJavaAppLaunchConfigurationName(configuration);
        if (singleMode) {
            if (configurationName.isEmpty()) {
                configurationName = projectName + "-" + configFile.replace("/", "-") + "-Single-Java";
            }
            mainType = MessageFormat.format(MAIN_SINGLE, projectName);
        } else {
            if (configurationName.isEmpty()) {
                configurationName = projectName + "-" + configFile.replace("/", "-") + "-HC-Java";
            }
            mainType = MessageFormat.format(MAIN_PARALLEL, projectName);
        }
        ILaunchConfiguration config = LaunchConfigurationUtil.findJavaAppLaunchConfigurationByName(configurationName);
        ILaunchConfigurationWorkingCopy wc = null;
        wc = config != null ? config.getWorkingCopy() : LaunchConfigurationUtil.getJavaAppLaunchConfigurationType().newInstance(null, LaunchConfigurationUtil.getLaunchManager().generateLaunchConfigurationName(configurationName));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainType);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
        if (singleMode) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, configFile);
            ArrayList<String> list = new ArrayList<String>(1);
            list.add("org.eclipse.debug.ui.launchGroup.run");
            wc.setAttribute("org.eclipse.debug.ui.favoriteGroups", list);
        } else {
            String args = LaunchConfigurationUtil.getArgsForParallelLaunch(project, configFile);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args);
        }
        IFile mainFile = project.getFile(PATH_PREFIX + File.separator + mainType.replace('.', File.separatorChar));
        wc.setMappedResources(new IResource[]{mainFile});
        config = wc.doSave();
        return config;
    }

    public static boolean disableHCinGroupLaunchConfiguration(ILaunchConfigurationWorkingCopy configuration) throws CoreException {
        if (configuration == null) {
            return false;
        }
        ILaunchConfiguration confGroup = LaunchConfigurationUtil.findGroupLaunchConfigurationByName(LaunchConfigurationUtil.getLinkedGroupLaunchConfigurationName((ILaunchConfiguration)configuration));
        if (confGroup == null) {
            return false;
        }
        ILaunchConfiguration confHC = LaunchConfigurationUtil.findJavaAppLaunchConfigurationByName(LaunchConfigurationUtil.getLinkedJavaAppLaunchConfigurationName((ILaunchConfiguration)configuration));
        if (confHC == null) {
            return false;
        }
        List<GroupLaunchElement> configList = LaunchConfigurationUtil.createGroupLaunchElements(configuration.getName(), confHC.getName(), false);
        ILaunchConfigurationWorkingCopy wc = confGroup.getWorkingCopy();
        GroupLaunchConfigurationDelegate.storeLaunchElements((ILaunchConfigurationWorkingCopy)wc, configList);
        confGroup = wc.doSave();
        return true;
    }

    public static ILaunchConfiguration findGroupLaunchConfigurationByName(String configurationName) throws CoreException {
        return LaunchConfigurationUtil.findLaunchConfigurationByName(configurationName, LaunchConfigurationUtil.getGroupLaunchConfigurationType());
    }

    public static ILaunchConfiguration findJavaAppLaunchConfigurationByName(String configurationName) throws CoreException {
        return LaunchConfigurationUtil.findLaunchConfigurationByName(configurationName, LaunchConfigurationUtil.getJavaAppLaunchConfigurationType());
    }

    public static ILaunchConfiguration findLaunchConfigurationByName(String configurationName) throws CoreException {
        return LaunchConfigurationUtil.findLaunchConfigurationByName(configurationName, null);
    }

    public static ILaunchConfiguration findLaunchConfigurationByName(String configurationName, ILaunchConfigurationType type) throws CoreException {
        if (configurationName == null || configurationName.isEmpty()) {
            return null;
        }
        ILaunchConfiguration[] configs = null;
        configs = type == null ? LaunchConfigurationUtil.getLaunchManager().getLaunchConfigurations() : LaunchConfigurationUtil.getLaunchManager().getLaunchConfigurations(type);
        for (ILaunchConfiguration config : configs) {
            if (!config.getName().equals(configurationName)) continue;
            return config;
        }
        return null;
    }

    public static String getArgsForParallelLaunch(IFile file) {
        int tcpPort;
        if (file == null || !file.exists()) {
            return "";
        }
        String configFileName = file.getLocation().toOSString();
        ConfigFileHandler configHandler = new ConfigFileHandler();
        configHandler.readFromFile(configFileName);
        String localAddress = configHandler.getLocalAddress();
        if (StringUtils.isNullOrEmpty((String)localAddress)) {
            localAddress = "127.0.0.1";
            TITANConsole.println((String)("\"LocalAddress\" parameter is missing from configuration file: " + configFileName));
            TITANConsole.println((String)("Using default: " + localAddress));
        }
        if ((tcpPort = configHandler.getTcpPort()) == 0) {
            ErrorReporter.logError((String)("\"TCPPort\" parameter is missing from configuration file: " + configFileName));
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)("Error while launching the project " + file.getProject().getName()), (String)("\"TCPPort\" parameter is missing from configuration file: " + file.getFullPath().toOSString() + "\nCannot continue"));
            TITANConsole.println((String)("\"TCPPort\" parameter is missing from configuration file: " + configFileName));
            TITANConsole.println((String)"Cannot continue");
            return "";
        }
        return MessageFormat.format("{0} {1,number,#}", localAddress, tcpPort);
    }

    public static String getArgsForParallelLaunch(IProject project, String configFileName) {
        return LaunchConfigurationUtil.getArgsForParallelLaunch(project.getFile(configFileName));
    }

    public static ILaunchConfigurationType getGroupLaunchConfigurationType() {
        return LaunchConfigurationUtil.getLaunchManager().getLaunchConfigurationType(GROUP_LAUNCH_CONFIGURATION_ID);
    }

    public static ILaunchConfigurationType getJavaAppLaunchConfigurationType() {
        return LaunchConfigurationUtil.getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
    }

    public static ILaunchConfigurationType getJavaMctrLaunchConfigurationType() {
        return LaunchConfigurationUtil.getLaunchManager().getLaunchConfigurationType("org.eclipse.titan.executor.executors.java_mctr.LaunchConfigurationDelegate");
    }

    public static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public static String getLinkedGroupLaunchConfigurationName(ILaunchConfiguration configuration) throws CoreException {
        List<String> list = LaunchConfigurationUtil.getLinkedLaunchConfigurations(configuration);
        if (list != null && list.size() == 2) {
            return list.get(1);
        }
        return "";
    }

    public static String getLinkedJavaAppLaunchConfigurationName(ILaunchConfiguration configuration) throws CoreException {
        List<String> list = LaunchConfigurationUtil.getLinkedLaunchConfigurations(configuration);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return "";
    }

    public static List<String> getLinkedLaunchConfigurations(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(LAUNCH_CONFIGURATION_LIST_ATTR, new ArrayList(0));
    }

    public static void setLinkedLaunchConfigurations(ILaunchConfigurationWorkingCopy configuration, List<String> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        configuration.setAttribute(LAUNCH_CONFIGURATION_LIST_ATTR, list);
    }

    private static List<GroupLaunchElement> createGroupLaunchElements(String MCName, String HCName, boolean enableHC) {
        ArrayList<GroupLaunchElement> configList = new ArrayList<GroupLaunchElement>(2);
        if (MCName == null || MCName.isEmpty() || HCName == null || HCName.isEmpty()) {
            return configList;
        }
        GroupLaunchElement elMC = new GroupLaunchElement();
        elMC.index = 0;
        elMC.name = MCName;
        configList.add(elMC);
        GroupLaunchElement elHC = new GroupLaunchElement();
        elHC.index = 1;
        elHC.name = HCName;
        elHC.enabled = enableHC;
        configList.add(elHC);
        return configList;
    }
}

