/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.tabpages.testset;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.executor.tabpages.testset.TestCaseTreeElement;

public final class TestcaseTransfer
extends ByteArrayTransfer {
    private static final TestcaseTransfer INSTANCE = new TestcaseTransfer();
    private static final String TYPE_NAME = "TITAN-testcase-transfer-format";
    private static final int TYPEID = TestcaseTransfer.registerType((String)"TITAN-testcase-transfer-format");

    private TestcaseTransfer() {
    }

    public static TestcaseTransfer getInstance() {
        return INSTANCE;
    }

    protected TestCaseTreeElement[] fromByteArray(byte[] bytes) {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        TestCaseTreeElement[] testcases = null;
        try {
            int size = in.readInt();
            testcases = new TestCaseTreeElement[size];
            for (int i = 0; i < size; ++i) {
                TestCaseTreeElement testcase;
                testcases[i] = testcase = new TestCaseTreeElement(in.readUTF());
            }
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        try {
            in.close();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        return testcases;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        byte[] bytes = this.toByteArray((TestCaseTreeElement[])object);
        if (null != bytes) {
            super.javaToNative((Object)bytes, transferData);
        }
    }

    protected TestCaseTreeElement[] nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        return this.fromByteArray(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] toByteArray(TestCaseTreeElement[] testcases) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        byte[] bytes = null;
        try {
            out.writeInt(testcases.length);
            for (TestCaseTreeElement testcase : testcases) {
                out.writeUTF(testcase.name());
            }
            bytes = byteOut.toByteArray();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        finally {
            try {
                out.close();
                byteOut.close();
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        return bytes;
    }
}

