/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.IsValueExpression;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class EncodeExpression
extends Expression_Value {
    private static final String OPERANDERROR1 = "Cannot determine the argument type of `encvalue' operation";
    private static final String OPERANDERROR2 = "The operand of the `encvalue' operation cannot be encoded";
    private static final String SECONDOPERANDERROR = "The second operand of the `encvalue' operation should be a (universal) charstring value";
    private static final String THIRDOPERANDERROR = "The third operand of the `encvalue' operation should be a (universal) charstring value";
    private final TemplateInstance templateInstance;
    private final Value encodingInfo;
    private final Value dynamicEncoding;

    public EncodeExpression(TemplateInstance templateInstance, Value encodingInfo, Value dynamicEncoding) {
        this.templateInstance = templateInstance;
        this.encodingInfo = encodingInfo;
        this.dynamicEncoding = dynamicEncoding;
        if (templateInstance != null) {
            templateInstance.setFullNameParent(this);
        }
        if (encodingInfo != null) {
            encodingInfo.setFullNameParent(this);
        }
        if (dynamicEncoding != null) {
            dynamicEncoding.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.ENCODE_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        return this.templateInstance != null && this.templateInstance.getTemplateBody().checkExpressionSelfReferenceTemplate(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        if (this.templateInstance == null) {
            return "<erroneous value>";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("encvalue(");
        builder.append(this.templateInstance.createStringRepresentation());
        if (this.encodingInfo != null) {
            builder.append(", ").append(this.encodingInfo.createStringRepresentation());
        }
        if (this.dynamicEncoding != null) {
            builder.append(", ").append(this.dynamicEncoding.createStringRepresentation());
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.templateInstance != null) {
            this.templateInstance.setMyScope(scope);
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.setMyScope(scope);
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.templateInstance != null) {
            this.templateInstance.setCodeSection(codeSection);
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.setCodeSection(codeSection);
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.templateInstance == child) {
            return builder.append(".<operand1>");
        }
        if (this.encodingInfo != null) {
            return builder.append(".<operand2>");
        }
        if (this.dynamicEncoding != null) {
            return builder.append(".<operand3>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_BITSTRING;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        IType.Type_type tempType;
        if (this.templateInstance == null) {
            this.setIsErroneous(true);
            return;
        }
        ITTCN3Template template = this.templateInstance.getTemplateBody();
        template.setMyGovernor(null);
        Expected_Value_type internalExpectation = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? Expected_Value_type.EXPECTED_TEMPLATE : expectedValue;
        IType type = this.templateInstance.getExpressionGovernor(timestamp, internalExpectation);
        if (type == null) {
            template = template.setLoweridToReference(timestamp);
            type = template.getExpressionGovernor(timestamp, internalExpectation);
        }
        if (type == null) {
            if (!template.getIsErroneous(timestamp)) {
                this.templateInstance.getLocation().reportSemanticError(OPERANDERROR1);
            }
            this.setIsErroneous(true);
            return;
        }
        IsValueExpression.checkExpressionTemplateInstance(timestamp, this, this.templateInstance, type, referenceChain, expectedValue);
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        template.checkSpecificValue(timestamp, false);
        IType lastType = type.getTypeRefdLast(timestamp);
        boolean attributeValidationDisabled = false;
        try {
            String property = this.getLocation().getFile().getProject().getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableAttributeValidation"));
            attributeValidationDisabled = property != null && "true".equals(property);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        if (!attributeValidationDisabled) {
            type.checkCoding(timestamp, true, this.getMyScope().getModuleScope(), false, this.templateInstance.getLocation());
        }
        switch (lastType.getTypetype()) {
            case TYPE_UNDEFINED: 
            case TYPE_NULL: 
            case TYPE_REFERENCED: 
            case TYPE_REFD_SPEC: 
            case TYPE_SELECTION: 
            case TYPE_VERDICT: 
            case TYPE_PORT: 
            case TYPE_COMPONENT: 
            case TYPE_DEFAULT: 
            case TYPE_SIGNATURE: 
            case TYPE_FUNCTION: 
            case TYPE_ALTSTEP: 
            case TYPE_TESTCASE: {
                if (this.isErroneous) break;
                this.location.reportSemanticError(OPERANDERROR2);
                this.setIsErroneous(true);
                break;
            }
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.setLoweridToReference(timestamp);
            tempType = this.encodingInfo.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType) {
                case TYPE_CHARSTRING: 
                case TYPE_UCHARSTRING: {
                    this.encodingInfo.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(SECONDOPERANDERROR);
                    this.setIsErroneous(true);
                }
            }
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.setLoweridToReference(timestamp);
            tempType = this.dynamicEncoding.getExpressionReturntype(timestamp, expectedValue);
            switch (tempType) {
                case TYPE_CHARSTRING: 
                case TYPE_UCHARSTRING: {
                    IValue lastValue = this.dynamicEncoding.getValueRefdLast(timestamp, expectedValue, referenceChain);
                    if (this.dynamicEncoding.isUnfoldable(timestamp)) break;
                    boolean errorFound = false;
                    if (IValue.Value_type.UNIVERSALCHARSTRING_VALUE.equals((Object)lastValue.getValuetype())) {
                        errorFound = ((UniversalCharstring_Value)lastValue).checkDynamicEncodingString(timestamp, type);
                    } else if (IValue.Value_type.CHARSTRING_VALUE.equals((Object)lastValue.getValuetype())) {
                        errorFound = ((Charstring_Value)lastValue).checkDynamicEncodingString(timestamp, type);
                    }
                    if (!errorFound) break;
                    this.dynamicEncoding.getLocation().reportSemanticError(MessageFormat.format("The encoding string does not match any encodings of type `{0}''", type.getTypename()));
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    this.location.reportSemanticError(THIRDOPERANDERROR);
                    this.setIsErroneous(true);
                }
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.templateInstance != null) {
            this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        }
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.templateInstance != null) {
            referenceChain.markState();
            this.templateInstance.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
            if (this.encodingInfo != null) {
                referenceChain.markState();
                this.encodingInfo.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.dynamicEncoding != null) {
                referenceChain.markState();
                this.dynamicEncoding.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.templateInstance != null) {
            this.templateInstance.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance.getLocation());
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.updateSyntax(reparser, false);
            reparser.updateLocation(this.encodingInfo.getLocation());
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.updateSyntax(reparser, false);
            reparser.updateLocation(this.dynamicEncoding.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.templateInstance != null) {
            this.templateInstance.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.templateInstance != null && !this.templateInstance.accept(v)) {
            return false;
        }
        if (this.encodingInfo != null && !this.encodingInfo.accept(v)) {
            return false;
        }
        return this.dynamicEncoding == null || this.dynamicEncoding.accept(v);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.templateInstance != null) {
            this.templateInstance.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.encodingInfo != null) {
            this.encodingInfo.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.dynamicEncoding != null) {
            this.dynamicEncoding.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        aData.addBuiltinTypeImport("TitanOctetString");
        aData.addCommonLibraryImport("AdditionalFunctions");
        boolean isValue = this.templateInstance.getTemplateBody().isValue(CompilationTimeStamp.getBaseTimestamp());
        ExpressionStruct expression2 = new ExpressionStruct();
        if (isValue) {
            this.templateInstance.getTemplateBody().getValue().generateCodeExpressionMandatory(aData, expression2, true);
        } else {
            this.templateInstance.generateCode(aData, expression2, TemplateRestriction.Restriction_type.TR_NONE);
        }
        Scope scope = this.templateInstance.getTemplateBody().getMyScope();
        IType governor = this.templateInstance.getTemplateBody().getMyGovernor();
        if (expression2.preamble.length() > 0) {
            expression.preamble.append((CharSequence)expression2.preamble);
        }
        ExpressionStruct expression3 = new ExpressionStruct();
        if (this.dynamicEncoding == null) {
            expression3.expression.append(MessageFormat.format("{0}_default_coding", governor.getGenNameDefaultCoding(aData, expression.expression, scope)));
        } else {
            this.dynamicEncoding.generateCodeExpression(aData, expression3, true);
            if (expression3.preamble.length() > 0) {
                expression.preamble.append((CharSequence)expression3.preamble);
            }
        }
        String tempID = aData.getTemporaryVariableName();
        expression.preamble.append(MessageFormat.format("final TitanOctetString {0} = new TitanOctetString();\n", tempID));
        expression.preamble.append(MessageFormat.format("{0}_encoder({1}{2}, {3}, {4});\n", governor.getGenNameCoder(aData, expression.expression, scope), expression2.expression, isValue ? "" : ".valueof()", tempID, expression3.expression));
        expression.expression.append(MessageFormat.format("AdditionalFunctions.oct2bit({0})", tempID));
        if (expression2.postamble.length() > 0) {
            expression.postamble.append((CharSequence)expression2.postamble);
        }
        if (expression3.postamble.length() > 0) {
            expression.postamble.append((CharSequence)expression3.postamble);
        }
    }
}

