/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.BreadcrumbTreeItem;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.ui.PlatformUI;

public class BreadcumbTreeStyledLabelProvider
extends DelegatingStyledCellLabelProvider {
    public BreadcumbTreeStyledLabelProvider() {
        super(new DelegatingStyledCellLabelProvider.IStyledLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public StyledString getStyledText(Object element) {
                if (element instanceof BreadcrumbTreeItem) {
                    BreadcrumbTreeItem item = (BreadcrumbTreeItem)element;
                    if (item.isDirectory()) {
                        // empty if block
                    }
                    return new StyledString(item.getText());
                }
                return new StyledString();
            }

            public Image getImage(Object element) {
                if (element instanceof BreadcrumbTreeItem) {
                    BreadcrumbTreeItem item = (BreadcrumbTreeItem)element;
                    if (item.isDirectory()) {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                    }
                    if (item.getText().matches(".*[.][Tt][Tt][Cc][Nn]3?$")) {
                        return ImageCache.getImage("ttcn.gif");
                    }
                    if (item.getText().matches(".*[.][Tt][Tt][Cc][Nn][Pp][Pp]$")) {
                        return ImageCache.getImage("ttcnpp.gif");
                    }
                    if (item.getText().matches(".*[.][Aa][Ss][Nn]1?$")) {
                        return ImageCache.getImage("asn.gif");
                    }
                }
                return null;
            }
        });
    }

    protected void erase(Event event, Object element) {
        if ((event.detail & 2) != 0) {
            event.detail &= 0xFFFFFFFD;
            Rectangle bounds = event.getBounds();
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            RGB rgb = StringConverter.asRGB((String)store.getString("org.eclipse.titan.designer.colorstyledSelectionIncativeBackground"), null);
            Color bgColor = new Color((Device)PlatformUI.getWorkbench().getDisplay(), rgb);
            event.gc.setBackground(bgColor);
            event.gc.fillRectangle(bounds);
        }
        super.erase(event, element);
    }

    protected void measure(Event event, Object element) {
        event.detail &= 0xFFFFFFFD;
        super.measure(event, element);
    }

    protected void paint(Event event, Object element) {
        event.detail &= 0xFFFFFFFD;
        super.paint(event, element);
    }
}

