/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.compile;

import java.util.Vector;
import org.eclipse.rse.internal.useractions.ui.compile.SystemDefaultCompileCommand;

public abstract class SystemDefaultCompileCommands {
    private Vector commands = new Vector();
    private SystemDefaultCompileCommand[] array;
    private String[] nameArray;
    private String[] stringArray;

    public abstract String[] getAllDefaultSuppliedSourceTypes();

    public SystemDefaultCompileCommand getCommand(int idx) {
        return (SystemDefaultCompileCommand)this.commands.elementAt(idx);
    }

    public SystemDefaultCompileCommand getCommand(String commandName) {
        SystemDefaultCompileCommand match = null;
        int idx = 0;
        while (match == null && idx < this.commands.size()) {
            SystemDefaultCompileCommand cmd = (SystemDefaultCompileCommand)this.commands.elementAt(idx);
            if (cmd.getName().equalsIgnoreCase(commandName)) {
                match = cmd;
            }
            ++idx;
        }
        return match;
    }

    public SystemDefaultCompileCommand[] getCommands() {
        if (this.array == null || this.array.length != this.commands.size()) {
            this.array = new SystemDefaultCompileCommand[this.commands.size()];
            int idx = 0;
            while (idx < this.commands.size()) {
                this.array[idx] = (SystemDefaultCompileCommand)this.commands.elementAt(idx);
                ++idx;
            }
        }
        return this.array;
    }

    public SystemDefaultCompileCommand[] getCommandsForSrcType(String srcType) {
        Vector v = new Vector();
        int idx = 0;
        while (idx < this.commands.size()) {
            if (((SystemDefaultCompileCommand)this.commands.elementAt(idx)).appliesToSourceType(srcType)) {
                v.addElement(this.commands.elementAt(idx));
            }
            ++idx;
        }
        SystemDefaultCompileCommand[] matches = new SystemDefaultCompileCommand[v.size()];
        int idx2 = 0;
        while (idx2 < matches.length) {
            matches[idx2] = (SystemDefaultCompileCommand)v.elementAt(idx2);
            ++idx2;
        }
        return matches;
    }

    public String[] getCommandNames() {
        if (this.nameArray == null || this.nameArray.length != this.commands.size()) {
            this.nameArray = new String[this.commands.size()];
            int idx = 0;
            while (idx < this.commands.size()) {
                this.nameArray[idx] = ((SystemDefaultCompileCommand)this.commands.elementAt(idx)).getName();
                ++idx;
            }
        }
        return this.nameArray;
    }

    public String[] getCommandStrings() {
        if (this.stringArray == null || this.stringArray.length != this.commands.size()) {
            this.stringArray = new String[this.commands.size()];
            int idx = 0;
            while (idx < this.commands.size()) {
                this.stringArray[idx] = ((SystemDefaultCompileCommand)this.commands.elementAt(idx)).getCommandWithParameters();
                ++idx;
            }
        }
        return this.stringArray;
    }

    public int getSize() {
        return this.commands.size();
    }

    public String fillWithRequiredParams(String commandString) {
        if (commandString == null) {
            return null;
        }
        if ((commandString = commandString.trim()).length() == 0) {
            return commandString;
        }
        int blankIdx = commandString.indexOf(32);
        String cmdName = null;
        String cmdParms = null;
        if (blankIdx == -1) {
            cmdName = commandString;
        } else {
            cmdName = commandString.substring(0, blankIdx);
            cmdParms = commandString.substring(blankIdx + 1);
        }
        SystemDefaultCompileCommand cmdMatch = this.getCommand(cmdName);
        if (cmdMatch != null) {
            return cmdMatch.fillWithRequiredParams(cmdParms);
        }
        return commandString;
    }

    public void addCommand(SystemDefaultCompileCommand cmd) {
        this.commands.add(cmd);
        this.clearCache();
    }

    public void printCommandLabels() {
        System.out.println();
        System.out.println("Total commands: " + this.getSize());
        int idx = 0;
        while (idx < this.commands.size()) {
            SystemDefaultCompileCommand cmd = (SystemDefaultCompileCommand)this.commands.elementAt(idx);
            cmd.printCommandLabel();
            ++idx;
        }
        System.out.println();
    }

    public void printCommandNames() {
        System.out.println();
        System.out.println("Total commands: " + this.getSize());
        int idx = 0;
        while (idx < this.commands.size()) {
            SystemDefaultCompileCommand cmd = (SystemDefaultCompileCommand)this.commands.elementAt(idx);
            cmd.printCommandName();
            ++idx;
        }
        System.out.println();
    }

    public void printCommands() {
        System.out.println();
        System.out.println("Total commands: " + this.getSize());
        int idx = 0;
        while (idx < this.commands.size()) {
            SystemDefaultCompileCommand cmd = (SystemDefaultCompileCommand)this.commands.elementAt(idx);
            cmd.printCommand();
            ++idx;
        }
        System.out.println();
    }

    private void clearCache() {
        this.array = null;
        this.nameArray = null;
    }
}

