/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.core.javaelements.IAspectJElement;
import org.eclipse.ajdt.core.javaelements.PointcutUtilities;
import org.eclipse.ajdt.core.text.CoreMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class AspectRenameParticipant
extends RenameParticipant {
    private IType fType;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange changes = new CompositeChange(CoreMessages.renameTypeReferences);
        String oldName = this.fType.getElementName();
        String newName = this.getArguments().getNewName();
        IProject project = this.fType.getResource().getProject();
        AJLog.log("Rename type references in aspects from " + oldName + " to " + newName);
        AJLog.log("qualified name: " + this.fType.getFullyQualifiedName());
        List ajs = AJCompilationUnitManager.INSTANCE.getCachedCUs(project);
        pm.beginTask(CoreMessages.renameTypeReferences, ajs.size());
        for (AJCompilationUnit cu : ajs) {
            if (this.fType.getParent().equals((Object)cu) && this.fType.getElementName().equals(new String(cu.getMainTypeName()))) continue;
            IResource res = cu.getUnderlyingResource();
            if (res.getType() == 1) {
                IFile file = (IFile)res;
                AJLog.log("Looking for type references for " + oldName + " in " + file);
                TextFileChange change = new TextFileChange(cu.getElementName(), file);
                TextEdit te = AspectRenameParticipant.renameJavaSpecificReferences(cu, this.fType, newName);
                TextEdit[] te2 = this.renameAspectSpecificReferences(cu, this.fType, newName);
                if (te2 != null && te2.length > 0) {
                    if (te == null) {
                        te = new MultiTextEdit();
                    }
                    int i = 0;
                    while (i < te2.length) {
                        te.addChild(te2[i]);
                        ++i;
                    }
                }
                if (te != null) {
                    change.setEdit(te);
                    changes.add((Change)change);
                }
            }
            pm.worked(1);
        }
        pm.done();
        if (changes.getChildren().length == 0) {
            return null;
        }
        return changes;
    }

    private TextEdit[] renameAspectSpecificReferences(AJCompilationUnit ajcu, IType type, String newName) throws JavaModelException {
        ArrayList<ReplaceEdit> editList = new ArrayList<ReplaceEdit>();
        String name = type.getElementName();
        IType[] types = ajcu.getTypes();
        int i = 0;
        while (i < types.length) {
            AspectChange[] aspectChanges;
            if (types[i] instanceof AspectElement && (aspectChanges = this.searchForReferenceInPointcut(ajcu, (AspectElement)types[i], name, type.getFullyQualifiedName())).length > 0) {
                int j = 0;
                while (j < aspectChanges.length) {
                    if (aspectChanges[j].element instanceof ISourceReference) {
                        ISourceRange range = aspectChanges[j].element.getSourceRange();
                        List offsets = aspectChanges[j].offsets;
                        for (Integer o : offsets) {
                            int offset = range.getOffset() + o - name.length();
                            ReplaceEdit edit = new ReplaceEdit(offset, name.length(), newName);
                            editList.add(edit);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return editList.toArray(new TextEdit[editList.size()]);
    }

    private static TextEdit renameJavaSpecificReferences(AJCompilationUnit ajcu, IType type, final String newName) throws JavaModelException {
        final String name = type.getElementName();
        final String fqn = type.getFullyQualifiedName();
        ajcu.requestOriginalContentMode();
        final int origLen = ajcu.getSource().length();
        ajcu.discardOriginalContentMode();
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource((ICompilationUnit)ajcu);
        parser.setResolveBindings(true);
        final CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        final ASTRewrite rewrite = ASTRewrite.create((AST)cu.getAST());
        cu.accept(new ASTVisitor(){

            public boolean visit(SimpleName node) {
                int endPos;
                String qual;
                ITypeBinding binding;
                String id = node.getIdentifier();
                if (id.equals(name) && (binding = node.resolveTypeBinding()) != null && (qual = binding.getQualifiedName()).equals(fqn) && (endPos = node.getStartPosition() + node.getLength()) < origLen) {
                    SimpleName replacement = cu.getAST().newSimpleName(newName);
                    rewrite.replace((ASTNode)node, (ASTNode)replacement, null);
                }
                return true;
            }
        });
        TextEdit edits = rewrite.rewriteAST();
        if (edits.getLength() == 0) {
            return null;
        }
        return edits;
    }

    private AspectChange[] searchForReferenceInPointcut(AJCompilationUnit ajcu, AspectElement aspect, String name, String qualifiedName) throws JavaModelException {
        boolean samePackage = this.removeTypeName(aspect.getFullyQualifiedName()).equals(this.removeTypeName(qualifiedName));
        ArrayList<AspectChange> elementsToChange = new ArrayList<AspectChange>();
        ArrayList elementsToSearch = new ArrayList();
        elementsToSearch.addAll(Arrays.asList(aspect.getAdvice()));
        elementsToSearch.addAll(Arrays.asList(aspect.getPointcuts()));
        elementsToSearch.addAll(Arrays.asList(aspect.getDeclares()));
        elementsToSearch.addAll(Arrays.asList(aspect.getITDs()));
        for (IAspectJElement element : elementsToSearch) {
            if (!(element instanceof ISourceReference)) continue;
            ajcu.requestOriginalContentMode();
            String src = element.getSource();
            ajcu.discardOriginalContentMode();
            Map map = PointcutUtilities.findAllIdentifiers(src);
            if (map == null) continue;
            for (String id : map.keySet()) {
                if (!id.equals(name)) continue;
                IImportDeclaration imp = ajcu.getImport(qualifiedName);
                if (!samePackage && !imp.exists()) continue;
                AJLog.log("found reference");
                AspectChange ac = new AspectChange();
                ac.element = element;
                ac.offsets = (List)map.get(id);
                elementsToChange.add(ac);
            }
        }
        return elementsToChange.toArray(new AspectChange[0]);
    }

    private String removeTypeName(String qualifiedName) {
        int ind = qualifiedName.lastIndexOf(46);
        if (ind == -1) {
            return qualifiedName;
        }
        return qualifiedName.substring(0, ind);
    }

    public String getName() {
        return "";
    }

    protected boolean initialize(Object element) {
        if (element instanceof IType) {
            this.fType = (IType)element;
            return true;
        }
        return false;
    }

    static class AspectChange {
        IAspectJElement element;
        List offsets;

        AspectChange() {
        }
    }
}

