/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.jdt.preferences;

import org.eclipse.contribution.jdt.JDTWeavingPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Version;

public class JDTWeavingPreferences {
    public static final String ASK_TO_ENABLE_WEAVING = "org.eclipse.contribution.weaving.jdt.ask";
    public static final String LAST_VERSION = "org.eclipse.contribution.weaving.jdt.version";
    public static final String HOOK_ID = "org.eclipse.equinox.weaving.hook";

    private JDTWeavingPreferences() {
    }

    public static boolean shouldAskToEnableWeaving() {
        return JDTWeavingPreferences.getAsk() || !JDTWeavingPreferences.getCurrentVersion().equals(JDTWeavingPreferences.getLastVersion());
    }

    public static void setAskToEnableWeaving(boolean value) {
        JDTWeavingPreferences.setAsk(value);
        JDTWeavingPreferences.setLastVersion();
    }

    public static void setAsk(boolean value) {
        Preferences store = JDTWeavingPreferences.getPreferences();
        store.setValue(ASK_TO_ENABLE_WEAVING, value ? "true" : "false");
        JDTWeavingPlugin.getInstance().savePluginPreferences();
    }

    public static boolean getAsk() {
        Preferences store = JDTWeavingPreferences.getPreferences();
        String value = store.getString(ASK_TO_ENABLE_WEAVING);
        return value == "" || value.equals("true");
    }

    public static void setLastVersion() {
        Preferences store = JDTWeavingPreferences.getPreferences();
        store.setValue(LAST_VERSION, JDTWeavingPreferences.getCurrentVersion().toString());
        JDTWeavingPlugin.getInstance().savePluginPreferences();
    }

    public static String getLastVersion() {
        Preferences store = JDTWeavingPreferences.getPreferences();
        return store.getString(LAST_VERSION);
    }

    private static String getCurrentVersion() {
        BundleDescription hook = Platform.getPlatformAdmin().getState(false).getBundle(HOOK_ID, null);
        return (hook != null ? hook.getVersion() : new Version(0, 0, 0)).toString();
    }

    public static Preferences getPreferences() {
        return JDTWeavingPlugin.getInstance().getPluginPreferences();
    }
}

