/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.generic.Tag;
import org.aspectj.apache.bcel.generic.Type;

public final class LocalVariableTag
extends Tag {
    private Type type;
    private final String signature;
    private String name;
    private int slot;
    private final int startPos;
    boolean remapped = false;
    private int hashCode = 0;

    public LocalVariableTag(String sig, String name, int slot, int startPosition) {
        this.signature = sig;
        this.name = name;
        this.slot = slot;
        this.startPos = startPosition;
    }

    public LocalVariableTag(Type t, String sig, String name, int slot, int startPosition) {
        this.type = t;
        this.signature = sig;
        this.name = name;
        this.slot = slot;
        this.startPos = startPosition;
    }

    public String getName() {
        return this.name;
    }

    public int getSlot() {
        return this.slot;
    }

    public String getType() {
        return this.signature;
    }

    public Type getRealType() {
        return this.type;
    }

    public void updateSlot(int newSlot) {
        this.slot = newSlot;
        this.remapped = true;
    }

    public boolean isRemapped() {
        return this.remapped;
    }

    public String toString() {
        return "local " + this.slot + ": " + this.signature + " " + this.name;
    }

    public boolean equals(Object other) {
        if (!(other instanceof LocalVariableTag)) {
            return false;
        }
        LocalVariableTag o = (LocalVariableTag)other;
        return o.slot == this.slot && o.startPos == this.startPos && o.signature.equals(this.signature) && o.name.equals(this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int ret = 17;
            ret = 37 * ret + this.signature.hashCode();
            ret = 37 * ret + this.name.hashCode();
            ret = 37 * ret + this.slot;
            this.hashCode = ret = 37 * ret + this.startPos;
        }
        return this.hashCode;
    }
}

