/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.ajde.core.AjCompiler;
import org.aspectj.ajde.core.IBuildMessageHandler;
import org.aspectj.ajde.core.IBuildProgressMonitor;
import org.aspectj.ajde.core.ICompilerConfiguration;
import org.eclipse.ajdt.internal.core.ajde.ICompilerFactory;
import org.eclipse.ajdt.internal.ui.ajde.UIBuildProgressMonitor;
import org.eclipse.ajdt.internal.ui.ajde.UIComplierConfiguration;
import org.eclipse.ajdt.internal.ui.ajde.UIMessageHandler;
import org.eclipse.core.resources.IProject;

public class UICompilerFactory
implements ICompilerFactory {
    private Map compilerMap = new HashMap();

    public AjCompiler getCompilerForProject(IProject project) {
        if (this.compilerMap.get(project) != null) {
            return (AjCompiler)this.compilerMap.get(project);
        }
        AjCompiler compiler = new AjCompiler(project.getName(), (ICompilerConfiguration)new UIComplierConfiguration(project), (IBuildProgressMonitor)new UIBuildProgressMonitor(project), (IBuildMessageHandler)new UIMessageHandler(project));
        this.compilerMap.put(project, compiler);
        return compiler;
    }

    public void removeCompilerForProject(IProject project) {
        AjCompiler compiler = (AjCompiler)this.compilerMap.get(project);
        if (compiler != null) {
            compiler.clearLastState();
            this.compilerMap.remove(project);
        }
    }

    public boolean hasCompilerForProject(IProject project) {
        return this.compilerMap.get(project) != null;
    }
}

