/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.ajdt.core.AopXmlPreferences;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.viewsupport.FilteredElementTreeSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class AopXmlPreferencePage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private final int IDX_ADD = 0;
    private final int IDX_REMOVE = 1;
    private final int IDX_EDIT = 2;
    private final String[] buttonLabels = new String[]{"Add", "Remove", "Edit"};
    private ListDialogField control;
    private AopXmlPreferences preferenceStore;

    public void editSelected() {
        IPath path = (IPath)this.control.getSelectedElements().get(0);
        IPath[] newPaths = this.chooseAopXmlEntries(this.getShell(), path, this.getElementsAsArray());
        if (newPaths != null) {
            int index = this.control.getIndexOfElement((Object)path);
            this.control.removeElement((Object)path);
            if (newPaths != null) {
                int i = 0;
                while (i < newPaths.length) {
                    this.control.addElement((Object)newPaths[i], index++);
                    ++i;
                }
            }
        }
    }

    public void removeSelected() {
        this.control.removeElements(this.control.getSelectedElements());
    }

    public void addNew() {
        IPath[] newPaths = this.chooseAopXmlEntries(this.getShell(), null, this.getElementsAsArray());
        if (newPaths != null) {
            int i = 0;
            while (i < newPaths.length) {
                this.control.addElement((Object)newPaths[i]);
                ++i;
            }
        }
    }

    public void storePreferences() {
        List elements = this.control.getElements();
        this.preferenceStore.setAopXmlFiles(elements != null ? elements.toArray(new IPath[0]) : null);
    }

    private void initializeContents() {
        IPath[] paths = this.preferenceStore.getAopXmlFiles();
        this.control.setElements((Collection)Arrays.asList(paths));
    }

    public IPath[] chooseAopXmlEntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        Class[] acceptedClasses = new Class[]{IFile.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        ArrayList<IResource> usedJars = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource = root.findMember(usedEntries[i]);
            if (resource instanceof IFile) {
                usedJars.add(resource);
            }
            ++i;
        }
        IResource focus = initialSelection != null ? root.findMember(initialSelection) : null;
        FilteredElementTreeSelectionDialog dialog = new FilteredElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInitialFilter("*.xml");
        dialog.setHelpAvailable(false);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle("aop.xml selection");
        dialog.setMessage("Choose the aop.xml files to be added to the build");
        dialog.setInput((Object)this.getProject());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setInitialSelection((Object)focus);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPath[] res = new IPath[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = elem.getFullPath();
                ++i2;
            }
            return res;
        }
        return null;
    }

    private IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }

    protected Control createContents(Composite parent) {
        this.preferenceStore = new AopXmlPreferences(this.getProject());
        AopXmlAdapter adapter = new AopXmlAdapter();
        this.control = new ListDialogField((IListAdapter)adapter, this.buttonLabels, (ILabelProvider)new AopXmlLabelProvider());
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.control}, (boolean)true, (int)-1, (int)-1);
        LayoutUtil.setHorizontalGrabbing((Control)this.control.getListControl(parent));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.control.setButtonsMinWidth(buttonBarWidth);
        this.control.setDialogFieldListener((IDialogFieldListener)adapter);
        this.control.enableButton(2, false);
        this.initializeContents();
        return composite;
    }

    private IPath[] getElementsAsArray() {
        List paths = this.control.getElements();
        return paths.toArray(new IPath[0]);
    }

    protected class AopXmlAdapter
    implements IDialogFieldListener,
    IListAdapter {
        protected AopXmlAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            AopXmlPreferencePage.this.storePreferences();
        }

        public void customButtonPressed(ListDialogField field, int index) {
            switch (index) {
                case 0: {
                    AopXmlPreferencePage.this.addNew();
                    break;
                }
                case 1: {
                    AopXmlPreferencePage.this.removeSelected();
                    break;
                }
                case 2: {
                    AopXmlPreferencePage.this.editSelected();
                }
            }
        }

        public void doubleClicked(ListDialogField field) {
            AopXmlPreferencePage.this.editSelected();
        }

        public void selectionChanged(ListDialogField field) {
            if (field.getSelectedElements().size() == 1) {
                field.enableButton(2, true);
            } else {
                field.enableButton(2, false);
            }
        }
    }

    private class AopXmlLabelProvider
    implements ILabelProvider {
        private Image image = AspectJImages.AOP_XML.getImageDescriptor().createImage();

        private AopXmlLabelProvider() {
        }

        public Image getImage(Object element) {
            return this.image;
        }

        public String getText(Object element) {
            return ((IPath)element).toPortableString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            this.image.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

