/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core;

import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.IAJLogger;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.internal.core.CompilerConfigResourceChangeListener;
import org.eclipse.ajdt.internal.core.ajde.CoreCompilerFactory;
import org.eclipse.ajdt.internal.core.ajde.ICompilerFactory;
import org.eclipse.ajdt.internal.core.contentassist.ContentAssistProvider;
import org.eclipse.ajdt.internal.core.ras.NoFFDC;
import org.eclipse.contribution.jdt.IsWovenTester;
import org.eclipse.contribution.jdt.itdawareness.ITDAwarenessAspect;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class AspectJPlugin
extends Plugin
implements NoFFDC {
    private static AspectJPlugin plugin;
    public static final String PLUGIN_ID = "org.eclipse.ajdt.core";
    public static final String TOOLS_PLUGIN_ID = "org.aspectj.ajde";
    public static final String WEAVER_PLUGIN_ID = "org.aspectj.weaver";
    public static final String RUNTIME_PLUGIN_ID = "org.aspectj.runtime";
    public static final String ID_BUILDER = "org.eclipse.ajdt.core.ajbuilder";
    public static final String DEFAULT_CONFIG_FILE = ".generated.lst";
    public static final String UI_PLUGIN_ID = "org.eclipse.ajdt.ui";
    public static final String ID_NATURE = "org.eclipse.ajdt.ui.ajnature";
    public static final String JAVA_NATURE_ID = "org.eclipse.jdt.core.javanature";
    public static final String AJ_FILE_EXT = "aj";
    public static final String ASPECTJRT_CONTAINER = "org.eclipse.ajdt.core.ASPECTJRT_CONTAINER";
    public static final String[] ajKeywords;
    public static final String[] declareAnnotationKeywords;
    public static final String NON_OS_SPECIFIC_SEPARATOR = "/";
    public static final boolean USING_CU_PROVIDER;
    private ICompilerFactory compilerFactory;

    static {
        ajKeywords = new String[]{"aspect", "pointcut", "privileged", "call", "execution", "initialization", "preinitialization", "handler", "get", "set", "staticinitialization", "target", "args", "within", "withincode", "cflow", "cflowbelow", "annotation", "before", "after", "around", "proceed", "throwing", "returning", "adviceexecution", "declare", "parents", "warning", "error", "soft", "precedence", "thisJoinPoint", "thisJoinPointStaticPart", "thisEnclosingJoinPointStaticPart", "issingleton", "perthis", "pertarget", "percflow", "percflowbelow", "pertypewithin", "@type", "@method", "@field"};
        declareAnnotationKeywords = new String[]{"type", "method", "field"};
        USING_CU_PROVIDER = AspectJPlugin.checkForCUprovider();
    }

    public AspectJPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        AspectJPlugin.checkForCUprovider();
        AspectJPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new CompilerConfigResourceChangeListener(), 5);
        this.setCompilerFactory(new CoreCompilerFactory());
        ITDAwarenessAspect.contentAssistProvider = new ContentAssistProvider();
        AJProjectModelFacade.installListener();
    }

    private static boolean checkForCUprovider() {
        try {
            return IsWovenTester.isWeavingActive();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static AspectJPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static boolean isAJProject(IProject project) {
        if (project != null && project.isAccessible()) {
            try {
                if (project.hasNature(ID_NATURE)) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public void setAJLogger(IAJLogger logger) {
        AJLog.setLogger(logger);
    }

    public ICompilerFactory getCompilerFactory() {
        return this.compilerFactory;
    }

    public void setCompilerFactory(ICompilerFactory compilerFactory) {
        this.compilerFactory = compilerFactory;
    }
}

