/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.refactoring;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJCore;
import org.eclipse.ajdt.core.codeconversion.AspectsConvertingParser;
import org.eclipse.ajdt.core.javaelements.DeclareElement;
import org.eclipse.ajdt.core.javaelements.IAspectJElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringDescriptor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class PushInRefactoring
extends Refactoring {
    public static final String ALL_ITDS = "all.itds";
    public static final String DELETE_EMPTY = "delete.empty";
    private boolean deleteEmpty = true;
    private Map allChanges = null;
    private List itds = null;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("Checking preconditions...", 2);
            this.allChanges = new LinkedHashMap();
            HashMap unitToITDs = new HashMap();
            for (IAspectJElement itd : this.itds) {
                List<IAspectJElement> itds;
                ICompilationUnit unit = itd.getCompilationUnit();
                if (unitToITDs.containsKey(unit)) {
                    itds = (List)unitToITDs.get(unit);
                } else {
                    itds = new LinkedList();
                    unitToITDs.put(unit, itds);
                }
                itds.add(itd);
            }
            HashMap importsMap = new HashMap();
            for (Map.Entry entry : unitToITDs.entrySet()) {
                status.merge(this.checkFinalConditionsForITD((ICompilationUnit)entry.getKey(), (List)entry.getValue(), importsMap, monitor));
            }
            for (NewImportsHolder holder : importsMap.values()) {
                holder.rewriteImports();
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private RefactoringStatus checkFinalConditionsForITD(final ICompilationUnit ajUnit, final List itdsForUnit, final Map imports, final IProgressMonitor monitor) throws JavaModelException {
        Collection<ICompilationUnit> units;
        final RefactoringStatus status = new RefactoringStatus();
        final Map unitsToTypes = this.getUnitTypeMap(this.getTargets(itdsForUnit));
        HashMap projects = new HashMap();
        for (ICompilationUnit targetUnit : unitsToTypes.keySet()) {
            IJavaProject project = targetUnit.getJavaProject();
            if (project == null) continue;
            ArrayList<ICompilationUnit> collection = (ArrayList<ICompilationUnit>)projects.get(project);
            if (collection == null) {
                collection = new ArrayList<ICompilationUnit>();
                projects.put(project, collection);
            }
            collection.add(targetUnit);
        }
        IJavaProject aspectProject = ajUnit.getJavaProject();
        if (projects.containsKey(aspectProject)) {
            units = (Collection)projects.get(aspectProject);
        } else {
            units = new ArrayList();
            projects.put(aspectProject, units);
        }
        units.add(ajUnit);
        ASTRequestor requestors = new ASTRequestor(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

            public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
                try {
                    NewImportsHolder holder;
                    if (imports.containsKey(source)) {
                        holder = (NewImportsHolder)imports.get(source);
                    } else {
                        holder = new NewImportsHolder(source);
                        imports.put(source, holder);
                    }
                    holder.computeImports(itdsForUnit, ajUnit, monitor);
                    if (PushInRefactoring.this.isCUnitContainingITD(source, (IAspectJElement)itdsForUnit.get(0))) {
                        PushInRefactoring.this.rewriteAspectType(itdsForUnit, source, ast, status);
                    } else {
                        boolean declareParentsDone = false;
                        for (IAspectJElement itd : itdsForUnit) {
                            ArrayList members = new ArrayList();
                            members.addAll((Collection)unitsToTypes.get(source));
                            AJProjectModelFacade model = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)itd);
                            List realTargets = itd.getAJKind().isDeclareAnnotation() ? model.getRelationshipsForElement((IJavaElement)itd, AJRelationshipManager.ANNOTATES) : model.getRelationshipsForElement((IJavaElement)itd, AJRelationshipManager.DECLARED_ON);
                            Iterator memberIter = members.iterator();
                            while (memberIter.hasNext()) {
                                IMember member = (IMember)memberIter.next();
                                if (realTargets.contains(member)) continue;
                                memberIter.remove();
                            }
                            if (members.size() <= 0) continue;
                            if (itd.getAJKind() == IProgramElement.Kind.DECLARE_PARENTS) {
                                if (declareParentsDone) continue;
                                declareParentsDone = true;
                            }
                            PushInRefactoring.this.applyTargetTypeEdits(itd, source, members);
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
                }
            }

            static {
                Factory factory = new Factory("PushInRefactoring.java", Class.forName("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoring$1"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoring$1", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 378);
                ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "acceptAST", "org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoring$1", "org.eclipse.jdt.core.ICompilationUnit:org.eclipse.jdt.core.dom.CompilationUnit:", "source:ast:", "", "void"), 317);
                ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoring$1", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 379);
            }
        };
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        try {
            try {
                Set set = projects.keySet();
                subMonitor.beginTask("Compiling source...", set.size());
                for (IJavaProject project : projects.keySet()) {
                    ASTParser parser = ASTParser.newParser((int)3);
                    parser.setProject(project);
                    parser.setResolveBindings(true);
                    Collection collection = (Collection)projects.get(project);
                    parser.createASTs(collection.toArray(new ICompilationUnit[collection.size()]), new String[0], requestors, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1));
                }
            }
            finally {
                subMonitor.done();
            }
        }
        finally {
            subMonitor.done();
        }
        return status;
    }

    protected void rewriteAspectType(List itdsForUnit, ICompilationUnit source, CompilationUnit ast, RefactoringStatus status) throws JavaModelException, CoreException {
        HashMap<IType, Integer> removalStored = new HashMap<IType, Integer>();
        HashMap typeDeletes = new HashMap();
        for (IAspectJElement itd : itdsForUnit) {
            List<DeleteEdit> deletes;
            IType type = (IType)itd.getParent();
            if (removalStored.containsKey(type)) {
                int numRemovals = (Integer)removalStored.get(type);
                removalStored.put(type, new Integer(++numRemovals));
            } else {
                removalStored.put(type, new Integer(1));
            }
            if (typeDeletes.containsKey(type)) {
                deletes = (List)typeDeletes.get(type);
            } else {
                deletes = new LinkedList();
                typeDeletes.put(type, deletes);
            }
            DeleteEdit edit = new DeleteEdit(itd.getSourceRange().getOffset(), itd.getSourceRange().getLength() + 1);
            deletes.add(edit);
        }
        if (this.deleteTypes(ast, typeDeletes, removalStored)) {
            this.allChanges.put(source, new DeleteResourceChange(source.getResource().getFullPath(), false));
        } else {
            this.applyAspectEdits(source, typeDeletes);
        }
    }

    private boolean deleteTypes(CompilationUnit ast, Map typeDeletes, Map removalStored) throws JavaModelException {
        if (!this.deleteEmpty) {
            return false;
        }
        int typesDeleted = 0;
        for (Map.Entry entry : removalStored.entrySet()) {
            IType type = (IType)entry.getKey();
            int removals = (Integer)entry.getValue();
            if (type.getChildren().length != removals) continue;
            List typeNodes = ast.types();
            for (AbstractTypeDeclaration typeNode : typeNodes) {
                if (!typeNode.getName().toString().equals(type.getElementName())) continue;
                List deletes = (List)typeDeletes.get(type);
                deletes.clear();
                deletes.add(new DeleteEdit(type.getSourceRange().getOffset(), type.getSourceRange().getLength()));
                ++typesDeleted;
            }
        }
        return ast.types().size() == typesDeleted;
    }

    private void applyTargetTypeEdits(IAspectJElement itd, ICompilationUnit source, Collection targets) throws CoreException, JavaModelException {
        MultiTextEdit multiEdit = new MultiTextEdit();
        for (IMember target : targets) {
            Object edit = null;
            if (itd instanceof IntertypeElement) {
                if (target instanceof IType) {
                    IType type = (IType)target;
                    edit = type.isInterface() && itd.getAJKind() != IProgramElement.Kind.INTER_TYPE_METHOD ? null : this.createEditForITDTarget((IntertypeElement)itd, type);
                }
            } else if (itd.getAJKind().isDeclareAnnotation()) {
                edit = this.createEditForDeclareTarget((DeclareElement)itd, target);
            } else if (itd.getAJKind() == IProgramElement.Kind.DECLARE_PARENTS) {
                edit = this.createEditForDeclareParents((IType)target);
            }
            if (edit == null) continue;
            multiEdit.addChild(edit);
        }
        if (!this.isEmptyEdit((TextEdit)multiEdit)) {
            TextFileChange change = (TextFileChange)this.allChanges.get(source);
            if (change == null) {
                change = new TextFileChange(source.getElementName(), (IFile)source.getResource());
                change.setTextType("java");
                change.setEdit((TextEdit)new MultiTextEdit());
                this.allChanges.put(source, change);
            }
            change.getEdit().addChild((TextEdit)multiEdit);
        }
    }

    private String getQualifiedTypeForDeclareAnnotation(DeclareElement itd) {
        IProgramElement ipe = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)itd).javaElementToProgramElement((IJavaElement)itd);
        if (ipe != null) {
            return ipe.getAnnotationType();
        }
        return null;
    }

    private TextEdit createEditForDeclareParents(IType type) throws JavaModelException {
        AspectsConvertingParser parser = new AspectsConvertingParser(null);
        parser.setUnit(type.getCompilationUnit());
        char[] implementsExtends = parser.createImplementExtendsITDs(type.getElementName().toCharArray());
        String source = type.getSource();
        String toSearch = type.isClass() ? "class" : "interface";
        int implExtEnd = source.indexOf("{");
        int implExtStart = source.lastIndexOf(toSearch, implExtEnd);
        int offset = type.getSourceRange().getOffset();
        return new ReplaceEdit(offset + implExtStart, implExtEnd - implExtStart, new String(implementsExtends));
    }

    private TextEdit createEditForDeclareTarget(DeclareElement itd, IMember target) throws JavaModelException {
        return new InsertEdit(this.getDeclareInsertLocation(target), this.getTextForDeclare(itd));
    }

    private String getTextForDeclare(DeclareElement itd) throws JavaModelException {
        IProgramElement ipe = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)itd).javaElementToProgramElement((IJavaElement)itd);
        if (ipe != null) {
            String details = ipe.getDetails();
            int colonIndex = details.indexOf(58);
            String text = details.substring(colonIndex + 1).trim();
            if (itd.getAJKind() == IProgramElement.Kind.DECLARE_ANNOTATION_AT_TYPE) {
                return String.valueOf(text) + "\n";
            }
            return String.valueOf(text) + "\n\t";
        }
        throw new RuntimeException("Could not find program element in AspectJ model for " + itd.getHandleIdentifier());
    }

    private int getDeclareInsertLocation(IMember target) throws JavaModelException {
        return target.getSourceRange().getOffset();
    }

    private TextEdit createEditForITDTarget(IntertypeElement itd, IType target) throws JavaModelException {
        InsertEdit edit = target.isInterface() ? new InsertEdit(this.getITDInsertLocation(target), this.getTargetTextForInterface(itd)) : new InsertEdit(this.getITDInsertLocation(target), this.getTargetTextForClass(itd));
        return edit;
    }

    private String getTargetTextForClass(IntertypeElement itd) throws JavaModelException {
        String maybeConstructor;
        String[] maybeConstructorArr;
        String itdName = itd.getElementName();
        String[] splits = itdName.split("\\.");
        String newName = splits[splits.length - 1];
        if ((itdName = itdName.replaceAll("\\.", "\\\\\\$")).endsWith("_new") && (maybeConstructorArr = (maybeConstructor = itdName.substring(0, itdName.length() - "_new".length())).split("\\\\\\$")).length == 2 && maybeConstructorArr[0].equals(maybeConstructorArr[1])) {
            itdName = String.valueOf(maybeConstructorArr[0]) + "\\$new";
            newName = maybeConstructorArr[0];
        }
        String targetSource = "\n\t" + itd.getSource() + "\n";
        targetSource = targetSource.replaceAll(itdName, newName);
        return targetSource;
    }

    private String getTargetTextForInterface(IntertypeElement itd) throws JavaModelException {
        String itdName = itd.getElementName();
        String[] splits = itdName.split("\\.");
        String newName = splits[splits.length - 1];
        itdName = itdName.replaceAll("\\.", "\\\\\\$");
        String targetSource = "\t" + itd.getSource() + "\n";
        int nameStart = targetSource.indexOf(itdName);
        int closeParen = targetSource.indexOf(")", nameStart);
        targetSource = "\n" + targetSource.substring(0, closeParen) + ";\n";
        targetSource = targetSource.replaceAll(itdName, newName);
        return targetSource;
    }

    private int getITDInsertLocation(IType type) throws JavaModelException {
        return type.getSourceRange().getOffset() + type.getSourceRange().getLength() - 1;
    }

    private void applyAspectEdits(ICompilationUnit source, Map typeDeletes) throws JavaModelException, CoreException {
        MultiTextEdit edit = new MultiTextEdit();
        for (List deletesForOneType : typeDeletes.values()) {
            for (DeleteEdit delete : deletesForOneType) {
                edit.addChild((TextEdit)delete);
            }
        }
        if (!this.isEmptyEdit((TextEdit)edit)) {
            TextFileChange change = (TextFileChange)this.allChanges.get(source);
            if (change == null) {
                change = new TextFileChange(source.getElementName(), (IFile)source.getResource());
                change.setTextType("java");
                change.setEdit((TextEdit)edit);
                this.allChanges.put(source, change);
            } else {
                change.getEdit().addChild((TextEdit)edit);
            }
        }
    }

    private Map getUnitTypeMap(IMember[] targets) {
        HashMap unitToTypes = new HashMap();
        int i = 0;
        while (i < targets.length) {
            Set<IMember> currTypes;
            IMember target = targets[i];
            ICompilationUnit unit = target.getCompilationUnit();
            if (unitToTypes.containsKey(unit)) {
                currTypes = (Set)unitToTypes.get(unit);
            } else {
                currTypes = new HashSet();
                unitToTypes.put(unit, currTypes);
            }
            currTypes.add(target);
            ++i;
        }
        return unitToTypes;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        RefactoringStatus status = new RefactoringStatus();
        monitor.beginTask("Checking preconditions...", 1);
        try {
            for (IAspectJElement itd : this.itds) {
                status.merge(this.initialITDCheck(itd));
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private RefactoringStatus initialITDCheck(IAspectJElement itd) {
        RefactoringStatus status = new RefactoringStatus();
        AJProjectModelFacade model = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)itd);
        if (!model.hasModel()) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)"Rebuild project.  No crosscutting model available."));
        }
        try {
            if (itd == null) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)"Intertype declaration has not been specified"));
            } else if (!itd.exists()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("ITD ''{0}'' does not exist.", itd.getElementName())));
            } else if (!itd.getCompilationUnit().isStructureKnown()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("Compilation unit ''{0}'' contains compile errors.", itd.getCompilationUnit().getElementName())));
            }
            IMember[] targets = this.getTargets(Collections.singletonList(itd));
            int i = 0;
            while (i < targets.length) {
                IMember target = targets[i];
                if (!target.exists()) {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("Target type ''{0}'' does not exist.", target.getElementName())));
                } else if (target.isBinary()) {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("Target type ''{0}'' is binary.", target.getElementName())));
                } else if (!itd.getCompilationUnit().isStructureKnown()) {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("Compilation unit ''{0}'' contains compile errors.", target.getCompilationUnit().getElementName())));
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            JavaModelException e = javaModelException;
            status.addFatalError("JavaModelException:\n\t" + e.getMessage() + "\n\t" + e.getJavaModelStatus().getMessage());
        }
        return status;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        monitor.beginTask("Creating change...", 1);
        try {
            CompositeChange change;
            Collection changes = this.allChanges.values();
            CompositeChange compositeChange = change = new CompositeChange(this.getName(), changes.toArray(new Change[changes.size()])){

                public ChangeDescriptor getDescriptor() {
                    return new RefactoringChangeDescriptor((RefactoringDescriptor)PushInRefactoring.this.createDescriptor());
                }
            };
            return compositeChange;
        }
        finally {
            monitor.done();
        }
    }

    public PushInRefactoringDescriptor createDescriptor() {
        StringBuffer projectsb = new StringBuffer();
        StringBuffer descriptionsb = new StringBuffer();
        StringBuffer commentsb = new StringBuffer();
        StringBuffer argssb = new StringBuffer();
        for (IAspectJElement itd : this.itds) {
            projectsb.append(String.valueOf(itd.getJavaProject().getElementName()) + "\n");
            descriptionsb.append(MessageFormat.format("Push In intertype declaration for ''{0}''\n", itd.getElementName()));
            String itdLabel = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)itd).getJavaElementLinkName((IJavaElement)itd);
            commentsb.append(MessageFormat.format("Push In intertype declaration for ''{0}''\n", itdLabel));
            argssb.append(String.valueOf(itd.getHandleIdentifier()) + "\n");
        }
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put(ALL_ITDS, argssb.toString());
        return new PushInRefactoringDescriptor(projectsb.toString(), descriptionsb.toString(), commentsb.toString(), arguments);
    }

    public String getName() {
        return "Push-In";
    }

    public RefactoringStatus initialize(Map arguments) {
        String value = (String)arguments.get(ALL_ITDS);
        if (value != null) {
            String[] values = value.split("\\n");
            ArrayList<IJavaElement> newitds = new ArrayList<IJavaElement>(values.length);
            int i = 0;
            while (i < values.length) {
                newitds.add(AspectJCore.create((String)value));
                ++i;
            }
            this.setITDs(newitds);
            return new RefactoringStatus();
        }
        return RefactoringStatus.createErrorStatus((String)"No ITD specified.");
    }

    public void setITDs(List itds) {
        this.itds = itds;
    }

    public List getITDs() {
        return this.itds;
    }

    private IMember[] getTargets(List itds) throws JavaModelException {
        AJProjectModelFacade model = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)itds.get(0));
        ArrayList targets = new ArrayList();
        for (IAspectJElement itd : itds) {
            List elts = itd.getAJKind().isDeclareAnnotation() ? model.getRelationshipsForElement((IJavaElement)itd, AJRelationshipManager.ANNOTATES) : model.getRelationshipsForElement((IJavaElement)itd, AJRelationshipManager.DECLARED_ON);
            Iterator eltIter = elts.iterator();
            while (eltIter.hasNext()) {
                targets.add(eltIter.next());
            }
        }
        return targets.toArray(new IMember[targets.size()]);
    }

    private boolean isEmptyEdit(TextEdit edit) {
        return edit.getClass() == MultiTextEdit.class && !edit.hasChildren();
    }

    private boolean isCUnitContainingITD(ICompilationUnit unit, IAspectJElement itd) {
        return itd != null && itd.getCompilationUnit().equals(unit);
    }

    private String transformedITDName(IntertypeElement itd) {
        String maybeConstructor;
        String[] maybeConstructorArr;
        String name = itd.getElementName();
        if (name.endsWith("_new") && (maybeConstructorArr = (maybeConstructor = name.substring(0, name.length() - "_new".length())).split("\\.")).length == 2 && maybeConstructorArr[0].equals(maybeConstructorArr[1])) {
            return String.valueOf(maybeConstructorArr[0]) + "$new";
        }
        return name.replace('.', '$');
    }

    static {
        Factory factory = new Factory("PushInRefactoring.java", Class.forName("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoring"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoring", "org.eclipse.jdt.core.JavaModelException:", "e:"), 720);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "initialITDCheck", "org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoring", "org.eclipse.ajdt.core.javaelements.IAspectJElement:", "itd:", "", "org.eclipse.ltk.core.refactoring.RefactoringStatus"), 689);
    }

    private class NewImportsHolder {
        Set staticImports = new HashSet();
        Set typeImports = new HashSet();
        Set extraImports = new HashSet();
        ICompilationUnit unit;

        NewImportsHolder(ICompilationUnit unit) {
            this.unit = unit;
        }

        void rewriteImports() throws CoreException {
            Change change = (Change)PushInRefactoring.this.allChanges.get(this.unit);
            if (!(change instanceof TextFileChange)) {
                return;
            }
            ImportRewrite rewrite = ImportRewrite.create((ICompilationUnit)this.unit, (boolean)true);
            for (Name name : this.typeImports) {
                ITypeBinding binding = name.resolveTypeBinding();
                if (binding == null) continue;
                rewrite.addImport(binding);
            }
            for (Name name : this.staticImports) {
                rewrite.addImport(name.resolveTypeBinding());
            }
            for (String qualName : this.extraImports) {
                rewrite.addImport(qualName);
            }
            TextEdit importEdit = rewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor());
            TextFileChange textChange = (TextFileChange)change;
            if (change == null) {
                change = new TextFileChange(this.unit.getElementName(), (IFile)this.unit.getResource());
                textChange.setTextType("java");
                textChange.setEdit((TextEdit)new MultiTextEdit());
                PushInRefactoring.this.allChanges.put(this.unit, change);
            }
            textChange.getEdit().addChild(importEdit);
        }

        void computeImports(List itds, ICompilationUnit ajUnit, IProgressMonitor monitor) throws JavaModelException {
            IJavaProject project = ajUnit.getJavaProject();
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setProject(project);
            parser.setResolveBindings(true);
            parser.setSource(ajUnit);
            parser.setKind(8);
            CompilationUnit ajAST = (CompilationUnit)parser.createAST(monitor);
            for (IAspectJElement itd : itds) {
                ISourceRange range = itd.getSourceRange();
                ImportReferencesCollector.collect((ASTNode)ajAST, (IJavaProject)project, (Region)new Region(range.getOffset(), range.getLength()), (Collection)this.typeImports, (Collection)this.staticImports);
                if (!(itd instanceof DeclareElement)) continue;
                String qualType = PushInRefactoring.this.getQualifiedTypeForDeclareAnnotation((DeclareElement)itd);
                if (qualType != null && qualType.length() > 0) {
                    this.extraImports.add(qualType);
                }
                List types = this.getExtraImportsFromDeclareElement((DeclareElement)itd, ajAST);
                for (Type type : types) {
                    ImportReferencesCollector.collect((ASTNode)type, (IJavaProject)project, (Region)new Region(type.getStartPosition(), type.getLength()), (Collection)this.typeImports, (Collection)this.staticImports);
                }
            }
        }

        private List getExtraImportsFromDeclareElement(DeclareElement itd, CompilationUnit ajAST) {
            int numTypes = ajAST.types().size();
            if (numTypes == 0) {
                return Collections.EMPTY_LIST;
            }
            String details = null;
            AbstractTypeDeclaration lastType = (AbstractTypeDeclaration)ajAST.types().get(numTypes - 1);
            List bodyDecls = lastType.bodyDeclarations();
            LinkedList<Type> extraSimpleNames = new LinkedList<Type>();
            int i = bodyDecls.size() - 1;
            while (i >= 0) {
                Type type;
                VariableDeclarationFragment frag;
                FieldDeclaration fDecl;
                BodyDeclaration decl = (BodyDeclaration)bodyDecls.get(i);
                if (decl.getNodeType() != 23 || (fDecl = (FieldDeclaration)decl).fragments().size() != 1 || !(frag = (VariableDeclarationFragment)fDecl.fragments().get(0)).getName().toString().startsWith("___ITD_INSERTED_IDENTIFIER___")) break;
                if (details == null) {
                    IProgramElement ipe = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)itd).javaElementToProgramElement((IJavaElement)itd);
                    details = ipe.getDetails();
                }
                if (details.indexOf((type = fDecl.getType()).toString()) != -1) {
                    extraSimpleNames.add(type);
                }
                --i;
            }
            return extraSimpleNames;
        }

        void addExtraImport(String typeImport) {
            this.extraImports.add(typeImport);
        }
    }
}

