/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.refactoring;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.javaelements.DeclareElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoring;
import org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringWizard;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class PushInRefactoringAction
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate,
IViewActionDelegate {
    private IJavaElement[] currSelection;
    private IWorkbenchWindow window = null;
    private CompilationUnitEditor editor = null;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_7;

    public void dispose() {
        this.window = null;
    }

    public void run(IAction action) {
        if (this.currSelection != null) {
            try {
                List itds = this.findAllITDs(this.currSelection);
                if (itds.size() > 0) {
                    PushInRefactoring refactoring = new PushInRefactoring();
                    refactoring.setITDs(itds);
                    this.run(new PushInRefactoringWizard(refactoring, "Push In Intertype Declaration", refactoring.createDescriptor()), this.getShell(), "Push In Intertype Declaration");
                } else {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"No ITDs", (String)"No intertype declarations selected");
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            }
        }
    }

    private Shell getShell() {
        if (this.window != null) {
            return this.window.getShell();
        }
        if (this.editor != null) {
            return this.editor.getEditorSite().getShell();
        }
        return null;
    }

    public void run(RefactoringWizard wizard, Shell parent, String dialogTitle) {
        try {
            RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation(wizard);
            operation.run(parent, dialogTitle);
        }
        catch (InterruptedException interruptedException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(interruptedException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currSelection = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection extended = (IStructuredSelection)selection;
            Object[] elements = extended.toArray();
            IJavaElement[] candidates = new IJavaElement[elements.length];
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IJavaElement) {
                    candidates[i] = (IJavaElement)elements[i];
                    if (candidates[i].isReadOnly()) {
                        candidates = null;
                        break;
                    }
                } else {
                    candidates = null;
                    break;
                }
                ++i;
            }
            this.currSelection = candidates;
        } else if (selection instanceof ITextSelection && this.editor != null) {
            ITextSelection textSel = (ITextSelection)selection;
            CompilationUnitDocumentProvider provider = (CompilationUnitDocumentProvider)this.editor.getDocumentProvider();
            ICompilationUnit unit = provider.getWorkingCopy((Object)this.editor.getEditorInput());
            try {
                IJavaElement candidate = unit.getElementAt(textSel.getOffset());
                if (candidate != null) {
                    this.currSelection = new IJavaElement[1];
                    this.currSelection[0] = candidate;
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
            }
        }
        action.setEnabled(this.currSelection != null && this.currSelection.length > 0);
        if (this.window == null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            this.window = workbench.getActiveWorkbenchWindow();
        }
    }

    protected List findAllITDs(IJavaElement[] selection) throws JavaModelException {
        LinkedList itds = new LinkedList();
        int i = 0;
        while (i < selection.length) {
            IJavaElement element = selection[i];
            itds.addAll(this.findITDsInChildren(element));
            ++i;
        }
        return itds;
    }

    private Collection findITDsInChildren(IJavaElement element) throws JavaModelException {
        LinkedList<IJavaElement> itds = new LinkedList<IJavaElement>();
        if (element.isReadOnly()) {
            return Collections.EMPTY_LIST;
        }
        if (element instanceof IntertypeElement) {
            itds.add(element);
        } else if (element instanceof DeclareElement && (((DeclareElement)element).getAJKind().isDeclareAnnotation() || ((DeclareElement)element).getAJKind() == IProgramElement.Kind.DECLARE_PARENTS)) {
            itds.add(element);
        } else if (element instanceof IParent) {
            IParent parent = (IParent)element;
            try {
                IJavaElement[] children = parent.getChildren();
                int i = 0;
                while (i < children.length) {
                    itds.addAll(this.findITDsInChildren(children[i]));
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
            }
        }
        return itds;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor instanceof CompilationUnitEditor ? (CompilationUnitEditor)targetEditor : null;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void init(IViewPart view) {
        this.window = view.getViewSite().getWorkbenchWindow();
    }

    static {
        Factory factory = new Factory("PushInRefactoringAction.java", Class.forName("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringAction"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringAction", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 63);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringAction", "org.eclipse.jface.action.IAction:", "action:", "", "void"), 50);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringAction", "java.lang.InterruptedException:", "<missing>:"), 82);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringAction", "org.eclipse.ltk.ui.refactoring.RefactoringWizard:org.eclipse.swt.widgets.Shell:java.lang.String:", "wizard:parent:dialogTitle:", "", "void"), 78);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringAction", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 120);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "selectionChanged", "org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringAction", "org.eclipse.jface.action.IAction:org.eclipse.jface.viewers.ISelection:", "action:selection:", "", "void"), 87);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringAction", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 158);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "findITDsInChildren", "org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringAction", "org.eclipse.jdt.core.IJavaElement:", "element:", "org.eclipse.jdt.core.JavaModelException:", "java.util.Collection"), 140);
    }
}

