/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.org.eclipse.jdt.core.dom.ASTParser;
import org.aspectj.org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.BodyDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.CompilationUnit;
import org.aspectj.org.eclipse.jdt.core.dom.InterTypeFieldDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.InterTypeMethodDeclaration;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.ReflectionUtils;
import org.eclipse.ajdt.core.codeconversion.ITDAwareLookupEnvironment;
import org.eclipse.ajdt.core.codeconversion.ITDAwareNameEnvironment;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElementInfo;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.ajdt.internal.core.search.ITDReferenceVisitor;
import org.eclipse.contribution.jdt.itdawareness.ISearchProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.FieldDeclarationMatch;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.jdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.OrPattern;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;
import org.eclipse.jdt.internal.core.search.matching.VariablePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AJDTSearchProvider
implements ISearchProvider {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_11;

    public IntertypeElement findITDGetter(IField field) {
        return this.findITDAccessor(field, true);
    }

    public IntertypeElement findITDSetter(IField field) {
        return this.findITDAccessor(field, false);
    }

    private IntertypeElement findITDAccessor(IField field, boolean getter) {
        AJProjectModelFacade model = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)field);
        List rels = model.getRelationshipsForElement((IJavaElement)field.getDeclaringType(), AJRelationshipManager.ASPECT_DECLARATIONS);
        for (IJavaElement elt : rels) {
            IntertypeElement itd;
            if (!(elt instanceof IntertypeElement) || !this.isAccessorITDName((itd = (IntertypeElement)elt).getElementName(), field.getElementName(), field.getDeclaringType().getElementName(), field.getDeclaringType().getFullyQualifiedName(), getter) || !this.checkParameters(itd, field, getter) || !this.checkReturnType(itd, field, getter)) continue;
            return itd;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkReturnType(IntertypeElement itd, IField field, boolean getter) {
        JavaModelException javaModelException2;
        block5: {
            try {
                if (getter) {
                    return itd.getReturnType().equals(field.getTypeSignature()) || field.getTypeSignature().equals(String.valueOf(itd.getQualifiedReturnType()));
                }
            }
            catch (JavaModelException javaModelException2) {
                // empty catch block
                break block5;
            }
            try {
                return itd.getReturnType().equals("V");
            }
            catch (JavaModelException javaModelException3) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException3, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                JavaModelException javaModelException4 = javaModelException3;
            }
        }
        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkParameters(IntertypeElement itd, IField field, boolean getter) {
        block7: {
            JavaModelException javaModelException2;
            block8: {
                String typeSignature;
                String[] parameterTypes = itd.getParameterTypes();
                if (getter) {
                    return parameterTypes == null || parameterTypes.length == 0;
                }
                try {
                    if (parameterTypes == null || parameterTypes.length != 1) break block7;
                    typeSignature = field.getTypeSignature();
                    if (parameterTypes[0].equals(typeSignature)) {
                        return true;
                    }
                }
                catch (JavaModelException javaModelException2) {
                    // empty catch block
                    break block8;
                }
                try {
                    String itdParamSignature = itd.getQualifiedParameterTypes()[0];
                    int arrayCount = org.eclipse.jdt.core.Signature.getArrayCount((String)itdParamSignature);
                    if (itdParamSignature.charAt(arrayCount) == 'L') {
                        itdParamSignature = String.valueOf(itdParamSignature.substring(0, arrayCount)) + 'Q' + itdParamSignature.substring(arrayCount + 1);
                    }
                    return typeSignature.equals(itdParamSignature);
                }
                catch (JavaModelException javaModelException3) {
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException3, this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_4);
                    JavaModelException javaModelException4 = javaModelException3;
                }
            }
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_4);
        }
        return false;
    }

    private boolean isAccessorITDName(String itdName, String fieldName, String declaringTypeName, String declaringFullyQualifedName, boolean getter) {
        String prefix = getter ? "get" : "set";
        int lastDot = itdName.lastIndexOf(46);
        if (getter && lastDot >= 0 && itdName.indexOf(".is", lastDot) > 0) {
            prefix = "is";
        }
        String suffix = String.valueOf(prefix) + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        String accessorName = String.valueOf(declaringTypeName) + "." + suffix;
        if (itdName.equals(accessorName)) {
            return true;
        }
        accessorName = String.valueOf(declaringFullyQualifedName) + "." + suffix;
        return itdName.equals(accessorName);
    }

    public IJavaElement convertJavaElement(IJavaElement origElement) {
        if (origElement instanceof IntertypeElement) {
            try {
                IType targetType;
                IMember newElement;
                AJProjectModelFacade model;
                List rels;
                char[] targetTypeName = ((IntertypeElementInfo)((IntertypeElement)origElement).getElementInfo()).getTargetType();
                if (targetTypeName != null && (rels = (model = AJProjectModelFactory.getInstance().getModelForJavaElement(origElement)).getRelationshipsForElement(origElement, AJRelationshipManager.DECLARED_ON)).size() > 0 && rels.get(0) instanceof IType && (newElement = ((IntertypeElement)origElement).createMockDeclaration(targetType = (IType)rels.get(0))) != null) {
                    return newElement;
                }
            }
            catch (JavaModelException javaModelException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
            }
        }
        return origElement;
    }

    public LookupEnvironment createLookupEnvironment(LookupEnvironment orig, ICompilationUnit[] workingCopies, JavaProject project) {
        try {
            ITDAwareNameEnvironment env = new ITDAwareNameEnvironment(project, workingCopies);
            return new ITDAwareLookupEnvironment(orig, (INameEnvironment)env);
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_8, (JoinPoint.StaticPart)ajc$tjp_9);
            return orig;
        }
    }

    public List<SearchMatch> findExtraMatches(PossibleMatch match, SearchPattern pattern, HierarchyResolver resolver) throws JavaModelException {
        ArrayList<SearchMatch> extraMatches = new ArrayList<SearchMatch>();
        if (pattern instanceof OrPattern) {
            SearchPattern[] patterns;
            SearchPattern[] searchPatternArray = patterns = (SearchPattern[])ReflectionUtils.getPrivateField(OrPattern.class, "patterns", (OrPattern)pattern);
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                SearchPattern orPattern = searchPatternArray[n2];
                extraMatches.addAll(this.findExtraMatches(match, orPattern, resolver));
                ++n2;
            }
        } else if (match.openable instanceof AJCompilationUnit) {
            boolean findDeclarations = this.findDeclarations(pattern);
            boolean findReferences = this.findReferences(pattern);
            AJCompilationUnit unit = (AJCompilationUnit)match.openable;
            List<IntertypeElement> allRelevantItds = this.findRelevantITDs(pattern, resolver, unit);
            if (allRelevantItds.size() > 0) {
                if (findReferences) {
                    extraMatches.addAll(this.findExtraReferenceMatches(unit, allRelevantItds, pattern, match));
                }
                if (findDeclarations) {
                    extraMatches.addAll(this.findExtraDeclarationMatches(unit, allRelevantItds, pattern, match));
                }
            }
        }
        return extraMatches;
    }

    private List<IntertypeElement> findRelevantITDs(SearchPattern pattern, HierarchyResolver resolver, AJCompilationUnit unit) throws JavaModelException {
        List<IntertypeElement> allItds = this.getAllItds((IParent)unit);
        if (allItds.size() == 0) {
            return Collections.emptyList();
        }
        char[] targetTypeName = null;
        if (pattern instanceof FieldPattern) {
            targetTypeName = this.getName(AJDTSearchProvider.getQualName((FieldPattern)pattern), AJDTSearchProvider.getSimpleName((FieldPattern)pattern));
        } else if (pattern instanceof MethodPattern) {
            targetTypeName = this.getName(((MethodPattern)pattern).declaringQualification, ((MethodPattern)pattern).declaringSimpleName);
        }
        if (targetTypeName != null && targetTypeName.length > 0) {
            if (resolver != null) {
                resolver.setFocusType(CharOperation.splitOn((char)'.', (char[])targetTypeName));
            }
            Iterator<IntertypeElement> itdIter = allItds.iterator();
            while (itdIter.hasNext()) {
                IntertypeElement itd = itdIter.next();
                if (this.isSubtypeOfSearchPattern(targetTypeName, itd, resolver)) continue;
                itdIter.remove();
            }
        }
        return allItds;
    }

    private boolean findReferences(SearchPattern pattern) {
        if (pattern instanceof MethodPattern) {
            return (Boolean)ReflectionUtils.getPrivateField(MethodPattern.class, "findReferences", (MethodPattern)pattern);
        }
        if (pattern instanceof FieldPattern) {
            return (Boolean)ReflectionUtils.getPrivateField(VariablePattern.class, "findReferences", (VariablePattern)pattern);
        }
        if (pattern instanceof ConstructorPattern) {
            return (Boolean)ReflectionUtils.getPrivateField(ConstructorPattern.class, "findReferences", (ConstructorPattern)pattern);
        }
        return false;
    }

    private boolean findDeclarations(SearchPattern pattern) {
        if (pattern instanceof MethodPattern) {
            return (Boolean)ReflectionUtils.getPrivateField(MethodPattern.class, "findDeclarations", (MethodPattern)pattern);
        }
        if (pattern instanceof FieldPattern) {
            return (Boolean)ReflectionUtils.getPrivateField(VariablePattern.class, "findDeclarations", (VariablePattern)pattern);
        }
        if (pattern instanceof ConstructorPattern) {
            return (Boolean)ReflectionUtils.getPrivateField(ConstructorPattern.class, "findDeclarations", (ConstructorPattern)pattern);
        }
        return false;
    }

    private List<SearchMatch> findExtraReferenceMatches(AJCompilationUnit unit, List<IntertypeElement> allRelevantItds, SearchPattern pattern, PossibleMatch match) throws JavaModelException {
        CompilationUnit ajDomUnit = this.getDom(unit);
        List<SearchMatch> matches = this.walkITDs(ajDomUnit, allRelevantItds, pattern, match);
        return matches;
    }

    private List<SearchMatch> findExtraDeclarationMatches(AJCompilationUnit unit, List<IntertypeElement> allRelevantItds, SearchPattern pattern, PossibleMatch match) throws JavaModelException {
        ArrayList<SearchMatch> extraDeclarationMatches;
        block4: {
            block5: {
                block3: {
                    extraDeclarationMatches = new ArrayList<SearchMatch>();
                    if (!(pattern instanceof MethodPattern)) break block3;
                    MethodPattern methPatt = (MethodPattern)pattern;
                    char[] selector = methPatt.selector;
                    char[][] simpleParamTypes = methPatt.parameterSimpleNames;
                    for (IntertypeElement itd : allRelevantItds) {
                        char[][] itdSimpleParamNames;
                        if (itd.getAJKind() != IProgramElement.Kind.INTER_TYPE_METHOD || !CharOperation.equals((char[])selector, (char[])itd.getTargetName().toCharArray()) || !CharOperation.equals((char[][])simpleParamTypes, (char[][])(itdSimpleParamNames = this.extractSimpleParamNames(itd)))) continue;
                        ISourceRange sourceRange = itd.getNameRange();
                        extraDeclarationMatches.add((SearchMatch)new MethodDeclarationMatch((IJavaElement)itd, 0, sourceRange.getOffset(), sourceRange.getLength(), match.document.getParticipant(), itd.getCompilationUnit().getResource()));
                    }
                    break block4;
                }
                if (!(pattern instanceof ConstructorPattern)) break block5;
                ConstructorPattern consPatt = (ConstructorPattern)pattern;
                char[] targetTypeName = this.getName(consPatt.declaringQualification, consPatt.declaringSimpleName);
                char[][] simpleParamTypes = consPatt.parameterSimpleNames;
                for (IntertypeElement itd : allRelevantItds) {
                    char[][] itdSimpleParamNames;
                    if (itd.getAJKind() != IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR || targetTypeName == null || !CharOperation.equals((char[])targetTypeName, (char[])this.fullyQualifiedTargetTypeName(itd)) || !CharOperation.equals((char[][])simpleParamTypes, (char[][])(itdSimpleParamNames = this.extractSimpleParamNames(itd)))) continue;
                    ISourceRange sourceRange = itd.getNameRange();
                    extraDeclarationMatches.add((SearchMatch)new MethodDeclarationMatch((IJavaElement)itd, 0, sourceRange.getOffset(), sourceRange.getLength(), match.document.getParticipant(), itd.getCompilationUnit().getResource()));
                }
                break block4;
            }
            if (!(pattern instanceof FieldPattern)) break block4;
            FieldPattern fieldPatt = (FieldPattern)pattern;
            char[] targetTypeName = this.getName(AJDTSearchProvider.getQualName(fieldPatt), AJDTSearchProvider.getSimpleName(fieldPatt));
            char[] fieldName = fieldPatt.getIndexKey();
            for (IntertypeElement itd : allRelevantItds) {
                if (itd.getAJKind() != IProgramElement.Kind.INTER_TYPE_FIELD || !CharOperation.equals((char[])fieldName, (char[])itd.getTargetName().toCharArray()) || targetTypeName == null || !CharOperation.equals((char[])targetTypeName, (char[])this.fullyQualifiedTargetTypeName(itd))) continue;
                ISourceRange sourceRange = itd.getNameRange();
                extraDeclarationMatches.add((SearchMatch)new FieldDeclarationMatch((IJavaElement)itd, 0, sourceRange.getOffset(), sourceRange.getLength(), match.document.getParticipant(), itd.getCompilationUnit().getResource()));
            }
        }
        return extraDeclarationMatches;
    }

    private char[][] extractSimpleParamNames(IntertypeElement itd) {
        String[] parameterTypes = itd.getParameterTypes();
        if (parameterTypes == null) {
            return new char[0][];
        }
        char[][] simpleNames = new char[parameterTypes.length][];
        int i = 0;
        while (i < parameterTypes.length) {
            try {
                simpleNames[i] = org.eclipse.jdt.core.Signature.getSignatureSimpleName((char[])org.eclipse.jdt.core.Signature.getTypeErasure((char[])parameterTypes[i].toCharArray()));
            }
            catch (Exception exception) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, this, ajc$tjp_10, (JoinPoint.StaticPart)ajc$tjp_11);
            }
            ++i;
        }
        return simpleNames;
    }

    private boolean isSubtypeOfSearchPattern(char[] targetTypeName, IntertypeElement itd, HierarchyResolver resolver) throws JavaModelException {
        ReferenceBinding targetBinding;
        char[] itdTargetTypeName = this.fullyQualifiedTargetTypeName(itd);
        if (CharOperation.equals((char[])targetTypeName, (char[])itdTargetTypeName)) {
            return true;
        }
        if (resolver != null && (targetBinding = ((LookupEnvironment)ReflectionUtils.getPrivateField(HierarchyResolver.class, "lookupEnvironment", resolver)).askForType(CharOperation.splitOn((char)'.', (char[])itdTargetTypeName))) != null) {
            return resolver.subOrSuperOfFocus(targetBinding);
        }
        return false;
    }

    private char[] fullyQualifiedTargetTypeName(IntertypeElement itd) {
        IType targetType = itd.findTargetType();
        char[] itdTargetTypeName = targetType == null ? new char[]{} : targetType.getFullyQualifiedName().replace('$', '.').toCharArray();
        return itdTargetTypeName;
    }

    private List<SearchMatch> walkITDs(CompilationUnit ajDomUnit, List<IntertypeElement> allItds, SearchPattern pattern, PossibleMatch possibleMatch) throws JavaModelException {
        LinkedList<SearchMatch> allExtraMatches = new LinkedList<SearchMatch>();
        for (IntertypeElement itd : allItds) {
            BodyDeclaration decl = this.findITDInDom(ajDomUnit, itd);
            if (!(decl instanceof InterTypeMethodDeclaration)) continue;
            allExtraMatches.addAll(this.findPatternInITD((InterTypeMethodDeclaration)decl, itd, pattern, possibleMatch));
        }
        return allExtraMatches;
    }

    private Collection<SearchMatch> findPatternInITD(InterTypeMethodDeclaration decl, IntertypeElement itd, SearchPattern pattern, PossibleMatch possibleMatch) {
        ITDReferenceVisitor visitor = new ITDReferenceVisitor(itd, pattern, possibleMatch.document.getParticipant());
        List<SearchMatch> matches = visitor.doVisit(decl);
        return matches;
    }

    private BodyDeclaration findITDInDom(CompilationUnit ajDomUnit, IntertypeElement itd) throws JavaModelException {
        List types = ajDomUnit.types();
        for (AbstractTypeDeclaration type : types) {
            BodyDeclaration maybeDecl = this.findITDInDom(type, itd);
            if (maybeDecl == null) continue;
            return maybeDecl;
        }
        return null;
    }

    private BodyDeclaration findITDInDom(AbstractTypeDeclaration type, IntertypeElement itd) throws JavaModelException {
        List decls = type.bodyDeclarations();
        for (BodyDeclaration decl : decls) {
            BodyDeclaration maybeDecl = null;
            if (decl instanceof AbstractTypeDeclaration) {
                maybeDecl = this.findITDInDom((AbstractTypeDeclaration)decl, itd);
            } else if (decl instanceof InterTypeMethodDeclaration || decl instanceof InterTypeFieldDeclaration) {
                int domStart = decl.getStartPosition();
                int domEnd = domStart + decl.getLength();
                ISourceRange sourceRange = itd.getSourceRange();
                int eltStart = sourceRange.getOffset();
                int eltEnd = eltStart + sourceRange.getLength();
                if (domStart <= eltStart && domEnd >= eltEnd || eltStart <= domStart && eltEnd >= domEnd) {
                    maybeDecl = decl;
                }
            }
            if (maybeDecl == null) continue;
            return maybeDecl;
        }
        return null;
    }

    private CompilationUnit getDom(AJCompilationUnit unit) {
        ASTParser parser = ASTParser.newParser((int)3);
        unit.requestOriginalContentMode();
        parser.setSource(unit.getContents());
        parser.setCompilerOptions(unit.getJavaProject().getOptions(true));
        unit.discardOriginalContentMode();
        return (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
    }

    private static char[] getQualName(FieldPattern pattern) {
        return (char[])ReflectionUtils.getPrivateField(FieldPattern.class, "declaringQualification", pattern);
    }

    private static char[] getSimpleName(FieldPattern pattern) {
        return (char[])ReflectionUtils.getPrivateField(FieldPattern.class, "declaringSimpleName", pattern);
    }

    private char[] getName(char[] qual, char[] name) {
        char[] targetTypeName;
        if (name == null) {
            return null;
        }
        if (qual != null && qual.length > 0) {
            qual = CharOperation.append((char[])qual, (char)'.');
            targetTypeName = CharOperation.append((char[])qual, (int)qual.length, (char[])name, (int)0, (int)name.length);
        } else {
            targetTypeName = name;
        }
        int lastChar = targetTypeName.length;
        while (targetTypeName[lastChar - 1] == '\u0000' && lastChar > 0) {
            --lastChar;
        }
        targetTypeName = CharOperation.subarray((char[])targetTypeName, (int)0, (int)lastChar);
        return targetTypeName;
    }

    private List<IntertypeElement> getAllItds(IParent parent) throws JavaModelException {
        IJavaElement[] children = parent.getChildren();
        LinkedList<IntertypeElement> allItds = new LinkedList<IntertypeElement>();
        IJavaElement[] iJavaElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement elt = iJavaElementArray[n2];
            if (elt instanceof IntertypeElement) {
                allItds.add((IntertypeElement)elt);
            } else if (elt.getElementType() == 7) {
                allItds.addAll(this.getAllItds((IParent)elt));
            }
            ++n2;
        }
        return allItds;
    }

    public IJavaElement filterJUnit4TestMatch(IJavaElement possibleTest) throws JavaModelException {
        String itdName;
        IntertypeElement matchingITD;
        if (!(possibleTest instanceof IMethod)) {
            return possibleTest;
        }
        IJavaElement parent = possibleTest.getAncestor(7);
        if (parent instanceof AspectElement && (matchingITD = this.findMatchingITD((AspectElement)parent, (IMethod)possibleTest, itdName = possibleTest.getElementName().replace('$', '.'))) != null) {
            return matchingITD.createMockDeclaration();
        }
        return possibleTest;
    }

    private IntertypeElement findMatchingITD(AspectElement parent, IMethod possibleTest, String itdName) throws JavaModelException {
        IntertypeElement[] allITDs;
        IntertypeElement[] intertypeElementArray = allITDs = parent.getITDs();
        int n = allITDs.length;
        int n2 = 0;
        while (n2 < n) {
            IntertypeElement itd = intertypeElementArray[n2];
            if (itdName.equals(itd.getElementName()) && Arrays.equals(itd.getParameterTypes(), possibleTest.getParameterTypes())) {
                return itd;
            }
            ++n2;
        }
        return null;
    }

    static {
        Factory factory = new Factory("AJDTSearchProvider.java", Class.forName("org.eclipse.ajdt.internal.core.search.AJDTSearchProvider"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 111);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "checkReturnType", "org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.ajdt.core.javaelements.IntertypeElement:org.eclipse.jdt.core.IField:boolean:", "itd:field:getter:", "", "boolean"), 102);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "java.lang.Exception:", "<missing>:"), 381);
        ajc$tjp_11 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "extractSimpleParamNames", "org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.ajdt.core.javaelements.IntertypeElement:", "itd:", "", "[[C"), 372);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 111);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 138);
        ajc$tjp_4 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "checkParameters", "org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.ajdt.core.javaelements.IntertypeElement:org.eclipse.jdt.core.IField:boolean:", "itd:field:getter:", "", "boolean"), 116);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 138);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 176);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "convertJavaElement", "org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.IJavaElement:", "origElement:", "", "org.eclipse.jdt.core.IJavaElement"), 161);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 188);
        ajc$tjp_9 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "createLookupEnvironment", "org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment:[Lorg.eclipse.jdt.core.ICompilationUnit;:org.eclipse.jdt.internal.core.JavaProject:", "orig:workingCopies:project:", "", "org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment"), 182);
    }
}

