/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.aspectj.org.eclipse.jdt.core.dom.ASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.AjASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.BodyDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.PatternNode;
import org.aspectj.org.eclipse.jdt.core.dom.SignaturePattern;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.DeclareElement;
import org.eclipse.ajdt.core.javaelements.IAspectJElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.javaelements.PointcutUtilities;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtraReferenceFinder<T extends SearchPattern> {
    public List<SearchMatch> findExtraMatches(PossibleMatch match, T pattern, HierarchyResolver resolver) throws JavaModelException {
        if (!(match.openable instanceof AJCompilationUnit)) {
            return Collections.emptyList();
        }
        AJCompilationUnit unit = (AJCompilationUnit)match.openable;
        List<IAspectJElement> allItds = this.getRelevantChildren((IParent)unit);
        ArrayList<SearchMatch> matches = new ArrayList<SearchMatch>(allItds.size());
        for (IAspectJElement elt : allItds) {
            if (elt instanceof IntertypeElement) {
                IntertypeElement itd = (IntertypeElement)elt;
                if (!this.isMatch(itd, pattern)) continue;
                matches.add(this.createITDMatch(itd, match.document.getParticipant()));
                continue;
            }
            if (!(elt instanceof DeclareElement)) continue;
            DeclareElement decl = (DeclareElement)elt;
            matches.addAll(this.findDeclareMatches(decl, match.document.getParticipant(), pattern));
        }
        return matches;
    }

    protected List<IAspectJElement> getRelevantChildren(IParent parent) throws JavaModelException {
        IJavaElement[] children = parent.getChildren();
        LinkedList<IAspectJElement> allItds = new LinkedList<IAspectJElement>();
        IJavaElement[] iJavaElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement elt = iJavaElementArray[n2];
            if (elt instanceof IntertypeElement || elt instanceof DeclareElement) {
                allItds.add((IAspectJElement)elt);
            } else if (elt.getElementType() == 7) {
                allItds.addAll(this.getRelevantChildren((IParent)elt));
            }
            ++n2;
        }
        return allItds;
    }

    protected List<SearchMatch> findDeclareMatches(DeclareElement decl, SearchParticipant participant, T pattern) throws JavaModelException {
        ISourceRange sourceRange;
        BodyDeclaration bdecl;
        AJCompilationUnit unit = (AJCompilationUnit)decl.getCompilationUnit();
        char[] contents = null;
        try {
            unit.requestOriginalContentMode();
            contents = unit.getContents();
        }
        finally {
            unit.discardOriginalContentMode();
        }
        if (contents != null && (bdecl = PointcutUtilities.createSingleBodyDeclarationNode((sourceRange = decl.getSourceRange()).getOffset(), sourceRange.getOffset() + sourceRange.getLength(), contents)) != null) {
            DeclareVisitor visitor = this.createDeclareVisitor(contents, decl, participant, pattern);
            bdecl.accept((ASTVisitor)visitor);
            return visitor.getAccumulatedMatches();
        }
        return Collections.emptyList();
    }

    protected abstract DeclareVisitor createDeclareVisitor(char[] var1, DeclareElement var2, SearchParticipant var3, T var4) throws JavaModelException;

    protected abstract boolean isMatch(IntertypeElement var1, T var2) throws JavaModelException;

    protected abstract SearchMatch createITDMatch(IntertypeElement var1, SearchParticipant var2) throws JavaModelException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class DeclareVisitor
    extends AjASTVisitor {
        private final List<SearchMatch> accumulatedMatches = new ArrayList<SearchMatch>();
        private final char[] fileContents;
        protected final int offset;
        protected final SearchParticipant participant;
        protected final DeclareElement decl;

        public DeclareVisitor(SearchParticipant participant, DeclareElement decl, char[] fileContents) throws JavaModelException {
            this.decl = decl;
            ISourceRange sourceRange = decl.getSourceRange();
            if (sourceRange == null) {
                throw new JavaModelException((IJavaModelStatus)new JavaModelStatus(999, "No source range available for " + decl.getElementName() + " " + decl.getParent().getElementName()));
            }
            this.offset = sourceRange.getOffset();
            this.fileContents = fileContents;
            this.participant = participant;
        }

        List<SearchMatch> getAccumulatedMatches() {
            return this.accumulatedMatches;
        }

        protected void acceptMatch(SearchMatch match) {
            this.accumulatedMatches.add(match);
        }

        protected boolean isComplexTypePattern(String detail) {
            return !JavaConventions.validateJavaTypeName((String)detail, (String)"1.3", (String)"1.3").isOK();
        }

        public boolean visit(SignaturePattern node) {
            this.findMatchesInComplexPattern((PatternNode)node);
            return super.visit(node);
        }

        protected abstract void findMatchesInComplexPattern(PatternNode var1);

        protected String findQualifier(String actualPatternText, int matchLoc) {
            int patternEnd;
            int patternStart = patternEnd = matchLoc - 1;
            while (patternStart > 0) {
                if (Character.isJavaIdentifierPart(actualPatternText.charAt(--patternStart)) || actualPatternText.charAt(patternStart) == '.') continue;
                ++patternStart;
                break;
            }
            return actualPatternText.substring(patternStart, patternEnd);
        }

        protected String getActualText(PatternNode node) {
            return String.valueOf(CharOperation.subarray((char[])this.fileContents, (int)(this.offset + node.getStartPosition()), (int)(this.offset + node.getStartPosition() + node.getLength())));
        }
    }
}

