/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.exports;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.wizards.AJJarPackageActionDelegate;
import org.eclipse.ajdt.internal.ui.wizards.exports.AJJarPackageData;
import org.eclipse.ajdt.internal.ui.wizards.exports.JarPackagerMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.jarpackager.IJarDescriptionReader;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateAJJarActionDelegate
extends AJJarPackageActionDelegate {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public void run(IAction action) {
        MultiStatus mergedStatus;
        IFile[] descriptions = this.getDescriptionFiles(this.getSelection());
        int length = descriptions.length;
        if (length < 1) {
            return;
        }
        String message = length > 1 ? JarPackagerMessages.JarFileExportOperation_creationOfSomeJARsFailed : JarPackagerMessages.JarFileExportOperation_jarCreationFailed;
        MultiStatus readStatus = new MultiStatus(JavaPlugin.getPluginId(), 0, message, null);
        AJJarPackageData[] jarPackages = this.readJarPackages(descriptions, readStatus);
        if (jarPackages.length > 0) {
            IStatus status = this.export(jarPackages);
            if (status == null) {
                return;
            }
            message = readStatus.getSeverity() == 4 ? readStatus.getMessage() : status.getMessage();
            mergedStatus = new MultiStatus(JavaPlugin.getPluginId(), status.getCode(), readStatus.getChildren(), message, null);
            mergedStatus.merge(status);
        } else {
            mergedStatus = readStatus;
        }
        if (!mergedStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)JarPackagerMessages.CreateJarActionDelegate_jarExport_title, null, (IStatus)mergedStatus);
        }
    }

    private AJJarPackageData[] readJarPackages(IFile[] descriptions, MultiStatus readStatus) {
        ArrayList<AJJarPackageData> jarPackagesList = new ArrayList<AJJarPackageData>(descriptions.length);
        int i = 0;
        while (i < descriptions.length) {
            AJJarPackageData jarPackage = this.readJarPackage(descriptions[i], readStatus);
            if (jarPackage != null) {
                jarPackagesList.add(jarPackage);
            }
            ++i;
        }
        return jarPackagesList.toArray(new AJJarPackageData[jarPackagesList.size()]);
    }

    private IStatus export(AJJarPackageData[] jarPackages) {
        Shell shell = this.getShell();
        IJarExportRunnable op = jarPackages[0].createJarExportRunnable(jarPackages, shell);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(invocationTargetException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            InvocationTargetException ex = invocationTargetException;
            if (ex.getTargetException() != null) {
                ExceptionHandler.handle((InvocationTargetException)ex, (Shell)shell, (String)JarPackagerMessages.CreateJarActionDelegate_jarExportError_title, (String)JarPackagerMessages.CreateJarActionDelegate_jarExportError_message);
                return null;
            }
        }
        catch (InterruptedException interruptedException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(interruptedException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
            return null;
        }
        return op.getStatus();
    }

    protected AJJarPackageData readJarPackage(IFile description, MultiStatus readStatus) {
        Assert.isLegal((boolean)description.isAccessible());
        Assert.isNotNull((Object)description.getFileExtension());
        Assert.isLegal((boolean)description.getFileExtension().equals("jardesc"));
        AJJarPackageData jarPackage = new AJJarPackageData();
        IJarDescriptionReader reader = null;
        try {
            try {
                reader = jarPackage.createJarDescriptionReader(description.getContents());
                reader.read((JarPackageData)jarPackage);
                jarPackage.setSaveManifest(false);
                jarPackage.setSaveDescription(false);
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_4);
                CoreException ex = coreException;
                String message = Messages.format((String)JarPackagerMessages.JarFileExportOperation_errorReadingFile, (Object[])new Object[]{BasicElementLabels.getPathLabel((IPath)description.getFullPath(), (boolean)false), ex.getStatus().getMessage()});
                this.addToStatus(readStatus, message, ex);
                if (reader != null) {
                    readStatus.addAll(reader.getStatus());
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (CoreException coreException2) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_4);
                    CoreException ex2 = coreException2;
                    String message2 = Messages.format((String)JarPackagerMessages.JarFileExportOperation_errorClosingJarPackageDescriptionReader, (Object)BasicElementLabels.getPathLabel((IPath)description.getFullPath(), (boolean)false));
                    this.addToStatus(readStatus, message2, ex2);
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            if (reader != null) {
                readStatus.addAll(reader.getStatus());
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_4);
                CoreException ex = coreException;
                String message = Messages.format((String)JarPackagerMessages.JarFileExportOperation_errorClosingJarPackageDescriptionReader, (Object)BasicElementLabels.getPathLabel((IPath)description.getFullPath(), (boolean)false));
                this.addToStatus(readStatus, message, ex);
            }
            throw throwable;
        }
        if (reader != null) {
            readStatus.addAll(reader.getStatus());
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_7, (JoinPoint.StaticPart)ajc$tjp_4);
            CoreException ex = coreException;
            String message = Messages.format((String)JarPackagerMessages.JarFileExportOperation_errorClosingJarPackageDescriptionReader, (Object)BasicElementLabels.getPathLabel((IPath)description.getFullPath(), (boolean)false));
            this.addToStatus(readStatus, message, ex);
        }
        return jarPackage;
    }

    private void addToStatus(MultiStatus multiStatus, String defaultMessage, CoreException ex) {
        IStatus status = ex.getStatus();
        String message = ex.getLocalizedMessage();
        if (message == null || message.length() < 1) {
            status = new Status(status.getSeverity(), status.getPlugin(), status.getCode(), defaultMessage, (Throwable)ex);
        }
        multiStatus.add(status);
    }

    static {
        Factory factory = new Factory("CreateAJJarActionDelegate.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.exports.CreateAJJarActionDelegate"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.CreateAJJarActionDelegate", "java.lang.reflect.InvocationTargetException:", "ex:"), 95);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "export", "org.eclipse.ajdt.internal.ui.wizards.exports.CreateAJJarActionDelegate", "[Lorg.eclipse.ajdt.internal.ui.wizards.exports.AJJarPackageData;:", "jarPackages:", "", "org.eclipse.core.runtime.IStatus"), 89);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.CreateAJJarActionDelegate", "java.lang.InterruptedException:", "<missing>:"), 100);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.CreateAJJarActionDelegate", "org.eclipse.core.runtime.CoreException:", "ex:"), 125);
        ajc$tjp_4 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "readJarPackage", "org.eclipse.ajdt.internal.ui.wizards.exports.CreateAJJarActionDelegate", "org.eclipse.core.resources.IFile:org.eclipse.core.runtime.MultiStatus:", "description:readStatus:", "", "org.eclipse.ajdt.internal.ui.wizards.exports.AJJarPackageData"), 113);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.CreateAJJarActionDelegate", "org.eclipse.core.runtime.CoreException:", "ex:"), 137);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.CreateAJJarActionDelegate", "org.eclipse.core.runtime.CoreException:", "ex:"), 137);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.exports.CreateAJJarActionDelegate", "org.eclipse.core.runtime.CoreException:", "ex:"), 137);
    }
}

