/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.jdt.preferences;

import org.eclipse.contribution.jdt.IsWovenTester;
import org.eclipse.contribution.jdt.JDTWeavingPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Version;

public class JDTWeavingPreferences {
    public static final String ASK_TO_ENABLE_WEAVING = "org.eclipse.contribution.weaving.jdt.ask";
    public static final String LAST_VERSION = "org.eclipse.contribution.weaving.jdt.version";
    public static final String HOOK_ID = "org.eclipse.equinox.weaving.hook";
    public static final String ASK_TO_REINDEX_PROJECTS = "org.eclipse.contribution.weaving.jdt.reindex";

    private JDTWeavingPreferences() {
    }

    public static boolean shouldAskToEnableWeaving() {
        return JDTWeavingPreferences.getAskToEnableWeaving() || !JDTWeavingPreferences.getCurrentVersion().equals(JDTWeavingPreferences.getLastVersion());
    }

    public static void setAskToEnableWeaving(boolean value) {
        JDTWeavingPreferences.internalSetAsk(value);
        JDTWeavingPreferences.setLastVersion();
    }

    private static void internalSetAsk(boolean value) {
        IPreferenceStore store = JDTWeavingPreferences.getPreferences();
        store.setValue(ASK_TO_ENABLE_WEAVING, value ? "true" : "false");
    }

    public static boolean getAskToEnableWeaving() {
        IPreferenceStore store = JDTWeavingPreferences.getPreferences();
        String value = store.getString(ASK_TO_ENABLE_WEAVING);
        return value == "" || value.equals("true");
    }

    public static boolean shouldAskToReindex() {
        return JDTWeavingPreferences.getAskToReindex() && IsWovenTester.isWeavingActive();
    }

    public static boolean getAskToReindex() {
        IPreferenceStore store = JDTWeavingPreferences.getPreferences();
        String value = store.getString(ASK_TO_REINDEX_PROJECTS);
        return value.equals("true");
    }

    public static void setAskToReindex(boolean value) {
        IPreferenceStore store = JDTWeavingPreferences.getPreferences();
        store.setValue(ASK_TO_REINDEX_PROJECTS, value ? "true" : "false");
    }

    public static void setLastVersion() {
        IPreferenceStore store = JDTWeavingPreferences.getPreferences();
        store.setValue(LAST_VERSION, JDTWeavingPreferences.getCurrentVersion().toString());
    }

    public static String getLastVersion() {
        IPreferenceStore store = JDTWeavingPreferences.getPreferences();
        return store.getString(LAST_VERSION);
    }

    private static String getCurrentVersion() {
        BundleDescription hook = Platform.getPlatformAdmin().getState(false).getBundle(HOOK_ID, null);
        return (hook != null ? hook.getVersion() : new Version(0, 0, 0)).toString();
    }

    public static IPreferenceStore getPreferences() {
        return JDTWeavingPlugin.getInstance().getPreferenceStore();
    }
}

