/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajde.core.AjCompiler;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.HierarchyWalker;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.asm.IRelationshipMap;
import org.aspectj.asm.internal.RelationshipMap;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJCore;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.core.builder.AJBuilder;
import org.eclipse.ajdt.core.builder.IAJBuildListener;
import org.eclipse.ajdt.core.javaelements.AJCodeElement;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AspectJMemberElement;
import org.eclipse.ajdt.core.javaelements.CompilationUnitTools;
import org.eclipse.ajdt.core.lazystart.IAdviceChangedListener;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.core.model.EnsureInitialized;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.ImportContainer;
import org.eclipse.jdt.internal.core.ImportDeclaration;
import org.eclipse.jdt.internal.core.JavaModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AJProjectModelFacade {
    public static final IJavaElement ERROR_JAVA_ELEMENT;
    IHierarchy structureModel;
    IRelationshipMap relationshipMap;
    private final IProject project;
    boolean isInitialized;
    boolean disposed;
    private static ProjectModelBuildListener buildListener;
    private Map<ISourceLocation, Integer> slocCache;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        AJProjectModelFacade.ajc$preClinit();
        ERROR_JAVA_ELEMENT = new CompilationUnit(null, "ERROR_JAVA_ELEMENT", null);
        buildListener = new ProjectModelBuildListener();
    }

    AJProjectModelFacade(IProject project) {
        this.project = project;
        this.disposed = false;
        this.isInitialized = false;
    }

    public static void installListener() {
        AJBuilder.addAJBuildListener(buildListener);
    }

    synchronized void init() {
        AjCompiler compiler;
        AsmManager existingState;
        if (!buildListener.isCurrentlyBuilding(this.project) && (existingState = (compiler = AspectJPlugin.getDefault().getCompilerFactory().getCompilerForProject(this.project)).getModel()) != null) {
            this.relationshipMap = existingState.getRelationshipMap();
            this.structureModel = existingState.getHierarchy();
            if (this.relationshipMap != null && this.structureModel != null) {
                this.isInitialized = true;
            }
        }
    }

    public boolean hasModel() {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        return this.isInitialized && !this.disposed && !buildListener.isCurrentlyBuilding(this.project);
    }

    public IProgramElement getProgramElement(String handle) {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        IProgramElement ipe = this.structureModel.findElementForHandleOrCreate(handle, false);
        if (ipe != null) {
            return ipe;
        }
        return IHierarchy.NO_STRUCTURE;
    }

    public int getJavaElementLineNumber(IJavaElement je) {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        IProgramElement ipe = this.javaElementToProgramElement(je);
        return ipe.getSourceLocation() != null ? ipe.getSourceLocation().getLine() : 1;
    }

    public String getJavaElementLinkName(IJavaElement je) {
        String name;
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        IProgramElement ipe = this.javaElementToProgramElement(je);
        if (ipe != IHierarchy.NO_STRUCTURE && (name = ipe.toLinkLabelString(false)) != null && name.length() > 0) {
            return name;
        }
        name = je.getElementName();
        if (je instanceof ISourceReference && !(je instanceof ITypeRoot)) {
            IJavaElement parent = je.getParent();
            while (parent != null && !(parent instanceof ITypeRoot)) {
                name = String.valueOf(parent.getElementName()) + "." + name;
                parent = parent.getParent();
            }
        }
        return name;
    }

    public IProgramElement javaElementToProgramElement(IJavaElement je) {
        IProgramElement ipe;
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        if (!this.isInitialized) {
            return IHierarchy.NO_STRUCTURE;
        }
        String ajHandle = je.getHandleIdentifier();
        boolean isBinary = false;
        if (this.isBinaryHandle(ajHandle) || je.isReadOnly()) {
            ajHandle = this.convertToAspectJBinaryHandle(ajHandle, false);
            isBinary = true;
        } else if (this.isFromExternalProject(je)) {
            ajHandle = this.convertToAspectJBinaryHandle(ajHandle, true);
            isBinary = true;
        }
        ICompilationUnit cu = null;
        if (je instanceof IMember) {
            cu = ((IMember)je).getCompilationUnit();
        } else if (je instanceof IPackageDeclaration) {
            IJavaElement parent = ((IPackageDeclaration)je).getParent();
            if (parent instanceof ICompilationUnit) {
                cu = (ICompilationUnit)parent;
            }
        } else if (je instanceof AJCodeElement) {
            cu = ((AJCodeElement)je).getCompilationUnit();
            int count = ((AJCodeElement)je).occurrenceCount;
            int lastParen = ajHandle.lastIndexOf(41);
            int firstBang = ajHandle.indexOf(33, lastParen);
            if (firstBang > -1) {
                ajHandle = ajHandle.substring(0, firstBang);
                if (count > 1) {
                    ajHandle = String.valueOf(ajHandle) + "!" + count;
                }
            }
        } else if (je instanceof ILocalVariable) {
            IOpenable openable = ((ILocalVariable)je).getOpenable();
            cu = openable instanceof ICompilationUnit ? (ICompilationUnit)openable : null;
        } else if (je instanceof ImportDeclaration) {
            cu = ((ImportDeclaration)je).getCompilationUnit();
        } else if (je instanceof ImportContainer) {
            cu = ((ImportContainer)je).getCompilationUnit();
        } else if (je instanceof ICompilationUnit) {
            cu = (ICompilationUnit)je;
        }
        if (cu != null && CoreUtils.ASPECTJ_SOURCE_ONLY_FILTER.accept(cu.getResource().getName())) {
            ajHandle = ajHandle.replaceFirst("\\{", Character.toString('*'));
        }
        if ((ipe = this.structureModel.findElementForHandleOrCreate(ajHandle, false)) == null) {
            if (isBinary) {
                ajHandle = ajHandle.replace('[', '\'');
                ipe = this.structureModel.findElementForHandleOrCreate(ajHandle, false);
            }
            if (ipe == null) {
                return IHierarchy.NO_STRUCTURE;
            }
        }
        return ipe;
    }

    private boolean isFromExternalProject(IJavaElement je) {
        return !je.getJavaProject().getProject().equals((Object)this.project);
    }

    public boolean hasProgramElement(IJavaElement je) {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        return IHierarchy.NO_STRUCTURE != this.javaElementToProgramElement(je);
    }

    private String convertToAspectJBinaryHandle(String ajHandle, boolean isSourceFromDependingProject) {
        int packageIndex = ajHandle.indexOf(60);
        String newHandle = "=" + this.project.getName() + '/' + "binaries" + ajHandle.substring(packageIndex);
        if (isSourceFromDependingProject) {
            newHandle = newHandle.replace(".aj'", ".class'");
            newHandle = AspectJPlugin.USING_CU_PROVIDER ? newHandle.replace('{', '(') : newHandle.replace('*', '(');
        }
        return newHandle;
    }

    private boolean isBinaryHandle(String ajHandle) {
        int classFileIndex;
        int jemClassIndex = ajHandle.indexOf(40);
        return jemClassIndex != -1 && (classFileIndex = ajHandle.indexOf(".class", jemClassIndex)) != -1;
    }

    public IJavaElement programElementToJavaElement(IProgramElement ipe) {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        return this.programElementToJavaElement(ipe.getHandleIdentifier());
    }

    public IJavaElement programElementToJavaElement(String ajHandle) {
        int codeEltIndex;
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        if (ajHandle.length() == 0 || ajHandle.charAt(0) != '=') {
            return ERROR_JAVA_ELEMENT;
        }
        String jHandle = ajHandle;
        if (this.isBinaryAspectJHandle(jHandle)) {
            jHandle = jHandle.replace('*', '(');
            jHandle = jHandle.replace(".aj'", ".class'");
            return this.getElementFromClassFile(jHandle);
        }
        if (AspectJPlugin.USING_CU_PROVIDER) {
            jHandle = jHandle.replaceFirst("\\*", Character.toString('{'));
        }
        if ((codeEltIndex = jHandle.indexOf(63)) != -1) {
            int countIndex = jHandle.lastIndexOf(33);
            int count = 0;
            if (countIndex > codeEltIndex) {
                try {
                    count = Integer.parseInt(jHandle.substring(countIndex + 1));
                    jHandle = jHandle.substring(0, countIndex);
                }
                catch (NumberFormatException numberFormatException) {
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(numberFormatException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    count = 0;
                }
            }
            jHandle = String.valueOf(jHandle) + "!0!0!0!0!I";
            if (count > 1) {
                jHandle = String.valueOf(jHandle) + "!" + count;
            }
        }
        jHandle = jHandle.replaceFirst("declare @", "declare \\\\@");
        jHandle = jHandle.replaceFirst("\\.\\*", ".\\\\*");
        IJavaElement je = AspectJCore.create(jHandle = jHandle.replaceAll("\\*>", "\\\\*>"));
        if (je == null) {
            return ERROR_JAVA_ELEMENT;
        }
        return je;
    }

    private boolean isBinaryAspectJHandle(String ajHandle) {
        int classFileIndex = ajHandle.indexOf(40);
        boolean doIt = false;
        if (classFileIndex != -1) {
            int dotClassIndex = ajHandle.indexOf(".class") + ".class".length();
            if (dotClassIndex >= ajHandle.length()) {
                doIt = true;
            } else if (dotClassIndex != -1) {
                char typeChar = ajHandle.charAt(dotClassIndex);
                doIt = typeChar == '\'' || typeChar == '[' || typeChar == '#' || typeChar == '%';
            }
        } else if (ajHandle.indexOf("/binaries<") != -1) {
            doIt = true;
        }
        return doIt;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IJavaElement getElementFromClassFile(String jHandle) {
        Throwable e;
        NullPointerException nullPointerException3222222;
        block14: {
            NullPointerException nullPointerException22222222;
            block15: {
                JavaModelException javaModelException6222222;
                block17: {
                    JavaModelException javaModelException22222222;
                    block16: {
                        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
                        HandleInfo handleInfo = this.qualifiedNameFromBinaryHandle(jHandle);
                        if (handleInfo == null) {
                            AspectJPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ajdt.core", "Could not find type root for " + jHandle));
                            return ERROR_JAVA_ELEMENT;
                        }
                        try {
                            IPackageFragment[] frags;
                            if (handleInfo.isPackageFragment() && (frags = this.findFragment(JavaCore.create((IProject)this.project), handleInfo)) != null && frags.length > 0) {
                                return frags[0];
                            }
                        }
                        catch (NullPointerException nullPointerException3222222) {
                            // empty catch block
                            break block14;
                        }
                        try {
                            IJavaElement candidate;
                            ITypeRoot typeRoot = this.getCUFromQualifiedName(handleInfo);
                            if (typeRoot instanceof ICompilationUnit) {
                                candidate = this.findElementInCU(handleInfo, (ICompilationUnit)typeRoot);
                            } else {
                                IResource file = typeRoot.getResource();
                                IClassFile classFile = (IClassFile)typeRoot;
                                candidate = file != null && !file.getFileExtension().equals("jar") ? this.findElementInBinaryFolder(handleInfo, classFile) : this.findElementInJar(handleInfo, classFile);
                            }
                            if (candidate != null) {
                                return candidate;
                            }
                        }
                        catch (NullPointerException nullPointerException22222222) {
                            // empty catch block
                            break block15;
                        }
                        try {
                            return ERROR_JAVA_ELEMENT;
                        }
                        catch (JavaModelException javaModelException3) {
                            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException3, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
                            JavaModelException javaModelException4 = javaModelException3;
                            break block16;
                        }
                        catch (NullPointerException nullPointerException4) {
                            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(nullPointerException4, this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_3);
                            NullPointerException nullPointerException5 = nullPointerException4;
                            break block15;
                        }
                        catch (JavaModelException javaModelException22222222) {
                            // empty catch block
                        }
                    }
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException22222222, this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_3);
                    JavaModelException javaModelException5 = javaModelException22222222;
                    break block17;
                    catch (JavaModelException javaModelException6222222) {
                        // empty catch block
                    }
                }
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException6222222, this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_3);
                e = javaModelException6222222;
                AspectJPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ajdt.core", "Could not find type root for " + jHandle, e));
                return ERROR_JAVA_ELEMENT;
            }
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(nullPointerException22222222, this, ajc$tjp_7, (JoinPoint.StaticPart)ajc$tjp_3);
            NullPointerException nullPointerException6 = nullPointerException22222222;
        }
        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(nullPointerException3222222, this, ajc$tjp_8, (JoinPoint.StaticPart)ajc$tjp_3);
        e = nullPointerException3222222;
        AspectJPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ajdt.core", "Could not find type root for " + jHandle, e));
        return ERROR_JAVA_ELEMENT;
    }

    private IJavaElement findElementInJar(HandleInfo handleInfo, IClassFile classFile) throws JavaModelException {
        IClassFile candidate = classFile;
        if (handleInfo.isType && !handleInfo.isInAspect) {
            candidate = classFile.getType();
        } else if (!handleInfo.isFile) {
            String newHandle = String.valueOf(classFile.getHandleIdentifier()) + handleInfo.restHandle;
            IJavaElement newElt = AspectJCore.create(newHandle);
            IProgramElement ipe = !handleInfo.isFile && (!handleInfo.isType || handleInfo.isInAspect) ? this.getProgramElement(handleInfo.origAJHandle) : IHierarchy.NO_STRUCTURE;
            if (newElt instanceof AspectJMemberElement && ipe != IHierarchy.NO_STRUCTURE) {
                JavaModelManager.getJavaModelManager().resetTemporaryCache();
                AspectJMemberElement ajElt = (AspectJMemberElement)newElt;
                ajElt.setStartLocation(this.offsetFromLine((ITypeRoot)classFile, ipe.getSourceLocation()));
            }
            candidate = newElt;
        }
        return candidate;
    }

    private IJavaElement findElementInBinaryFolder(HandleInfo handleInfo, IClassFile classFile) throws JavaModelException {
        IType type;
        IClassFile candidate = classFile;
        IPath path = classFile.getPath();
        IJavaProject otherProject = JavaCore.create((IProject)this.project).getJavaModel().getJavaProject(path.segment(0));
        Object typeRoot = classFile;
        if (otherProject.exists() && (typeRoot = (type = otherProject.findType(handleInfo.sourceTypeQualName())).getTypeRoot()) instanceof ICompilationUnit) {
            AJCompilationUnit newUnit = CompilationUnitTools.convertToAJCompilationUnit((ICompilationUnit)typeRoot);
            AJCompilationUnit aJCompilationUnit = typeRoot = newUnit != null ? newUnit : typeRoot;
        }
        if (handleInfo.isType) {
            switch (typeRoot.getElementType()) {
                case 6: {
                    candidate = typeRoot.getType();
                    break;
                }
                case 5: {
                    candidate = CompilationUnitTools.findType((ICompilationUnit)typeRoot, classFile.getType().getElementName(), true);
                    break;
                }
            }
        } else if (!handleInfo.isFile && !handleInfo.isType) {
            IProgramElement ipe = this.getProgramElement(handleInfo.origAJHandle);
            if (ipe != IHierarchy.NO_STRUCTURE) {
                candidate = typeRoot.getElementAt(this.offsetFromLine((ITypeRoot)typeRoot, ipe.getSourceLocation()));
            } else {
                String newHandle = String.valueOf(typeRoot.getHandleIdentifier()) + handleInfo.restHandle;
                candidate = AspectJCore.create(newHandle);
            }
        }
        return candidate;
    }

    private IJavaElement findElementInCU(HandleInfo handleInfo, ICompilationUnit cunit) throws JavaModelException {
        Object candidate;
        AJCompilationUnit newUnit = CompilationUnitTools.convertToAJCompilationUnit(cunit);
        cunit = newUnit != null ? newUnit : cunit;
        IProgramElement ipe = !handleInfo.isFile && !handleInfo.isType ? this.getProgramElement(handleInfo.origAJHandle) : IHierarchy.NO_STRUCTURE;
        if (handleInfo.isFile) {
            candidate = cunit;
        } else if (handleInfo.isType) {
            candidate = CompilationUnitTools.findType(cunit, handleInfo.simpleName, true);
        } else if (ipe != IHierarchy.NO_STRUCTURE) {
            candidate = cunit.getElementAt(this.offsetFromLine((ITypeRoot)cunit, ipe.getSourceLocation()));
        } else {
            String newHandle = String.valueOf(newUnit.getHandleIdentifier()) + handleInfo.restHandle;
            candidate = AspectJCore.create(newHandle);
        }
        return candidate;
    }

    private HandleInfo qualifiedNameFromBinaryHandle(String ajHandle) {
        boolean isFile;
        int packageStart = ajHandle.indexOf(60);
        int packageEnd = ajHandle.indexOf(40, packageStart + 1);
        if (packageEnd < 0) {
            String packageName = ajHandle.substring(packageStart + 1);
            return new HandleInfo(ajHandle, "", packageName, "", "", false, false, false);
        }
        int typeNameEnd = ajHandle.indexOf(".class", packageEnd + 1);
        if (typeNameEnd < 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String packageName = ajHandle.substring(packageStart + 1, packageEnd);
        sb.append(packageName);
        if (sb.length() > 0) {
            sb.append(".");
        }
        String simpleName = ajHandle.substring(packageEnd + 1, typeNameEnd);
        sb.append(simpleName);
        int aspectStart = ajHandle.indexOf(39, typeNameEnd);
        int classStart = ajHandle.indexOf(91, typeNameEnd);
        int typeStart = classStart == -1 ? aspectStart : (aspectStart == -1 ? classStart : Math.min(classStart, aspectStart));
        boolean bl = isFile = typeStart == -1;
        boolean isType = !isFile ? typeStart + simpleName.length() + 1 == ajHandle.length() : false;
        boolean isInAspect = aspectStart >= 0;
        String restHandle = typeStart >= 0 ? ajHandle.substring(typeStart) : "";
        return new HandleInfo(ajHandle, simpleName, packageName, sb.toString(), restHandle, isFile, isType, isInAspect);
    }

    private ITypeRoot getCUFromQualifiedName(HandleInfo handleInfo) throws JavaModelException {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        IJavaProject jproj = JavaCore.create((IProject)this.project);
        IType type = jproj.findType(handleInfo.qualName);
        if (type != null) {
            return type.getTypeRoot();
        }
        IPackageFragment[] fragments = this.findFragment(jproj, handleInfo);
        if (fragments.length > 0) {
            IPackageFragment[] iPackageFragmentArray = fragments;
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment fragment = iPackageFragmentArray[n2];
                ICompilationUnit[] cus = fragment.getCompilationUnits();
                int j = 0;
                while (j < cus.length) {
                    IType maybeType = CompilationUnitTools.findType(cus[j], handleInfo.simpleName, true);
                    if (maybeType != null) {
                        return cus[j];
                    }
                    ++j;
                }
                IClassFile[] cfs = fragment.getClassFiles();
                int j2 = 0;
                while (j2 < cfs.length) {
                    IType cType = cfs[j2].getType();
                    if (cType.getElementName().equals(handleInfo.simpleName)) {
                        return cfs[j2];
                    }
                    ++j2;
                }
                ++n2;
            }
        }
        return (ICompilationUnit)ERROR_JAVA_ELEMENT;
    }

    private IPackageFragment[] findFragment(IJavaProject jproj, HandleInfo handleInfo) throws JavaModelException {
        IPackageFragmentRoot[] pkgRoots = jproj.getAllPackageFragmentRoots();
        ArrayList<IPackageFragment> frags = new ArrayList<IPackageFragment>();
        int i = 0;
        while (i < pkgRoots.length) {
            IPackageFragment candidate = pkgRoots[i].getPackageFragment(handleInfo.packageName);
            if (candidate.exists()) {
                frags.add(candidate);
            }
            ++i;
        }
        return frags.toArray(new IPackageFragment[frags.size()]);
    }

    private int offsetFromLine(ITypeRoot unit, ISourceLocation sloc) throws JavaModelException {
        if (sloc.getOffset() > 0) {
            return sloc.getOffset();
        }
        if (this.slocCache != null && this.slocCache.containsKey(sloc)) {
            return this.slocCache.get(sloc);
        }
        if (unit instanceof AJCompilationUnit) {
            AJCompilationUnit ajUnit = (AJCompilationUnit)unit;
            ajUnit.requestOriginalContentMode();
        }
        IBuffer buf = unit.getBuffer();
        if (unit instanceof AJCompilationUnit) {
            AJCompilationUnit ajUnit = (AJCompilationUnit)unit;
            ajUnit.discardOriginalContentMode();
        }
        if (buf != null) {
            int requestedLine = sloc.getLine();
            int currentLine = 1;
            int offset = 0;
            while (offset < buf.getLength() && currentLine < requestedLine) {
                if (buf.getChar(offset++) != '\n') continue;
                ++currentLine;
            }
            while (offset < buf.getLength() && Character.isWhitespace(buf.getChar(offset))) {
                ++offset;
            }
            if (this.slocCache == null) {
                this.slocCache = new HashMap<ISourceLocation, Integer>();
            }
            this.slocCache.put(sloc, new Integer(offset));
            return offset;
        }
        return 0;
    }

    public boolean hasRuntimeTest(IJavaElement je) {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        if (!this.isInitialized) {
            return false;
        }
        IProgramElement ipe = this.javaElementToProgramElement(je);
        List relationships = this.relationshipMap.get(ipe);
        if (relationships != null) {
            for (IRelationship rel : relationships) {
                if (!rel.hasRuntimeTest()) continue;
                return true;
            }
        }
        return false;
    }

    public List<IJavaElement> getJavaElementsForLine(ICompilationUnit icu, final int line) {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        IProgramElement ipe = this.javaElementToProgramElement((IJavaElement)icu);
        final LinkedList elementsOnLine = new LinkedList();
        ipe.walk((HierarchyWalker)new CancellableHierarchyWalker(){

            protected void preProcess(IProgramElement node) {
                ISourceLocation sourceLocation = node.getSourceLocation();
                if (sourceLocation != null) {
                    if (sourceLocation.getEndLine() < line) {
                        this.cancel();
                    } else if (sourceLocation.getLine() == line) {
                        elementsOnLine.add(node);
                    }
                }
            }
        });
        ArrayList<IJavaElement> javaElements = new ArrayList<IJavaElement>(elementsOnLine.size());
        for (IProgramElement ipeOnLine : elementsOnLine) {
            javaElements.add(this.programElementToJavaElement(ipeOnLine));
        }
        return javaElements;
    }

    public List<IJavaElement> getRelationshipsForElement(IJavaElement je, AJRelationshipType relType) {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        return this.getRelationshipsForElement(je, relType, false);
    }

    public List<IJavaElement> getRelationshipsForElement(IJavaElement je, AJRelationshipType relType, boolean includeChildren) {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        if (!this.isInitialized) {
            return Collections.emptyList();
        }
        IProgramElement ipe = this.javaElementToProgramElement(je);
        List relationships = this.relationshipMap.get(ipe);
        ArrayList<IJavaElement> relatedJavaElements = new ArrayList<IJavaElement>(relationships != null ? relationships.size() : 0);
        if (relationships != null && relationships != null) {
            for (IRelationship rel : relationships) {
                if (!relType.getDisplayName().equals(rel.getName())) continue;
                for (String handle : rel.getTargets()) {
                    IJavaElement targetJe = this.programElementToJavaElement(handle);
                    if (targetJe != null && targetJe != ERROR_JAVA_ELEMENT) {
                        relatedJavaElements.add(targetJe);
                        continue;
                    }
                    if (handle.startsWith("*")) continue;
                    AspectJPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ajdt.core", "Could not create a Java element with handle:\n" + handle, (Throwable)new RuntimeException()));
                }
            }
        }
        if (includeChildren) {
            for (IProgramElement child : ipe.getChildren()) {
                relatedJavaElements.addAll(this.getRelationshipsForElement(this.programElementToJavaElement(child), relType, true));
            }
        }
        return relatedJavaElements;
    }

    public Map<Integer, List<IRelationship>> getRelationshipsForFile(ICompilationUnit icu) {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        return this.getRelationshipsForFile(icu, null);
    }

    public Map<Integer, List<IRelationship>> getRelationshipsForFile(ICompilationUnit icu, AJRelationshipType[] relType) {
        HashSet<String> interesting;
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        if (relType != null) {
            interesting = new HashSet<String>();
            int i = 0;
            while (i < relType.length) {
                interesting.add(relType[i].getDisplayName());
                ++i;
            }
        } else {
            interesting = null;
        }
        final HashMap<Integer, List<IRelationship>> allRelationshipsMap = new HashMap<Integer, List<IRelationship>>();
        IProgramElement ipe = this.javaElementToProgramElement((IJavaElement)icu);
        ipe.walk(new HierarchyWalker(){

            protected void preProcess(IProgramElement node) {
                List orig = AJProjectModelFacade.this.relationshipMap.get(node);
                if (orig == null) {
                    return;
                }
                ArrayList nodeRels = new ArrayList(orig);
                if (interesting != null) {
                    Iterator relIter = nodeRels.iterator();
                    while (relIter.hasNext()) {
                        IRelationship rel = (IRelationship)relIter.next();
                        if (interesting.contains(rel.getName())) continue;
                        relIter.remove();
                    }
                }
                if (nodeRels.size() > 0) {
                    List allRelsForLine;
                    Integer line = new Integer(node.getSourceLocation().getLine());
                    if (allRelationshipsMap.containsKey(line)) {
                        allRelsForLine = (List)allRelationshipsMap.get(line);
                    } else {
                        allRelsForLine = new LinkedList();
                        allRelationshipsMap.put(line, allRelsForLine);
                    }
                    allRelsForLine.addAll(nodeRels);
                }
            }
        });
        return allRelationshipsMap;
    }

    public List<IRelationship> getRelationshipsForProject(AJRelationshipType[] relType) {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        HashSet<String> interesting = new HashSet<String>();
        int i = 0;
        while (i < relType.length) {
            interesting.add(relType[i].getDisplayName());
            ++i;
        }
        if (this.relationshipMap instanceof RelationshipMap) {
            RelationshipMap map = (RelationshipMap)this.relationshipMap;
            LinkedList<IRelationship> allRels = new LinkedList<IRelationship>();
            for (List relList : map.values()) {
                for (IRelationship rel : relList) {
                    if (!interesting.contains(rel.getName())) continue;
                    allRels.add(rel);
                }
            }
            return allRels;
        }
        return Collections.emptyList();
    }

    public boolean isAdvised(IJavaElement elt) {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        if (!this.isInitialized) {
            return false;
        }
        IProgramElement ipe = this.javaElementToProgramElement(elt);
        if (ipe != IHierarchy.NO_STRUCTURE) {
            List ipeChildren;
            List rels = this.relationshipMap.get(ipe);
            if (rels != null && rels.size() > 0) {
                for (IRelationship rel : rels) {
                    if (rel.isAffects()) continue;
                    return true;
                }
            }
            if (ipe.getKind() != IProgramElement.Kind.CLASS && ipe.getKind() != IProgramElement.Kind.ASPECT && (ipeChildren = ipe.getChildren()) != null) {
                for (IProgramElement child : ipeChildren) {
                    if (child.getKind() != IProgramElement.Kind.CODE) continue;
                    rels = this.relationshipMap.get(child);
                    for (IRelationship rel : rels) {
                        if (rel.isAffects()) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public Set<IType> aspectsForFile(ICompilationUnit cu) {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        IProgramElement ipe = this.javaElementToProgramElement((IJavaElement)cu);
        final HashSet<IType> aspects = new HashSet<IType>();
        ipe.walk(new HierarchyWalker(){

            protected void preProcess(IProgramElement node) {
                if (node.getKind() == IProgramElement.Kind.ASPECT) {
                    aspects.add((IType)AJProjectModelFacade.this.programElementToJavaElement(node));
                }
            }
        });
        return aspects;
    }

    void dispose() {
        this.structureModel = null;
        this.relationshipMap = null;
        this.isInitialized = false;
        this.disposed = true;
    }

    public boolean isDisposed() {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        return this.disposed;
    }

    public IProject getProject() {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        return this.project;
    }

    public static String printHierarchy(IHierarchy h) {
        final StringBuffer sb = new StringBuffer();
        HierarchyWalker walker = new HierarchyWalker(){
            int depth = 0;

            protected void preProcess(IProgramElement node) {
                sb.append(this.spaces(this.depth));
                sb.append(node.getHandleIdentifier());
                sb.append("\n");
                this.depth += 2;
            }

            protected void postProcess(IProgramElement node) {
                this.depth -= 2;
            }

            String spaces(int depth) {
                StringBuffer sb2 = new StringBuffer();
                int i = 0;
                while (i < depth) {
                    sb2.append(" ");
                    ++i;
                }
                return sb2.toString();
            }
        };
        h.getRoot().walk(walker);
        return sb.toString();
    }

    public static String printRelationships(IRelationshipMap map) {
        StringBuffer sb = new StringBuffer();
        RelationshipMap rmap = (RelationshipMap)map;
        for (Map.Entry entry : rmap.entrySet()) {
            String handle = (String)entry.getKey();
            sb.append(String.valueOf(handle) + " ::\n");
            for (IRelationship rel : (List)entry.getValue()) {
                String str = AJProjectModelFacade.printRelationship(rel);
                sb.append("\t" + str + "\n");
            }
        }
        return sb.toString();
    }

    public static String printRelationship(IRelationship rel) {
        return String.valueOf(rel.getSourceHandle()) + " --" + rel.getName() + "--> " + rel.getTargets();
    }

    IRelationshipMap getAllRelationships() {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        return this.relationshipMap;
    }

    public String getModelAsString() {
        EnsureInitialized.aspectOf().ajc$before$org_eclipse_ajdt_core_model_EnsureInitialized$1$40ffe7ba(this);
        if (this.hasModel()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Hierarchy:\n");
            sb.append(AJProjectModelFacade.printHierarchy(this.structureModel));
            sb.append("\nRelationship map:\n");
            sb.append(AJProjectModelFacade.printRelationships(this.relationshipMap));
            return sb.toString();
        }
        return "No structure model available for " + this.project.getName();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AJProjectModelFacade.java", AJProjectModelFacade.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.model.AJProjectModelFacade", "java.lang.NumberFormatException", "<missing>"), 410);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "programElementToJavaElement", "org.eclipse.ajdt.core.model.AJProjectModelFacade", "java.lang.String", "ajHandle", "", "org.eclipse.jdt.core.IJavaElement"), 371);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.model.AJProjectModelFacade", "org.eclipse.jdt.core.JavaModelException", "e"), 546);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getElementFromClassFile", "org.eclipse.ajdt.core.model.AJProjectModelFacade", "java.lang.String", "jHandle", "", "org.eclipse.jdt.core.IJavaElement"), 499);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.model.AJProjectModelFacade", "org.eclipse.jdt.core.JavaModelException", "e"), 546);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.model.AJProjectModelFacade", "org.eclipse.jdt.core.JavaModelException", "e"), 546);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.model.AJProjectModelFacade", "java.lang.NullPointerException", "e"), 550);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.model.AJProjectModelFacade", "java.lang.NullPointerException", "e"), 550);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.model.AJProjectModelFacade", "java.lang.NullPointerException", "e"), 550);
    }

    class CancellableHierarchyWalker
    extends HierarchyWalker {
        private boolean cancelled = false;

        CancellableHierarchyWalker() {
        }

        public IProgramElement process(IProgramElement node) {
            this.preProcess(node);
            if (!this.cancelled) {
                node.walk((HierarchyWalker)this);
            } else {
                this.cancelled = false;
            }
            this.postProcess(node);
            return node;
        }

        protected void cancel() {
            this.cancelled = true;
        }
    }

    private class HandleInfo {
        final String origAJHandle;
        final String simpleName;
        final String packageName;
        final String qualName;
        final String restHandle;
        final boolean isFile;
        final boolean isType;
        final boolean isInAspect;

        public HandleInfo(String origAJHandle, String simpleName, String packageName, String qualName, String restHandle, boolean isFile, boolean isType, boolean isInAspect) {
            this.origAJHandle = origAJHandle;
            this.simpleName = simpleName;
            this.packageName = packageName;
            this.qualName = qualName;
            this.restHandle = restHandle;
            this.isFile = isFile;
            this.isType = isType;
            this.isInAspect = isInAspect;
        }

        boolean isPackageFragment() {
            return !this.isFile && !this.isType && !this.isInAspect;
        }

        String sourceTypeQualName() {
            return this.qualName.replaceAll("\\$", "\\.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectModelBuildListener
    implements IAJBuildListener {
        private Set<IProject> beingBuilt = new HashSet<IProject>();
        private Set<IProject> beingCleaned = new HashSet<IProject>();

        private ProjectModelBuildListener() {
        }

        @Override
        public synchronized void postAJBuild(int kind, IProject project, boolean noSourceChanges, Map<IFile, List<CategorizedProblem>> newProblems) {
            this.beingBuilt.remove(project);
        }

        @Override
        public synchronized void postAJClean(IProject project) {
            this.beingCleaned.remove(project);
        }

        @Override
        public synchronized void preAJBuild(int kind, IProject project, IProject[] requiredProjects) {
            if (kind == 15) {
                this.beingCleaned.add(project);
            } else {
                this.beingBuilt.add(project);
            }
        }

        @Override
        public void addAdviceListener(IAdviceChangedListener adviceListener) {
        }

        @Override
        public void removeAdviceListener(IAdviceChangedListener adviceListener) {
        }

        synchronized boolean isCurrentlyBuilding(IProject project) {
            return this.beingBuilt.contains(project) || this.beingCleaned.contains(project);
        }
    }
}

