/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.internal.preference;

import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderDefinition;
import org.eclipse.contribution.visualiser.core.RendererManager;
import org.eclipse.jface.preference.IPreferenceStore;

public class VisualiserPreferences {
    public static final String MAX_BAR = "org.eclipse.contribution.visualiser.preferences.maxbarwidth";
    public static final String MIN_BAR = "org.eclipse.contribution.visualiser.preferences.minbarwidth";
    public static final String PROVIDER = "org.eclipse.contribution.visualiser.preferences.provider";
    public static final String BAR_WIDTH = "org.eclipse.contribution.visualiser.preferences.barwidth";
    public static final String STRIPE_HEIGHT = "org.eclipse.contribution.visualiser.preferences.stripeheight";
    public static final String RENDERER = "org.eclipse.contribution.visualiser.preferences.renderer";
    public static final String PALETTE_PREFIX = "org.eclipse.contribution.visualiser.preferences.palette_";
    public static final String PATTERN_STRIPE_HEIGHT = "org.eclipse.contribution.visualiser.preferences.patternstripeheight";
    public static final String USE_PATTERNS = "org.eclipse.contribution.visualiser.preferences.patterns";
    public static final String DO_AUTO_INCREASE_VISUALISER_STRIPE_HEIGHT = "org.eclipse.contribution.visualiser.preferences.doincreasestipeheight";
    public static final String DONT_AUTO_INCREASE_VISUALISER_STRIPE_HEIGHT = "org.eclipse.contribution.visualiser.preferences.dontincreasestipeheight";
    public static final int STRIPE_SIZE_DEFAULT = 4;
    public static final int BAR_WIDTH_DEFAULT = 60;
    public static final int BAR_MIN_WIDTH = 18;
    public static final int PATTERN_STRIPE_SIZE_DEFAULT = 8;
    public static final boolean USE_PATTERNS_DEFAULT = false;
    public static final boolean INCREASE_VISUALISER_STRIPE_HEIGHT_AUTO_DEFAULT = false;

    public static void initDefaults() {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        store.setDefault(PROVIDER, "");
        store.setDefault(BAR_WIDTH, 60);
        store.setDefault(STRIPE_HEIGHT, 4);
        store.setDefault(MIN_BAR, 18);
        store.setValue(MIN_BAR, 18);
        store.setDefault(PATTERN_STRIPE_HEIGHT, 8);
        store.setDefault(USE_PATTERNS, false);
    }

    public static int getMaxBarSize() {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        return store.getInt(MAX_BAR);
    }

    public static int getMinBarSize() {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        return store.getInt(MIN_BAR);
    }

    public static String getProvider() {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        return store.getString(PROVIDER);
    }

    public static int getBarWidth() {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        return store.getInt(BAR_WIDTH);
    }

    public static int getStripeHeight() {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        return store.getInt(STRIPE_HEIGHT);
    }

    public static boolean getUsePatterns() {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(USE_PATTERNS);
    }

    public static String getRendererName() {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        return store.getString(RENDERER);
    }

    public static void setRendererName(String value) {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        store.setValue(RENDERER, value);
        RendererManager.setCurrentRendererByName(value);
    }

    public static int getDefaultBarWidth() {
        return 60;
    }

    public static int getDefaultStripeHeight() {
        return 4;
    }

    public static int getDefaultPatternStripeHeight() {
        return 8;
    }

    public static boolean getDefaultUsePatterns() {
        return false;
    }

    public static String getPaletteIDForProvider(String providerID) {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        String pref = PALETTE_PREFIX + providerID;
        return store.getString(pref);
    }

    public static boolean getDoAutoIncreaseStripeHeight() {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(DO_AUTO_INCREASE_VISUALISER_STRIPE_HEIGHT);
    }

    public static boolean getDontAutoIncreaseStripeHeight() {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(DONT_AUTO_INCREASE_VISUALISER_STRIPE_HEIGHT);
    }

    public static void setBarWidth(int value) {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        store.setValue(BAR_WIDTH, value);
    }

    public static void setStripeHeight(int value) {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        store.setValue(STRIPE_HEIGHT, value);
    }

    public static void setUsePatterns(boolean value) {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        store.setValue(USE_PATTERNS, value);
    }

    public static void setPaletteIDForProvider(ProviderDefinition def, String value) {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        String pref = PALETTE_PREFIX + def.getID();
        store.setValue(pref, value);
    }

    public static void setDoIncreaseStripeHeight(boolean value) {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        store.setValue(DO_AUTO_INCREASE_VISUALISER_STRIPE_HEIGHT, value);
    }

    public static void setDontIncreaseStripeHeight(boolean value) {
        IPreferenceStore store = VisualiserPlugin.getDefault().getPreferenceStore();
        store.setValue(DONT_AUTO_INCREASE_VISUALISER_STRIPE_HEIGHT, value);
    }
}

