/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.refactoring;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJCore;
import org.eclipse.ajdt.core.javaelements.DeclareElement;
import org.eclipse.ajdt.core.javaelements.DeclareElementInfo;
import org.eclipse.ajdt.core.javaelements.IAspectJElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoringDescriptor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushInRefactoring
extends Refactoring {
    public static final String ALL_ITDS = "all.itds";
    public static final String DELETE_EMPTY = "delete.empty";
    private boolean deleteEmpty = true;
    private Map<ICompilationUnit, Change> allChanges = null;
    private List<IMember> itds = null;
    private Map<IProject, AJProjectModelFacade> allModels = new HashMap<IProject, AJProjectModelFacade>();
    private Map<IJavaProject, NameLookup> allLookups = new HashMap<IJavaProject, NameLookup>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    private AJProjectModelFacade getModel(IJavaElement elt) {
        IProject project = elt.getJavaProject().getProject();
        AJProjectModelFacade model = this.allModels.get(project);
        if (model == null) {
            model = AJProjectModelFactory.getInstance().getModelForProject(project);
            this.allModels.put(project, model);
        }
        return model;
    }

    private NameLookup getLookup(IJavaElement elt) throws JavaModelException {
        IJavaProject javaProject = elt.getJavaProject();
        NameLookup nameLookup = this.allLookups.get(javaProject);
        if (nameLookup == null) {
            nameLookup = ((JavaProject)javaProject).newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
            this.allLookups.put(javaProject, nameLookup);
        }
        return nameLookup;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("Checking final conditions...", 2);
            this.allChanges = new LinkedHashMap<ICompilationUnit, Change>();
            HashMap<ICompilationUnit, LinkedList<IMember>> unitToITDs = new HashMap<ICompilationUnit, LinkedList<IMember>>();
            HashMap<ICompilationUnit, PerUnitInformation> importsMap = new HashMap<ICompilationUnit, PerUnitInformation>();
            for (IMember iMember : this.itds) {
                ICompilationUnit unit;
                LinkedList<IMember> itdList;
                if (iMember instanceof IAspectJElement && ((IAspectJElement)iMember).getAJKind() == IProgramElement.Kind.DECLARE_PARENTS) {
                    AJProjectModelFacade model = this.getModel((IJavaElement)iMember);
                    List elts = model.getRelationshipsForElement((IJavaElement)iMember, AJRelationshipManager.DECLARED_ON);
                    IProgramElement ipe = model.javaElementToProgramElement((IJavaElement)iMember);
                    List parentTypes = ipe.getParentTypes();
                    for (IJavaElement elt : elts) {
                        if (elt.getElementType() != 7) continue;
                        IType type = (IType)elt;
                        ICompilationUnit owningUnit = type.getCompilationUnit();
                        PerUnitInformation holder = (PerUnitInformation)importsMap.get(owningUnit);
                        if (holder == null) {
                            holder = new PerUnitInformation(owningUnit);
                            importsMap.put(owningUnit, holder);
                        }
                        holder.addDeclarParents(type, parentTypes);
                    }
                }
                if ((itdList = (LinkedList<IMember>)unitToITDs.get(unit = iMember.getCompilationUnit())) == null) {
                    itdList = new LinkedList<IMember>();
                    unitToITDs.put(unit, itdList);
                }
                itdList.add(iMember);
            }
            for (Map.Entry entry : unitToITDs.entrySet()) {
                status.merge(this.checkFinalConditionsForITD((ICompilationUnit)entry.getKey(), (List)entry.getValue(), importsMap, monitor));
            }
            for (PerUnitInformation perUnitInformation : importsMap.values()) {
                perUnitInformation.rewriteImports();
            }
        }
        finally {
            this.allLookups.clear();
            this.allModels.clear();
            monitor.done();
        }
        return status;
    }

    private RefactoringStatus checkFinalConditionsForITD(final ICompilationUnit ajUnit, final List<IMember> itdsForUnit, final Map<ICompilationUnit, PerUnitInformation> imports, final IProgressMonitor monitor) throws JavaModelException {
        Collection<ICompilationUnit> units;
        RefactoringStatus status = new RefactoringStatus();
        final Map<ICompilationUnit, Set<IMember>> unitsToTypes = this.getUnitTypeMap(this.getTargets(itdsForUnit));
        HashMap projects = new HashMap();
        for (ICompilationUnit targetUnit : unitsToTypes.keySet()) {
            IJavaProject project = targetUnit.getJavaProject();
            if (project == null) continue;
            ArrayList<ICompilationUnit> collection = (ArrayList<ICompilationUnit>)projects.get(project);
            if (collection == null) {
                collection = new ArrayList<ICompilationUnit>();
                projects.put(project, collection);
            }
            collection.add(targetUnit);
        }
        IJavaProject aspectProject = ajUnit.getJavaProject();
        if (projects.containsKey(aspectProject)) {
            units = (Collection)projects.get(aspectProject);
        } else {
            units = new ArrayList();
            projects.put(aspectProject, units);
        }
        units.add(ajUnit);
        ASTRequestor requestors = new ASTRequestor(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

            public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
                try {
                    PerUnitInformation holder;
                    if (imports.containsKey(source)) {
                        holder = (PerUnitInformation)imports.get(source);
                    } else {
                        holder = new PerUnitInformation(source);
                        imports.put(source, holder);
                    }
                    holder.computeImports(itdsForUnit, ajUnit, monitor);
                    for (Map.Entry<IType, Set<String>> entry : holder.declareParents.entrySet()) {
                        PushInRefactoring.this.rewriteDeclareParents(entry.getKey(), ast, entry.getValue(), source);
                    }
                    if (PushInRefactoring.this.isCUnitContainingITD(source, (IMember)itdsForUnit.get(0))) {
                        PushInRefactoring.this.rewriteAspectType(itdsForUnit, source, ast);
                    } else {
                        for (IMember itd : itdsForUnit) {
                            ArrayList members = new ArrayList();
                            members.addAll((Collection)unitsToTypes.get(source));
                            AJProjectModelFacade model = PushInRefactoring.this.getModel((IJavaElement)itd);
                            List realTargets = itd instanceof IAspectJElement && ((IAspectJElement)itd).getAJKind().isDeclareAnnotation() ? model.getRelationshipsForElement((IJavaElement)itd, AJRelationshipManager.ANNOTATES) : model.getRelationshipsForElement((IJavaElement)itd, AJRelationshipManager.DECLARED_ON);
                            Iterator memberIter = members.iterator();
                            while (memberIter.hasNext()) {
                                IMember member = (IMember)memberIter.next();
                                if (realTargets.contains(member)) continue;
                                memberIter.remove();
                            }
                            if (members.size() <= 0) continue;
                            if (itd instanceof IAspectJElement) {
                                ((IAspectJElement)itd).getAJKind();
                            }
                            PushInRefactoring.this.applyTargetTypeEdits(itd, source, members);
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
                }
            }

            static {
                1.ajc$preClinit();
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("PushInRefactoring.java", 1.class);
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoring$1", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 458);
                ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "acceptAST", "org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoring$1", "org.eclipse.jdt.core.ICompilationUnit:org.eclipse.jdt.core.dom.CompilationUnit", "source:ast", "", "void"), 395);
                ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoring$1", "org.eclipse.core.runtime.CoreException", "<missing>"), 459);
            }
        };
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        try {
            try {
                Set set = projects.keySet();
                subMonitor.beginTask("Compiling source...", set.size());
                for (IJavaProject project : projects.keySet()) {
                    ASTParser parser = ASTParser.newParser((int)3);
                    parser.setProject(project);
                    parser.setResolveBindings(true);
                    Collection collection = (Collection)projects.get(project);
                    parser.createASTs(collection.toArray(new ICompilationUnit[collection.size()]), new String[0], requestors, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1));
                }
            }
            finally {
                subMonitor.done();
            }
        }
        finally {
            subMonitor.done();
        }
        return status;
    }

    protected void rewriteAspectType(List<IMember> itdsForUnit, ICompilationUnit source, CompilationUnit ast) throws JavaModelException, CoreException {
        HashMap<IType, Integer> removalStored = new HashMap<IType, Integer>();
        HashMap<IType, List<DeleteEdit>> typeDeletes = new HashMap<IType, List<DeleteEdit>>();
        for (IMember itd : itdsForUnit) {
            List<DeleteEdit> deletes;
            IType parentAspectType = (IType)itd.getParent();
            if (removalStored.containsKey(parentAspectType)) {
                int numRemovals = (Integer)removalStored.get(parentAspectType);
                removalStored.put(parentAspectType, new Integer(++numRemovals));
            } else {
                removalStored.put(parentAspectType, new Integer(1));
            }
            if (typeDeletes.containsKey(parentAspectType)) {
                deletes = (List)typeDeletes.get(parentAspectType);
            } else {
                deletes = new LinkedList();
                typeDeletes.put(parentAspectType, deletes);
            }
            DeleteEdit edit = new DeleteEdit(itd.getSourceRange().getOffset(), itd.getSourceRange().getLength() + 1);
            deletes.add(edit);
        }
        if (this.deleteTypes(ast, typeDeletes, removalStored)) {
            this.allChanges.put(source, (Change)new DeleteResourceChange(source.getResource().getFullPath(), false));
        } else {
            this.applyAspectEdits(source, typeDeletes);
        }
    }

    private void rewriteDeclareParents(IType targetType, CompilationUnit astUnit, Set<String> newParents, ICompilationUnit unit) throws JavaModelException {
        TextEdit edit;
        TypeDeclaration typeDecl = this.findType(astUnit, targetType.getElementName());
        if (typeDecl == null) {
            this.createJavaModelException("Couldn't find type " + targetType.getElementName() + " in " + unit.getElementName());
        }
        ArrayList<String> simpleParents = new ArrayList<String>(newParents.size());
        for (String qual : newParents) {
            simpleParents.add(this.convertToSimple(qual));
        }
        Type superclassType = typeDecl.getSuperclassType();
        Type supr = superclassType;
        if (supr != null && supr.isSimpleType()) {
            simpleParents.remove(((SimpleType)supr).getName().getFullyQualifiedName());
        }
        for (Type iface : typeDecl.superInterfaceTypes()) {
            if (!iface.isSimpleType()) continue;
            simpleParents.remove(((SimpleType)iface).getName().getFullyQualifiedName());
        }
        String newSuper = null;
        int cnt = 0;
        for (String parent : newParents) {
            if (this.isClass(parent, targetType)) {
                newSuper = (String)simpleParents.remove(cnt);
            }
            ++cnt;
        }
        ASTRewrite rewriter = ASTRewrite.create((AST)astUnit.getAST());
        AST ast = typeDecl.getAST();
        if (newSuper != null) {
            Type newSuperType = this.createTypeAST(newSuper, ast);
            if (superclassType == null) {
                rewriter.set((ASTNode)typeDecl, (StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, (Object)newSuperType, null);
            } else {
                rewriter.replace((ASTNode)superclassType, (ASTNode)newSuperType, null);
            }
        }
        if (simpleParents.size() > 0) {
            ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)typeDecl, TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY);
            for (String simpleParent : simpleParents) {
                listRewrite.insertLast((ASTNode)this.createTypeAST(simpleParent, ast), null);
            }
        }
        if (!this.isEmptyEdit(edit = rewriter.rewriteAST())) {
            TextFileChange change = (TextFileChange)this.allChanges.get(unit);
            if (change == null) {
                change = new TextFileChange(unit.getElementName(), (IFile)unit.getResource());
                change.setTextType("java");
                change.setEdit((TextEdit)new MultiTextEdit());
                this.allChanges.put(unit, (Change)change);
            }
            change.getEdit().addChild(edit);
        }
    }

    private Type createTypeAST(String newSuper, AST ast) {
        Object object;
        String toParse = String.valueOf(newSuper) + " t;";
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(toParse.toCharArray());
        parser.setKind(4);
        ASTNode astNode = parser.createAST(null);
        SimpleType t = null;
        if (astNode instanceof TypeDeclaration && (object = ((TypeDeclaration)astNode).bodyDeclarations().get(0)) instanceof FieldDeclaration) {
            t = ((FieldDeclaration)object).getType();
            t = (Type)ASTNode.copySubtree((AST)ast, (ASTNode)t);
        }
        if (t == null) {
            t = ast.newSimpleType((Name)ast.newSimpleName("MISSING"));
        }
        return t;
    }

    String convertToSimple(String qualName) {
        char[] charArray = qualName.toCharArray();
        StringBuilder candidate = new StringBuilder(charArray.length);
        StringBuilder complete = new StringBuilder(charArray.length);
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '.': {
                    candidate.delete(0, candidate.length());
                    break;
                }
                case ',': 
                case '<': 
                case '>': {
                    complete.append((CharSequence)candidate).append(c);
                    candidate.delete(0, candidate.length());
                    break;
                }
                default: {
                    candidate.append(c);
                }
            }
            ++n2;
        }
        complete.append((CharSequence)candidate);
        return complete.toString();
    }

    private boolean isClass(String name, IType type) throws JavaModelException {
        String simpleName;
        String packageName;
        int dotIndex;
        String erasedName = name;
        int genericsIndex = name.indexOf(60);
        if (genericsIndex > 0) {
            erasedName = name.substring(0, genericsIndex);
        }
        if ((dotIndex = erasedName.lastIndexOf(46)) > 0) {
            packageName = erasedName.substring(0, dotIndex);
            simpleName = erasedName.substring(dotIndex + 1);
        } else {
            packageName = "";
            simpleName = erasedName;
        }
        IType found = this.findType(packageName, simpleName, type);
        return found != null && found.isClass();
    }

    private IType findType(String packageName, String simpleName, IType type) throws JavaModelException {
        IType foundType;
        NameLookup lookup = this.getLookup((IJavaElement)type);
        NameLookup.Answer answer = lookup.findType(simpleName, packageName, false, 6, true, false, false, null);
        if (answer != null) {
            return answer.type;
        }
        int dotIndex = packageName.lastIndexOf(46);
        if (dotIndex > 0 && (foundType = this.findType(packageName.substring(0, dotIndex), packageName.substring(dotIndex + 1), type)) != null && foundType.getType(simpleName).exists()) {
            return foundType.getType(simpleName);
        }
        return null;
    }

    private void createJavaModelException(String message) throws JavaModelException {
        throw new JavaModelException(new CoreException((IStatus)new Status(1, "org.eclipse.ajdt.ui", message)));
    }

    private TypeDeclaration findType(CompilationUnit ast, String name) {
        for (TypeDeclaration type : ast.types()) {
            if (!type.getName().getIdentifier().equals(name)) continue;
            return type;
        }
        return null;
    }

    private boolean deleteTypes(CompilationUnit ast, Map<IType, List<DeleteEdit>> typeDeletes, Map<IType, Integer> removalStored) throws JavaModelException {
        if (!this.deleteEmpty) {
            return false;
        }
        int typesDeleted = 0;
        for (Map.Entry<IType, Integer> entry : removalStored.entrySet()) {
            IType type = entry.getKey();
            int removals = entry.getValue();
            if (type.getChildren().length != removals) continue;
            List typeNodes = ast.types();
            for (AbstractTypeDeclaration typeNode : typeNodes) {
                if (!typeNode.getName().toString().equals(type.getElementName())) continue;
                List<DeleteEdit> deletes = typeDeletes.get(type);
                deletes.clear();
                deletes.add(new DeleteEdit(type.getSourceRange().getOffset(), type.getSourceRange().getLength()));
                ++typesDeleted;
            }
        }
        return ast.types().size() == typesDeleted;
    }

    private void applyTargetTypeEdits(IMember itd, ICompilationUnit source, Collection<IMember> targets) throws CoreException, JavaModelException {
        MultiTextEdit multiEdit = new MultiTextEdit();
        for (IMember target : targets) {
            Object edit = null;
            if (itd instanceof IAspectJElement) {
                IAspectJElement ajElement = (IAspectJElement)itd;
                if (itd instanceof IntertypeElement) {
                    if (target instanceof IType) {
                        IType type = (IType)target;
                        edit = type.isInterface() && ajElement.getAJKind() != IProgramElement.Kind.INTER_TYPE_METHOD ? null : this.createEditForITDTarget((IntertypeElement)itd, type);
                    }
                } else if (ajElement.getAJKind().isDeclareAnnotation()) {
                    edit = this.createEditForDeclareTarget((DeclareElement)itd, target);
                }
            } else if (itd instanceof IType) {
                edit = this.createEditForIntertypeInnerType((IType)itd, (IType)target);
            }
            if (edit == null) continue;
            multiEdit.addChild(edit);
        }
        if (!this.isEmptyEdit((TextEdit)multiEdit)) {
            TextFileChange change = (TextFileChange)this.allChanges.get(source);
            if (change == null) {
                change = new TextFileChange(source.getElementName(), (IFile)source.getResource());
                change.setTextType("java");
                change.setEdit((TextEdit)new MultiTextEdit());
                this.allChanges.put(source, (Change)change);
            }
            change.getEdit().addChild((TextEdit)multiEdit);
        }
    }

    private String getQualifiedTypeForDeclareAnnotation(DeclareElement itd) {
        IProgramElement ipe = this.getModel((IJavaElement)itd).javaElementToProgramElement((IJavaElement)itd);
        if (ipe != null) {
            return ipe.getAnnotationType();
        }
        return null;
    }

    private TextEdit createEditForIntertypeInnerType(IType itit, IType target) throws JavaModelException {
        String source = itit.getSource();
        int nameOffset = itit.getNameRange().getOffset() - itit.getSourceRange().getOffset();
        int dotOffset = source.lastIndexOf(36, nameOffset);
        int classIndex = source.lastIndexOf("class ", dotOffset);
        source = "\n\t" + source.substring(0, classIndex + "class ".length()) + source.substring(dotOffset + 1, source.length()) + "\n";
        return new InsertEdit(this.getITDInsertLocation(target), source);
    }

    private TextEdit createEditForDeclareTarget(DeclareElement itd, IMember target) throws JavaModelException {
        DeclareElementInfo declareElementInfo = (DeclareElementInfo)itd.getElementInfo();
        if (declareElementInfo.isAnnotationRemover()) {
            AJProjectModelFacade model = this.getModel((IJavaElement)itd);
            IProgramElement ipe = model.javaElementToProgramElement((IJavaElement)itd);
            return this.getAnnotationRemovalEdit(target, ipe.getRemovedAnnotationTypes());
        }
        return new InsertEdit(this.getDeclareInsertLocation(target), this.getTextForDeclare(itd));
    }

    private TextEdit getAnnotationRemovalEdit(IMember target, String[] removedAnnotationTypes) throws JavaModelException {
        if (target instanceof IAnnotatable) {
            IAnnotatable annotatable = (IAnnotatable)target;
            IAnnotation[] anns = annotatable.getAnnotations();
            ArrayList<DeleteEdit> deletes = new ArrayList<DeleteEdit>(removedAnnotationTypes.length);
            String[] stringArray = removedAnnotationTypes;
            int n = removedAnnotationTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String removedType = stringArray[n2];
                DeleteEdit edit = null;
                IAnnotation[] iAnnotationArray = anns;
                int n3 = anns.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAnnotation ann = iAnnotationArray[n4];
                    String annName = ann.getElementName();
                    boolean qualMatch = removedType.equals(annName);
                    boolean simpleMatch = removedType.endsWith("." + annName);
                    if (simpleMatch || qualMatch) {
                        ISourceRange range = ann.getSourceRange();
                        edit = new DeleteEdit(range.getOffset(), range.getLength());
                        if (qualMatch) break;
                    }
                    ++n4;
                }
                if (edit != null) {
                    deletes.add(edit);
                }
                ++n2;
            }
            if (deletes.size() == 0) {
                return null;
            }
            if (deletes.size() == 1) {
                return (TextEdit)deletes.get(0);
            }
            MultiTextEdit multi = new MultiTextEdit();
            for (DeleteEdit delete : deletes) {
                multi.addChild((TextEdit)delete);
            }
            return multi;
        }
        return null;
    }

    private String getTextForDeclare(DeclareElement itd) throws JavaModelException {
        IProgramElement ipe = this.getModel((IJavaElement)itd).javaElementToProgramElement((IJavaElement)itd);
        if (ipe != null) {
            String details = ipe.getDetails();
            int colonIndex = details.indexOf(58);
            String text = details.substring(colonIndex + 1).trim();
            if (itd.getAJKind() == IProgramElement.Kind.DECLARE_ANNOTATION_AT_TYPE) {
                return String.valueOf(text) + "\n";
            }
            return String.valueOf(text) + "\n\t";
        }
        throw new RuntimeException("Could not find program element in AspectJ model for " + itd.getHandleIdentifier());
    }

    private int getDeclareInsertLocation(IMember target) throws JavaModelException {
        return target.getSourceRange().getOffset();
    }

    private TextEdit createEditForITDTarget(IntertypeElement itd, IType target) throws JavaModelException {
        InsertEdit edit = target.isInterface() ? new InsertEdit(this.getITDInsertLocation(target), this.getTargetTextForInterface(itd)) : new InsertEdit(this.getITDInsertLocation(target), this.getTargetTextForClass(itd));
        return edit;
    }

    private String getTargetTextForClass(IntertypeElement itd) throws JavaModelException {
        String maybeConstructor;
        String[] maybeConstructorArr;
        String itdName = itd.getElementName();
        String[] splits = itdName.split("\\.");
        String newName = splits[splits.length - 1];
        if ((itdName = itdName.replaceAll("\\.", "\\\\\\$")).endsWith("_new") && (maybeConstructorArr = (maybeConstructor = itdName.substring(0, itdName.length() - "_new".length())).split("\\\\\\$")).length == 2 && maybeConstructorArr[0].equals(maybeConstructorArr[1])) {
            itdName = String.valueOf(maybeConstructorArr[0]) + "\\$new";
            newName = maybeConstructorArr[0];
        }
        String targetSource = this.getTargetSource(newName, itd);
        targetSource = "\n\t" + targetSource + "\n";
        targetSource = targetSource.replaceAll(itdName, newName);
        return targetSource;
    }

    private String getTargetTextForInterface(IntertypeElement itd) throws JavaModelException {
        String itdName = itd.getElementName();
        String[] splits = itdName.split("\\.");
        String newName = splits[splits.length - 1];
        itdName = itdName.replaceAll("\\.", "\\\\\\$");
        String targetSource = this.getTargetSource(newName, itd);
        int closeParen = targetSource.indexOf(")");
        if (closeParen >= 0) {
            targetSource = String.valueOf(targetSource.substring(0, closeParen + 1)) + ';';
        }
        targetSource = "\n\t" + targetSource + "\n\n";
        targetSource = targetSource.replaceAll(itdName, newName);
        return targetSource;
    }

    private String getTargetSource(String newName, IntertypeElement itd) throws JavaModelException {
        int itdStart = itd.getSourceRange().getOffset();
        int itdNameStart = itd.getTargetTypeSourceRange().getOffset() - itdStart;
        int itdNameEnd = itd.getNameRange().getOffset() + itd.getNameRange().getLength() - itdStart;
        String targetSource = itd.getSource();
        targetSource = String.valueOf(targetSource.substring(0, itdNameStart)) + newName + targetSource.substring(itdNameEnd);
        return targetSource;
    }

    private int getITDInsertLocation(IType type) throws JavaModelException {
        return type.getSourceRange().getOffset() + type.getSourceRange().getLength() - 1;
    }

    private void applyAspectEdits(ICompilationUnit source, Map<IType, List<DeleteEdit>> typeDeletes) throws JavaModelException, CoreException {
        MultiTextEdit edit = new MultiTextEdit();
        for (List<DeleteEdit> deletesForOneType : typeDeletes.values()) {
            for (DeleteEdit delete : deletesForOneType) {
                edit.addChild((TextEdit)delete);
            }
        }
        if (!this.isEmptyEdit((TextEdit)edit)) {
            TextFileChange change = (TextFileChange)this.allChanges.get(source);
            if (change == null) {
                change = new TextFileChange(source.getElementName(), (IFile)source.getResource());
                change.setTextType("java");
                change.setEdit((TextEdit)edit);
                this.allChanges.put(source, (Change)change);
            } else {
                change.getEdit().addChild((TextEdit)edit);
            }
        }
    }

    private Map<ICompilationUnit, Set<IMember>> getUnitTypeMap(IMember[] targets) {
        HashMap<ICompilationUnit, Set<IMember>> unitToTypes = new HashMap<ICompilationUnit, Set<IMember>>();
        int i = 0;
        while (i < targets.length) {
            Set<IMember> currTypes;
            IMember target = targets[i];
            ICompilationUnit unit = target.getCompilationUnit();
            if (unitToTypes.containsKey(unit)) {
                currTypes = (Set)unitToTypes.get(unit);
            } else {
                currTypes = new HashSet();
                unitToTypes.put(unit, currTypes);
            }
            currTypes.add(target);
            ++i;
        }
        return unitToTypes;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        RefactoringStatus status = new RefactoringStatus();
        monitor.beginTask("Checking preconditions...", 1);
        if (this.itds.isEmpty()) {
            return RefactoringStatus.createWarningStatus((String)"No Intertype declarations selected.  Nothing to do.");
        }
        try {
            for (IMember itd : this.itds) {
                status.merge(this.initialITDCheck(itd));
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private RefactoringStatus initialITDCheck(IMember itd) {
        RefactoringStatus status = new RefactoringStatus();
        if (itd == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)"Intertype declaration has not been specified"));
            return status;
        }
        if (!(itd instanceof IAspectJElement)) {
            return status;
        }
        try {
            AJProjectModelFacade model = this.getModel((IJavaElement)itd);
            if (!model.hasModel()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)"No crosscutting model available.  Rebuild project."));
            }
            ICompilationUnit unit = itd.getCompilationUnit();
            Object[] itdName = new Object[]{unit.getElementName()};
            if (!itd.exists()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("ITD ''{0}'' does not exist.", itd.getElementName())));
            } else if (!unit.isStructureKnown()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("Compilation unit ''{0}'' contains compile errors.", itdName)));
            } else {
                try {
                    if (unit.getResource().findMaxProblemSeverity("org.eclipse.core.resources.marker", true, 0) >= 2) {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("Compilation unit ''{0}'' contains compile errors.", itdName)));
                    }
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    CoreException e = coreException;
                    status.merge(RefactoringStatus.create((IStatus)e.getStatus()));
                }
            }
            IMember[] targets = this.getTargets(Collections.singletonList(itd));
            if (targets.length > 0) {
                int i = 0;
                while (i < targets.length) {
                    IMember target = targets[i];
                    if (!target.exists()) {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("Target type ''{0}'' does not exist.", target.getElementName())));
                    } else if (target.isBinary()) {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("Target type ''{0}'' is binary.", target.getElementName())));
                    } else if (!unit.isStructureKnown()) {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("Compilation unit ''{0}'' contains compile errors.", target.getCompilationUnit().getElementName())));
                    }
                    ++i;
                }
            } else {
                status.merge(RefactoringStatus.createWarningStatus((String)MessageFormat.format("ITD ''{0}'' has no target.  This refactoring will delete the declaration.  Perhaps there is an unresolved compilation error?", itd.getElementName())));
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
            JavaModelException e = javaModelException;
            status.addFatalError("JavaModelException:\n\t" + e.getMessage() + "\n\t" + e.getJavaModelStatus().getMessage());
        }
        return status;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        monitor.beginTask("Creating change...", 1);
        try {
            CompositeChange change;
            Collection<Change> changes = this.allChanges.values();
            CompositeChange compositeChange = change = new CompositeChange(this.getName(), changes.toArray(new Change[changes.size()])){

                public ChangeDescriptor getDescriptor() {
                    return new RefactoringChangeDescriptor((RefactoringDescriptor)PushInRefactoring.this.createDescriptor());
                }
            };
            return compositeChange;
        }
        finally {
            monitor.done();
        }
    }

    public PushInRefactoringDescriptor createDescriptor() {
        StringBuffer projectsb = new StringBuffer();
        StringBuffer descriptionsb = new StringBuffer();
        StringBuffer commentsb = new StringBuffer();
        StringBuffer argssb = new StringBuffer();
        for (IMember itd : this.itds) {
            projectsb.append(String.valueOf(itd.getJavaProject().getElementName()) + "\n");
            descriptionsb.append(MessageFormat.format("Push In intertype declaration for ''{0}''\n", itd.getElementName()));
            String itdLabel = this.getModel((IJavaElement)itd).getJavaElementLinkName((IJavaElement)itd);
            commentsb.append(MessageFormat.format("Push In intertype declaration for ''{0}''\n", itdLabel));
            argssb.append(String.valueOf(itd.getHandleIdentifier()) + "\n");
        }
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put(ALL_ITDS, argssb.toString());
        return new PushInRefactoringDescriptor(projectsb.toString(), descriptionsb.toString(), commentsb.toString(), arguments);
    }

    public String getName() {
        return "Push-In";
    }

    public RefactoringStatus initialize(Map<String, String> arguments) {
        String value = arguments.get(ALL_ITDS);
        if (value != null) {
            String[] values = value.split("\\n");
            ArrayList<IMember> newitds = new ArrayList<IMember>(values.length);
            int i = 0;
            while (i < values.length) {
                newitds.add((IMember)AspectJCore.create((String)value));
                ++i;
            }
            this.setITDs(newitds);
            return new RefactoringStatus();
        }
        return RefactoringStatus.createErrorStatus((String)"No ITD specified.");
    }

    public void setITDs(List<IMember> itds) {
        this.itds = itds;
    }

    public List<IMember> getITDs() {
        return this.itds;
    }

    private IMember[] getTargets(List<IMember> itds) throws JavaModelException {
        AJProjectModelFacade model = this.getModel((IJavaElement)itds.get(0));
        ArrayList<IMember> targets = new ArrayList<IMember>();
        for (IMember itd : itds) {
            AJRelationshipType relationship = itd instanceof IAspectJElement && ((IAspectJElement)itd).getAJKind().isDeclareAnnotation() ? AJRelationshipManager.ANNOTATES : AJRelationshipManager.DECLARED_ON;
            List elts = model.getRelationshipsForElement((IJavaElement)itd, relationship);
            for (IJavaElement elt : elts) {
                targets.add((IMember)elt);
            }
        }
        return targets.toArray(new IMember[targets.size()]);
    }

    private boolean isEmptyEdit(TextEdit edit) {
        return edit.getClass() == MultiTextEdit.class && !edit.hasChildren();
    }

    private boolean isCUnitContainingITD(ICompilationUnit unit, IMember itd) {
        return itd != null && itd.getCompilationUnit().equals(unit);
    }

    static {
        PushInRefactoring.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PushInRefactoring.java", PushInRefactoring.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoring", "org.eclipse.core.runtime.CoreException", "e"), 1101);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "initialITDCheck", "org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoring", "org.eclipse.jdt.core.IMember", "itd", "", "org.eclipse.ltk.core.refactoring.RefactoringStatus"), 1075);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.PushInRefactoring", "org.eclipse.jdt.core.JavaModelException", "e"), 1125);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PerUnitInformation {
        final Set<SimpleName> staticImports = new HashSet<SimpleName>();
        final Set<SimpleName> typeImports = new HashSet<SimpleName>();
        final Set<String> extraImports = new HashSet<String>();
        final ICompilationUnit unit;
        final Map<IType, Set<String>> declareParents;

        PerUnitInformation(ICompilationUnit unit) {
            this.unit = unit;
            this.declareParents = new HashMap<IType, Set<String>>();
        }

        void rewriteImports() throws CoreException {
            Change change = (Change)PushInRefactoring.this.allChanges.get(this.unit);
            if (!(change instanceof TextFileChange)) {
                return;
            }
            ImportRewrite rewrite = ImportRewrite.create((ICompilationUnit)this.unit, (boolean)true);
            for (Name name : this.typeImports) {
                ITypeBinding binding = name.resolveTypeBinding();
                if (binding == null) continue;
                rewrite.addImport(binding);
            }
            for (Name name : this.staticImports) {
                rewrite.addImport(name.resolveTypeBinding());
            }
            for (String string : this.extraImports) {
                rewrite.addImport(string);
            }
            TextEdit textEdit = rewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor());
            TextFileChange textChange = (TextFileChange)change;
            textChange.getEdit().addChild(textEdit);
        }

        void computeImports(List<IMember> itds, ICompilationUnit ajUnit, IProgressMonitor monitor) throws JavaModelException {
            IJavaProject project = ajUnit.getJavaProject();
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setProject(project);
            parser.setResolveBindings(true);
            parser.setSource(ajUnit);
            parser.setKind(8);
            CompilationUnit ajAST = (CompilationUnit)parser.createAST(monitor);
            for (IMember itd : itds) {
                DeclareElement declare;
                ISourceRange range = itd.getSourceRange();
                ImportReferencesCollector.collect((ASTNode)ajAST, (IJavaProject)project, (Region)new Region(range.getOffset(), range.getLength()), this.typeImports, this.staticImports);
                if (!(itd instanceof DeclareElement) || ((DeclareElementInfo)(declare = (DeclareElement)itd).getElementInfo()).isAnnotationRemover()) continue;
                String qualType = PushInRefactoring.this.getQualifiedTypeForDeclareAnnotation(declare);
                if (qualType != null && qualType.length() > 0) {
                    this.extraImports.add(qualType);
                }
                List<Type> types = this.getExtraImportsFromDeclareElement(declare, ajAST);
                for (Type type : types) {
                    ImportReferencesCollector.collect((ASTNode)type, (IJavaProject)project, (Region)new Region(type.getStartPosition(), type.getLength()), this.typeImports, this.staticImports);
                }
            }
        }

        private List<Type> getExtraImportsFromDeclareElement(DeclareElement itd, CompilationUnit ajAST) {
            int numTypes = ajAST.types().size();
            if (numTypes == 0) {
                return Collections.emptyList();
            }
            String details = null;
            AbstractTypeDeclaration lastType = (AbstractTypeDeclaration)ajAST.types().get(numTypes - 1);
            List bodyDecls = lastType.bodyDeclarations();
            LinkedList<Type> extraSimpleNames = new LinkedList<Type>();
            int i = bodyDecls.size() - 1;
            while (i >= 0) {
                Type type;
                VariableDeclarationFragment frag;
                FieldDeclaration fDecl;
                BodyDeclaration decl = (BodyDeclaration)bodyDecls.get(i);
                if (decl.getNodeType() != 23 || (fDecl = (FieldDeclaration)decl).fragments().size() != 1 || !(frag = (VariableDeclarationFragment)fDecl.fragments().get(0)).getName().toString().startsWith("___ITD_INSERTED_IDENTIFIER___")) break;
                if (details == null) {
                    IProgramElement ipe = PushInRefactoring.this.getModel((IJavaElement)itd).javaElementToProgramElement((IJavaElement)itd);
                    details = ipe.getDetails();
                }
                if (details.indexOf((type = fDecl.getType()).toString()) != -1) {
                    extraSimpleNames.add(type);
                }
                --i;
            }
            return extraSimpleNames;
        }

        public void addDeclarParents(IType type, List<String> parentTypes) {
            Set<String> set = this.declareParents.get(type);
            if (set == null) {
                set = new HashSet<String>();
                this.declareParents.put(type, set);
            }
            set.addAll(parentTypes);
            for (String parent : parentTypes) {
                String[] split;
                String[] stringArray = split = parent.split("<|>|,");
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    this.extraImports.add(name.trim());
                    ++n2;
                }
            }
        }
    }
}

