/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.lazystart;

import org.eclipse.ajdt.core.builder.AJBuilder;
import org.eclipse.ajdt.core.javaelements.AspectJMemberElement;
import org.eclipse.ajdt.core.lazystart.IAdviceChangedListener;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.internal.ui.lazystart.Utils;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public class AdviceImageDecorator
implements ILightweightLabelDecorator {
    private ListenerList fListeners;
    private IAdviceChangedListener fAdviceChangedListener;

    public void decorate(Object element, IDecoration decoration) {
        IJavaElement je;
        IJavaProject jp;
        if ((element instanceof IMethod || element instanceof SourceType) && (jp = (je = (IJavaElement)element).getJavaProject()) != null && Utils.isAJProject(jp.getProject()) && !(je instanceof AspectJMemberElement) && AJProjectModelFactory.getInstance().getModelForJavaElement(je).isAdvised(je)) {
            this.ensureAdviceListenerIsRegistered();
            AspectJUIPlugin.getDefault();
            decoration.addOverlay(AspectJImages.ADVICE_OVERLAY.getImageDescriptor(), 0);
        }
    }

    private void ensureAdviceListenerIsRegistered() {
        if (this.fAdviceChangedListener == null) {
            this.fAdviceChangedListener = new IAdviceChangedListener(){

                public void adviceChanged() {
                    AdviceImageDecorator.this.fireAdviceChanged();
                }
            };
            AJBuilder.addAdviceListener((IAdviceChangedListener)this.fAdviceChangedListener);
        }
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
    }

    private void fireAdviceChanged() {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }

    public void dispose() {
        if (this.fAdviceChangedListener != null) {
            AJBuilder.removeAdviceListener((IAdviceChangedListener)this.fAdviceChangedListener);
            this.fAdviceChangedListener = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
            if (this.fListeners.isEmpty() && this.fAdviceChangedListener != null) {
                AJBuilder.removeAdviceListener((IAdviceChangedListener)this.fAdviceChangedListener);
                this.fAdviceChangedListener = null;
            }
        }
    }
}

