/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.parserbridge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJWorldFacade;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.parser.TypeConverter;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ITDInserter
extends ASTVisitor {
    private final ICompilationUnit unit;
    private final LookupEnvironment env;
    private Map<TypeDeclaration, OrigContents> origMap = new HashMap<TypeDeclaration, OrigContents>();
    private final ITDTypeConverter typeConverter;
    private AJProjectModelFacade model;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public ITDInserter(ICompilationUnit unit, LookupEnvironment env, ProblemReporter reporter) {
        this.unit = unit;
        this.typeConverter = new ITDTypeConverter(reporter);
        this.model = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)unit);
        this.env = env;
    }

    public boolean visit(TypeDeclaration type, BlockScope blockScope) {
        this.augmentType(type);
        return false;
    }

    public boolean visit(TypeDeclaration type, CompilationUnitScope compilationUnitScope) {
        this.augmentType(type);
        return true;
    }

    public boolean visit(TypeDeclaration memberType, ClassScope classScope) {
        this.augmentType(memberType);
        return true;
    }

    private void augmentType(TypeDeclaration type) {
        OrigContents orig = new OrigContents();
        orig.methods = type.methods;
        orig.fields = type.fields;
        orig.superClass = type.superclass;
        orig.superInterfaces = type.superInterfaces;
        orig.memberTypes = type.memberTypes;
        try {
            LinkedList<FieldDeclaration> itdFields = new LinkedList<FieldDeclaration>();
            LinkedList<Object> itdMethods = new LinkedList<Object>();
            LinkedList<TypeDeclaration> itits = new LinkedList<TypeDeclaration>();
            IType handle = this.getHandle(type);
            List<IProgramElement> ipes = this.getITDs(handle);
            for (IProgramElement elt : ipes) {
                Map parentsMap;
                if (elt.getKind() == IProgramElement.Kind.INTER_TYPE_METHOD) {
                    if (TypeDeclaration.kind((int)type.modifiers) != 1 || elt.getAccessibility() == IProgramElement.Accessibility.PRIVATE) continue;
                    itdMethods.add(this.createMethod(elt, type, handle));
                    continue;
                }
                if (elt.getKind() == IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR) {
                    if (elt.getAccessibility() == IProgramElement.Accessibility.PRIVATE) continue;
                    itdMethods.add(this.createConstructor(elt, type));
                    continue;
                }
                if (elt.getKind() == IProgramElement.Kind.INTER_TYPE_FIELD) {
                    if (elt.getAccessibility() == IProgramElement.Accessibility.PRIVATE) continue;
                    itdFields.add(this.createField(elt, type));
                    continue;
                }
                if (elt.getKind() == IProgramElement.Kind.DECLARE_PARENTS) {
                    boolean isClass = this.isClass(elt);
                    if (isClass && TypeDeclaration.kind((int)type.modifiers) == 1) {
                        this.addSuperClass(elt, type);
                        continue;
                    }
                    this.addSuperInterfaces(elt, type);
                    continue;
                }
                if (elt.getKind() == IProgramElement.Kind.CLASS) {
                    TypeDeclaration ititAST = this.createITIT(elt.getName(), type);
                    if (ititAST == null) continue;
                    this.populateITIT(ititAST, elt);
                    itits.add(ititAST);
                    continue;
                }
                if (elt.getKind() != IProgramElement.Kind.ASPECT || (parentsMap = elt.getDeclareParentsMap()) == null || type.binding == null || type.binding.compoundName == null) continue;
                List parents = (List)parentsMap.get(String.valueOf(CharOperation.concatWith((char[][])type.binding.compoundName, (char)'.')));
                LinkedList<String> interfacesToAdd = new LinkedList<String>();
                for (String parent : parents) {
                    try {
                        IType parentElt = this.unit.getJavaProject().findType(parent, null);
                        if (parentElt != null && parentElt.isClass()) {
                            this.addSuperClass(parent, type);
                            continue;
                        }
                        if (parentElt == null || !parentElt.isInterface()) continue;
                        interfacesToAdd.add(parent);
                    }
                    catch (JavaModelException javaModelException) {
                        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    }
                }
                this.addSuperInterfaces(interfacesToAdd, type);
            }
            if (ipes.size() > 0) {
                int i;
                this.origMap.put(type, orig);
                if (itdFields.size() > 0) {
                    int numFields = type.fields == null ? 0 : type.fields.length;
                    FieldDeclaration[] fields = new FieldDeclaration[numFields + itdFields.size()];
                    if (numFields > 0) {
                        System.arraycopy(type.fields, 0, fields, 0, numFields);
                    }
                    i = 0;
                    while (i < itdFields.size()) {
                        fields[i + numFields] = (FieldDeclaration)itdFields.get(i);
                        ++i;
                    }
                    type.fields = fields;
                }
                if (itdMethods.size() > 0) {
                    int numMethods = type.methods == null ? 0 : type.methods.length;
                    AbstractMethodDeclaration[] methods = new AbstractMethodDeclaration[numMethods + itdMethods.size()];
                    if (numMethods > 0) {
                        System.arraycopy(type.methods, 0, methods, 0, numMethods);
                    }
                    i = 0;
                    while (i < itdMethods.size()) {
                        methods[i + numMethods] = (AbstractMethodDeclaration)itdMethods.get(i);
                        ++i;
                    }
                    type.methods = methods;
                }
                if (itits.size() > 0) {
                    int numInners = type.memberTypes == null ? 0 : type.memberTypes.length;
                    TypeDeclaration[] inners = new TypeDeclaration[numInners + itits.size()];
                    if (numInners > 0) {
                        System.arraycopy(type.memberTypes, 0, inners, 0, numInners);
                    }
                    i = 0;
                    while (i < itits.size()) {
                        inners[i + numInners] = (TypeDeclaration)itits.get(i);
                        ++i;
                    }
                    type.memberTypes = inners;
                }
            }
        }
        catch (Exception exception) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
            this.origMap.remove(type);
            this.revertType(type, orig);
        }
    }

    private void populateITIT(TypeDeclaration ititAST, IProgramElement elt) {
        LinkedList<FieldDeclaration> fields = new LinkedList<FieldDeclaration>();
        LinkedList<FieldBinding> fieldBindings = new LinkedList<FieldBinding>();
        LinkedList<MethodDeclaration> methods = new LinkedList<MethodDeclaration>();
        LinkedList<MethodBinding> methodBindings = new LinkedList<MethodBinding>();
        for (IProgramElement child : elt.getChildren()) {
            if (child.getKind() == IProgramElement.Kind.FIELD) {
                FieldDeclaration field = this.createField(child, ititAST);
                fields.add(field);
                fieldBindings.add(new FieldBinding(field, this.getReturnTypeBinding(child.getCorrespondingTypeSignature().toCharArray(), (TypeBinding)ititAST.binding), field.modifiers, (ReferenceBinding)ititAST.binding));
                continue;
            }
            if (child.getKind() != IProgramElement.Kind.METHOD) continue;
            MethodDeclaration method = this.createMethod(child, ititAST, null);
            methods.add(method);
            methodBindings.add(new MethodBinding(method.modifiers, method.selector, this.getReturnTypeBinding(child.getCorrespondingTypeSignature().toCharArray(), (TypeBinding)ititAST.binding), this.getParameterBindings(elt, (ReferenceBinding)ititAST.binding), new ReferenceBinding[0], (ReferenceBinding)ititAST.binding));
        }
        ititAST.fields = fields.toArray(new FieldDeclaration[0]);
        ititAST.methods = (AbstractMethodDeclaration[])methods.toArray(new MethodDeclaration[0]);
        ititAST.binding.setFields(fieldBindings.toArray(new FieldBinding[0]));
    }

    private TypeBinding[] getParameterBindings(IProgramElement elt, ReferenceBinding ititBinding) {
        List paramTypes = elt.getParameterSignatures();
        if (paramTypes == null) {
            return new TypeBinding[0];
        }
        TypeBinding[] paramBindings = new TypeBinding[paramTypes.size()];
        int i = 0;
        for (char[] paramType : paramTypes) {
            paramBindings[i++] = this.getReturnTypeBinding(paramType, (TypeBinding)ititBinding);
        }
        return paramBindings;
    }

    private boolean isClass(IProgramElement elt) throws JavaModelException {
        List parentTypes = elt.getParentTypes();
        if (parentTypes != null && parentTypes.size() > 0) {
            for (String parentTypeName : parentTypes) {
                IType parentType;
                int genericsIndex = parentTypeName.indexOf("<");
                if (genericsIndex > 0) {
                    parentTypeName = parentTypeName.substring(0, genericsIndex);
                }
                if ((parentType = this.unit.getJavaProject().findType(parentTypeName, null)) == null) continue;
                return parentType.isClass();
            }
        }
        return false;
    }

    protected TypeBinding getReturnTypeBinding(char[] typeName, TypeBinding ititBinding) {
        TypeBinding typeBinding = this.env.getTypeFromTypeSignature(new SignatureWrapper(typeName), new TypeVariableBinding[0], (ReferenceBinding)ititBinding, (char[][][])new char[0][][]);
        typeBinding = BinaryTypeBinding.resolveType((TypeBinding)typeBinding, (LookupEnvironment)this.env, (boolean)false);
        return typeBinding;
    }

    private TypeDeclaration createITIT(String name, TypeDeclaration enclosing) {
        TypeDeclaration decl = new TypeDeclaration(enclosing.compilationResult);
        decl.enclosingType = enclosing;
        decl.name = name.toCharArray();
        ClassScope innerClassScope = new ClassScope((Scope)enclosing.scope, decl);
        decl.binding = new MemberTypeBinding((char[][])new char[][]{enclosing.name, name.toCharArray()}, innerClassScope, enclosing.binding);
        decl.staticInitializerScope = enclosing.staticInitializerScope;
        decl.initializerScope = enclosing.initializerScope;
        decl.scope = innerClassScope;
        decl.binding.superInterfaces = new ReferenceBinding[0];
        decl.binding.typeVariables = new TypeVariableBinding[0];
        decl.binding.memberTypes = new ReferenceBinding[0];
        decl.binding.modifiers = decl.modifiers = 9;
        ReferenceBinding[] newBindings = new ReferenceBinding[enclosing.binding.memberTypes.length + 1];
        System.arraycopy(enclosing.binding.memberTypes, 0, newBindings, 0, enclosing.binding.memberTypes.length);
        newBindings[enclosing.binding.memberTypes.length] = decl.binding;
        enclosing.binding.memberTypes = newBindings;
        return decl;
    }

    private FieldDeclaration createField(IProgramElement field, TypeDeclaration type) {
        FieldDeclaration decl = new FieldDeclaration();
        String[] split = field.getName().split("\\.");
        decl.name = split[split.length - 1].toCharArray();
        decl.type = this.createTypeReference(field.getCorrespondingType(true));
        decl.modifiers = field.getRawModifiers();
        return decl;
    }

    /*
     * Unable to fully structure code
     */
    private MethodDeclaration createMethod(IProgramElement method, TypeDeclaration type, IType handle) {
        block10: {
            block11: {
                decl = new MethodDeclaration(type.compilationResult);
                decl.scope = new MethodScope(type.scope, (ReferenceContext)decl, true);
                split = method.getName().split("\\.");
                decl.selector = split[split.length - 1].toCharArray();
                decl.modifiers = method.getRawModifiers();
                decl.returnType = this.createTypeReference(method.getCorrespondingType(true));
                decl.modifiers = method.getRawModifiers();
                args = method.getParameterTypes() != null ? new Argument[method.getParameterTypes().size()] : new Argument[]{};
                try {
                    sig = null;
                    if (handle != null) {
                        world = new AJWorldFacade(handle.getJavaProject().getProject());
                        sig = world.getMethodTypeSignatures(org.eclipse.jdt.core.Signature.createTypeSignature((String)handle.getFullyQualifiedName(), (boolean)true), method);
                    }
                    if (sig == null) {
                        params = new String[method.getParameterTypes().size()];
                        i = 0;
                        while (i < params.length) {
                            params[i] = new String(org.eclipse.jdt.core.Signature.getTypeErasure((char[])((char[])method.getParameterTypes().get(i))));
                            ++i;
                        }
                        sig = new AJWorldFacade.ErasedTypeSignature(method.getCorrespondingTypeSignature(), params);
                    }
                    if ((pNames = method.getParameterNames()) == null || pNames.size() != args.length) {
                        pNames = new ArrayList<String>(args.length);
                        i = 0;
                        while (i < args.length) {
                            pNames.add("args" + i);
                            ++i;
                        }
                    }
                    i = 0;
                    while (i < args.length) {
                        args[i] = new Argument(((String)pNames.get(i)).toCharArray(), 0L, this.createTypeReference(org.eclipse.jdt.core.Signature.getElementType((String)sig.paramTypes[i])), 0);
                        ++i;
                    }
                    decl.returnType = this.createTypeReferenceFromSignature(sig.returnTypeSig);
                    decl.typeParameters = this.createTypeParameters(sig.typeParameters);
                    break block10;
                }
                catch (Exception var10_12) {
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(var10_12, (Object)this, ITDInserter.ajc$tjp_3, (JoinPoint.StaticPart)ITDInserter.ajc$tjp_4);
                    AJLog.log("Exception occurred in ITDInserter.createMethod().  (Ignoring)");
                    AJLog.log("Relevant method: " + method.getParent().getName() + "." + method.getName());
                    pNames = method.getParameterNames();
                    if (pNames != null && pNames.size() == args.length) break block11;
                    pNames = new ArrayList<String>(args.length);
                    i = 0;
                    ** while (i < args.length)
                }
lbl-1000:
                // 1 sources

                {
                    pNames.add("args" + i);
                    ++i;
                    continue;
                }
            }
            i = 0;
            while (i < args.length) {
                args[i] = new Argument(((String)pNames.get(i)).toCharArray(), 0L, this.createTypeReference(new String((char[])method.getParameterTypes().get(i))), 0);
                ++i;
            }
        }
        decl.arguments = args;
        return decl;
    }

    private TypeParameter[] createTypeParameters(AJWorldFacade.TypeParameter[] typeParameters) {
        if (typeParameters == null || typeParameters.length == 0) {
            return null;
        }
        TypeParameter[] newTypeParameters = new TypeParameter[typeParameters.length];
        int i = 0;
        while (i < typeParameters.length) {
            newTypeParameters[i] = new TypeParameter();
            newTypeParameters[i].name = typeParameters[i].name.toCharArray();
            if (typeParameters[i].upperBoundTypeName != null) {
                newTypeParameters[i].bounds = new TypeReference[1];
                newTypeParameters[i].bounds[0] = this.createTypeReference(typeParameters[i].upperBoundTypeName);
            }
            ++i;
        }
        return newTypeParameters;
    }

    private ConstructorDeclaration createConstructor(IProgramElement constructor, TypeDeclaration type) {
        int i;
        ConstructorDeclaration decl = new ConstructorDeclaration(type.compilationResult);
        decl.scope = new MethodScope(type.scope, (ReferenceContext)decl, true);
        decl.selector = constructor.getName().split("\\.")[1].toCharArray();
        decl.modifiers = constructor.getRawModifiers();
        Argument[] args = constructor.getParameterTypes() != null ? new Argument[constructor.getParameterTypes().size()] : new Argument[]{};
        ArrayList<String> pNames = constructor.getParameterNames();
        if (pNames == null || pNames.size() != args.length) {
            pNames = new ArrayList<String>(args.length);
            i = 0;
            while (i < args.length) {
                pNames.add("args" + i);
                ++i;
            }
        }
        i = 0;
        while (i < args.length) {
            args[i] = new Argument(((String)pNames.get(i)).toCharArray(), 0L, this.createTypeReference(new String((char[])constructor.getParameterTypes().get(i))), 0);
            ++i;
        }
        decl.arguments = args;
        return decl;
    }

    private void addSuperClass(IProgramElement ipe, TypeDeclaration decl) {
        List types = ipe.getParentTypes();
        if (types == null || types.size() < 1) {
            return;
        }
        String typeName = (String)types.get(0);
        this.addSuperClass(typeName, decl);
    }

    private void addSuperClass(String newSuper, TypeDeclaration decl) {
        decl.superclass = this.createTypeReference(newSuper);
        if (decl.binding != null) {
            decl.binding.superclass = this.createTypeBinding(newSuper);
        }
    }

    private ReferenceBinding createTypeBinding(String newSuper) {
        int genericsIndex = newSuper.indexOf("<");
        if (genericsIndex > 0) {
            newSuper = newSuper.substring(0, genericsIndex);
        }
        newSuper = newSuper.replace('$', '.');
        return this.env.askForType(CharOperation.splitOn((char)'.', (char[])newSuper.toCharArray()));
    }

    private void addSuperInterfaces(IProgramElement ipe, TypeDeclaration decl) {
        List newInterfaces = ipe.getParentTypes();
        if (newInterfaces != null) {
            ArrayList<String> copy = new ArrayList<String>(newInterfaces.size());
            for (String newInterface : newInterfaces) {
                copy.add(newInterface.replace('$', '.'));
            }
            this.addSuperInterfaces(newInterfaces, decl);
        }
    }

    private void addSuperInterfaces(List<String> newInterfaces, TypeDeclaration decl) {
        if (newInterfaces != null) {
            int superInterfacesNum = decl.superInterfaces == null ? 0 : decl.superInterfaces.length;
            ArrayList<TypeReference> newReferences = new ArrayList<TypeReference>(newInterfaces.size());
            Iterator<String> iterator = newInterfaces.iterator();
            while (iterator.hasNext()) {
                String newInterface = iterator.next();
                TypeReference reference = this.createTypeReference(newInterface);
                boolean matchFound = false;
                int i = 0;
                while (i < superInterfacesNum) {
                    if (CharOperation.equals((char[][])decl.superInterfaces[i].getTypeName(), (char[][])reference.getTypeName())) {
                        iterator.remove();
                        matchFound = true;
                        break;
                    }
                    ++i;
                }
                if (matchFound) continue;
                newReferences.add(reference);
            }
            TypeReference[] refs = new TypeReference[superInterfacesNum + newReferences.size()];
            if (superInterfacesNum > 0) {
                System.arraycopy(decl.superInterfaces, 0, refs, 0, decl.superInterfaces.length);
            }
            int i = 0;
            while (i < refs.length - superInterfacesNum) {
                refs[i + superInterfacesNum] = (TypeReference)newReferences.get(i);
                ++i;
            }
            decl.superInterfaces = refs;
            superInterfacesNum = decl.binding != null && decl.binding.superInterfaces != null ? decl.binding.superInterfaces.length : 0;
            ReferenceBinding[] refBindings = new ReferenceBinding[superInterfacesNum + newInterfaces.size()];
            if (superInterfacesNum > 0) {
                System.arraycopy(decl.binding.superInterfaces, 0, refBindings, 0, decl.binding.superInterfaces.length);
            }
            int i2 = 0;
            while (i2 < refBindings.length - superInterfacesNum) {
                refBindings[i2 + superInterfacesNum] = this.createTypeBinding(newInterfaces.get(i2));
                ++i2;
            }
            if (decl.binding != null) {
                decl.binding.superInterfaces = refBindings;
            }
        }
    }

    private IType getHandle(TypeDeclaration decl) {
        String typeName = new String(decl.name);
        try {
            IJavaElement maybeType = this.unit.getElementAt(decl.sourceStart);
            if (maybeType != null && maybeType.getElementType() == 7) {
                return (IType)maybeType;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_6);
        }
        try {
            IType type = this.getHandleFromChild(typeName, (IParent)this.unit);
            if (type != null) {
                return type;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_7, (JoinPoint.StaticPart)ajc$tjp_6);
        }
        return this.unit.getType(typeName);
    }

    private IType getHandleFromChild(String typeName, IParent parent) throws JavaModelException {
        IJavaElement[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getElementType() == 7 && typeName.equals(children[i].getElementName())) {
                return (IType)children[i];
            }
            ++i;
        }
        i = 0;
        while (i < children.length) {
            IType type;
            if ((children[i].getElementType() == 7 || children[i].getElementType() == 9) && (type = this.getHandleFromChild(typeName, (IParent)children[i])) != null) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private List<IProgramElement> getITDs(IType handle) {
        if (this.model.hasModel() && this.model.hasProgramElement((IJavaElement)handle)) {
            List<IJavaElement> rels = this.model.getRelationshipsForElement((IJavaElement)handle, AJRelationshipManager.ASPECT_DECLARATIONS);
            ArrayList<IProgramElement> elts = new ArrayList<IProgramElement>();
            for (IJavaElement je : rels) {
                IProgramElement declareElt = this.model.javaElementToProgramElement(je);
                elts.add(declareElt);
            }
            return elts;
        }
        return Collections.emptyList();
    }

    private TypeReference createTypeReferenceFromSignature(String origTypeSig) {
        return this.typeConverter.createTypeReference(origTypeSig);
    }

    private TypeReference createTypeReference(String origTypeName) {
        if (origTypeName.endsWith("#RAW")) {
            origTypeName = origTypeName.substring(0, origTypeName.length() - 4);
        }
        origTypeName = origTypeName.replace('$', '.');
        return this.typeConverter.createTypeReference(origTypeName.toCharArray());
    }

    public void revert() {
        for (Map.Entry<TypeDeclaration, OrigContents> entry : this.origMap.entrySet()) {
            this.revertType(entry.getKey(), entry.getValue());
        }
    }

    private void revertType(TypeDeclaration type, OrigContents orig) {
        type.methods = orig.methods;
        type.fields = orig.fields;
        type.superclass = orig.superClass;
        type.superInterfaces = orig.superInterfaces;
        type.memberTypes = orig.memberTypes;
    }

    static {
        ITDInserter.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ITDInserter.java", ITDInserter.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.parserbridge.ITDInserter", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 206);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "augmentType", "org.eclipse.ajdt.core.parserbridge.ITDInserter", "org.eclipse.jdt.internal.compiler.ast.TypeDeclaration", "type", "", "void"), 139);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.parserbridge.ITDInserter", "java.lang.Exception", "<missing>"), 251);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.parserbridge.ITDInserter", "java.lang.Exception", "<missing>"), 417);
        ajc$tjp_4 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "createMethod", "org.eclipse.ajdt.core.parserbridge.ITDInserter", "org.aspectj.asm.IProgramElement:org.eclipse.jdt.internal.compiler.ast.TypeDeclaration:org.eclipse.jdt.core.IType", "method:type:handle", "", "org.eclipse.jdt.internal.compiler.ast.MethodDeclaration"), 370);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.parserbridge.ITDInserter", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 593);
        ajc$tjp_6 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getHandle", "org.eclipse.ajdt.core.parserbridge.ITDInserter", "org.eclipse.jdt.internal.compiler.ast.TypeDeclaration", "decl", "", "org.eclipse.jdt.core.IType"), 586);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.parserbridge.ITDInserter", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 601);
    }

    private static class ITDTypeConverter
    extends TypeConverter {
        public ITDTypeConverter(ProblemReporter reporter) {
            super(reporter, '.');
        }

        protected TypeReference createTypeReference(char[] typeName) {
            return super.createTypeReference(typeName, 0, typeName.length);
        }

        protected TypeReference createTypeReference(String typeSignature) {
            return super.createTypeReference(typeSignature.replace('/', '.'), 0, typeSignature.length());
        }
    }

    private static class OrigContents {
        AbstractMethodDeclaration[] methods;
        FieldDeclaration[] fields;
        TypeReference superClass;
        TypeReference[] superInterfaces;
        TypeDeclaration[] memberTypes;

        private OrigContents() {
        }
    }
}

