/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.refactoring;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.ajdt.internal.core.refactoring.CollectingSearchRequestor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.search.JavaSearchScope;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ITDAccessorRenameParticipant
extends RenameParticipant {
    private IField field;
    private AJCompilationUnit aspectDeclaringGetter;
    private AJCompilationUnit aspectDeclaringSetter;
    private boolean useIsForBooleanGetter = false;
    private boolean disableITDUpdatingForRoo;
    private Field fRenameGetterField;
    private Field fRenameSetterField;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_7;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public String getName() {
        return "Rename occurrences of intertype getters and setters";
    }

    protected boolean initialize(Object element) {
        if (element instanceof IField) {
            this.field = (IField)element;
            if (AspectJPlugin.isAJProject(this.field.getJavaProject().getProject())) {
                this.disableITDUpdatingForRoo = this.shouldDisableITDUpdatingForRoo();
                return true;
            }
        }
        return false;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        boolean shouldRenameGetter = this.shouldRename(true);
        boolean shouldRenameSetter = this.shouldRename(false);
        boolean shouldRenamePrivateField = this.shouldRenamePrivateField();
        if (!(shouldRenameGetter || shouldRenameSetter || shouldRenamePrivateField)) {
            return null;
        }
        IType declaring = this.field.getDeclaringType();
        AJProjectModelFacade model = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)declaring);
        if (model.hasModel()) {
            List<IJavaElement> itds = model.getRelationshipsForElement((IJavaElement)declaring, AJRelationshipManager.ASPECT_DECLARATIONS);
            IntertypeElement getter = null;
            IntertypeElement setter = null;
            for (IJavaElement elt : itds) {
                if (shouldRenameGetter && this.isGetter(elt)) {
                    getter = (IntertypeElement)elt;
                    this.aspectDeclaringGetter = (AJCompilationUnit)getter.getCompilationUnit();
                    continue;
                }
                if (!shouldRenameSetter || !this.isSetter(elt)) continue;
                setter = (IntertypeElement)elt;
                this.aspectDeclaringSetter = (AJCompilationUnit)setter.getCompilationUnit();
            }
            if (getter == null && setter == null) {
                return null;
            }
            List<Object> getterReferences = getter != null ? this.findReferences(getter) : Collections.emptyList();
            List<Object> setterReferences = setter != null ? this.findReferences(setter) : Collections.emptyList();
            List<Object> privateFieldReferences = shouldRenamePrivateField ? this.findPrivateAspectReferences() : Collections.emptyList();
            CompositeChange change = new CompositeChange(this.getName());
            this.createDeclarationChange(getter, change, this.getOldGetterName(this.useIsForBooleanGetter), this.getNewGetterName(this.useIsForBooleanGetter));
            this.createDeclarationChange(setter, change, this.getOldSetterName(), this.getNewSetterName());
            this.createMatchedChanges(privateFieldReferences, change, this.field.getElementName(), this.getArguments().getNewName());
            this.createMatchedChanges(getterReferences, change, this.getOldGetterName(this.useIsForBooleanGetter), this.getNewGetterName(this.useIsForBooleanGetter));
            this.createMatchedChanges(setterReferences, change, this.getOldSetterName(), this.getNewSetterName());
            if (change.getChildren().length > 0) {
                return change;
            }
        }
        return null;
    }

    private List<SearchMatch> findPrivateAspectReferences() {
        List<SearchMatch> maybeMatches = this.findReferences((IMember)this.field);
        Iterator<SearchMatch> matchIter = maybeMatches.iterator();
        while (matchIter.hasNext()) {
            IMember member;
            SearchMatch maybeMatch = matchIter.next();
            if (!(maybeMatch.getElement() instanceof IMember) || (member = (IMember)maybeMatch.getElement()).getAncestor(7) instanceof AspectElement) continue;
            matchIter.remove();
        }
        return maybeMatches;
    }

    private void createMatchedChanges(List<SearchMatch> references, CompositeChange finalChange, String oldName, String newName) {
        for (SearchMatch searchMatch : references) {
            Object elt = searchMatch.getElement();
            if (!(elt instanceof IMember)) continue;
            this.addChange(finalChange, (IMember)elt, searchMatch.getOffset(), oldName.length(), newName);
        }
    }

    private void createDeclarationChange(IntertypeElement accessor, CompositeChange finalChange, String oldName, String newName) throws JavaModelException {
        if (accessor == null) {
            return;
        }
        ISourceRange region = accessor.getNameRange();
        this.addChange(finalChange, accessor, region.getOffset() + region.getLength() - oldName.length(), oldName.length(), newName);
    }

    private void addChange(CompositeChange finalChange, IMember enclosingElement, int offset, int length, String newName) {
        ICompilationUnit unit = enclosingElement.getCompilationUnit();
        if (this.disableITDUpdatingForRoo && unit != null && (unit.equals(this.aspectDeclaringGetter) || unit.equals(this.aspectDeclaringSetter))) {
            return;
        }
        CompilationUnitChange existingChange = this.findOrCreateChange(enclosingElement, finalChange);
        TextEditChangeGroup[] groups = existingChange.getTextEditChangeGroups();
        ReplaceEdit occurrenceEdit = new ReplaceEdit(offset, length, newName);
        boolean isOverlapping = false;
        TextEditChangeGroup[] textEditChangeGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            TextEditChangeGroup group = textEditChangeGroupArray[n2];
            if (group.getTextEdits()[0].covers((TextEdit)occurrenceEdit)) {
                isOverlapping = true;
                break;
            }
            ++n2;
        }
        if (isOverlapping) {
            return;
        }
        existingChange.addEdit((TextEdit)occurrenceEdit);
        existingChange.addChangeGroup((TextEditBasedChangeGroup)new TextEditChangeGroup((TextChange)existingChange, new TextEditGroup("Update ITD accessor occurrence", (TextEdit)occurrenceEdit)));
    }

    private CompilationUnitChange findOrCreateChange(IMember accessor, CompositeChange finalChange) {
        TextChange textChange = this.getTextChange(accessor.getCompilationUnit());
        CompilationUnitChange existingChange = null;
        if (textChange instanceof CompilationUnitChange) {
            existingChange = (CompilationUnitChange)textChange;
        } else {
            Change[] children;
            Change[] changeArray = children = finalChange.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Change change = changeArray[n2];
                if (change instanceof CompilationUnitChange && ((CompilationUnitChange)change).getCompilationUnit().equals(accessor.getCompilationUnit())) {
                    existingChange = (CompilationUnitChange)change;
                    break;
                }
                ++n2;
            }
        }
        if (existingChange == null) {
            existingChange = new CompilationUnitChange("ITD accessor renamings for " + accessor.getCompilationUnit().getElementName(), accessor.getCompilationUnit());
            existingChange.setEdit((TextEdit)new MultiTextEdit());
            finalChange.add((Change)existingChange);
        }
        return existingChange;
    }

    private List<SearchMatch> findReferences(IMember accessor) {
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)accessor, (int)2);
        SearchEngine engine = new SearchEngine();
        JavaSearchScope scope = new JavaSearchScope();
        try {
            scope.add((IJavaElement)accessor.getJavaProject());
            CollectingSearchRequestor requestor = new CollectingSearchRequestor();
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, (IJavaSearchScope)scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
            return requestor.getResults();
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        return Collections.emptyList();
    }

    private boolean isSetter(IJavaElement elt) throws JavaModelException {
        if (elt instanceof IntertypeElement && elt.getElementName().endsWith("." + this.getOldSetterName())) {
            IntertypeElement itd = (IntertypeElement)elt;
            String[] parameterTypes = itd.getParameterTypes();
            if (itd.getAJKind() == IProgramElement.Kind.INTER_TYPE_METHOD && parameterTypes != null && parameterTypes.length == 1 && parameterTypes[0].equals(this.field.getTypeSignature()) && itd.getReturnType().equals("V")) {
                return true;
            }
        }
        return false;
    }

    private boolean isGetter(IJavaElement elt) throws JavaModelException {
        boolean nameMatch = false;
        boolean isFound = false;
        if (elt instanceof IntertypeElement && elt.getElementName().endsWith("." + this.getOldGetterName(false))) {
            nameMatch = true;
        } else if (elt instanceof IntertypeElement && elt.getElementName().endsWith("." + this.getOldGetterName(true))) {
            nameMatch = true;
        }
        if (nameMatch) {
            this.useIsForBooleanGetter = isFound;
            IntertypeElement itd = (IntertypeElement)elt;
            String[] parameterTypes = itd.getParameterTypes();
            if (itd.getAJKind() == IProgramElement.Kind.INTER_TYPE_METHOD && (parameterTypes == null || parameterTypes.length == 0) && itd.getReturnType().equals(this.field.getTypeSignature())) {
                return true;
            }
        }
        return false;
    }

    private String getNewSetterName() {
        return this.accessorName("set", this.getArguments().getNewName());
    }

    private String getNewGetterName(boolean useIsForBoolean) {
        return this.accessorName("get", this.getArguments().getNewName());
    }

    private String getOldSetterName() {
        return this.accessorName("set", this.field.getElementName());
    }

    private String getOldGetterName(boolean useIsForBoolean) {
        return this.accessorName(useIsForBoolean ? "is" : "get", this.field.getElementName());
    }

    private String accessorName(String prefix, String name) {
        return String.valueOf(prefix) + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private boolean shouldRenamePrivateField() throws JavaModelException {
        return Flags.isPrivate((int)this.field.getFlags());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean shouldRename(boolean getter) {
        Exception exception2;
        block8: {
            RefactoringProcessor processor;
            try {
                processor = this.getProcessor();
                if (!processor.getClass().getCanonicalName().equals("org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor")) {
                    return false;
                }
            }
            catch (Exception exception2) {
                // empty catch block
                break block8;
            }
            try {
                Field thisField;
                if (getter) {
                    if (this.fRenameGetterField == null) {
                        this.fRenameGetterField = processor.getClass().getDeclaredField("fRenameGetter");
                        this.fRenameGetterField.setAccessible(true);
                    }
                    thisField = this.fRenameGetterField;
                    return thisField.getBoolean(processor);
                }
                if (this.fRenameSetterField == null) {
                    this.fRenameSetterField = processor.getClass().getDeclaredField("fRenameSetter");
                    this.fRenameSetterField.setAccessible(true);
                }
                thisField = this.fRenameSetterField;
                return thisField.getBoolean(processor);
            }
            catch (Exception exception3) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception3, (Object)this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_4);
                Exception exception4 = exception3;
            }
        }
        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception2, (Object)this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_4);
        return false;
    }

    private boolean shouldDisableITDUpdatingForRoo() {
        try {
            return this.field.getJavaProject().getProject().hasNature("com.springsource.sts.roo.core.nature") && (Platform.getBundle((String)"com.springsource.sts.roo.core") != null || Platform.getBundle((String)"rg.springframework.ide.eclipse.roo.core") != null);
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
            return false;
        }
    }

    static {
        ITDAccessorRenameParticipant.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ITDAccessorRenameParticipant.java", ITDAccessorRenameParticipant.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.refactoring.ITDAccessorRenameParticipant", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 280);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "findReferences", "org.eclipse.ajdt.internal.core.refactoring.ITDAccessorRenameParticipant", "org.eclipse.jdt.core.IMember", "accessor", "", "java.util.List"), 270);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.refactoring.ITDAccessorRenameParticipant", "org.eclipse.core.runtime.CoreException", "<missing>"), 281);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.refactoring.ITDAccessorRenameParticipant", "java.lang.Exception", "<missing>"), 380);
        ajc$tjp_4 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "shouldRename", "org.eclipse.ajdt.internal.core.refactoring.ITDAccessorRenameParticipant", "boolean", "getter", "", "boolean"), 359);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.refactoring.ITDAccessorRenameParticipant", "java.lang.Exception", "<missing>"), 380);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.refactoring.ITDAccessorRenameParticipant", "org.eclipse.core.runtime.CoreException", "<missing>"), 396);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "shouldDisableITDUpdatingForRoo", "org.eclipse.ajdt.internal.core.refactoring.ITDAccessorRenameParticipant", "", "", "", "boolean"), 389);
    }
}

