/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.ClasspathAttributeConfiguration;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;

public class InpathRestrictionAttributeConfiguration
extends ClasspathAttributeConfiguration {
    public boolean canEdit(ClasspathAttributeConfiguration.ClasspathAttributeAccess attribute) {
        return true;
    }

    public boolean canRemove(ClasspathAttributeConfiguration.ClasspathAttributeAccess attribute) {
        return attribute.getClasspathAttribute().getValue().length() > 0;
    }

    public ImageDescriptor getImageDescriptor(ClasspathAttributeConfiguration.ClasspathAttributeAccess attribute) {
        return AspectJImages.JAR_ON_INPATH.getImageDescriptor();
    }

    public String getNameLabel(ClasspathAttributeConfiguration.ClasspathAttributeAccess attribute) {
        return "Only the following elements are included on Inpath";
    }

    public String getValueLabel(ClasspathAttributeConfiguration.ClasspathAttributeAccess attribute) {
        if (attribute.getClasspathAttribute().getValue().equals("")) {
            return "<no restrictions>";
        }
        return attribute.getClasspathAttribute().getValue();
    }

    public IClasspathAttribute performEdit(Shell shell, ClasspathAttributeConfiguration.ClasspathAttributeAccess attribute) {
        String oldValue = attribute.getClasspathAttribute().getValue();
        InputDialog d = new InputDialog(shell, "Add a restriction to the classpath container", "Enter a comma separated list to specify a subset of this classpath container's\nelements to be on the inpath.\n\nEnter a fragment of the desired name to include.  Example, if the classpath\ncontainer includes:\njar1.jar\notherjar1.jar\notherjar2.jar\n\nand you enter: \"otherjar\", the result will be to include otherjar1.jar and\notherjar2.jar on the inpath, and to exclude jar1.jar.", oldValue, null);
        int res = d.open();
        if (res == 0) {
            return JavaCore.newClasspathAttribute((String)attribute.getClasspathAttribute().getName(), (String)d.getValue());
        }
        return attribute.getClasspathAttribute();
    }

    public IClasspathAttribute performRemove(ClasspathAttributeConfiguration.ClasspathAttributeAccess attribute) {
        return JavaCore.newClasspathAttribute((String)attribute.getClasspathAttribute().getName(), (String)"");
    }
}

