/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.visualiser;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.BuildConfig;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.visualiser.AJDTMarkupProvider;
import org.eclipse.contribution.jdt.IsWovenTester;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.jdtImpl.JDTContentProvider;
import org.eclipse.contribution.visualiser.jdtImpl.JDTGroup;
import org.eclipse.contribution.visualiser.jdtImpl.JDTMember;
import org.eclipse.contribution.visualiser.simpleImpl.SimpleMember;
import org.eclipse.contribution.visualiser.utils.JDTUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AJDTContentProvider
extends JDTContentProvider {
    List<IGroup> currentGroups;
    List<IMember> currentMembers;
    private Set<IFile> includedFiles;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IGroup> getAllGroups() {
        AJDTContentProvider aJDTContentProvider = this;
        synchronized (aJDTContentProvider) {
            if (this.currentGroups == null) {
                this.updateData();
            }
        }
        return this.currentGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMember> getAllMembers() {
        AJDTContentProvider aJDTContentProvider = this;
        synchronized (aJDTContentProvider) {
            if (this.currentMembers == null) {
                this.updateData();
            }
        }
        return this.currentMembers;
    }

    public void selectionChanged(IWorkbenchPart workbenchPart, ISelection selection) {
        IStructuredSelection structuredSelection;
        Object firstElement;
        if (!ProviderManager.getContentProvider().equals((Object)this)) {
            return;
        }
        boolean updateRequired = false;
        if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null && firstElement instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)firstElement;
            if (this.currentlySelectedJE == javaElement) {
                return;
            }
            this.currentlySelectedJE = javaElement;
            updateRequired = true;
            if (javaElement.getJavaProject() != null) {
                this.setCurrentProject(javaElement.getJavaProject());
            }
        }
        if (updateRequired) {
            this.reset();
            VisualiserPlugin.refresh();
        }
    }

    private void updateData() {
        if (ProviderManager.getMarkupProvider() instanceof AJDTMarkupProvider) {
            ((AJDTMarkupProvider)ProviderManager.getMarkupProvider()).resetMarkupsAndKinds();
        }
        long stime = System.currentTimeMillis();
        ArrayList<IGroup> newGroups = new ArrayList<IGroup>();
        ArrayList<IMember> newMembers = new ArrayList<IMember>();
        if (this.currentProject != null) {
            try {
                if (this.currentlySelectedJE.getElementType() == 2) {
                    IPackageFragment[] packageFragments = ((IJavaProject)this.currentlySelectedJE).getPackageFragments();
                    int i = 0;
                    while (i < packageFragments.length) {
                        if (!packageFragments[i].isReadOnly()) {
                            this.addMembersAndGroups(newGroups, newMembers, packageFragments[i]);
                        }
                        ++i;
                    }
                } else if (this.currentlySelectedJE.getElementType() == 4) {
                    IPackageFragment packageFragment = (IPackageFragment)this.currentlySelectedJE;
                    this.addMembersAndGroups(newGroups, newMembers, packageFragment);
                } else if (this.currentlySelectedJE.getElementType() == 5) {
                    JDTMember member = null;
                    if (this.getIncludedFiles(this.currentProject.getProject()).contains(this.currentlySelectedJE.getResource())) {
                        String memberName = this.currentlySelectedJE.getElementName();
                        if (memberName.endsWith(".java")) {
                            memberName = memberName.substring(0, memberName.length() - 5);
                        } else if (memberName.endsWith(".aj")) {
                            memberName = memberName.substring(0, memberName.length() - 3);
                        }
                        member = new JDTMember(memberName, this.currentlySelectedJE);
                        member.setSize(this.getLength((ICompilationUnit)this.currentlySelectedJE));
                        newMembers.add((IMember)member);
                    }
                    if (member != null) {
                        IPackageFragment packageFrag = (IPackageFragment)((ICompilationUnit)this.currentlySelectedJE).getParent();
                        boolean defaultPackage = packageFrag.isDefaultPackage();
                        JDTGroup group = new JDTGroup(packageFrag.getElementName());
                        if (defaultPackage) {
                            group.setName("(default package)");
                            group.setTooltip("(default package)");
                        }
                        if (defaultPackage) {
                            member.setFullName(member.getName());
                        }
                        group.add((IMember)member);
                        newGroups.add((IGroup)group);
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            }
            long etime = System.currentTimeMillis();
            AJLog.log((String)("AJDTContentProvider.updateData() executed - took " + (etime - stime) + "ms"));
        }
        this.currentMembers = newMembers;
        this.currentGroups = newGroups;
    }

    private void addMembersAndGroups(List<IGroup> newGroups, List<IMember> newMembers, IPackageFragment packageFragment) {
        List<IMember> classes = this.getMembersForPackage(packageFragment);
        if (classes.size() > 0) {
            boolean defaultPackage = packageFragment.isDefaultPackage();
            JDTGroup group = new JDTGroup(packageFragment.getElementName());
            if (defaultPackage) {
                group.setName("(default package)");
                group.setTooltip("(default package)");
            }
            for (IMember jdtMember : classes) {
                group.add(jdtMember);
                newMembers.add(jdtMember);
                if (!defaultPackage) continue;
                ((SimpleMember)jdtMember).setFullName(jdtMember.getName());
            }
            newGroups.add((IGroup)group);
        }
    }

    protected void setCurrentProject(IJavaProject newProject) {
        if (this.currentProject == null || !this.currentProject.equals(newProject)) {
            if (ProviderManager.getMarkupProvider() instanceof AJDTMarkupProvider) {
                ((AJDTMarkupProvider)ProviderManager.getMarkupProvider()).resetColours();
            }
            this.currentProject = newProject;
        }
    }

    public void reset() {
        this.currentGroups = null;
        this.currentMembers = null;
        this.includedFiles = null;
    }

    public boolean processMouseclick(IMember member, boolean markupWasClicked, int buttonClicked) {
        IJavaElement jEl;
        if (buttonClicked != 1) {
            return true;
        }
        if (markupWasClicked) {
            return false;
        }
        if (member instanceof JDTMember && (jEl = ((JDTMember)member).getResource()) != null) {
            JDTUtils.openInEditor((IResource)jEl.getResource(), (int)JDTUtils.getClassDeclLineNum((IJavaElement)jEl));
        }
        return false;
    }

    public List<IMember> getMembersForPackage(IPackageFragment packageFragment) {
        ArrayList<IMember> returningClasses = new ArrayList<IMember>();
        try {
            if (this.containsUsefulStuff(packageFragment)) {
                IJavaElement[] javaElements = packageFragment.getChildren();
                int j = 0;
                while (j < javaElements.length) {
                    String memberName;
                    if (javaElements[j].getElementType() == 5 && this.getIncludedFiles(packageFragment.getJavaProject().getProject()).contains(javaElements[j].getResource()) && (IsWovenTester.isWeavingActive() || javaElements[j] instanceof AJCompilationUnit || javaElements[j].getElementName() == null || !javaElements[j].getElementName().endsWith(".aj")) && !this.shouldIgnore(memberName = javaElements[j].getElementName())) {
                        if (memberName.endsWith(".java")) {
                            memberName = memberName.substring(0, memberName.length() - 5);
                        } else if (memberName.endsWith(".aj")) {
                            memberName = memberName.substring(0, memberName.length() - 3);
                        }
                        JDTMember member = new JDTMember(memberName, javaElements[j]);
                        member.setSize(this.getLength((ICompilationUnit)javaElements[j]));
                        returningClasses.add((IMember)member);
                    }
                    ++j;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
        }
        return returningClasses;
    }

    protected boolean shouldIgnore(String memberName) {
        return memberName.equals("package-info.java");
    }

    private Set<IFile> getIncludedFiles(IProject project) {
        if (this.includedFiles == null) {
            this.includedFiles = BuildConfig.getIncludedSourceFiles((IProject)project);
        }
        return this.includedFiles;
    }

    static {
        AJDTContentProvider.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AJDTContentProvider.java", AJDTContentProvider.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 196);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "updateData", "org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider", "", "", "", "void"), 139);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 315);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "getMembersForPackage", "org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider", "org.eclipse.jdt.core.IPackageFragment", "packageFragment", "", "java.util.List"), 282);
    }
}

