/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.ajde;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.ajde.core.ICompilerConfiguration;
import org.aspectj.ajde.core.IOutputLocationManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AopXmlPreferences;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.BuildConfig;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.core.text.CoreMessages;
import org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager;
import org.eclipse.ajdt.internal.core.ajde.FileURICache;
import org.eclipse.ajdt.internal.core.builder.BuildClasspathResolver;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreCompilerConfiguration
implements ICompilerConfiguration {
    private String cachedClasspath = null;
    protected IProject project;
    protected CoreOutputLocationManager locationManager;
    protected FileURICache fileCache;
    private List<File> modifiedFiles = null;
    private int configurationChanges;
    private List<String> classpathElementsWithModifiedContents = null;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_7;

    public CoreCompilerConfiguration(IProject project) {
        this.project = project;
        AJLog.log(2, "Compiler configuration for project " + project.getName() + " doesn't know previous state, so assuming EVERYTHING has changed.");
        this.configurationChanges = 65535;
        this.fileCache = new FileURICache(project);
    }

    public void buildStarting() {
        ((CoreOutputLocationManager)this.getOutputLocationManager()).buildStarting();
    }

    public void buildComplete() {
        ((CoreOutputLocationManager)this.getOutputLocationManager()).buildComplete();
    }

    public Map<String, String> getJavaOptionsMap() {
        Map optionsMap = null;
        try {
            JavaProject javaProject = (JavaProject)this.project.getNature("org.eclipse.jdt.core.javanature");
            optionsMap = javaProject.getOptions(true);
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        if (optionsMap == null) {
            return JavaCore.getOptions();
        }
        return optionsMap;
    }

    public String getNonStandardOptions() {
        return "";
    }

    public Set<File> getAspectPath() {
        String[] v = AspectJCorePreferences.getResolvedProjectAspectPath(this.project);
        String aspectpath = this.expandVariables(v[0], v[2]);
        if ((aspectpath = this.fullyQualifyPathEntries(aspectpath)).length() == 0) {
            return null;
        }
        return this.mapStringToSet(aspectpath, false);
    }

    public String getClasspath() {
        if (this.cachedClasspath != null) {
            return this.cachedClasspath;
        }
        IJavaProject jp = JavaCore.create((IProject)this.project);
        this.cachedClasspath = new BuildClasspathResolver().getClasspath(AspectJPlugin.getWorkspace().getRoot(), jp);
        return this.cachedClasspath;
    }

    public Set<File> getInpath() {
        String[] v = AspectJCorePreferences.getResolvedProjectInpath(this.project);
        String inpath = this.expandVariables(v[0], v[2]);
        if ((inpath = this.fullyQualifyPathEntries(inpath)).length() == 0) {
            return null;
        }
        return this.mapStringToSet(inpath, false);
    }

    public String getOutJar() {
        String outputJar = AspectJCorePreferences.getProjectOutJar(this.project);
        if (outputJar.trim().length() > 0 && !outputJar.startsWith("\\") && !outputJar.startsWith("/")) {
            String trimmedName = outputJar.trim();
            boolean prependProject = true;
            if (trimmedName.length() > 1 && trimmedName.charAt(1) == ':') {
                prependProject = false;
            }
            if (prependProject) {
                String projectBaseDirectory = this.project.getLocation().toOSString();
                outputJar = String.valueOf(projectBaseDirectory) + File.separator + outputJar.trim();
            }
        }
        return outputJar;
    }

    public IOutputLocationManager getOutputLocationManager() {
        if (this.locationManager == null) {
            this.locationManager = new CoreOutputLocationManager(this.project, this.fileCache);
        }
        return this.locationManager;
    }

    public boolean flushOutputLocationManagerIfNecessary(int buildKind) {
        if (buildKind == 6 || buildKind == 15) {
            this.locationManager = null;
        } else if ((this.configurationChanges & 0x35C) != 0) {
            this.locationManager = null;
        } else if (this.locationManager != null) {
            this.locationManager.zapBinFolderToProjectMap();
        }
        return this.locationManager == null;
    }

    public List<String> getProjectSourceFiles() {
        Set<IFile> files = BuildConfig.getIncludedSourceFiles(this.project);
        ArrayList<String> iofiles = new ArrayList<String>(files.size());
        for (IFile f : files) {
            iofiles.add(f.getLocation().toOSString());
        }
        return iofiles;
    }

    public Map<String, File> getSourcePathResources() {
        return null;
    }

    public void flushClasspathCache() {
        this.cachedClasspath = null;
    }

    public String expandVariables(String path, String eKinds) {
        StringBuffer resultBuffer = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(path, File.pathSeparator);
        StringTokenizer strTok2 = new StringTokenizer(eKinds, File.pathSeparator);
        while (strTok.hasMoreTokens()) {
            String current = strTok.nextToken();
            int entryKind = Integer.parseInt(strTok2.nextToken());
            if (entryKind == 4) {
                String exp;
                int slashPos = current.indexOf("/", 0);
                if (slashPos != -1) {
                    exp = JavaCore.getClasspathVariable((String)current.substring(0, slashPos)).toOSString();
                    resultBuffer.append(exp);
                    resultBuffer.append(current.substring(slashPos));
                } else {
                    exp = JavaCore.getClasspathVariable((String)current).toOSString();
                    resultBuffer.append(exp);
                }
            } else {
                resultBuffer.append(current);
            }
            resultBuffer.append(File.pathSeparator);
        }
        return resultBuffer.toString();
    }

    public String fullyQualifyPathEntries(String inputPath) {
        StringBuffer resultBuffer = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(inputPath, File.pathSeparator);
        while (strTok.hasMoreTokens()) {
            String current = strTok.nextToken();
            File f = new File(current);
            if (f.exists() && f.isAbsolute()) {
                resultBuffer.append(current);
            } else {
                String projectName = null;
                int slashPos = current.indexOf("/", 1);
                projectName = slashPos != -1 ? current.substring(1, slashPos) : current.substring(1);
                IProject proj = AspectJPlugin.getWorkspace().getRoot().getProject(projectName);
                if (proj != null && proj.getLocation() != null) {
                    String projectPath = proj.getLocation().toString();
                    if (slashPos != -1) {
                        String rest = current.substring(slashPos + 1);
                        IResource res = proj.findMember(rest);
                        if (res != null) {
                            resultBuffer.append(res.getRawLocation().toOSString());
                        } else {
                            resultBuffer.append(String.valueOf(projectPath) + "/" + rest);
                        }
                    } else {
                        resultBuffer.append(projectPath);
                    }
                } else {
                    AJLog.log(2, "AspectJ path entry " + current + " does not exist.");
                    resultBuffer.append(current);
                }
            }
            resultBuffer.append(File.pathSeparator);
        }
        String result = resultBuffer.toString();
        if (result.endsWith(File.pathSeparator)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private Set<File> mapStringToSet(String input, boolean validateFiles) {
        if (input.length() == 0) {
            return null;
        }
        String inputCopy = input;
        StringBuffer invalidEntries = new StringBuffer();
        String projectBaseDirectory = this.project.getLocation().toOSString();
        HashSet<File> fileSet = new HashSet<File>();
        while (inputCopy.indexOf(File.pathSeparator) != -1) {
            int idx = inputCopy.indexOf(File.pathSeparator);
            String path = inputCopy.substring(0, idx);
            File f = new File(path);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + path);
            }
            if (validateFiles && !f.exists()) {
                invalidEntries.append(f + "\n");
            } else {
                fileSet.add(f);
            }
            inputCopy = inputCopy.substring(idx + 1);
        }
        if (inputCopy.length() != 0) {
            File f = new File(inputCopy);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + inputCopy);
            }
            if (validateFiles && !f.exists()) {
                invalidEntries.append(f + "\n");
            } else {
                fileSet.add(f);
            }
        }
        if (validateFiles && invalidEntries.length() != 0) {
            AJLog.log(1, NLS.bind((String)CoreMessages.missingJarsWarning, (Object)invalidEntries.toString()));
        }
        return fileSet;
    }

    private void getProjectRelativePaths(IResource[] resource_list, List<String> allProjectFiles, CoreUtils.FilenameFilter filter, int trimSegments, IClasspathEntry sourceEntry) {
        try {
            int i = 0;
            while (i < resource_list.length) {
                char[][] exclusionPatterns;
                IResource ir = resource_list[i];
                char[][] inclusionPatterns = ((ClasspathEntry)sourceEntry).fullInclusionPatternChars();
                if (!Util.isExcluded((IResource)ir, (char[][])inclusionPatterns, (char[][])(exclusionPatterns = ((ClasspathEntry)sourceEntry).fullExclusionPatternChars()))) {
                    if (ir instanceof IContainer) {
                        this.getProjectRelativePaths(((IContainer)ir).members(), allProjectFiles, filter, trimSegments, sourceEntry);
                    } else if (filter.accept(ir.getName())) {
                        String[] segments = ir.getProjectRelativePath().segments();
                        String path = "";
                        int j = trimSegments;
                        while (j < segments.length) {
                            path = String.valueOf(path) + segments[j];
                            if (j < segments.length - 1) {
                                path = String.valueOf(path) + '/';
                            }
                            ++j;
                        }
                        allProjectFiles.add(path);
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
        }
    }

    private ArrayList<IResource> getLinkedChildFolders(IResource resource) {
        ArrayList<IResource> resultList = new ArrayList<IResource>();
        if (resource instanceof IContainer) {
            try {
                IResource[] children = ((IContainer)resource).members();
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof IFolder && children[i].isLinked()) {
                        resultList.add(children[i]);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
            }
        }
        return resultList;
    }

    private String getResourceFullPath(IResource srcContainer, String relPath, ArrayList<IResource> linkedFolders) {
        String result = null;
        if (relPath.lastIndexOf(47) != -1) {
            for (IFolder iFolder : linkedFolders) {
                String linkedFolderName = iFolder.getName();
                if (relPath.indexOf(String.valueOf(linkedFolderName) + "/") != 0) continue;
                result = String.valueOf(iFolder.getLocation().toString()) + relPath.substring(linkedFolderName.length());
                result = result.replace('/', File.separatorChar);
                break;
            }
        }
        if (result == null) {
            result = String.valueOf(srcContainer.getLocation().toOSString()) + File.separator + relPath;
        }
        return result;
    }

    public void addModifiedFile(File changedFile) {
        AJLog.log(2, "File: " + changedFile + " has changed.");
        if (this.modifiedFiles != null) {
            this.modifiedFiles.add(changedFile);
        } else {
            AJLog.log(2, "    but, we don't have any state yet, so not recording the change.");
        }
    }

    public void configurationChanged(int changeFlag) {
        this.configurationChanges |= changeFlag;
        this.logConfigurationChange(changeFlag);
    }

    private void logConfigurationChange(int changeFlag) {
        ArrayList<String> changeKind = new ArrayList<String>();
        if ((changeFlag & 1) != 0) {
            changeKind.add("PROJECTSOURCEFILES_CHANGED");
        }
        if ((changeFlag & 2) != 0) {
            changeKind.add("JAVAOPTIONS_CHANGED");
        }
        if ((changeFlag & 4) != 0) {
            changeKind.add("ASPECTPATH_CHANGED");
        }
        if ((changeFlag & 8) != 0) {
            changeKind.add("CLASSPATH_CHANGED");
        }
        if ((changeFlag & 0x10) != 0) {
            changeKind.add("INPATH_CHANGED");
        }
        if ((changeFlag & 0x20) != 0) {
            changeKind.add("NONSTANDARDOPTIONS_CHANGED");
        }
        if ((changeFlag & 0x40) != 0) {
            changeKind.add("OUTJAR_CHANGED");
        }
        if ((changeFlag & 0x80) != 0) {
            changeKind.add("PROJECTSOURCERESOURCES_CHANGED");
        }
        if ((changeFlag & 0x100) != 0) {
            changeKind.add("OUTPUTDESTINATIONS_CHANGED");
        }
        if ((changeFlag & 0x200) != 0) {
            changeKind.add("INJARS_CHANGED");
        }
        AJLog.log(2, "CoreCompilerConfiguration for project " + this.project.getName() + " registered a configuration change: " + changeKind);
    }

    private String toConfigurationString() {
        ArrayList<String> changeKind = new ArrayList<String>();
        if ((this.configurationChanges & 1) != 0) {
            changeKind.add("PROJECTSOURCEFILES_CHANGED");
        }
        if ((this.configurationChanges & 2) != 0) {
            changeKind.add("JAVAOPTIONS_CHANGED");
        }
        if ((this.configurationChanges & 4) != 0) {
            changeKind.add("ASPECTPATH_CHANGED");
        }
        if ((this.configurationChanges & 8) != 0) {
            changeKind.add("CLASSPATH_CHANGED");
        }
        if ((this.configurationChanges & 0x10) != 0) {
            changeKind.add("INPATH_CHANGED");
        }
        if ((this.configurationChanges & 0x20) != 0) {
            changeKind.add("NONSTANDARDOPTIONS_CHANGED");
        }
        if ((this.configurationChanges & 0x40) != 0) {
            changeKind.add("OUTJAR_CHANGED");
        }
        if ((this.configurationChanges & 0x80) != 0) {
            changeKind.add("PROJECTSOURCERESOURCES_CHANGED");
        }
        if ((this.configurationChanges & 0x100) != 0) {
            changeKind.add("OUTPUTDESTINATIONS_CHANGED");
        }
        if ((this.configurationChanges & 0x200) != 0) {
            changeKind.add("INJARS_CHANGED");
        }
        return ((Object)changeKind).toString();
    }

    public void configurationRead() {
        AJLog.log(2, "Compiler configuration for project " + this.project.getName() + " has been read by compiler.  Resetting.");
        AJLog.log(2, "     Configuration was " + this.toConfigurationString());
        this.configurationChanges = 0;
        this.resetModifiedList();
    }

    public int getConfigurationChanges() {
        if (!AspectJCorePreferences.isIncrementalCompilationOptimizationsEnabled()) {
            AJLog.log(2, "Optimizations turned off, so assuming all parts of configuration have changed");
            return 65535;
        }
        AJLog.log(2, "Sending the following configuration changes to the compiler: " + this.toConfigurationString());
        return AspectJCorePreferences.isIncrementalCompilationOptimizationsEnabled() ? this.configurationChanges : 65535;
    }

    public List<File> getProjectSourceFilesChanged() {
        if (!AspectJCorePreferences.isIncrementalCompilationOptimizationsEnabled()) {
            AJLog.log(2, "Optimizations turned off, so assuming all source files have changed");
            return null;
        }
        if (this.modifiedFiles == null) {
            AJLog.log(2, "We don't know what has changed since last build, so assuming all source files have changed");
            return null;
        }
        AJLog.log(2, String.valueOf(this.modifiedFiles.size()) + " source file changes since last build");
        return this.modifiedFiles;
    }

    public void resetModifiedList() {
        AJLog.log(2, "Resetting list of modified source files.  Was " + (this.modifiedFiles == null ? "null" : this.modifiedFiles.toString()));
        this.modifiedFiles = new ArrayList<File>();
    }

    public void resetClasspathElementsWithModifiedContents() {
        this.classpathElementsWithModifiedContents = null;
    }

    public void setClasspathElementsWithModifiedContents(List<String> modifiedContents) {
        AJLog.log(2, "Setting list of classpath elements with modified contents:");
        AJLog.log(2, "      " + (modifiedContents == null ? "NULL" : modifiedContents.toString()));
        this.classpathElementsWithModifiedContents = modifiedContents;
    }

    public List<String> getClasspathElementsWithModifiedContents() {
        return this.classpathElementsWithModifiedContents;
    }

    public static CoreCompilerConfiguration getCompilerConfigurationForProject(IProject project) {
        return (CoreCompilerConfiguration)AspectJPlugin.getDefault().getCompilerFactory().getCompilerForProject(project).getCompilerConfiguration();
    }

    public File[] getCompiledSourceFiles() {
        CoreOutputLocationManager coreOutputLocationManager = (CoreOutputLocationManager)this.getOutputLocationManager();
        File[] compiledSourceFiles = coreOutputLocationManager.getCompiledSourceFiles();
        return compiledSourceFiles;
    }

    public List<String> getProjectXmlConfigFiles() {
        return new AopXmlPreferences(this.project).getAopXmlFilesAsListOfStrings();
    }

    public String getProjectEncoding() {
        try {
            String charset = this.project.getDefaultCharset(false);
            if (charset == null) {
                charset = ContentTypeManager.getInstance().findContentTypeFor("f.java").getDefaultCharset();
            }
            if (charset == null) {
                charset = ResourcesPlugin.getEncoding();
            }
            return charset;
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
            return ResourcesPlugin.getEncoding();
        }
    }

    public FileURICache getFileCache() {
        return this.fileCache;
    }

    static {
        CoreCompilerConfiguration.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CoreCompilerConfiguration.java", CoreCompilerConfiguration.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreCompilerConfiguration", "org.eclipse.core.runtime.CoreException", "<missing>"), 102);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "getJavaOptionsMap", "org.eclipse.ajdt.internal.core.ajde.CoreCompilerConfiguration", "", "", "", "java.util.Map"), 95);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreCompilerConfiguration", "java.lang.Exception", "<missing>"), 397);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getProjectRelativePaths", "org.eclipse.ajdt.internal.core.ajde.CoreCompilerConfiguration", "[Lorg.eclipse.core.resources.IResource;:java.util.List:org.eclipse.ajdt.core.CoreUtils$FilenameFilter:int:org.eclipse.jdt.core.IClasspathEntry", "resource_list:allProjectFiles:filter:trimSegments:sourceEntry", "", "void"), 373);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreCompilerConfiguration", "org.eclipse.core.runtime.CoreException", "<missing>"), 412);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getLinkedChildFolders", "org.eclipse.ajdt.internal.core.ajde.CoreCompilerConfiguration", "org.eclipse.core.resources.IResource", "resource", "", "java.util.ArrayList"), 401);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreCompilerConfiguration", "org.eclipse.core.runtime.CoreException", "<missing>"), 646);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "getProjectEncoding", "org.eclipse.ajdt.internal.core.ajde.CoreCompilerConfiguration", "", "", "", "java.lang.String"), 636);
    }
}

