/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.search;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.aspectj.org.eclipse.jdt.core.dom.ASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.AjASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.Assignment;
import org.aspectj.org.eclipse.jdt.core.dom.Block;
import org.aspectj.org.eclipse.jdt.core.dom.FieldAccess;
import org.aspectj.org.eclipse.jdt.core.dom.InterTypeMethodDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.MethodInvocation;
import org.aspectj.org.eclipse.jdt.core.dom.MethodRef;
import org.aspectj.org.eclipse.jdt.core.dom.MethodRefParameter;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleName;
import org.aspectj.org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.Type;
import org.aspectj.org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.FieldReferenceMatch;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ITDReferenceVisitor
extends AjASTVisitor {
    private Scope currentScope;
    private IntertypeElement itd;
    private FieldPattern fieldPattern;
    private MethodPattern methodPattern;
    private SearchParticipant participant;
    private List<SearchMatch> definitiveMatches;
    private List<SearchMatch> tentativeMatches;

    public ITDReferenceVisitor(IntertypeElement itd, SearchPattern pattern, SearchParticipant participant) {
        this.itd = itd;
        if (pattern instanceof MethodPattern) {
            this.methodPattern = (MethodPattern)pattern;
        }
        if (pattern instanceof FieldPattern) {
            this.fieldPattern = (FieldPattern)pattern;
        }
        this.definitiveMatches = new LinkedList<SearchMatch>();
        this.tentativeMatches = new LinkedList<SearchMatch>();
        this.participant = participant;
    }

    public boolean visit(InterTypeMethodDeclaration node) {
        this.currentScope = new Scope(null);
        return true;
    }

    public boolean visit(MethodRef node) {
        this.checkMethodPattern(node);
        return false;
    }

    public boolean visit(SimpleName node) {
        if (node.getParent() instanceof Type) {
            return false;
        }
        String identifier = node.getIdentifier();
        if (!this.currentScope.isVarInScope(identifier)) {
            this.checkFieldPattern(node);
        }
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        if (node.getName() != null) {
            this.currentScope.addVariableName(node.getName().getIdentifier());
        }
        if (node.getInitializer() != null) {
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(FieldAccess node) {
        if (node.getExpression() != null && node.getExpression().getNodeType() == 52) {
            this.checkFieldPattern(node.getName());
        }
        return false;
    }

    public boolean visit(MethodInvocation node) {
        this.checkMethodPattern(node);
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationFragment node) {
        this.currentScope.addVariableName(node.getName().getIdentifier());
        if (node.getInitializer() != null) {
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(Block node) {
        this.currentScope = new Scope(this.currentScope);
        return super.visit(node);
    }

    public void endVisit(Block node) {
        this.currentScope = this.currentScope.parent;
        super.endVisit(node);
    }

    public List<SearchMatch> doVisit(InterTypeMethodDeclaration itdNode) {
        itdNode.accept((ASTVisitor)this);
        return this.definitiveMatches;
    }

    public List<SearchMatch> getTentativeMatches() {
        return this.tentativeMatches;
    }

    private void checkMethodPattern(MethodRef node) {
        if (this.methodPattern != null && node.getName().equals((Object)String.valueOf(this.methodPattern.selector))) {
            int i = 0;
            if (node.parameters().size() == this.methodPattern.parameterCount) {
                for (MethodRefParameter param : node.parameters()) {
                    if (param.getName().equals((Object)String.valueOf(this.methodPattern.parameterSimpleNames[i]))) continue;
                    return;
                }
            }
            this.definitiveMatches.add((SearchMatch)new MethodReferenceMatch((IJavaElement)this.itd, 0, node.getName().getStartPosition(), node.getName().getLength(), false, false, false, true, this.participant, this.itd.getResource()));
        }
    }

    private void checkMethodPattern(MethodInvocation node) {
        if (this.methodPattern != null && node.getName().getIdentifier().equals(String.valueOf(this.methodPattern.selector)) && (node.getExpression() == null || node.getExpression().getNodeType() == 52) && node.arguments().size() == this.methodPattern.parameterCount) {
            this.tentativeMatches.add((SearchMatch)new MethodReferenceMatch((IJavaElement)this.itd, 0, node.getStartPosition(), node.getLength(), false, false, false, true, this.participant, this.itd.getResource()));
        }
    }

    private void checkFieldPattern(SimpleName name) {
        boolean isWrite;
        boolean bl = isWrite = name.getParent().getNodeType() == 7 && ((Assignment)name.getParent()).getLeftHandSide() == name;
        if (this.fieldPattern != null && String.valueOf(this.fieldPattern.getIndexKey()).equals(name.getIdentifier())) {
            this.definitiveMatches.add((SearchMatch)new FieldReferenceMatch((IJavaElement)this.itd, 0, name.getStartPosition(), name.getLength(), !isWrite, isWrite, name.getParent().getNodeType() == 67, this.participant, this.itd.getResource()));
        }
    }

    class Scope {
        private Set<String> varNames;
        final Scope parent;

        public Scope(Scope parent) {
            this.parent = parent;
            this.varNames = new HashSet<String>();
        }

        void addVariableName(String name) {
            this.varNames.add(name);
        }

        boolean isVarInScope(String name) {
            if (this.varNames.contains(name)) {
                return true;
            }
            return this.parent != null ? this.parent.isVarInScope(name) : false;
        }
    }
}

