/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.jdt.sourceprovider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.contribution.jdt.JDTWeavingPlugin;
import org.eclipse.contribution.jdt.sourceprovider.ISourceTransformer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class SourceTransformerRegistry {
    public static String SOURCETRANSFORMERS_EXTENSION_POINT = "org.eclipse.contribution.weaving.jdt.sourcetransformer";
    private static final SourceTransformerRegistry INSTANCE = new SourceTransformerRegistry();
    private Map<String, ISourceTransformer> registry;

    public static SourceTransformerRegistry getInstance() {
        return INSTANCE;
    }

    private SourceTransformerRegistry() {
    }

    void registerSelector(String key, ISourceTransformer transformer) {
        this.registry.put(key, transformer);
    }

    ISourceTransformer getSelector(String key) {
        if (!this.isRegistered()) {
            this.registerTransformers();
        }
        return this.registry.get(key);
    }

    public boolean isRegistered() {
        return this.registry != null;
    }

    public void registerTransformers() {
        this.registry = new HashMap<String, ISourceTransformer>();
        IExtensionPoint exP = Platform.getExtensionRegistry().getExtensionPoint(SOURCETRANSFORMERS_EXTENSION_POINT);
        if (exP != null) {
            IExtension[] exs = exP.getExtensions();
            int i = 0;
            while (i < exs.length) {
                IConfigurationElement[] configs = exs[i].getConfigurationElements();
                int j = 0;
                while (j < configs.length) {
                    try {
                        IConfigurationElement config = configs[j];
                        if (config.isValid()) {
                            ISourceTransformer provider = (ISourceTransformer)config.createExecutableExtension("class");
                            this.registry.put(config.getAttribute("file_extension"), provider);
                        }
                    }
                    catch (CoreException e) {
                        JDTWeavingPlugin.logException(e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

