/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.refactoring.pullout;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.javaelements.SourceRange;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.refactoring.pullout.CompilationUnitComparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class PullOutRefactoring
extends Refactoring {
    private static final String MAKE_PRIVILEGED = "makePrivileged";
    private static final String MEMBER = "member";
    protected static final String ASPECT = "aspect";
    private Map<ICompilationUnit, Collection<IMember>> memberMap;
    private HashSet<IMember> memberSet;
    private AspectElement targetAspect;
    private boolean makePrivileged = false;
    private boolean generateAbstractMethodStubs = false;
    private boolean allowDeleteProtected = false;
    private boolean allowMakePublic;
    private IJavaProject javaProject;
    private AspectRewrite aspectChanges;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;

    public PullOutRefactoring() {
        this.clearMembers();
    }

    public void addMember(IMember member, RefactoringStatus status) {
        ICompilationUnit cu = member.getCompilationUnit();
        Collection<IMember> members = this.getMembers(cu);
        members.add(member);
        this.memberSet.add(member);
        if (this.javaProject == null) {
            this.javaProject = member.getJavaProject();
        } else if (this.javaProject != member.getJavaProject()) {
            status.addError("Pull-out refactoring across multiple projects is not suppored", PullOutRefactoring.makeContext(member));
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        SubProgressMonitor submonitor = new SubProgressMonitor(pm, this.memberMap.keySet().size());
        submonitor.beginTask("Checking preconditions...", this.memberMap.keySet().size());
        try {
            try {
                this.aspectChanges = new AspectRewrite();
                ICompilationUnit[] cus = this.memberMap.keySet().toArray(new ICompilationUnit[0]);
                Arrays.sort(cus, CompilationUnitComparator.the);
                ICompilationUnit[] iCompilationUnitArray = cus;
                int n = cus.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompilationUnit cu = iCompilationUnitArray[n2];
                    ASTParser parser = ASTParser.newParser((int)8);
                    parser.setSource(cu);
                    parser.setResolveBindings(true);
                    ASTNode cuNode = parser.createAST(pm);
                    for (IMember member : this.memberMap.get(cu)) {
                        BodyDeclaration memberNode = (BodyDeclaration)this.findASTNode(cuNode, member);
                        ITDCreator itd = new ITDCreator(member, memberNode);
                        if (member.getDeclaringType().isInterface()) {
                            itd.addModifier(1);
                        }
                        if (itd.wasProtected()) {
                            if (this.isAllowDeleteProtected()) {
                                itd.removeModifier(4);
                            } else {
                                status.addWarning("moved member '" + member.getElementName() + "' is protected\n" + "protected ITDs are not allowed by AspectJ.\n", PullOutRefactoring.makeContext(member));
                            }
                        }
                        if (itd.wasAbstract()) {
                            if (this.isGenerateAbstractMethodStubs()) {
                                itd.removeModifier(1024);
                                itd.setBody(this.getAbstractMethodStubBody(member));
                            } else {
                                status.addWarning("moved member '" + member.getElementName() + "' is abstract.\n" + "abstract ITDs are not allowed by AspectJ.\n" + "You can enable the 'convert abstract methods' option to avoid this error.", PullOutRefactoring.makeContext(member));
                                itd.addModifier(1024);
                            }
                        }
                        this.checkOutgoingReferences(itd, status);
                        this.checkIncomingReferences(itd, status);
                        this.checkConctructorThisCall(itd, status);
                        this.aspectChanges.addITD(itd, status);
                    }
                    submonitor.worked(1);
                    ++n2;
                }
            }
            catch (BadLocationException badLocationException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(badLocationException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                BadLocationException e = badLocationException;
                status.merge(RefactoringStatus.createFatalErrorStatus((String)("Internal error:" + e.getMessage())));
                submonitor.done();
            }
        }
        finally {
            submonitor.done();
        }
        return status;
    }

    private void checkConctructorThisCall(ITDCreator itd, RefactoringStatus status) throws JavaModelException {
        if (itd.wasConstructorMethod() && !itd.hasThisCall()) {
            status.addWarning("Program semantics changed: moved '" + itd.getElementName() + "' constructor has no this() call. Initializers in the target class will not be executed " + "by the intertype constructor", PullOutRefactoring.makeContext(itd.getMember()));
        }
    }

    private ASTNode findASTNode(ASTNode cuNode, IMember member) throws JavaModelException {
        ISourceRange range = member.getSourceRange();
        NodeFinder finder = new NodeFinder(cuNode, range.getOffset(), range.getLength());
        return finder.getCoveredNode();
    }

    private boolean checkIncomingReferences(ITDCreator movedMember, RefactoringStatus status) throws CoreException {
        if (movedMember.wasPublic()) {
            return true;
        }
        boolean ok = true;
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.javaProject});
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)movedMember.getMember(), (int)2);
        SearchEngine engine = new SearchEngine();
        final HashSet references = new HashSet();
        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                if (match.getAccuracy() == 0 && !match.isInsideDocComment()) {
                    references.add(match);
                }
            }
        }, (IProgressMonitor)new NullProgressMonitor());
        String referredPkg = this.getPackageName((IJavaElement)this.targetAspect);
        for (SearchMatch match : references) {
            String referringPkg;
            IJavaElement referingElement;
            if (!(match.getElement() instanceof IJavaElement) || this.isMoved(referingElement = (IJavaElement)match.getElement())) continue;
            if (movedMember.wasPrivate()) {
                ok = false;
                if (this.isAllowMakePublic()) {
                    movedMember.addModifier(1);
                    continue;
                }
                status.addWarning("The moved private member '" + movedMember.getElementName() + "' will not be accessible" + " after refactoring.", PullOutRefactoring.makeContext(match));
                continue;
            }
            if (!movedMember.wasPackageVisible() && !movedMember.wasProtected() || (referringPkg = this.getPackageName(referingElement)) == null || referringPkg.equals(referredPkg)) continue;
            ok = false;
            if (this.isAllowMakePublic()) {
                movedMember.addModifier(1);
                continue;
            }
            status.addWarning("The moved member '" + movedMember.getElementName() + "' may not be accessible " + "after refactoring", PullOutRefactoring.makeContext(match));
        }
        return ok;
    }

    private String getPackageName(IJavaElement el) {
        IPackageFragment pkg = (IPackageFragment)el.getAncestor(4);
        if (pkg == null) {
            return null;
        }
        return pkg.getElementName();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        monitor.beginTask("Checking preconditions...", 1);
        try {
            if (this.memberMap == null || this.memberMap.isEmpty()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)"No pullout targets have been specified."));
            } else {
                for (ICompilationUnit cu : this.memberMap.keySet()) {
                    for (IMember member : this.memberMap.get(cu)) {
                        if (!member.exists()) {
                            status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("Member ''{0}'' does not exist.", member.getElementName())));
                            continue;
                        }
                        if (!this.isInTopLevelType(member)) {
                            status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("Member ''{0}'' is not directly nested in a top-level type.", member.getElementName())));
                            continue;
                        }
                        if (member.isBinary()) {
                            status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("Member ''{0}'' is not in source code. Binary methods can not be refactored.", member.getElementName())));
                            continue;
                        }
                        if (member.getCompilationUnit().isStructureKnown()) continue;
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("Compilation unit ''{0}'' contains compile errors.", cu.getElementName())));
                    }
                }
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private void checkOutgoingReferences(final ITDCreator itd, final RefactoringStatus status) throws CoreException, OperationCanceledException {
        if (this.willBePrivileged()) {
            return;
        }
        itd.getMemberNode().accept(new ASTVisitor(){

            private void checkReference(ASTNode node, IBinding binding, RefactoringStatus status2) {
                if (this.isField(binding) || this.isMethod(binding) || this.isType(binding)) {
                    String aspectPkg;
                    String referredPkg;
                    if (this.isTypeParameter(binding)) {
                        return;
                    }
                    if (PullOutRefactoring.this.isMoved(binding)) {
                        return;
                    }
                    int mods = binding.getModifiers();
                    if (Modifier.isPrivate((int)mods)) {
                        status2.addWarning("private member '" + binding.getName() + "' accessed and refactored aspect is not privileged", PullOutRefactoring.makeContext(itd.getMember(), node));
                    }
                    if ((JdtFlags.isProtected((IBinding)binding) || JdtFlags.isPackageVisible((IBinding)binding)) && (referredPkg = PullOutRefactoring.this.getPackageName(binding.getJavaElement())) != null && !referredPkg.equals(aspectPkg = PullOutRefactoring.this.targetAspect.getPackageFragment().getElementName())) {
                        String keyword = JdtFlags.isProtected((IBinding)binding) ? "protected" : "package restricted";
                        status2.addWarning(String.valueOf(keyword) + " member '" + binding.getName() + "' is accessed and refactored aspect is not privileged", PullOutRefactoring.makeContext(itd.getMember(), node));
                    }
                }
            }

            private boolean isField(IBinding binding) {
                return binding instanceof IVariableBinding && ((IVariableBinding)binding).isField();
            }

            private boolean isMethod(IBinding binding) {
                return binding instanceof IMethodBinding;
            }

            private boolean isType(IBinding binding) {
                return binding instanceof ITypeBinding;
            }

            private boolean isTypeParameter(IBinding binding) {
                return binding instanceof ITypeBinding && (((ITypeBinding)binding).isCapture() || ((ITypeBinding)binding).isTypeVariable());
            }

            public boolean visit(SimpleName node) {
                IBinding binding = node.resolveBinding();
                this.checkReference((ASTNode)node, binding, status);
                return true;
            }
        });
    }

    private void clearMembers() {
        this.memberMap = new HashMap<ICompilationUnit, Collection<IMember>>();
        this.memberSet = new HashSet();
        this.javaProject = null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask("Creating changes...", this.memberMap.keySet().size());
            CompositeChange allChanges = new CompositeChange("PullOut ITDs");
            for (ICompilationUnit cu : this.memberMap.keySet()) {
                ASTParser parser = ASTParser.newParser((int)8);
                parser.setSource(cu);
                parser.createAST(pm);
                MultiTextEdit cuEdits = new MultiTextEdit();
                for (IMember member : this.getMembers(cu)) {
                    ISourceRange range = member.getSourceRange();
                    range = this.grabSpaceBefore(cu, range);
                    cuEdits.addChild((TextEdit)new DeleteEdit(range.getOffset(), range.getLength()));
                }
                CompilationUnitChange cuChanges = this.newCompilationUnitChange(cu);
                cuChanges.setEdit((TextEdit)cuEdits);
                allChanges.add((Change)cuChanges);
                pm.worked(1);
            }
            this.aspectChanges.rewriteAspect(pm, allChanges);
            CompositeChange compositeChange = allChanges;
            return compositeChange;
        }
        finally {
            pm.done();
        }
    }

    private ISourceRange grabSpaceBefore(ICompilationUnit cu, ISourceRange range) {
        try {
            IBuffer sourceText = cu.getBuffer();
            int start = range.getOffset();
            int len = range.getLength();
            while (start > 0 && this.isSpace(sourceText.getChar(start - 1))) {
                --start;
                ++len;
            }
            return new SourceRange(start, len);
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
            return range;
        }
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\t';
    }

    private CompilationUnitChange newCompilationUnitChange(ICompilationUnit cu) {
        CompilationUnitChange cuChange = new CompilationUnitChange("PullOut ITDs", cu);
        if (this.targetAspect.getCompilationUnit() == cu) {
            this.aspectChanges.setCUChange(cuChange);
        }
        return cuChange;
    }

    public AspectElement getAspect() {
        return this.targetAspect;
    }

    public String getAspectName() {
        AspectElement theAspect = this.getAspect();
        if (theAspect == null) {
            return "";
        }
        return theAspect.getFullyQualifiedName();
    }

    private int getInsertLocation() {
        try {
            return this.targetAspect.getSourceRange().getOffset() + this.targetAspect.getSourceRange().getLength() - 1;
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
            return 0;
        }
    }

    IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public IMember[] getMembers() {
        ArrayList<IMember> members = new ArrayList<IMember>();
        for (ICompilationUnit cu : this.memberMap.keySet()) {
            members.addAll(this.getMembers(cu));
        }
        return members.toArray(new IMember[members.size()]);
    }

    private Collection<IMember> getMembers(ICompilationUnit cu) {
        Collection<IMember> result = this.memberMap.get(cu);
        if (result == null) {
            result = new ArrayList<IMember>();
            this.memberMap.put(cu, result);
        }
        return result;
    }

    public String getName() {
        return "Pull-Out";
    }

    public boolean hasMembers() {
        return !this.memberSet.isEmpty();
    }

    public RefactoringStatus initialize(Map<String, String> args) {
        RefactoringStatus status = new RefactoringStatus();
        this.setMakePrivileged(Boolean.valueOf(args.get(MAKE_PRIVILEGED)));
        this.setMember((IMember)JavaCore.create((String)args.get(MEMBER)), status);
        return status;
    }

    private boolean isInTopLevelType(IMember member) {
        IJavaElement parent = member.getParent();
        Assert.isTrue((parent.getElementType() == 7 ? 1 : 0) != 0);
        return parent.getParent().getElementType() == 5;
    }

    public boolean isMakePrivileged() {
        return this.makePrivileged;
    }

    private boolean isMoved(IBinding binding) {
        return this.isPulled(binding.getJavaElement());
    }

    public boolean isMoved(IJavaElement javaElement) {
        return javaElement != null && (this.isPulled(javaElement) || this.isMoved(javaElement.getParent()));
    }

    private boolean isPrivileged() {
        if (this.targetAspect == null) {
            return false;
        }
        try {
            return this.targetAspect.isPrivileged();
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
            return false;
        }
    }

    public boolean isGenerateAbstractMethodStubs() {
        return this.generateAbstractMethodStubs;
    }

    public void setGenerateAbstractMethodStubs(boolean allow) {
        this.generateAbstractMethodStubs = allow;
    }

    public void setAllowMakePublic(boolean allow) {
        this.allowMakePublic = allow;
    }

    public void setAllowDeleteProtected(boolean allow) {
        this.allowDeleteProtected = allow;
    }

    public boolean isAllowMakePublic() {
        return this.allowMakePublic;
    }

    public boolean isAllowDeleteProtected() {
        return this.allowDeleteProtected || this.allowMakePublic;
    }

    private boolean isPulled(IJavaElement javaElement) {
        return this.memberSet.contains(javaElement);
    }

    private static RefactoringStatusContext makeContext(ICompilationUnit cu, ASTNode node) {
        return JavaStatusContext.create((ITypeRoot)cu, (ISourceRange)new SourceRange(node.getStartPosition(), node.getLength()));
    }

    private static RefactoringStatusContext makeContext(IMember member) {
        try {
            return JavaStatusContext.create((ITypeRoot)member.getCompilationUnit(), (ISourceRange)member.getSourceRange());
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(javaModelException, ajc$tjp_8, (JoinPoint.StaticPart)ajc$tjp_9);
            return null;
        }
    }

    static RefactoringStatusContext makeContext(IMember member, ASTNode node) {
        return PullOutRefactoring.makeContext(member.getCompilationUnit(), node);
    }

    private static RefactoringStatusContext makeContext(SearchMatch match) {
        try {
            IJavaElement element = (IJavaElement)match.getElement();
            ITypeRoot typeRoot = (ITypeRoot)element.getAncestor(5);
            if (typeRoot == null) {
                typeRoot = (ITypeRoot)element.getAncestor(6);
            }
            SourceRange range = new SourceRange(match.getOffset(), match.getLength());
            return JavaStatusContext.create((ITypeRoot)typeRoot, (ISourceRange)range);
        }
        catch (Throwable throwable) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(throwable, ajc$tjp_10, (JoinPoint.StaticPart)ajc$tjp_11);
            return null;
        }
    }

    public void setAspect(AspectElement target) {
        this.targetAspect = target;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus setAspect(String name) {
        IType type;
        block11: {
            JavaModelException javaModelException622222;
            block13: {
                JavaModelException javaModelException2222222;
                block12: {
                    block10: {
                        block9: {
                            type = null;
                            if (name.length() != 0) break block9;
                            return RefactoringStatus.createFatalErrorStatus((String)"Select an Aspect.");
                        }
                        type = this.getJavaProject().findType(name, (IProgressMonitor)new NullProgressMonitor());
                        if (type != null && type.exists()) break block10;
                        return RefactoringStatus.createErrorStatus((String)MessageFormat.format("Aspect ''{0}'' does not exist.", name));
                    }
                    if (!(type instanceof AspectElement)) {
                        return RefactoringStatus.createErrorStatus((String)MessageFormat.format("''{0}'' is not an Aspect.", name));
                    }
                    break block11;
                    catch (JavaModelException javaModelException3) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException3, (Object)this, ajc$tjp_12, (JoinPoint.StaticPart)ajc$tjp_13);
                        JavaModelException javaModelException4 = javaModelException3;
                    }
                    break block12;
                    catch (JavaModelException javaModelException2222222) {
                        // empty catch block
                    }
                }
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException2222222, (Object)this, ajc$tjp_14, (JoinPoint.StaticPart)ajc$tjp_13);
                JavaModelException javaModelException5 = javaModelException2222222;
                break block13;
                catch (JavaModelException javaModelException622222) {
                    // empty catch block
                }
            }
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException622222, (Object)this, ajc$tjp_15, (JoinPoint.StaticPart)ajc$tjp_13);
            return RefactoringStatus.createFatalErrorStatus((String)"Could not determine type.");
        }
        if (type.isReadOnly()) {
            return RefactoringStatus.createFatalErrorStatus((String)"Type is read-only.");
        }
        if (type.isBinary()) {
            return RefactoringStatus.createFatalErrorStatus((String)"Type is binary.");
        }
        this.targetAspect = (AspectElement)type;
        return new RefactoringStatus();
    }

    public void setMakePrivileged(boolean makePrivileged) {
        this.makePrivileged = makePrivileged;
    }

    public void setMember(IMember member, RefactoringStatus status) {
        this.clearMembers();
        this.addMember(member, status);
    }

    public boolean willBePrivileged() {
        return this.isPrivileged() || this.isMakePrivileged();
    }

    protected String getAbstractMethodStubBody(IMember originalMember) {
        return " { throw new Error(\"abstract method stub\"); }";
    }

    static {
        PullOutRefactoring.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PullOutRefactoring.java", PullOutRefactoring.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring", "org.eclipse.jface.text.BadLocationException", "e"), 731);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "checkFinalConditions", "org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring", "org.eclipse.core.runtime.IProgressMonitor", "pm", "org.eclipse.core.runtime.CoreException:org.eclipse.core.runtime.OperationCanceledException", "org.eclipse.ltk.core.refactoring.RefactoringStatus"), 676);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring", "java.lang.Throwable", "<missing>"), 1214);
        ajc$tjp_11 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("a", "makeContext", "org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring", "org.eclipse.jdt.core.search.SearchMatch", "match", "", "org.eclipse.ltk.core.refactoring.RefactoringStatusContext"), 1204);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 1241);
        ajc$tjp_13 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "setAspect", "org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring", "java.lang.String", "name", "", "org.eclipse.ltk.core.refactoring.RefactoringStatus"), 1229);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 1241);
        ajc$tjp_15 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 1241);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 1010);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "grabSpaceBefore", "org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring", "org.eclipse.jdt.core.ICompilationUnit:org.eclipse.jdt.core.ISourceRange", "cu:range", "", "org.eclipse.jdt.core.ISourceRange"), 1001);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 1049);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getInsertLocation", "org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring", "", "", "", "int"), 1045);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 1129);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "isPrivileged", "org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring", "", "", "", "boolean"), 1124);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 1195);
        ajc$tjp_9 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("a", "makeContext", "org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring", "org.eclipse.jdt.core.IMember", MEMBER, "", "org.eclipse.ltk.core.refactoring.RefactoringStatusContext"), 1192);
    }

    class AspectRewrite {
        private StringBuffer itds = new StringBuffer();
        private ImportRewrite importRewrite;
        private CompilationUnitChange cuChange = null;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        public AspectRewrite() throws JavaModelException {
            this.importRewrite = ImportRewrite.create((ICompilationUnit)PullOutRefactoring.this.targetAspect.getCompilationUnit(), (boolean)true);
        }

        public void addITD(ITDCreator itd, RefactoringStatus status) throws JavaModelException, BadLocationException {
            itd.collectImports(this.importRewrite, status);
            this.itds.append(itd.createText());
        }

        private void rewriteAspect(IProgressMonitor submonitor, CompositeChange allChanges) {
            try {
                CompilationUnitChange edits = this.getCUChange();
                if (PullOutRefactoring.this.isMakePrivileged() && !PullOutRefactoring.this.isPrivileged()) {
                    int start = PullOutRefactoring.this.targetAspect.getSourceRange().getOffset();
                    int nameStart = PullOutRefactoring.this.targetAspect.getNameRange().getOffset() - start;
                    String aspectText = PullOutRefactoring.this.targetAspect.getSource().substring(0, nameStart);
                    int aspectKeywordStart = aspectText.lastIndexOf("class");
                    Assert.isTrue((aspectKeywordStart >= 0 ? 1 : 0) != 0, (String)"The aspect keyword was not found in the aspect source");
                    edits.addEdit((TextEdit)new InsertEdit(aspectKeywordStart += start, "privileged "));
                }
                if (this.importRewrite.hasRecordedChanges()) {
                    try {
                        edits.addEdit(this.importRewrite.rewriteImports(submonitor));
                    }
                    catch (Exception exception) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    }
                }
                edits.addEdit((TextEdit)new InsertEdit(PullOutRefactoring.this.getInsertLocation(), this.itds.toString()));
                if (edits.getParent() == null) {
                    allChanges.add((Change)edits);
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
            }
        }

        private CompilationUnitChange getCUChange() {
            if (this.cuChange == null) {
                this.cuChange = PullOutRefactoring.this.newCompilationUnitChange(PullOutRefactoring.this.getAspect().getCompilationUnit());
                this.cuChange.setEdit((TextEdit)new MultiTextEdit());
            }
            return this.cuChange;
        }

        public void setCUChange(CompilationUnitChange cuChange) {
            this.cuChange = cuChange;
        }

        static {
            AspectRewrite.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("PullOutRefactoring.java", AspectRewrite.class);
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring$AspectRewrite", "java.lang.Exception", "<missing>"), 157);
            ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "rewriteAspect", "org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring$AspectRewrite", "org.eclipse.core.runtime.IProgressMonitor:org.eclipse.ltk.core.refactoring.CompositeChange", "submonitor:allChanges", "", "void"), 135);
            ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.pullout.PullOutRefactoring$AspectRewrite", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 172);
        }
    }

    static class ITDCreator {
        private static final int VISIBILITY_MODIFIERS = 7;
        private IMember member;
        private BodyDeclaration memberNode;
        private IDocument memberText;
        private MultiTextEdit edits = new MultiTextEdit();
        private int deleteMods = 0;
        private String insertMods = "";
        private String declaringTypeRef = null;

        public ITDCreator(IMember member, BodyDeclaration memberNode) throws JavaModelException {
            this.member = member;
            this.memberNode = memberNode;
            this.memberText = new Document(this.getAJSource(member));
        }

        private String getAJSource(IMember member) throws JavaModelException {
            ICompilationUnit cu = member.getCompilationUnit();
            if (cu instanceof AJCompilationUnit) {
                AJCompilationUnit ajcu = (AJCompilationUnit)cu;
                ajcu.requestOriginalContentMode();
                try {
                    String string = member.getSource();
                    return string;
                }
                finally {
                    ajcu.discardOriginalContentMode();
                }
            }
            return member.getSource();
        }

        public String toString() {
            if (this.memberText == null) {
                return "ITDCreator(DISPOSED)";
            }
            return "ITDCreator(----\n" + this.memberText.get() + "\n" + "----)";
        }

        public void collectImports(ImportRewrite importRewrite, RefactoringStatus status) throws JavaModelException {
            IBinding binding;
            Region rangeLimit = new Region(this.memberNode.getStartPosition(), this.memberNode.getLength());
            ArrayList extraType = new ArrayList();
            ArrayList extraStatic = new ArrayList();
            ImportReferencesCollector.collect((ASTNode)this.memberNode, (IJavaProject)this.member.getJavaProject(), (Region)rangeLimit, extraType, extraStatic);
            for (Name name : extraStatic) {
                binding = name.resolveBinding();
                if (binding == null) {
                    status.addWarning("Couldn't resolve binding, imports may be incorrect", PullOutRefactoring.makeContext(this.member, (ASTNode)name));
                    continue;
                }
                this.replaceNameRef(name, importRewrite.addStaticImport(binding));
            }
            for (Name name : extraType) {
                binding = (ITypeBinding)name.resolveBinding();
                if (binding == null) {
                    status.addWarning("Couldn't resolve binding, imports may be incorrect", PullOutRefactoring.makeContext(this.member, (ASTNode)name));
                    continue;
                }
                if (binding.isParameterizedType()) {
                    binding = binding.getErasure();
                }
                this.replaceNameRef(name, importRewrite.addImport((ITypeBinding)binding));
            }
            if (this.wasIntertype()) {
                IntertypeElement ite = (IntertypeElement)this.member;
                AJCompilationUnit cfr_ignored_0 = (AJCompilationUnit)ite.getCompilationUnit();
                IType targetType = ite.findTargetType();
                String typeQName = targetType != null ? targetType.getFullyQualifiedName() : ite.getTargetName();
                this.declaringTypeRef = importRewrite.addImport(typeQName);
            } else {
                this.declaringTypeRef = importRewrite.addImport(this.member.getDeclaringType().getFullyQualifiedName());
            }
        }

        private boolean wasIntertype() {
            return this.member instanceof IntertypeElement;
        }

        private void replaceNameRef(Name name, String replaceStr) throws MalformedTreeException, JavaModelException {
            String orgRefText = name.getFullyQualifiedName();
            if (replaceStr.equals(orgRefText)) {
                return;
            }
            this.edits.addChild((TextEdit)new ReplaceEdit(name.getStartPosition() - this.memberStart(), name.getLength(), replaceStr));
        }

        private void rewriteModifiers() throws BadLocationException, MalformedTreeException, JavaModelException {
            if (this.deleteMods != 0) {
                List mods = this.memberNode.modifiers();
                String replaceText = "";
                for (Modifier modifier : mods) {
                    if ((modifier.getKeyword().toFlagValue() & this.deleteMods) == 0) continue;
                    int modStart = modifier.getStartPosition() - this.memberStart();
                    int modEnd = modStart + modifier.getLength();
                    if (Character.isWhitespace(this.memberText.getChar(modEnd))) {
                        ++modEnd;
                    }
                    this.edits.addChild((TextEdit)new ReplaceEdit(modStart, modEnd - modStart, replaceText));
                }
            }
            if (this.insertMods != null && !"".equals(this.insertMods)) {
                int insertPos;
                if (this.memberNode instanceof MethodDeclaration) {
                    MethodDeclaration methodNode = (MethodDeclaration)this.memberNode;
                    insertPos = methodNode.isConstructor() ? methodNode.getName().getStartPosition() - this.memberStart() : methodNode.getReturnType2().getStartPosition() - this.memberStart();
                } else if (this.memberNode instanceof FieldDeclaration) {
                    FieldDeclaration fieldNode = (FieldDeclaration)this.memberNode;
                    insertPos = fieldNode.getType().getStartPosition() - this.memberStart();
                } else {
                    insertPos = 0;
                }
                this.edits.addChild((TextEdit)new InsertEdit(insertPos, this.insertMods));
            }
        }

        private int memberStart() throws JavaModelException {
            return this.member.getSourceRange().getOffset();
        }

        public void removeModifier(int mod) {
            this.deleteMods |= mod;
        }

        public String createText() throws JavaModelException, MalformedTreeException, BadLocationException {
            try {
                String newline;
                int memberStart = this.memberStart();
                int memberEnd = this.memberText.getLength();
                int nameStart = this.member.getNameRange().getOffset() - memberStart;
                this.edits.addChild((TextEdit)new InsertEdit(0, CodeFormatterUtil.createIndentString((int)1, (IJavaProject)this.member.getJavaProject())));
                this.rewriteModifiers();
                if (!this.wasIntertype()) {
                    IType declaringType = this.member.getDeclaringType();
                    Assert.isNotNull((Object)this.declaringTypeRef, (String)"The declaring type name is computed by collectImports. Forgot to call it?");
                    StringBuffer typeName = new StringBuffer(this.declaringTypeRef);
                    ITypeParameter[] typeParameters = declaringType.getTypeParameters();
                    if (typeParameters != null && typeParameters.length > 0) {
                        typeName.append("<");
                        int i = 0;
                        while (i < typeParameters.length) {
                            if (i > 0) {
                                typeName.append(", ");
                            }
                            typeName.append(typeParameters[i].getElementName());
                            ++i;
                        }
                        typeName.append(">");
                    }
                    typeName.append(".");
                    this.edits.addChild((TextEdit)new InsertEdit(nameStart, typeName.toString()));
                    if (this.member instanceof IMethod && ((IMethod)this.member).isConstructor()) {
                        this.edits.addChild((TextEdit)new ReplaceEdit(nameStart, this.member.getNameRange().getLength(), "new"));
                    }
                }
                if ((newline = this.memberText.getLineDelimiter(0)) == null) {
                    newline = System.getProperty("line.separator");
                }
                this.edits.addChild((TextEdit)new InsertEdit(memberEnd, String.valueOf(newline) + newline));
                this.edits.apply(this.memberText, 0);
                String string = this.memberText.get();
                return string;
            }
            finally {
                this.dispose();
            }
        }

        private void dispose() {
            this.member = null;
            this.memberNode = null;
            this.memberText = null;
            this.edits = null;
            this.insertMods = null;
            this.declaringTypeRef = null;
        }

        public boolean wasProtected() throws JavaModelException {
            return JdtFlags.isProtected((IMember)this.member);
        }

        public boolean wasPublic() throws JavaModelException {
            return JdtFlags.isPublic((IMember)this.member);
        }

        public boolean wasPrivate() throws JavaModelException {
            return JdtFlags.isPrivate((IMember)this.member);
        }

        public boolean wasAbstract() throws JavaModelException {
            return JdtFlags.isAbstract((IMember)this.member);
        }

        public boolean wasPackageVisible() throws JavaModelException {
            return JdtFlags.isPackageVisible((IMember)this.member);
        }

        public IMember getMember() {
            return this.member;
        }

        public String getElementName() {
            return this.member.getElementName();
        }

        public ASTNode getMemberNode() {
            return this.memberNode;
        }

        public void addModifier(int modFlag) {
            if (this.isVisibilityModifier(modFlag)) {
                this.deleteMods |= 7;
            }
            Modifier.ModifierKeyword toAdd = Modifier.ModifierKeyword.fromFlagValue((int)modFlag);
            String toAddStr = toAdd.toString();
            this.removeModifier(modFlag);
            if (!this.insertMods.contains(toAddStr)) {
                this.insertMods = String.valueOf(this.insertMods) + toAddStr + " ";
            }
        }

        private boolean isVisibilityModifier(int modFlag) {
            return (modFlag & 7) != 0;
        }

        public void setBody(String bodyText) {
            Object bodyNode = this.memberNode.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY);
            Assert.isTrue((bodyNode == null ? 1 : 0) != 0, (String)("There already is a method body for this member: " + this.getMember()));
            int startPos = this.memberText.get().lastIndexOf(59);
            this.edits.addChild((TextEdit)new ReplaceEdit(startPos, 1, bodyText));
        }

        public boolean wasConstructorMethod() throws JavaModelException {
            return this.member instanceof IMethod && !this.wasIntertype() && ((IMethod)this.member).isConstructor();
        }

        public boolean hasThisCall() throws JavaModelException {
            Assert.isNotNull((Object)this.memberNode);
            Assert.isLegal((boolean)this.wasConstructorMethod());
            Block body = ((MethodDeclaration)this.memberNode).getBody();
            if (body == null) {
                return false;
            }
            List stms = body.statements();
            if (stms == null || stms.size() == 0) {
                return false;
            }
            Statement firstStm = (Statement)stms.get(0);
            if (!(firstStm instanceof ConstructorInvocation)) {
                return false;
            }
            ConstructorInvocation call = (ConstructorInvocation)firstStm;
            return call.arguments().isEmpty();
        }
    }
}

