/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.util.HashSet;
import java.util.Set;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.ast.KnownFieldReference;
import org.aspectj.ajdt.internal.compiler.lookup.AjLookupEnvironment;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeMethodBinding;
import org.aspectj.asm.internal.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.UnresolvedType;

public class SuperFixerVisitor
extends ASTVisitor {
    Set superMethodsCalled = new HashSet();
    AbstractMethodDeclaration method;
    ReferenceBinding targetClass;
    private int depthCounter = 0;
    private static final char[] ctor = "<init>".toCharArray();

    SuperFixerVisitor(AbstractMethodDeclaration method, ReferenceBinding targetClass) {
        this.method = method;
        this.targetClass = targetClass;
    }

    @Override
    public boolean visit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
        if (localTypeDeclaration.binding instanceof LocalTypeBinding && ((LocalTypeBinding)localTypeDeclaration.binding).isAnonymousType()) {
            localTypeDeclaration.binding.modifiers |= 1;
            MethodBinding[] bindings = localTypeDeclaration.binding.methods;
            if (bindings != null) {
                for (MethodBinding binding : bindings) {
                    if (!CharOperation.equals((char[])binding.selector, (char[])ctor)) continue;
                    binding.modifiers |= 1;
                }
            }
        }
        ++this.depthCounter;
        return super.visit(localTypeDeclaration, scope);
    }

    @Override
    public void endVisit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
        --this.depthCounter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endVisit(MessageSend call, BlockScope scope) {
        if (call.binding == null) {
            return;
        }
        MethodBinding superBinding = call.binding;
        if (superBinding instanceof ProblemMethodBinding) {
            return;
        }
        if (superBinding instanceof InterTypeMethodBinding) {
            return;
        }
        if (superBinding instanceof ParameterizedMethodBinding) {
            superBinding = ((ParameterizedMethodBinding)superBinding).original();
        }
        EclipseFactory factory = ((AjLookupEnvironment)this.method.scope.environment()).factory;
        if (this.depthCounter != 0 && this.targetClass.isInterface()) {
            if (!call.isSuperAccess() || call.binding.isStatic()) return;
            MethodScope currentMethodScope = scope.methodScope();
            SourceTypeBinding sourceType = currentMethodScope.enclosingSourceType();
            FieldBinding field = sourceType.addSyntheticFieldForInnerclass(this.targetClass);
            call.receiver = new KnownFieldReference(field, call.receiver.sourceStart, call.receiver.sourceEnd);
        } else {
            char[] accessName;
            if (this.depthCounter != 0) return;
            if (call.isSuperAccess() && !call.binding.isStatic()) {
                call.receiver = new ThisReference(call.receiver.sourceStart, call.receiver.sourceEnd);
                accessName = NameMangler.superDispatchMethod((UnresolvedType)factory.fromBinding(this.targetClass), (String)new String(superBinding.selector)).toCharArray();
            } else {
                if (!call.receiver.isThis() || !call.binding.isProtected() || call.binding.isStatic()) return;
                ReferenceBinding superBindingDeclaringClass = superBinding.declaringClass;
                if (superBindingDeclaringClass.isParameterizedType()) {
                    superBindingDeclaringClass = ((ParameterizedTypeBinding)superBindingDeclaringClass).type;
                }
                accessName = superBindingDeclaringClass.equals(this.targetClass) ? NameMangler.protectedDispatchMethod((UnresolvedType)factory.fromBinding(this.targetClass), (String)new String(superBinding.selector)).toCharArray() : NameMangler.superDispatchMethod((UnresolvedType)factory.fromBinding(this.targetClass), (String)new String(superBinding.selector)).toCharArray();
            }
            MethodBinding superAccessBinding = new MethodBinding(1, accessName, superBinding.returnType, superBinding.parameters, superBinding.thrownExceptions, this.targetClass);
            AstUtil.replaceMethodBinding(call, superAccessBinding);
        }
        ResolvedMemberImpl targetMember = null;
        targetMember = superBinding.declaringClass.isParameterizedType() ? factory.makeResolvedMember(superBinding, (TypeBinding)((ParameterizedTypeBinding)superBinding.declaringClass).genericType()) : factory.makeResolvedMember(superBinding);
        this.superMethodsCalled.add(targetMember);
    }
}

