/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.problem;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.ast.AdviceDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.DeclareAnnotationDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.IfMethodDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.Proceed;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeMethodBinding;
import org.aspectj.ajdt.internal.compiler.lookup.PrivilegedFieldBinding;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.compiler.IProblem;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.aspectj.org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.IPrivilegedHandler;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.DeclareAnnotation;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.DeclareSoft;
import org.aspectj.weaver.patterns.TypePattern;

public class AjProblemReporter
extends ProblemReporter {
    private static final boolean DUMP_STACK = false;
    public EclipseFactory factory;
    private static final char[] thisJoinPointName = "thisJoinPoint".toCharArray();
    private static final char[] thisJoinPointStaticPartName = "thisJoinPointStaticPart".toCharArray();
    private static final char[] thisEnclosingJoinPointStaticPartName = "thisEnclosingJoinPointStaticPart".toCharArray();
    private static final char[] thisAspectInstanceName = "thisAspectInstance".toCharArray();

    public AjProblemReporter(IErrorHandlingPolicy policy, CompilerOptions options, IProblemFactory problemFactory) {
        super(policy, options, problemFactory);
    }

    @Override
    public void unhandledException(TypeBinding exceptionType, ASTNode location) {
        if (!this.factory.getWorld().getDeclareSoft().isEmpty()) {
            Shadow callSite = this.factory.makeShadow(location, this.referenceContext);
            Shadow enclosingExec = this.factory.makeShadow(this.referenceContext);
            if (callSite == null && enclosingExec.getKind() == Shadow.ConstructorExecution && location instanceof ExplicitConstructorCall) {
                super.unhandledException(exceptionType, location);
                return;
            }
            for (DeclareSoft d : this.factory.getWorld().getDeclareSoft()) {
                FuzzyBoolean match;
                ResolvedType throwException = this.factory.fromEclipse((ReferenceBinding)exceptionType);
                FuzzyBoolean isExceptionTypeOrSubtype = d.getException().matchesInstanceof(throwException);
                if (!isExceptionTypeOrSubtype.alwaysTrue()) continue;
                if (callSite != null) {
                    match = d.getPointcut().match(callSite);
                    if (match.alwaysTrue()) {
                        return;
                    }
                    if (!match.alwaysFalse()) {
                        // empty if block
                    }
                }
                if (enclosingExec == null) continue;
                match = d.getPointcut().match(enclosingExec);
                if (match.alwaysTrue()) {
                    return;
                }
                if (match.alwaysFalse()) continue;
            }
        }
        if (location instanceof Proceed) {
            return;
        }
        super.unhandledException(exceptionType, location);
    }

    @Override
    public void unhandledExceptionFromAutoClose(TypeBinding exceptionType, ASTNode location) {
        if (!this.factory.getWorld().getDeclareSoft().isEmpty()) {
            Shadow callSite = this.factory.makeShadow(location, this.referenceContext);
            Shadow enclosingExec = this.factory.makeShadow(this.referenceContext);
            if (callSite == null && enclosingExec.getKind() == Shadow.ConstructorExecution && location instanceof ExplicitConstructorCall) {
                super.unhandledException(exceptionType, location);
                return;
            }
            for (DeclareSoft d : this.factory.getWorld().getDeclareSoft()) {
                FuzzyBoolean match;
                ResolvedType throwException = this.factory.fromEclipse((ReferenceBinding)exceptionType);
                FuzzyBoolean isExceptionTypeOrSubtype = d.getException().matchesInstanceof(throwException);
                if (!isExceptionTypeOrSubtype.alwaysTrue()) continue;
                if (callSite != null) {
                    match = d.getPointcut().match(callSite);
                    if (match.alwaysTrue()) {
                        return;
                    }
                    if (!match.alwaysFalse()) {
                        // empty if block
                    }
                }
                if (enclosingExec == null) continue;
                match = d.getPointcut().match(enclosingExec);
                if (match.alwaysTrue()) {
                    return;
                }
                if (match.alwaysFalse()) continue;
            }
        }
        if (location instanceof Proceed) {
            return;
        }
        super.unhandledExceptionFromAutoClose(exceptionType, location);
    }

    private boolean isPointcutDeclaration(MethodBinding binding) {
        return CharOperation.prefixEquals(PointcutDeclaration.mangledPrefix, binding.selector);
    }

    private boolean isIntertypeDeclaration(MethodBinding binding) {
        return binding instanceof InterTypeMethodBinding;
    }

    @Override
    public void abstractMethodCannotBeOverridden(SourceTypeBinding type, MethodBinding concreteMethod) {
        if (this.isPointcutDeclaration(concreteMethod)) {
            return;
        }
        super.abstractMethodCannotBeOverridden(type, concreteMethod);
    }

    @Override
    public void inheritedMethodReducesVisibility(SourceTypeBinding type, MethodBinding concreteMethod, MethodBinding[] abstractMethods) {
        ResolvedType onTypeX = null;
        onTypeX = !type.isAnonymousType() ? this.factory.fromEclipse(type) : this.factory.fromEclipse(type.superclass());
        for (ConcreteTypeMunger m : onTypeX.getInterTypeMungersIncludingSupers()) {
            ResolvedMember sig = m.getSignature();
            if (Modifier.isAbstract(sig.getModifiers()) || !ResolvedType.matches((Member)AjcMemberMaker.interMethod((ResolvedMember)sig, (UnresolvedType)m.getAspectType(), (boolean)sig.getDeclaringType().resolve(this.factory.getWorld()).isInterface()), (Member)this.factory.makeResolvedMember(concreteMethod))) continue;
            return;
        }
        super.inheritedMethodReducesVisibility(type, concreteMethod, abstractMethods);
    }

    @Override
    public void staticAndInstanceConflict(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (currentMethod instanceof InterTypeMethodBinding) {
            return;
        }
        if (inheritedMethod instanceof InterTypeMethodBinding) {
            return;
        }
        super.staticAndInstanceConflict(currentMethod, inheritedMethod);
    }

    @Override
    public void abstractMethodMustBeImplemented(SourceTypeBinding type, MethodBinding abstractMethod) {
        if (this.isPointcutDeclaration(abstractMethod)) {
            return;
        }
        if (this.isIntertypeDeclaration(abstractMethod)) {
            return;
        }
        if (CharOperation.prefixEquals("ajc$interField".toCharArray(), abstractMethod.selector)) {
            return;
        }
        ResolvedType onTypeX = null;
        onTypeX = !type.isAnonymousType() ? this.factory.fromEclipse(type) : this.factory.fromEclipse(type.superclass());
        if (onTypeX.isRawType()) {
            onTypeX = onTypeX.getGenericType();
        }
        List mungers = onTypeX.getInterTypeMungersIncludingSupers();
        for (ConcreteTypeMunger m : mungers) {
            ResolvedMember sig = m.getSignature();
            if (sig == null || Modifier.isAbstract(sig.getModifiers())) continue;
            ResolvedMemberImpl abstractMember = this.factory.makeResolvedMember(abstractMethod);
            if (abstractMember.getName().startsWith("ajc$interMethodDispatch")) {
                ResolvedType dType = this.factory.getWorld().resolve(sig.getDeclaringType(), false);
                if (!ResolvedType.matches((Member)AjcMemberMaker.interMethod((ResolvedMember)sig, (UnresolvedType)m.getAspectType(), (boolean)dType.isInterface()), (Member)abstractMember)) continue;
                return;
            }
            if (!ResolvedType.matches((Member)sig, (Member)this.factory.makeResolvedMember(abstractMethod))) continue;
            return;
        }
        super.abstractMethodMustBeImplemented(type, abstractMethod);
    }

    @Override
    public void disallowedTargetForAnnotation(Annotation annotation) {
        if (annotation.recipient instanceof MethodBinding) {
            MethodBinding binding = (MethodBinding)annotation.recipient;
            String name = new String(binding.selector);
            if (name.startsWith("ajc$")) {
                long metaTagBits = annotation.resolvedType.getAnnotationTagBits();
                if (name.contains("interField") ? (metaTagBits & 0x2000000000L) != 0L : (name.contains("interConstructor") ? (metaTagBits & 0x10000000000L) != 0L : (name.contains("interMethod") ? (metaTagBits & 0x4000000000L) != 0L : (name.contains("declare_" + DeclareAnnotation.AT_TYPE + "_") ? (metaTagBits & 0x40000000000L) != 0L || (metaTagBits & 0x1000000000L) != 0L : (name.contains("declare_" + DeclareAnnotation.AT_FIELD + "_") ? (metaTagBits & 0x2000000000L) != 0L : (name.contains("declare_" + DeclareAnnotation.AT_CONSTRUCTOR + "_") ? (metaTagBits & 0x10000000000L) != 0L : name.contains("declare_eow") && (metaTagBits & 0x2000000000L) != 0L)))))) {
                    return;
                }
            }
        }
        super.disallowedTargetForAnnotation(annotation);
    }

    @Override
    public void overridesPackageDefaultMethod(MethodBinding localMethod, MethodBinding inheritedMethod) {
        if (new String(localMethod.selector).startsWith("ajc$")) {
            return;
        }
        super.overridesPackageDefaultMethod(localMethod, inheritedMethod);
    }

    public void handle(int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, ReferenceContext referenceContext, CompilationResult unitResult) {
        if (severity != 256) {
            // empty if block
        }
        super.handle(problemId, problemArguments, 0, messageArguments, severity, problemStartPosition, problemEndPosition, referenceContext, unitResult);
    }

    @Override
    public void javadocMissingParamTag(char[] name, int sourceStart, int sourceEnd, int modifiers) {
        boolean reportIt = true;
        String sName = new String(name);
        if (sName.startsWith("ajc$")) {
            reportIt = false;
        }
        if (sName.equals("thisJoinPoint")) {
            reportIt = false;
        }
        if (sName.equals("thisJoinPointStaticPart")) {
            reportIt = false;
        }
        if (sName.equals("thisEnclosingJoinPointStaticPart")) {
            reportIt = false;
        }
        if (sName.equals("ajc_aroundClosure")) {
            reportIt = false;
        }
        if (reportIt) {
            super.javadocMissingParamTag(name, sourceStart, sourceEnd, modifiers);
        }
    }

    @Override
    public void abstractMethodInAbstractClass(SourceTypeBinding type, AbstractMethodDeclaration methodDecl) {
        String abstractMethodName = new String(methodDecl.selector);
        if (abstractMethodName.startsWith("ajc$pointcut")) {
            return;
        }
        String[] arguments = new String[]{new String(type.sourceName()), abstractMethodName};
        super.handle(67109227, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd, this.referenceContext, this.referenceContext == null ? null : this.referenceContext.compilationResult());
    }

    public void itdMethodMustOverride(AbstractMethodDeclaration method, MethodBinding binding) {
        this.handle(67109487, new String[]{new String(binding.selector), this.typesAsString(binding.isVarargs(), binding.parameters, false), new String(binding.declaringClass.readableName())}, new String[]{new String(binding.selector), this.typesAsString(binding.isVarargs(), binding.parameters, true), new String(binding.declaringClass.shortReadableName())}, method.sourceStart, method.sourceEnd, this.referenceContext, this.referenceContext == null ? null : this.referenceContext.compilationResult());
    }

    @Override
    public void methodMustOverride(AbstractMethodDeclaration method, long complianceLevel) {
        if (new String(method.selector).startsWith("ajc$")) {
            return;
        }
        ResolvedMemberImpl possiblyErroneousRm = this.factory.makeResolvedMember(method.binding);
        ResolvedType onTypeX = this.factory.fromEclipse(method.binding.declaringClass);
        for (ResolvedType supertypeToLookAt = onTypeX.getSuperclass(); supertypeToLookAt != null; supertypeToLookAt = supertypeToLookAt.getSuperclass()) {
            List itMungers = supertypeToLookAt.getInterTypeMungers();
            for (ConcreteTypeMunger m : itMungers) {
                UnresolvedType dType;
                ResolvedMember sig;
                if (m.getMunger() != null && m.getMunger().getKind() == ResolvedTypeMunger.PrivilegedAccess || (sig = m.getSignature()) == null || (dType = sig.getDeclaringType()) == null) continue;
                ResolvedType resolvedDeclaringType = dType.resolve(this.factory.getWorld());
                ResolvedMember rm = AjcMemberMaker.interMethod((ResolvedMember)sig, (UnresolvedType)m.getAspectType(), (boolean)resolvedDeclaringType.isInterface());
                if (!ResolvedType.matches((Member)rm, (Member)possiblyErroneousRm)) continue;
                return;
            }
        }
        super.methodMustOverride(method, complianceLevel);
    }

    private String typesAsString(boolean isVarargs, TypeBinding[] types, boolean makeShort) {
        StringBuilder buffer = new StringBuilder(10);
        int length = types.length;
        for (int i = 0; i < length; ++i) {
            boolean isVarargType;
            if (i != 0) {
                buffer.append(", ");
            }
            TypeBinding type = types[i];
            boolean bl = isVarargType = isVarargs && i == length - 1;
            if (isVarargType) {
                type = ((ArrayBinding)type).elementsType();
            }
            buffer.append(new String(makeShort ? type.shortReadableName() : type.readableName()));
            if (!isVarargType) continue;
            buffer.append("...");
        }
        return buffer.toString();
    }

    @Override
    public void visibilityConflict(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (this.isIntertypeDeclaration(currentMethod) && this.isIntertypeDeclaration(inheritedMethod) && Modifier.isPrivate(currentMethod.modifiers) && Modifier.isPrivate(inheritedMethod.modifiers)) {
            return;
        }
        super.visibilityConflict(currentMethod, inheritedMethod);
    }

    @Override
    public void unusedPrivateType(TypeDeclaration typeDecl) {
        if (typeDecl instanceof AspectDeclaration) {
            return;
        }
        if (typeDecl.enclosingType != null && typeDecl.enclosingType instanceof AspectDeclaration) {
            AspectDeclaration ad = (AspectDeclaration)typeDecl.enclosingType;
            if (ad.concreteName != null) {
                List<Declare> declares = ad.concreteName.declares;
                for (Declare dec : declares) {
                    TypePattern[] newparents;
                    if (!(dec instanceof DeclareParents)) continue;
                    DeclareParents decp = (DeclareParents)dec;
                    for (TypePattern pattern : newparents = decp.getParents().getTypePatterns()) {
                        UnresolvedType ut = pattern.getExactType();
                        if (ut == null || CharOperation.compareWith(typeDecl.binding.signature(), ut.getSignature().toCharArray()) != 0) continue;
                        return;
                    }
                }
            }
        }
        super.unusedPrivateType(typeDecl);
    }

    @Override
    public void uninitializedLocalVariable(LocalVariableBinding binding, ASTNode location, Scope scope) {
        if ((CharOperation.equals(binding.name, thisJoinPointName) || CharOperation.equals(binding.name, thisJoinPointStaticPartName) || CharOperation.equals(binding.name, thisAspectInstanceName) || CharOperation.equals(binding.name, thisEnclosingJoinPointStaticPartName)) && binding.declaringScope != null && (binding.declaringScope.referenceContext() instanceof AdviceDeclaration || binding.declaringScope.referenceContext() instanceof IfMethodDeclaration)) {
            return;
        }
        super.uninitializedLocalVariable(binding, location, scope);
    }

    @Override
    public void abstractMethodInConcreteClass(SourceTypeBinding type) {
        if (type.scope != null && type.scope.referenceContext instanceof AspectDeclaration) {
            return;
        }
        super.abstractMethodInConcreteClass(type);
    }

    @Override
    public void unusedPrivateField(FieldDeclaration fieldDecl) {
        if (fieldDecl != null && fieldDecl.binding != null && fieldDecl.binding.declaringClass != null) {
            ReferenceBinding type = fieldDecl.binding.declaringClass;
            ResolvedType weaverType = null;
            weaverType = !type.isAnonymousType() ? this.factory.fromEclipse(type) : this.factory.fromEclipse(type.superclass());
            HashSet<ResolvedType> checked = new HashSet<ResolvedType>();
            for (ConcreteTypeMunger m : weaverType.getInterTypeMungersIncludingSupers()) {
                ResolvedType theAspect = m.getAspectType();
                if (checked.contains(theAspect)) continue;
                TypeBinding tb = this.factory.makeTypeBinding((UnresolvedType)m.getAspectType());
                if (tb instanceof SourceTypeBinding) {
                    IPrivilegedHandler privilegedHandler = ((SourceTypeBinding)tb).privilegedHandler;
                    if (privilegedHandler != null) {
                        if (privilegedHandler.definesPrivilegedAccessToField(fieldDecl.binding)) {
                            return;
                        }
                    } else if (theAspect instanceof ReferenceType) {
                        String fname = new String(fieldDecl.name);
                        Collection privvies = ((ReferenceType)theAspect).getPrivilegedAccesses();
                        if (privvies != null) {
                            for (Object privvy : privvies) {
                                ResolvedMember priv = (ResolvedMember)privvy;
                                if (!priv.getName().equals(fname)) continue;
                                return;
                            }
                        }
                    }
                }
                checked.add(theAspect);
            }
        }
        super.unusedPrivateField(fieldDecl);
    }

    @Override
    public void unusedPrivateMethod(AbstractMethodDeclaration methodDecl) {
        if (!(methodDecl instanceof PointcutDeclaration)) {
            super.unusedPrivateMethod(methodDecl);
        }
    }

    @Override
    public void caseExpressionMustBeConstant(Expression expression) {
        if (expression instanceof QualifiedNameReference) {
            QualifiedNameReference qnr = (QualifiedNameReference)expression;
            if (qnr.otherBindings != null && qnr.otherBindings.length > 0 && qnr.otherBindings[0] instanceof PrivilegedFieldBinding) {
                super.signalError(expression.sourceStart, expression.sourceEnd, "Fields accessible due to an aspect being privileged can not be used in switch statements");
                this.referenceContext.tagAsHavingErrors();
                return;
            }
        }
        super.caseExpressionMustBeConstant(expression);
    }

    @Override
    public void unusedArgument(LocalDeclaration localDecl) {
        String argType = new String(localDecl.type.resolvedType.signature());
        if (argType.startsWith("Lorg/aspectj/runtime/internal")) {
            return;
        }
        if (localDecl instanceof Argument) {
            ReferenceContext context;
            Argument arg = (Argument)localDecl;
            if (arg.binding != null && arg.binding.declaringScope != null && (context = arg.binding.declaringScope.referenceContext()) != null && context instanceof PointcutDeclaration) {
                return;
            }
        }
        if (new String(localDecl.name).startsWith("ajc$")) {
            return;
        }
        super.unusedArgument(localDecl);
    }

    @Override
    public void finalMethodCannotBeOverridden(MethodBinding currentMethod, MethodBinding inheritedMethod) {
        if (currentMethod == inheritedMethod) {
            return;
        }
        super.finalMethodCannotBeOverridden(currentMethod, inheritedMethod);
    }

    @Override
    public void duplicateInheritedMethods(SourceTypeBinding type, MethodBinding inheritedMethod1, MethodBinding inheritedMethod2, boolean isJava8) {
        if (inheritedMethod1 instanceof InterTypeMethodBinding || inheritedMethod2 instanceof InterTypeMethodBinding) {
            return;
        }
        if (inheritedMethod1 instanceof ParameterizedMethodBinding && ((ParameterizedMethodBinding)inheritedMethod1).original() instanceof InterTypeMethodBinding) {
            return;
        }
        if (inheritedMethod2 instanceof ParameterizedMethodBinding && ((ParameterizedMethodBinding)inheritedMethod2).original() instanceof InterTypeMethodBinding) {
            return;
        }
        super.duplicateInheritedMethods(type, inheritedMethod1, inheritedMethod2, isJava8);
    }

    public IProblem createProblem(char[] fileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, int lineNumber) {
        IProblem problem = super.createProblem(fileName, problemId, problemArguments, messageArguments, severity, problemStartPosition, problemEndPosition, lineNumber, 0);
        if (this.factory.getWorld().isInPinpointMode()) {
            MessageIssued ex = new MessageIssued();
            ex.fillInStackTrace();
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            StringBuilder sb = new StringBuilder();
            sb.append(CompilationAndWeavingContext.getCurrentContext());
            sb.append(sw.toString());
            problem = new PinpointedProblem(problem, sb.toString());
        }
        return problem;
    }

    @Override
    public void duplicateMethodInType(AbstractMethodDeclaration methodDecl, boolean equalParameters, int severity) {
        if (new String(methodDecl.selector).startsWith("ajc$interMethod")) {
            return;
        }
        super.duplicateMethodInType(methodDecl, equalParameters, severity);
    }

    @Override
    public void parseErrorInsertAfterToken(int start, int end, int currentKind, char[] errorTokenSource, String errorTokenName, String expectedToken) {
        if (expectedToken.equals("privileged") || expectedToken.equals("around")) {
            super.parseErrorNoSuggestion(start, end, currentKind, errorTokenSource, errorTokenName);
        } else {
            super.parseErrorInsertAfterToken(start, end, currentKind, errorTokenSource, errorTokenName, expectedToken);
        }
    }

    @Override
    public void missingValueForAnnotationMember(Annotation annotation, char[] memberName) {
        if (this.referenceContext instanceof DeclareAnnotationDeclaration && ((DeclareAnnotationDeclaration)this.referenceContext).isRemover()) {
            return;
        }
        super.missingValueForAnnotationMember(annotation, memberName);
    }

    private static class PinpointedProblem
    implements IProblem {
        private IProblem delegate;
        private String message;

        public PinpointedProblem(IProblem aProblem, String pinpoint) {
            this.delegate = aProblem;
            this.message = !this.delegate.getMessage().contains("message issued...") ? this.delegate.getMessage() + "\n" + pinpoint : this.delegate.getMessage();
        }

        @Override
        public String[] getArguments() {
            return this.delegate.getArguments();
        }

        @Override
        public int getID() {
            return this.delegate.getID();
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public char[] getOriginatingFileName() {
            return this.delegate.getOriginatingFileName();
        }

        @Override
        public int getSourceEnd() {
            return this.delegate.getSourceEnd();
        }

        @Override
        public int getSourceLineNumber() {
            return this.delegate.getSourceLineNumber();
        }

        @Override
        public int getSourceStart() {
            return this.delegate.getSourceStart();
        }

        @Override
        public boolean isError() {
            return this.delegate.isError();
        }

        @Override
        public boolean isWarning() {
            return this.delegate.isWarning();
        }

        @Override
        public void setSourceEnd(int sourceEnd) {
            this.delegate.setSourceEnd(sourceEnd);
        }

        @Override
        public void setSourceLineNumber(int lineNumber) {
            this.delegate.setSourceLineNumber(lineNumber);
        }

        @Override
        public void setSourceStart(int sourceStart) {
            this.delegate.setSourceStart(sourceStart);
        }

        @Override
        public void setSeeAlsoProblems(IProblem[] problems) {
            this.delegate.setSeeAlsoProblems(problems);
        }

        @Override
        public IProblem[] seeAlso() {
            return this.delegate.seeAlso();
        }

        @Override
        public void setSupplementaryMessageInfo(String msg) {
            this.delegate.setSupplementaryMessageInfo(msg);
        }

        @Override
        public String getSupplementaryMessageInfo() {
            return this.delegate.getSupplementaryMessageInfo();
        }

        @Override
        public boolean isInfo() {
            return this.delegate.isInfo();
        }
    }

    private static class MessageIssued
    extends RuntimeException {
        private MessageIssued() {
        }

        @Override
        public String getMessage() {
            return "message issued...";
        }
    }
}

