/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.WorkingCopyOwner;
import org.aspectj.org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.aspectj.org.eclipse.jdt.internal.core.INameEnvironmentWithProgress;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.NameLookup;
import org.aspectj.org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class CancelableNameEnvironment
extends SearchableEnvironment
implements INameEnvironmentWithProgress {
    private IProgressMonitor monitor;

    public CancelableNameEnvironment(JavaProject project, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        this(project, owner, monitor, false);
    }

    public CancelableNameEnvironment(JavaProject project, WorkingCopyOwner owner, IProgressMonitor monitor, boolean excludeTestCode) throws JavaModelException {
        super(project, owner, excludeTestCode);
        this.setMonitor(monitor);
    }

    private void checkCanceled() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            if (NameLookup.VERBOSE) {
                System.out.println(Thread.currentThread() + " CANCELLING LOOKUP ");
            }
            throw new AbortCompilation(true, (RuntimeException)((Object)new OperationCanceledException()));
        }
    }

    @Override
    public void findPackages(char[] prefix, ISearchRequestor requestor) {
        this.checkCanceled();
        super.findPackages(prefix, requestor);
    }

    @Override
    public NameEnvironmentAnswer findType(char[] name, char[][] packageName) {
        this.checkCanceled();
        return super.findType(name, packageName);
    }

    @Override
    public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
        this.checkCanceled();
        return super.findType(compoundTypeName);
    }

    @Override
    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, boolean searchWithSecondaryTypes, char[] moduleName) {
        return this.findType(typeName, packageName, moduleName);
    }

    @Override
    public void findTypes(char[] prefix, boolean findMembers, int matchRule, int searchFor, ISearchRequestor storage, IProgressMonitor progressMonitor) {
        this.checkCanceled();
        super.findTypes(prefix, findMembers, matchRule, searchFor, storage, progressMonitor);
    }

    @Override
    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

