/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.java.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;
import org.aspectj.org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.JrtPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.ModularClassFile;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.model.BinaryModuleDescriptor;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.model.BinaryTypeFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public class BinaryModuleFactory {
    public static BinaryModuleDescriptor createDescriptor(ModularClassFile modularClassFile) {
        return BinaryModuleFactory.createDescriptor(modularClassFile.getPackageFragmentRoot(), modularClassFile);
    }

    private static BinaryModuleDescriptor createDescriptor(PackageFragmentRoot root, ModularClassFile classFile) {
        String indexPath;
        IPath location = BinaryTypeFactory.getLocationForElement(root);
        if (location == null) {
            return null;
        }
        String entryName = "module-info.class";
        IPath workspacePath = root.getPath();
        char[] moduleName = null;
        if (root instanceof JarPackageFragmentRoot) {
            entryName = ((JarPackageFragmentRoot)root).getClassFilePath(entryName);
            indexPath = String.valueOf(root.getHandleIdentifier()) + '|' + entryName;
            if (root instanceof JrtPackageFragmentRoot) {
                moduleName = root.getElementName().toCharArray();
            }
        } else {
            location = location.append(entryName);
            indexPath = workspacePath.append(entryName).toString();
            workspacePath = classFile.resource().getFullPath();
        }
        return new BinaryModuleDescriptor(location.toString().toCharArray(), moduleName, workspacePath.toString().toCharArray(), indexPath.toCharArray());
    }

    public static IBinaryModule readModule(BinaryModuleDescriptor descriptor, IProgressMonitor monitor) throws JavaModelException, ClassFormatException {
        return BinaryModuleFactory.rawReadModule(descriptor, true);
    }

    public static IBinaryModule rawReadModule(BinaryModuleDescriptor descriptor, boolean fullyInitialize) throws JavaModelException, ClassFormatException {
        try {
            return BinaryModuleFactory.rawReadModuleTestForExists(descriptor, fullyInitialize, true);
        }
        catch (FileNotFoundException e) {
            throw new JavaModelException(e, 985);
        }
    }

    public static IBinaryModule rawReadModuleTestForExists(BinaryModuleDescriptor descriptor, boolean fullyInitialize, boolean useInvalidArchiveCache) throws JavaModelException, ClassFormatException, FileNotFoundException {
        ZipFile zip;
        block21: {
            byte[] contents;
            if (descriptor == null) {
                return null;
            }
            if (descriptor.isInJarFile()) {
                zip = null;
                try {
                    byte[] contents2;
                    zip = JavaModelManager.getJavaModelManager().getZipFile((IPath)new Path(new String(descriptor.workspacePath)), useInvalidArchiveCache);
                    String entryName = "module-info.class";
                    ZipEntry ze = zip.getEntry(entryName);
                    if (ze == null) break block21;
                    try {
                        contents2 = Util.getZipEntryByteContent(ze, zip);
                    }
                    catch (IOException ioe) {
                        throw new JavaModelException(ioe, 985);
                    }
                    ClassFileReader classFileReader = new ClassFileReader(contents2, descriptor.indexPath, fullyInitialize);
                    IBinaryModule iBinaryModule = classFileReader.getModuleDeclaration();
                    JavaModelManager.getJavaModelManager().closeZipFile(zip);
                    return iBinaryModule;
                }
                catch (CoreException e) {
                    try {
                        throw new JavaModelException(e);
                    }
                    catch (Throwable throwable) {
                        JavaModelManager.getJavaModelManager().closeZipFile(zip);
                        throw throwable;
                    }
                }
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(new String(descriptor.workspacePath)));
            try {
                Throwable ze = null;
                Object contents22 = null;
                try (InputStream stream = file.getContents(true);){
                    contents = Util.getInputStreamAsByteArray(stream);
                }
                catch (Throwable contents22) {
                    if (ze == null) {
                        ze = contents22;
                    } else if (ze != contents22) {
                        ze.addSuppressed(contents22);
                    }
                    throw ze;
                }
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                if (status.getCode() == 368) {
                    throw new FileNotFoundException();
                }
                throw new JavaModelException(e);
            }
            catch (IOException e) {
                throw new JavaModelException(e, 985);
            }
            ClassFileReader classFileReader = new ClassFileReader(contents, file.getFullPath().toString().toCharArray(), fullyInitialize);
            return classFileReader.getModuleDeclaration();
        }
        JavaModelManager.getJavaModelManager().closeZipFile(zip);
        return null;
    }
}

