/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.codeconversion;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.org.eclipse.jdt.core.dom.ASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.AjASTVisitor;
import org.aspectj.org.eclipse.jdt.core.dom.AnyWithAnnotationTypePattern;
import org.aspectj.org.eclipse.jdt.core.dom.BodyDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.DeclareAnnotationDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.DeclareParentsDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.IdentifierTypePattern;
import org.aspectj.org.eclipse.jdt.core.dom.PatternNode;
import org.aspectj.org.eclipse.jdt.core.dom.SignaturePattern;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleName;
import org.aspectj.org.eclipse.jdt.core.dom.TypeCategoryTypePattern;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.ReflectionUtils;
import org.eclipse.ajdt.core.javaelements.PointcutUtilities;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.SourceIndexer;
import org.eclipse.jdt.internal.core.search.indexing.SourceIndexerRequestor;

public class AJSourceIndexerRequestor
extends SourceIndexerRequestor {
    private SourceIndexer indexer;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_4;

    public AJSourceIndexerRequestor(SourceIndexer indexer) {
        super(indexer);
        this.indexer = indexer;
    }

    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        block16: {
            super.enterField(fieldInfo);
            try {
                char[] fieldName = fieldInfo.name;
                char[] fieldType = fieldInfo.type;
                int last = CharOperation.lastIndexOf((char)'$', (char[])fieldName) + 1;
                if (this.maybeDeclare(fieldName, fieldType)) {
                    try {
                        char[] contents = this.getContents();
                        BodyDeclaration node = PointcutUtilities.createSingleBodyDeclarationNode(fieldInfo.declarationStart, this.getSourceEnd(fieldInfo), contents);
                        if (node instanceof DeclareParentsDeclaration) {
                            DeclareParentsDeclaration declare = (DeclareParentsDeclaration)node;
                            AjASTVisitor typePatternVisitor = new AjASTVisitor(){

                                protected void index(String tokenString) {
                                    char[][] tokens;
                                    char[][] cArray = tokens = AJSourceIndexerRequestor.this.tokenize(tokenString);
                                    int n = tokens.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        char[] token = cArray[n2];
                                        AJSourceIndexerRequestor.super.acceptUnknownReference(token, 0);
                                        ++n2;
                                    }
                                }

                                public boolean visit(IdentifierTypePattern node) {
                                    this.index(node.getTypePatternExpression());
                                    return true;
                                }

                                public boolean visit(AnyWithAnnotationTypePattern node) {
                                    this.index(node.getTypePatternExpression());
                                    return true;
                                }

                                public boolean visit(TypeCategoryTypePattern node) {
                                    this.index(node.getTypePatternExpression());
                                    return true;
                                }

                                public boolean visit(SignaturePattern node) {
                                    this.index(node.getDetail());
                                    return true;
                                }
                            };
                            declare.accept((ASTVisitor)typePatternVisitor);
                        } else if (node instanceof DeclareAnnotationDeclaration) {
                            PatternNode targetPattern;
                            DeclareAnnotationDeclaration declare = (DeclareAnnotationDeclaration)node;
                            SimpleName annotationName = declare.getAnnotationName();
                            if (annotationName != null) {
                                String annotationStr = annotationName.toString();
                                if (annotationStr.startsWith("@")) {
                                    annotationStr = annotationStr.substring(1, annotationStr.length());
                                }
                                char[][] splitChars = CharOperation.splitOn((char)'.', (char[])annotationStr.toCharArray());
                                super.acceptTypeReference(splitChars, annotationName.getStartPosition(), annotationName.getStartPosition() + annotationName.getLength());
                            }
                            if ((targetPattern = declare.getPatternNode()) instanceof IdentifierTypePattern) {
                                String detail = ((IdentifierTypePattern)targetPattern).getTypePatternExpression();
                                char[][] tokens = detail != null ? CharOperation.splitOn((char)'.', (char[])detail.toCharArray()) : null;
                                super.acceptTypeReference(tokens, targetPattern.getStartPosition(), targetPattern.getStartPosition() + targetPattern.getLength());
                            } else if (targetPattern instanceof SignaturePattern) {
                                char[][] tokens;
                                char[][] cArray = tokens = this.tokenize(((SignaturePattern)targetPattern).getDetail());
                                int n = tokens.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    char[] token = cArray[n2];
                                    super.acceptUnknownReference(token, targetPattern.getStartPosition());
                                    ++n2;
                                }
                            }
                        }
                        break block16;
                    }
                    catch (Exception exception) {
                        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    }
                    break block16;
                }
                if (this.maybeITD(fieldName, last)) {
                    char[][] splits = CharOperation.splitAndTrimOn((char)'$', (char[])fieldName);
                    int length = splits.length;
                    this.indexer.addFieldDeclaration(fieldInfo.type, splits[splits.length - 1]);
                    if (length > 1) {
                        char[][] newSplits = new char[splits.length - 1][];
                        System.arraycopy(splits, 0, newSplits, 0, splits.length - 1);
                        super.acceptUnknownReference((char[][])newSplits, fieldInfo.nameSourceStart, fieldInfo.nameSourceEnd - splits[length - 1].length - 1);
                    }
                }
            }
            catch (Exception exception) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
            }
        }
    }

    private int getSourceEnd(ISourceElementRequestor.FieldInfo fieldInfo) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field f = fieldInfo.getClass().getDeclaredField("node");
        ASTNode node = (ASTNode)f.get(fieldInfo);
        return node.sourceEnd;
    }

    private char[] getContents() {
        SearchDocument searchDocument = (SearchDocument)ReflectionUtils.getPrivateField(AbstractIndexer.class, "document", this.indexer);
        if (searchDocument != null) {
            return searchDocument.getCharContents();
        }
        return new char[0];
    }

    private char[][] tokenize(String detail) {
        if (detail == null) {
            return CharOperation.NO_CHAR_CHAR;
        }
        Map<String, List<Integer>> allIds = PointcutUtilities.findAllIdentifiers(detail);
        char[][] tokens = new char[allIds.size()][];
        int i = 0;
        for (String token : allIds.keySet()) {
            tokens[i++] = token.toCharArray();
        }
        return tokens;
    }

    private boolean maybeDeclare(char[] fieldName, char[] fieldType) {
        return CharOperation.equals((char[])"declare".toCharArray(), (char[])fieldType) && (CharOperation.equals((char[])"parents".toCharArray(), (char[])fieldName) || CharOperation.equals((char[])"$type".toCharArray(), (char[])fieldName) || CharOperation.equals((char[])"$method".toCharArray(), (char[])fieldName) || CharOperation.equals((char[])"$constructor".toCharArray(), (char[])fieldName) || CharOperation.equals((char[])"$field".toCharArray(), (char[])fieldName));
    }

    private boolean maybeITD(char[] fieldName, int lastDollar) {
        return lastDollar > 1 && lastDollar < fieldName.length;
    }

    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        super.enterMethod(methodInfo);
        try {
            char[] methodName = methodInfo.name;
            int last = CharOperation.lastIndexOf((char)'$', (char[])methodName) + 1;
            if (this.maybeITD(methodName, last)) {
                char[][] splits;
                int length;
                char[] realMethodName = CharOperation.subarray((char[])methodName, (int)last, (int)methodName.length);
                boolean isConstructor = false;
                if (CharOperation.equals((char[])"new".toCharArray(), (char[])realMethodName)) {
                    isConstructor = true;
                } else {
                    this.indexer.addMethodDeclaration(realMethodName, methodInfo.parameterTypes, methodInfo.returnType, methodInfo.exceptionTypes);
                }
                if (last > 1 && (length = (splits = CharOperation.splitAndTrimOn((char)'$', (char[])methodName)).length) > 1) {
                    char[][] newSplits = new char[splits.length - 1][];
                    System.arraycopy(splits, 0, newSplits, 0, splits.length - 1);
                    super.acceptUnknownReference((char[][])newSplits, methodInfo.nameSourceStart, methodInfo.nameSourceEnd - splits[length - 1].length - 1);
                    if (isConstructor) {
                        int argCount = methodInfo.parameterTypes == null ? 0 : methodInfo.parameterTypes.length;
                        this.indexer.addConstructorDeclaration(splits[length - 2], argCount, null, methodInfo.parameterTypes, methodInfo.parameterNames, methodInfo.modifiers, methodInfo.declaringPackageName, methodInfo.declaringTypeModifiers, methodInfo.exceptionTypes, methodInfo.extraFlags);
                    }
                }
            }
        }
        catch (Exception exception) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, (Object)this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_4);
        }
    }

    static {
        AJSourceIndexerRequestor.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AJSourceIndexerRequestor.java", AJSourceIndexerRequestor.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.codeconversion.AJSourceIndexerRequestor", "java.lang.Exception", "<missing>"), 149);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "enterField", "org.eclipse.ajdt.core.codeconversion.AJSourceIndexerRequestor", "org.eclipse.jdt.internal.compiler.ISourceElementRequestor$FieldInfo", "fieldInfo", "", "void"), 57);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.codeconversion.AJSourceIndexerRequestor", "java.lang.Exception", "<missing>"), 173);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.codeconversion.AJSourceIndexerRequestor", "java.lang.Exception", "<missing>"), 278);
        ajc$tjp_4 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "enterMethod", "org.eclipse.ajdt.core.codeconversion.AJSourceIndexerRequestor", "org.eclipse.jdt.internal.compiler.ISourceElementRequestor$MethodInfo", "methodInfo", "", "void"), 238);
    }
}

