/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.reconcile;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.parserbridge.AJCompilationUnitProblemFinder;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.ReconcileContext;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaElementDeltaBuilder;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.ReconcileWorkingCopyOperation;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public class AJReconcileWorkingCopyOperation
extends ReconcileWorkingCopyOperation {
    public static boolean PERF;
    public int astLevel;
    public boolean resolveBindings;
    public HashMap problems;
    public int reconcileFlags;
    WorkingCopyOwner workingCopyOwner;
    public org.eclipse.jdt.core.dom.CompilationUnit ast;
    public JavaElementDeltaBuilder deltaBuilder;
    public boolean requestorIsActive;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_6;

    static {
        AJReconcileWorkingCopyOperation.ajc$preClinit();
        PERF = false;
    }

    public AJReconcileWorkingCopyOperation(IJavaElement workingCopy, int astLevel, int reconcileFlags, WorkingCopyOwner workingCopyOwner) {
        super(workingCopy, astLevel, reconcileFlags, workingCopyOwner);
        this.astLevel = astLevel;
        this.workingCopyOwner = workingCopyOwner;
        this.reconcileFlags = reconcileFlags;
    }

    protected void executeOperation() throws JavaModelException {
        this.checkCanceled();
        try {
            JavaElementDelta delta;
            this.beginTask(Messages.element_reconciling, 2);
            CompilationUnit workingCopy = this.getWorkingCopy();
            boolean wasConsistent = workingCopy.isConsistent();
            JavaModelManager.PerWorkingCopyInfo problemRequestor = workingCopy.getPerWorkingCopyInfo();
            if (problemRequestor != null) {
                problemRequestor = problemRequestor.getProblemRequestor();
            }
            boolean defaultRequestorIsActive = problemRequestor != null && problemRequestor.isActive();
            IProblemRequestor ownerProblemRequestor = this.workingCopyOwner.getProblemRequestor((ICompilationUnit)workingCopy);
            boolean ownerRequestorIsActive = ownerProblemRequestor != null && ownerProblemRequestor != problemRequestor && ownerProblemRequestor.isActive();
            this.requestorIsActive = defaultRequestorIsActive || ownerRequestorIsActive;
            this.deltaBuilder = new JavaElementDeltaBuilder((IJavaElement)workingCopy);
            this.makeConsistent(workingCopy);
            if (!wasConsistent || (this.reconcileFlags & 1) != 0) {
                this.notifyParticipants(workingCopy);
                if (this.ast == null) {
                    this.makeConsistent(workingCopy);
                }
            }
            if (!(this.problems == null || (this.reconcileFlags & 1) == 0 && wasConsistent)) {
                if (defaultRequestorIsActive) {
                    this.reportProblems(workingCopy, (IProblemRequestor)problemRequestor);
                }
                if (ownerRequestorIsActive) {
                    this.reportProblems(workingCopy, ownerProblemRequestor);
                }
            }
            if ((delta = this.getDelta(this.deltaBuilder)) != null) {
                this.addReconcileDelta((ICompilationUnit)workingCopy, (IJavaElementDelta)delta);
            }
        }
        finally {
            this.done();
        }
    }

    private JavaElementDelta getDelta(JavaElementDeltaBuilder deltaBuilder) {
        try {
            Field deltaField = JavaElementDeltaBuilder.class.getDeclaredField("delta");
            deltaField.setAccessible(true);
            Object o = deltaField.get(deltaBuilder);
            return (JavaElementDelta)o;
        }
        catch (SecurityException securityException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(securityException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(noSuchFieldException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(illegalArgumentException, (Object)this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        catch (IllegalAccessException illegalAccessException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(illegalAccessException, (Object)this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        return null;
    }

    private void reportProblems(CompilationUnit workingCopy, IProblemRequestor problemRequestor) {
        try {
            problemRequestor.beginReporting();
            block3: for (CategorizedProblem[] categorizedProblems : this.problems.values()) {
                if (categorizedProblems == null) continue;
                int i = 0;
                int length = categorizedProblems.length;
                while (i < length) {
                    CategorizedProblem problem = categorizedProblems[i];
                    if (JavaModelManager.VERBOSE) {
                        AJLog.log(6, "PROBLEM FOUND while reconciling : " + problem.getMessage());
                    }
                    if (this.progressMonitor != null && this.progressMonitor.isCanceled()) continue block3;
                    problemRequestor.acceptProblem((IProblem)problem);
                    ++i;
                }
            }
        }
        finally {
            problemRequestor.endReporting();
        }
    }

    protected CompilationUnit getWorkingCopy() {
        return (CompilationUnit)this.getElementToProcess();
    }

    public boolean isReadOnly() {
        return true;
    }

    public org.eclipse.jdt.core.dom.CompilationUnit makeConsistent(CompilationUnit workingCopy) throws JavaModelException {
        if (!workingCopy.isConsistent()) {
            if (this.problems == null) {
                this.problems = new HashMap();
            }
            this.resolveBindings = this.requestorIsActive;
            this.ast = workingCopy.makeConsistent(this.astLevel, this.resolveBindings, this.reconcileFlags, this.problems, (IProgressMonitor)this.progressMonitor);
            this.deltaBuilder.buildDeltas();
            if (this.ast != null && this.deltaBuilder.delta != null) {
                this.deltaBuilder.delta.changedAST(this.ast);
            }
            return this.ast;
        }
        if (this.ast != null) {
            return this.ast;
        }
        CompilationUnitDeclaration unit = null;
        try {
            try {
                JavaModelManager.getJavaModelManager().abortOnMissingSource.set(Boolean.TRUE);
                CompilationUnit source = workingCopy instanceof AJCompilationUnit ? ((AJCompilationUnit)workingCopy).ajCloneCachingContents() : workingCopy.cloneCachingContents();
                if (JavaProject.hasJavaNature((IProject)workingCopy.getJavaProject().getProject()) && (this.reconcileFlags & 1) != 0) {
                    this.resolveBindings = this.requestorIsActive;
                    if (this.problems == null) {
                        this.problems = new HashMap();
                    }
                    unit = AJCompilationUnitProblemFinder.processAJ(source, this.workingCopyOwner, this.problems, this.astLevel != 0, this.reconcileFlags, (IProgressMonitor)this.progressMonitor);
                    if (this.progressMonitor != null) {
                        this.progressMonitor.worked(1);
                    }
                }
                if (this.astLevel != 0 && unit != null) {
                    Map options = workingCopy.getJavaProject().getOptions(true);
                    this.ast = AST.convertCompilationUnit((int)this.astLevel, unit, (Map)options, (boolean)this.resolveBindings, (CompilationUnit)source, (int)this.reconcileFlags, (IProgressMonitor)this.progressMonitor);
                    if (this.ast != null) {
                        if (this.deltaBuilder.delta == null) {
                            this.deltaBuilder.delta = new JavaElementDelta((IJavaElement)workingCopy);
                        }
                        this.deltaBuilder.delta.changedAST(this.ast);
                    }
                    if (this.progressMonitor != null) {
                        this.progressMonitor.worked(1);
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_6);
                JavaModelException e = javaModelException;
                if (JavaProject.hasJavaNature((IProject)workingCopy.getJavaProject().getProject())) {
                    throw e;
                }
                JavaModelManager.getJavaModelManager().abortOnMissingSource.set(null);
                if (unit != null) {
                    unit.cleanUp();
                }
            }
        }
        finally {
            JavaModelManager.getJavaModelManager().abortOnMissingSource.set(null);
            if (unit != null) {
                unit.cleanUp();
            }
        }
        return this.ast;
    }

    private void notifyParticipants(CompilationUnit workingCopy) {
        JavaProject javaProject = this.getWorkingCopy().getJavaProject();
        CompilationParticipant[] participants = JavaModelManager.getJavaModelManager().compilationParticipants.getCompilationParticipants((IJavaProject)javaProject);
        if (participants == null) {
            return;
        }
        final ReconcileContext context = new ReconcileContext((ReconcileWorkingCopyOperation)this, workingCopy);
        int i = 0;
        int length = participants.length;
        while (i < length) {
            final CompilationParticipant participant = participants[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    if (exception instanceof Error) {
                        throw (Error)exception;
                    }
                    if (exception instanceof OperationCanceledException) {
                        throw (OperationCanceledException)exception;
                    }
                    if (exception instanceof UnsupportedOperationException) {
                        Util.log((Throwable)exception, (String)"Reconcile participant attempted to modify the buffer of the working copy being reconciled");
                    } else {
                        Util.log((Throwable)exception, (String)"Exception occurred in reconcile participant");
                    }
                }

                public void run() throws Exception {
                    participant.reconcile(context);
                }
            });
            ++i;
        }
    }

    protected IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        CompilationUnit workingCopy = this.getWorkingCopy();
        if (!workingCopy.isWorkingCopy()) {
            return new JavaModelStatus(969, (IJavaElement)workingCopy);
        }
        return status;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AJReconcileWorkingCopyOperation.java", AJReconcileWorkingCopyOperation.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.reconcile.AJReconcileWorkingCopyOperation", "java.lang.SecurityException", "<missing>"), 156);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getDelta", "org.eclipse.ajdt.core.reconcile.AJReconcileWorkingCopyOperation", "org.eclipse.jdt.internal.core.JavaElementDeltaBuilder", "deltaBuilder", "", "org.eclipse.jdt.internal.core.JavaElementDelta"), 149);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.reconcile.AJReconcileWorkingCopyOperation", "java.lang.NoSuchFieldException", "<missing>"), 157);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.reconcile.AJReconcileWorkingCopyOperation", "java.lang.IllegalArgumentException", "<missing>"), 158);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.reconcile.AJReconcileWorkingCopyOperation", "java.lang.IllegalAccessException", "<missing>"), 159);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.reconcile.AJReconcileWorkingCopyOperation", "org.eclipse.jdt.core.JavaModelException", "e"), 276);
        ajc$tjp_6 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "makeConsistent", "org.eclipse.ajdt.core.reconcile.AJReconcileWorkingCopyOperation", "org.eclipse.jdt.internal.core.CompilationUnit", "workingCopy", "org.eclipse.jdt.core.JavaModelException", "org.eclipse.jdt.core.dom.CompilationUnit"), 214);
    }
}

