/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPrintHandler {
    public static final String XML_COMMENT_END_TAG = "-->";
    public static final String XML_COMMENT_BEGIN_TAG = "<!--";
    public static final String XML_HEAD = "<?xml version=\"1.0\" encoding=\"";
    public static final String XML_HEAD_END_TAG = "?>";
    public static final String XML_DBL_QUOTES = "\"";
    public static final String XML_SPACE = " ";
    public static final String XML_BEGIN_TAG = "<";
    public static final String XML_END_TAG = ">";
    public static final String XML_EQUAL = "=";
    public static final String XML_SLASH = "/";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public static void printBeginElement(Writer xmlWriter, String elementString, String indent, boolean terminate) throws IOException {
        StringBuffer temp = new StringBuffer(indent);
        temp.append(XML_BEGIN_TAG);
        temp.append(elementString);
        if (terminate) {
            temp.append(XML_SLASH);
        }
        temp.append(XML_END_TAG);
        temp.append("\n");
        xmlWriter.write(temp.toString());
    }

    public static void printEndElement(Writer xmlWriter, String elementString, String indent) throws IOException {
        StringBuffer temp = new StringBuffer(indent);
        temp.append(XML_BEGIN_TAG);
        temp.append(XML_SLASH).append(elementString).append(XML_END_TAG).append("\n");
        xmlWriter.write(temp.toString());
    }

    public static void printText(Writer xmlWriter, String text) throws IOException {
        xmlWriter.write(XMLPrintHandler.encode(text).toString());
    }

    public static void printComment(Writer xmlWriter, String comment) throws IOException {
        StringBuffer temp = new StringBuffer(XML_COMMENT_BEGIN_TAG);
        temp.append(XMLPrintHandler.encode(comment).toString()).append(XML_COMMENT_END_TAG).append("\n");
        xmlWriter.write(temp.toString());
    }

    public static void printHead(Writer xmlWriter, String encoding) throws IOException {
        StringBuffer temp = new StringBuffer(XML_HEAD);
        temp.append(encoding).append(XML_DBL_QUOTES).append(XML_HEAD_END_TAG).append("\n");
        xmlWriter.write(temp.toString());
    }

    public static String wrapAttributeForPrint(String attribute, String value) throws IOException {
        StringBuffer temp = new StringBuffer(XML_SPACE);
        temp.append(attribute).append(XML_EQUAL).append(XML_DBL_QUOTES).append(XMLPrintHandler.encode(value).toString()).append(XML_DBL_QUOTES);
        return temp.toString();
    }

    public static void printNode(Writer xmlWriter, Node node, String encoding, String indent) throws IOException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: {
                XMLPrintHandler.printHead(xmlWriter, encoding);
                XMLPrintHandler.printNode(xmlWriter, ((Document)node).getDocumentElement(), encoding, indent);
                break;
            }
            case 1: {
                StringBuffer tempElementString = new StringBuffer(node.getNodeName());
                NamedNodeMap attributeList = node.getAttributes();
                if (attributeList != null) {
                    int i = 0;
                    while (i < attributeList.getLength()) {
                        Node attribute = attributeList.item(i);
                        tempElementString.append(XMLPrintHandler.wrapAttributeForPrint(attribute.getNodeName(), attribute.getNodeValue()));
                        ++i;
                    }
                }
                NodeList childNodes = node.getChildNodes();
                int length = childNodes.getLength();
                XMLPrintHandler.printBeginElement(xmlWriter, tempElementString.toString(), indent, length == 0);
                int i = 0;
                while (i < length) {
                    XMLPrintHandler.printNode(xmlWriter, childNodes.item(i), encoding, String.valueOf(indent) + "\t");
                    ++i;
                }
                if (length <= 0) break;
                XMLPrintHandler.printEndElement(xmlWriter, node.getNodeName(), indent);
                break;
            }
            case 3: {
                break;
            }
            case 8: {
                StringBuffer temp = new StringBuffer(XML_COMMENT_BEGIN_TAG);
                temp.append(XMLPrintHandler.encode(node.getNodeValue()).toString()).append(XML_COMMENT_END_TAG).append("\n");
                xmlWriter.write(temp.toString());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported XML Node Type.");
            }
        }
    }

    public static StringBuffer encode(String value) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf;
    }

    public static void writeFile(Document doc, File file) throws IOException {
        Writer writer = null;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            XMLPrintHandler.printNode(writer, doc, "UTF-8", "");
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(iOException, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            }
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(iOException, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
            }
            throw throwable;
        }
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(iOException, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        try {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
        catch (IOException iOException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(iOException, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_1);
        }
    }

    static {
        XMLPrintHandler.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("XMLPrintHandler.java", XMLPrintHandler.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.XMLPrintHandler", "java.io.IOException", "<missing>"), 178);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "writeFile", "org.eclipse.ajdt.internal.launching.XMLPrintHandler", "org.w3c.dom.Document:java.io.File", "doc:file", "java.io.IOException", "void"), 167);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.XMLPrintHandler", "java.io.IOException", "<missing>"), 183);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.XMLPrintHandler", "java.io.IOException", "<missing>"), 178);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.XMLPrintHandler", "java.io.IOException", "<missing>"), 183);
    }
}

