/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajdocexport;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.ajdocexport.AJdocOptionsManager;
import org.eclipse.ajdt.internal.ui.ajdocexport.AJdocSpecificsWizardPage;
import org.eclipse.ajdt.internal.ui.ajdocexport.AJdocStandardWizardPage;
import org.eclipse.ajdt.internal.ui.ajdocexport.AJdocTreeWizardPage;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AJdocWizard
extends Wizard
implements IExportWizard {
    private AJdocTreeWizardPage fJTWPage;
    private AJdocSpecificsWizardPage fJSWPage;
    private AJdocStandardWizardPage fJSpWPage;
    private IPath fDestination;
    private boolean fWriteCustom;
    private boolean fOpenInBrowser;
    private final String TREE_PAGE_DESC = "JavadocTreePage";
    private final String SPECIFICS_PAGE_DESC = "JavadocSpecificsPage";
    private final String STANDARD_PAGE_DESC = "JavadocStandardPage";
    private final int YES = 0;
    private final int YES_TO_ALL = 1;
    private final int NO = 2;
    private final int NO_TO_ALL = 3;
    private AJdocOptionsManager fStore;
    private IWorkspaceRoot fRoot;
    private IFile fXmlJavadocFile;
    private static final String ID_JAVADOC_PROCESS_TYPE = "org.eclipse.jdt.ui.javadocProcess";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_14;

    public static void openJavadocWizard(AJdocWizard wizard, Shell shell, IStructuredSelection selection) {
        wizard.init(PlatformUI.getWorkbench(), selection);
        PixelConverter converter = new PixelConverter((Control)shell);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(100), converter.convertHeightInCharsToPixels(20));
        dialog.open();
    }

    public AJdocWizard() {
        this(null);
    }

    public AJdocWizard(IFile xmlJavadocFile) {
        this.setDefaultPageImageDescriptor(AspectJImages.W_EXPORT_AJDOC.getImageDescriptor());
        this.setWindowTitle(UIMessages.ajdocWizard_javadocwizard_title);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.fRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fXmlJavadocFile = xmlJavadocFile;
        this.fWriteCustom = false;
    }

    public boolean performFinish() {
        IJavaProject[] checkedProjects = this.fJTWPage.getCheckedProjects();
        this.updateStore(checkedProjects);
        if (this.fXmlJavadocFile == null) {
            this.fStore.updateDialogSettings(this.getDialogSettings(), checkedProjects);
        }
        if (!new RefactoringSaveHelper(1).saveEditors(this.getShell())) {
            return false;
        }
        this.fDestination = new Path(this.fStore.getDestination());
        this.fDestination.toFile().mkdirs();
        this.fOpenInBrowser = this.fStore.doOpenInBrowser();
        if (this.fStore.isFromStandard()) {
            try {
                URL newURL = this.fDestination.toFile().toURL();
                ArrayList<IJavaProject> projs = new ArrayList<IJavaProject>();
                int i = 0;
                while (i < checkedProjects.length) {
                    IJavaProject curr = checkedProjects[i];
                    URL currURL = JavaUI.getProjectJavadocLocation((IJavaProject)curr);
                    if (!newURL.equals(currURL)) {
                        projs.add(curr);
                    }
                    ++i;
                }
                if (!projs.isEmpty()) {
                    this.setAllJavadocLocations(projs.toArray(new IJavaProject[projs.size()]), newURL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(malformedURLException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                MalformedURLException e = malformedURLException;
                JavaPlugin.log((Throwable)e);
            }
        }
        return this.executeJavadocGeneration();
    }

    private void updateStore(IJavaProject[] checkedProjects) {
        this.fJTWPage.updateStore(checkedProjects);
        this.fJSpWPage.updateStore();
        this.fJSWPage.updateStore();
    }

    public boolean performCancel() {
        IJavaProject[] checkedProjects = this.fJTWPage.getCheckedProjects();
        this.updateStore(checkedProjects);
        if (this.fXmlJavadocFile == null) {
            this.fStore.updateDialogSettings(this.getDialogSettings(), checkedProjects);
        }
        return super.performCancel();
    }

    private void setAllJavadocLocations(IJavaProject[] projects, URL newURL) {
        Shell shell = this.getShell();
        Image image = shell == null ? null : shell.getDisplay().getSystemImage(4);
        String[] buttonlabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL};
        int j = 0;
        while (j < projects.length) {
            IJavaProject iJavaProject = projects[j];
            String message = Messages.format((String)JavadocExportMessages.JavadocWizard_updatejavadoclocation_message, (Object[])new String[]{iJavaProject.getElementName(), this.fDestination.toOSString()});
            MessageDialog dialog = new MessageDialog(shell, JavadocExportMessages.JavadocWizard_updatejavadocdialog_label, image, message, 4, buttonlabels, 1);
            switch (dialog.open()) {
                case 0: {
                    JavaUI.setProjectJavadocLocation((IJavaProject)iJavaProject, (URL)newURL);
                    break;
                }
                case 1: {
                    int i = j;
                    while (i < projects.length) {
                        iJavaProject = projects[i];
                        JavaUI.setProjectJavadocLocation((IJavaProject)iJavaProject, (URL)newURL);
                        ++j;
                        ++i;
                    }
                    break;
                }
                case 3: {
                    j = projects.length;
                    break;
                }
            }
            ++j;
        }
    }

    /*
     * Exception decompiling
     */
    private boolean executeJavadocGeneration() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String checkForSpaces(String curr) {
        if (curr.indexOf(32) == -1) {
            return curr;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < curr.length()) {
            char ch = curr.charAt(i);
            if (ch == '\\' || ch == '\'') {
                buf.append('\\');
            }
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }

    public void addPages() {
        this.fJTWPage = new AJdocTreeWizardPage("JavadocTreePage", this.fStore);
        this.fJSWPage = new AJdocSpecificsWizardPage("JavadocSpecificsPage", this.fJTWPage, this.fStore);
        this.fJSpWPage = new AJdocStandardWizardPage("JavadocStandardPage", this.fJTWPage, this.fStore);
        super.addPage((IWizardPage)this.fJTWPage);
        super.addPage((IWizardPage)this.fJSWPage);
        super.addPage((IWizardPage)this.fJSpWPage);
        this.fJTWPage.init();
        this.fJSWPage.init();
        this.fJSpWPage.init();
    }

    public void init(IWorkbench workbench, IStructuredSelection structuredSelection) {
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        ArrayList<IJavaElement> selected = Collections.EMPTY_LIST;
        if (window != null) {
            ISelection selection = window.getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection) {
                selected = ((IStructuredSelection)selection).toList();
            } else {
                IJavaElement element = EditorUtility.getActiveEditorJavaInput();
                if (element != null) {
                    selected = new ArrayList<IJavaElement>();
                    selected.add(element);
                }
            }
        }
        this.fStore = new AJdocOptionsManager(this.fXmlJavadocFile, this.getDialogSettings(), selected);
    }

    private void refresh(IPath path) {
        if (this.fRoot.findContainersForLocation(path).length > 0) {
            try {
                this.fRoot.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_11, (JoinPoint.StaticPart)ajc$tjp_12);
                CoreException e = coreException;
                JavaPlugin.log((Throwable)e);
            }
        }
    }

    private void spawnInBrowser(Display display) {
        if (this.fOpenInBrowser) {
            try {
                IPath indexFile = this.fDestination.append("index.html");
                URL url = indexFile.toFile().toURL();
                OpenBrowserUtil.open((URL)url, (Display)display);
            }
            catch (MalformedURLException malformedURLException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(malformedURLException, (Object)this, ajc$tjp_13, (JoinPoint.StaticPart)ajc$tjp_14);
                MalformedURLException e = malformedURLException;
                JavaPlugin.log((Throwable)e);
            }
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof AJdocTreeWizardPage) {
            return this.fJSWPage;
        }
        if (page instanceof AJdocSpecificsWizardPage) {
            return null;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page instanceof AJdocSpecificsWizardPage) {
            return this.fJSWPage;
        }
        if (page instanceof AJdocTreeWizardPage) {
            return null;
        }
        return null;
    }

    static {
        AJdocWizard.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AJdocWizard.java", AJdocWizard.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajdocexport.AJdocWizard", "java.net.MalformedURLException", "e"), 187);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "performFinish", "org.eclipse.ajdt.internal.ui.ajdocexport.AJdocWizard", "", "", "", "boolean"), 145);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajdocexport.AJdocWizard", "java.io.IOException", "e"), 473);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajdocexport.AJdocWizard", "org.eclipse.core.runtime.CoreException", "e"), 546);
        ajc$tjp_12 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "refresh", "org.eclipse.ajdt.internal.ui.ajdocexport.AJdocWizard", "org.eclipse.core.runtime.IPath", "path", "", "void"), 542);
        ajc$tjp_13 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajdocexport.AJdocWizard", "java.net.MalformedURLException", "e"), 558);
        ajc$tjp_14 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "spawnInBrowser", "org.eclipse.ajdt.internal.ui.ajdocexport.AJdocWizard", "org.eclipse.swt.widgets.Display", "display", "", "void"), 552);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajdocexport.AJdocWizard", "java.io.IOException", "<missing>"), 342);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "executeJavadocGeneration", "org.eclipse.ajdt.internal.ui.ajdocexport.AJdocWizard", "", "", "", "boolean"), 280);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajdocexport.AJdocWizard", "java.io.IOException", "<missing>"), 342);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajdocexport.AJdocWizard", "java.io.IOException", "<missing>"), 342);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajdocexport.AJdocWizard", "org.eclipse.core.runtime.CoreException", "e"), 462);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajdocexport.AJdocWizard", "java.io.IOException", "e"), 473);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajdocexport.AJdocWizard", "java.io.IOException", "e"), 473);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajdocexport.AJdocWizard", "java.io.IOException", "e"), 473);
    }

    private class JavadocLaunchListener
    implements ILaunchesListener2 {
        private Display fDisplay;
        private volatile ILaunch fLaunch;
        private File fFile;

        public JavadocLaunchListener(Display display, ILaunch launch, File file) {
            this.fDisplay = display;
            this.fLaunch = launch;
            this.fFile = file;
        }

        public void launchesTerminated(ILaunch[] launches) {
            int i = 0;
            while (i < launches.length) {
                if (launches[i] == this.fLaunch) {
                    this.onTerminated();
                    return;
                }
                ++i;
            }
        }

        public void onTerminated() {
            try {
                if (this.fLaunch != null) {
                    this.fFile.delete();
                    AJdocWizard.this.spawnInBrowser(this.fDisplay);
                    AJdocWizard.this.refresh(AJdocWizard.this.fDestination);
                    this.fLaunch = null;
                }
            }
            finally {
                DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
            }
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }
    }
}

