/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor.quickfix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.QualifiedTypeNameHistory;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.NameMatcher;
import org.eclipse.jdt.internal.ui.text.correction.SimilarElement;
import org.eclipse.jdt.internal.ui.text.correction.SimilarElementsRequestor;
import org.eclipse.jdt.internal.ui.text.correction.TypeMismatchSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AddArgumentCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AddImportCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AddTypeParameterProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.CastCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ChangeMethodSignatureProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewAnnotationMemberProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewCUUsingWizardProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewMethodCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewVariableCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.RenameNodeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ReplaceCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.CUCorrectionProposal;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class UnresolvedElementsSubProcessor {
    private static final String ADD_IMPORT_ID = "org.eclipse.jdt.ui.correction.addImport";

    public static void getVariableProposals(IInvocationContext context, IProblemLocation problem, IVariableBinding resolvedField, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveredNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        ITypeBinding binding = null;
        ITypeBinding declaringTypeBinding = Bindings.getBindingOfParentTypeContext((ASTNode)selectedNode);
        if (declaringTypeBinding == null) {
            return;
        }
        boolean suggestVariableProposals = true;
        int typeKind = 0;
        while (selectedNode instanceof ParenthesizedExpression) {
            selectedNode = ((ParenthesizedExpression)selectedNode).getExpression();
        }
        SimpleName node = null;
        switch (selectedNode.getNodeType()) {
            case 42: {
                node = (SimpleName)selectedNode;
                ASTNode parent = node.getParent();
                StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
                if (locationInParent == MethodInvocation.EXPRESSION_PROPERTY) {
                    typeKind = 2;
                    break;
                }
                if (locationInParent == FieldAccess.NAME_PROPERTY) {
                    Expression expression = ((FieldAccess)parent).getExpression();
                    if (expression == null || (binding = expression.resolveTypeBinding()) != null) break;
                    node = null;
                    break;
                }
                if (parent instanceof SimpleType) {
                    suggestVariableProposals = false;
                    typeKind = 30;
                    break;
                }
                if (parent instanceof QualifiedName) {
                    Name qualifier = ((QualifiedName)parent).getQualifier();
                    if (qualifier != node) {
                        binding = qualifier.resolveTypeBinding();
                    } else {
                        typeKind = 30;
                    }
                    ASTNode outerParent = parent.getParent();
                    while (outerParent instanceof QualifiedName) {
                        outerParent = outerParent.getParent();
                    }
                    if (!(outerParent instanceof SimpleType)) break;
                    typeKind = 30;
                    suggestVariableProposals = false;
                    break;
                }
                if (locationInParent == SwitchCase.EXPRESSION_PROPERTY) {
                    ITypeBinding switchExp = ((SwitchStatement)node.getParent().getParent()).getExpression().resolveTypeBinding();
                    if (switchExp == null || !switchExp.isEnum()) break;
                    binding = switchExp;
                    break;
                }
                if (locationInParent != SuperFieldAccess.NAME_PROPERTY) break;
                binding = declaringTypeBinding.getSuperclass();
                break;
            }
            case 40: {
                QualifiedName qualifierName = (QualifiedName)selectedNode;
                ITypeBinding qualifierBinding = qualifierName.getQualifier().resolveTypeBinding();
                if (qualifierBinding != null) {
                    node = qualifierName.getName();
                    binding = qualifierBinding;
                } else {
                    node = qualifierName.getQualifier();
                    typeKind = 30;
                    suggestVariableProposals = node.isSimpleName();
                }
                if (!(selectedNode.getParent() instanceof SimpleType)) break;
                typeKind = 30;
                suggestVariableProposals = false;
                break;
            }
            case 22: {
                FieldAccess access = (FieldAccess)selectedNode;
                Expression expression = access.getExpression();
                if (expression == null || (binding = expression.resolveTypeBinding()) == null) break;
                node = access.getName();
                break;
            }
            case 47: {
                binding = declaringTypeBinding.getSuperclass();
                node = ((SuperFieldAccess)selectedNode).getName();
            }
        }
        if (node == null) {
            return;
        }
        if (typeKind != 0) {
            if (!JavaModelUtil.is50OrHigher((IJavaProject)cu.getJavaProject())) {
                typeKind &= 0xFFFFFFC7;
            }
            int relevance = Character.isUpperCase(ASTNodes.getSimpleNameIdentifier((Name)node).charAt(0)) ? 5 : -2;
            UnresolvedElementsSubProcessor.addSimilarTypeProposals(typeKind, cu, (Name)node, relevance + 1, proposals);
            UnresolvedElementsSubProcessor.addNewTypeProposals(cu, (Name)node, typeKind, relevance, proposals);
        }
        if (!suggestVariableProposals) {
            return;
        }
        SimpleName simpleName = node.isSimpleName() ? node : ((QualifiedName)node).getName();
        boolean isWriteAccess = ASTResolving.isWriteAccess((Name)node);
        UnresolvedElementsSubProcessor.addSimilarVariableProposals(cu, astRoot, binding, simpleName, isWriteAccess, proposals);
        if (resolvedField == null || binding == null || resolvedField.getDeclaringClass() != binding.getTypeDeclaration() && Modifier.isPrivate((int)resolvedField.getModifiers())) {
            UnresolvedElementsSubProcessor.addNewFieldProposals(cu, astRoot, binding, declaringTypeBinding, simpleName, isWriteAccess, proposals);
            if (binding == null) {
                UnresolvedElementsSubProcessor.addNewVariableProposals(cu, (Name)node, simpleName, proposals);
            }
        }
    }

    private static void addNewVariableProposals(ICompilationUnit cu, Name node, SimpleName simpleName, Collection proposals) {
        Assignment assignment;
        Image image;
        String label;
        int relevance;
        String name = simpleName.getIdentifier();
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)node, (boolean)true);
        int type = bodyDeclaration.getNodeType();
        if (type == 31) {
            relevance = StubUtility.hasParameterName((IJavaProject)cu.getJavaProject(), (String)name) ? 8 : 5;
            label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_createparameter_description, (Object)simpleName.getIdentifier());
            image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.localvariable_obj.gif");
            proposals.add(new NewVariableCorrectionProposal(label, cu, 3, simpleName, null, relevance, image));
        }
        if (type == 28 || type == 31 && !ASTResolving.isInsideConstructorInvocation((MethodDeclaration)((MethodDeclaration)bodyDeclaration), (ASTNode)node)) {
            relevance = StubUtility.hasLocalVariableName((IJavaProject)cu.getJavaProject(), (String)name) ? 10 : 7;
            label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_createlocal_description, (Object)simpleName.getIdentifier());
            image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.localvariable_obj.gif");
            proposals.add(new NewVariableCorrectionProposal(label, cu, 1, simpleName, null, relevance, image));
        }
        if (node.getParent().getNodeType() == 7 && (assignment = (Assignment)node.getParent()).getLeftHandSide() == node && assignment.getParent().getNodeType() == 21) {
            ASTNode statement = assignment.getParent();
            ASTRewrite rewrite = ASTRewrite.create((AST)statement.getAST());
            if (ASTNodes.isControlStatementBody((StructuralPropertyDescriptor)assignment.getParent().getLocationInParent())) {
                rewrite.replace(statement, (ASTNode)rewrite.getAST().newBlock(), null);
            } else {
                rewrite.remove(statement, null);
            }
            String label2 = CorrectionMessages.UnresolvedElementsSubProcessor_removestatement_description;
            Image image2 = JavaPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label2, cu, rewrite, 4, image2);
            proposals.add(proposal);
        }
    }

    private static void addNewFieldProposals(ICompilationUnit cu, CompilationUnit astRoot, ITypeBinding binding, ITypeBinding declaringTypeBinding, SimpleName simpleName, boolean isWriteAccess, Collection proposals) throws JavaModelException {
        ITypeBinding bind;
        ASTNode anonymDecl;
        ICompilationUnit targetCU;
        ITypeBinding senderDeclBinding;
        if (binding != null) {
            senderDeclBinding = binding.getTypeDeclaration();
            targetCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)senderDeclBinding);
        } else {
            senderDeclBinding = declaringTypeBinding;
            targetCU = cu;
        }
        if (!senderDeclBinding.isFromSource() || targetCU == null) {
            return;
        }
        boolean mustBeConst = ASTResolving.isInsideModifiers((ASTNode)simpleName);
        UnresolvedElementsSubProcessor.addNewFieldForType(targetCU, binding, senderDeclBinding, simpleName, isWriteAccess, mustBeConst, proposals);
        if (binding == null && senderDeclBinding.isNested() && (anonymDecl = astRoot.findDeclaringNode((IBinding)senderDeclBinding)) != null && !(bind = Bindings.getBindingOfParentType((ASTNode)anonymDecl.getParent())).isAnonymous()) {
            UnresolvedElementsSubProcessor.addNewFieldForType(targetCU, bind, bind, simpleName, isWriteAccess, mustBeConst, proposals);
        }
    }

    private static void addNewFieldForType(ICompilationUnit targetCU, ITypeBinding binding, ITypeBinding senderDeclBinding, SimpleName simpleName, boolean isWriteAccess, boolean mustBeConst, Collection proposals) {
        String name = simpleName.getIdentifier();
        if (senderDeclBinding.isEnum() && !isWriteAccess) {
            String label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_createenum_description, (Object[])new Object[]{name, ASTResolving.getTypeSignature((ITypeBinding)senderDeclBinding)});
            Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.field_public_obj.gif");
            proposals.add(new NewVariableCorrectionProposal(label, targetCU, 5, simpleName, senderDeclBinding, 10, image));
        } else {
            Image image;
            String label;
            if (!mustBeConst) {
                if (binding == null) {
                    label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_createfield_description, (Object)name);
                    image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.field_private_obj.gif");
                } else {
                    label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_createfield_other_description, (Object[])new Object[]{name, ASTResolving.getTypeSignature((ITypeBinding)senderDeclBinding)});
                    image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.field_public_obj.gif");
                }
                int fieldRelevance = StubUtility.hasFieldName((IJavaProject)targetCU.getJavaProject(), (String)name) ? 9 : 6;
                proposals.add(new NewVariableCorrectionProposal(label, targetCU, 2, simpleName, senderDeclBinding, fieldRelevance, image));
            }
            if (!isWriteAccess && !senderDeclBinding.isAnonymous()) {
                if (binding == null) {
                    label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_createconst_description, (Object)name);
                    image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.field_private_obj.gif");
                } else {
                    label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_createconst_other_description, (Object[])new Object[]{name, ASTResolving.getTypeSignature((ITypeBinding)senderDeclBinding)});
                    image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.field_public_obj.gif");
                }
                int constRelevance = StubUtility.hasConstantName((IJavaProject)targetCU.getJavaProject(), (String)name) ? 9 : 4;
                proposals.add(new NewVariableCorrectionProposal(label, targetCU, 4, simpleName, senderDeclBinding, constRelevance, image));
            }
        }
    }

    private static void addSimilarVariableProposals(ICompilationUnit cu, CompilationUnit astRoot, ITypeBinding binding, SimpleName node, boolean isWriteAccess, Collection proposals) {
        IBinding[] varsAndMethodsInScope;
        int kind = 18;
        if (!isWriteAccess) {
            kind |= 1;
        }
        if ((varsAndMethodsInScope = new ScopeAnalyzer(astRoot).getDeclarationsInScope(node, kind)).length > 0) {
            String otherNameInAssign = null;
            String methodSenderName = null;
            String fieldSenderName = null;
            ASTNode parent = node.getParent();
            switch (parent.getNodeType()) {
                case 59: {
                    otherNameInAssign = ((VariableDeclarationFragment)parent).getName().getIdentifier();
                    break;
                }
                case 7: {
                    Assignment assignment = (Assignment)parent;
                    if (isWriteAccess && assignment.getRightHandSide() instanceof SimpleName) {
                        otherNameInAssign = ((SimpleName)assignment.getRightHandSide()).getIdentifier();
                        break;
                    }
                    if (isWriteAccess || !(assignment.getLeftHandSide() instanceof SimpleName)) break;
                    otherNameInAssign = ((SimpleName)assignment.getLeftHandSide()).getIdentifier();
                    break;
                }
                case 32: {
                    MethodInvocation inv = (MethodInvocation)parent;
                    if (inv.getExpression() != node) break;
                    methodSenderName = inv.getName().getIdentifier();
                    break;
                }
                case 40: {
                    QualifiedName qualName = (QualifiedName)parent;
                    if (qualName.getQualifier() != node) break;
                    fieldSenderName = qualName.getName().getIdentifier();
                }
            }
            ITypeBinding guessedType = ASTResolving.guessBindingForReference((ASTNode)node);
            ITypeBinding objectBinding = astRoot.getAST().resolveWellKnownType("java.lang.Object");
            String identifier = node.getIdentifier();
            boolean isInStaticContext = ASTResolving.isInStaticContext((ASTNode)node);
            int i = 0;
            while (i < varsAndMethodsInScope.length) {
                IVariableBinding curr;
                IBinding varOrMeth = varsAndMethodsInScope[i];
                if (varOrMeth instanceof IVariableBinding) {
                    boolean isFinal;
                    curr = (IVariableBinding)varOrMeth;
                    String currName = curr.getName();
                    if (!(currName.equals(otherNameInAssign) || (isFinal = Modifier.isFinal((int)curr.getModifiers())) && curr.isField() && isWriteAccess || isInStaticContext && !Modifier.isStatic((int)curr.getModifiers()) && curr.isField())) {
                        ITypeBinding varType;
                        int relevance = 0;
                        if (NameMatcher.isSimilarName((String)currName, (String)identifier)) {
                            relevance += 3;
                        }
                        if (currName.equalsIgnoreCase(identifier)) {
                            relevance += 5;
                        }
                        if ((varType = curr.getType()) != null) {
                            if (guessedType != null && guessedType != objectBinding && (!isWriteAccess && UnresolvedElementsSubProcessor.canAssign(varType, guessedType) || isWriteAccess && UnresolvedElementsSubProcessor.canAssign(guessedType, varType))) {
                                relevance += 2;
                            }
                            if (methodSenderName != null && UnresolvedElementsSubProcessor.hasMethodWithName(varType, methodSenderName)) {
                                relevance += 2;
                            }
                            if (fieldSenderName != null && UnresolvedElementsSubProcessor.hasFieldWithName(varType, fieldSenderName)) {
                                relevance += 2;
                            }
                        }
                        if (relevance > 0) {
                            String label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_changevariable_description, (Object)currName);
                            proposals.add(new RenameNodeCorrectionProposal(label, cu, node.getStartPosition(), node.getLength(), currName, relevance));
                        }
                    }
                } else if (varOrMeth instanceof IMethodBinding && !(curr = (IMethodBinding)varOrMeth).isConstructor() && guessedType != null && UnresolvedElementsSubProcessor.canAssign(curr.getReturnType(), guessedType) && NameMatcher.isSimilarName((String)curr.getName(), (String)identifier)) {
                    AST ast = astRoot.getAST();
                    ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                    String label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_changetomethod_description, (Object)ASTResolving.getMethodSignature((IMethodBinding)curr));
                    Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
                    LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, cu, rewrite, 8, image);
                    proposals.add(proposal);
                    MethodInvocation newInv = ast.newMethodInvocation();
                    newInv.setName(ast.newSimpleName(curr.getName()));
                    ITypeBinding[] parameterTypes = curr.getParameterTypes();
                    int k = 0;
                    while (k < parameterTypes.length) {
                        Expression arg = ASTNodeFactory.newDefaultExpression((AST)ast, (ITypeBinding)parameterTypes[k]);
                        newInv.arguments().add(arg);
                        proposal.addLinkedPosition(rewrite.track((ASTNode)arg), false, null);
                        ++k;
                    }
                    rewrite.replace((ASTNode)node, (ASTNode)newInv, null);
                }
                ++i;
            }
        }
        if (binding != null && binding.isArray()) {
            String idLength = "length";
            String label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_changevariable_description, (Object)idLength);
            proposals.add(new RenameNodeCorrectionProposal(label, cu, node.getStartPosition(), node.getLength(), idLength, 8));
        }
    }

    private static boolean canAssign(ITypeBinding returnType, ITypeBinding guessedType) {
        return returnType.isAssignmentCompatible(guessedType);
    }

    private static boolean hasMethodWithName(ITypeBinding typeBinding, String name) {
        IVariableBinding[] fields = typeBinding.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals(name)) {
                return true;
            }
            ++i;
        }
        ITypeBinding superclass = typeBinding.getSuperclass();
        if (superclass != null) {
            return UnresolvedElementsSubProcessor.hasMethodWithName(superclass, name);
        }
        return false;
    }

    private static boolean hasFieldWithName(ITypeBinding typeBinding, String name) {
        IMethodBinding[] methods = typeBinding.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(name)) {
                return true;
            }
            ++i;
        }
        ITypeBinding superclass = typeBinding.getSuperclass();
        if (superclass != null) {
            return UnresolvedElementsSubProcessor.hasMethodWithName(superclass, name);
        }
        return false;
    }

    private static int evauateTypeKind(ASTNode node, IJavaProject project) {
        int kind = ASTResolving.getPossibleTypeKinds((ASTNode)node, (boolean)JavaModelUtil.is50OrHigher((IJavaProject)project));
        return kind;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void getTypeProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        if (selectedNode.getParent() == null) {
            return;
        }
        int kind = UnresolvedElementsSubProcessor.evauateTypeKind(selectedNode, cu.getJavaProject());
        while (selectedNode != null && selectedNode.getLocationInParent() == QualifiedName.NAME_PROPERTY) {
            selectedNode = selectedNode.getParent();
        }
        if (selectedNode == null) {
            return;
        }
        Name node = null;
        if (selectedNode instanceof SimpleType) {
            node = ((SimpleType)selectedNode).getName();
        } else if (selectedNode instanceof ArrayType) {
            Type elementType = ((ArrayType)selectedNode).getElementType();
            if (!elementType.isSimpleType()) return;
            node = ((SimpleType)elementType).getName();
        } else {
            if (!(selectedNode instanceof Name)) return;
            node = (Name)selectedNode;
        }
        UnresolvedElementsSubProcessor.addSimilarTypeProposals(kind, cu, node, 3, proposals);
        while (node.getParent() instanceof QualifiedName) {
            node = (Name)node.getParent();
        }
        UnresolvedElementsSubProcessor.addNewTypeProposals(cu, node, kind, 0, proposals);
    }

    private static void addSimilarTypeProposals(int kind, ICompilationUnit cu, Name node, int relevance, Collection proposals) throws CoreException {
        SimilarElement[] elements = SimilarElementsRequestor.findSimilarElement((ICompilationUnit)cu, (Name)node, (int)kind);
        String resolvedTypeName = null;
        ITypeBinding binding = ASTResolving.guessBindingForTypeReference((ASTNode)node);
        if (binding != null) {
            ITypeBinding simpleBinding = binding;
            if (simpleBinding.isArray()) {
                simpleBinding = simpleBinding.getElementType();
            }
            simpleBinding = simpleBinding.getTypeDeclaration();
            resolvedTypeName = simpleBinding.getQualifiedName();
            CUCorrectionProposal proposal = UnresolvedElementsSubProcessor.createTypeRefChangeProposal(cu, resolvedTypeName, node, relevance + 2, elements.length);
            proposals.add(proposal);
            if (proposal instanceof AddImportCorrectionProposal) {
                proposal.setRelevance(relevance + elements.length + 2);
            }
            if (binding.isParameterizedType() && node.getParent() instanceof SimpleType && !(node.getParent().getParent() instanceof Type)) {
                proposals.add(UnresolvedElementsSubProcessor.createTypeRefChangeFullProposal(cu, binding, (ASTNode)node, relevance + 2));
            }
        } else {
            ITypeBinding normBinding;
            ASTNode normalizedNode = ASTNodes.getNormalizedNode((ASTNode)node);
            if (!(normalizedNode.getParent() instanceof Type) && node.getParent() != normalizedNode && (normBinding = ASTResolving.guessBindingForTypeReference((ASTNode)normalizedNode)) != null) {
                proposals.add(UnresolvedElementsSubProcessor.createTypeRefChangeFullProposal(cu, normBinding, normalizedNode, relevance + 2));
            }
        }
        int i = 0;
        while (i < elements.length) {
            String fullName;
            SimilarElement elem = elements[i];
            if ((elem.getKind() & 0x7E) != 0 && !(fullName = elem.getName()).equals(resolvedTypeName)) {
                proposals.add(UnresolvedElementsSubProcessor.createTypeRefChangeProposal(cu, fullName, node, relevance, elements.length));
            }
            ++i;
        }
    }

    private static CUCorrectionProposal createTypeRefChangeProposal(ICompilationUnit cu, String fullName, Name node, int relevance, int maxProposals) throws CoreException {
        ASTRewriteCorrectionProposal proposal;
        ImportRewrite importRewrite = null;
        String simpleName = fullName;
        String packName = Signature.getQualifier((String)fullName);
        if (packName.length() > 0) {
            importRewrite = StubUtility.createImportRewrite((CompilationUnit)((CompilationUnit)node.getRoot()), (boolean)true);
            simpleName = importRewrite.addImport(fullName);
        }
        if (!UnresolvedElementsSubProcessor.isLikelyTypeName(simpleName)) {
            relevance -= 2;
        }
        if (importRewrite != null && node.isSimpleName() && simpleName.equals(((SimpleName)node).getIdentifier())) {
            Object[] arg = new String[]{simpleName, packName};
            String label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_importtype_description, (Object[])arg);
            Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.imp_obj.gif");
            int boost = QualifiedTypeNameHistory.getBoost((String)fullName, (int)0, (int)maxProposals);
            proposal = new AddImportCorrectionProposal(label, cu, relevance + 100 + boost, image, packName, simpleName, (SimpleName)node);
            proposal.setCommandId(ADD_IMPORT_ID);
        } else {
            String label;
            if (packName.length() == 0) {
                label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_changetype_nopack_description, (Object)simpleName);
            } else {
                Object[] arg = new String[]{simpleName, packName};
                label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_changetype_description, (Object[])arg);
            }
            ASTRewrite rewrite = ASTRewrite.create((AST)node.getAST());
            rewrite.replace((ASTNode)node, rewrite.createStringPlaceholder(simpleName, 43), null);
            Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
            proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, relevance, image);
        }
        if (importRewrite != null) {
            proposal.setImportRewrite(importRewrite);
        }
        return proposal;
    }

    private static CUCorrectionProposal createTypeRefChangeFullProposal(ICompilationUnit cu, ITypeBinding binding, ASTNode node, int relevance) throws CoreException {
        ASTRewrite rewrite = ASTRewrite.create((AST)node.getAST());
        String label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_change_full_type_description, (Object)BindingLabelProvider.getBindingLabel((IBinding)binding, (long)0x200009L));
        Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, relevance + 3, image);
        ImportRewrite imports = proposal.createImportRewrite((CompilationUnit)node.getRoot());
        Type type = imports.addImport(binding, node.getAST());
        rewrite.replace(node, (ASTNode)type, null);
        return proposal;
    }

    private static boolean isLikelyTypeName(String name) {
        return name.length() > 0 && Character.isUpperCase(name.charAt(0));
    }

    private static boolean isLikelyPackageName(String name) {
        if (name.length() != 0) {
            int i = 0;
            do {
                if (!Character.isUpperCase(name.charAt(i))) continue;
                return false;
            } while ((i = name.indexOf(46, i) + 1) != 0 && i < name.length());
        }
        return true;
    }

    private static boolean isLikelyTypeParameterName(String name) {
        return name.length() == 1 && Character.isUpperCase(name.charAt(0));
    }

    private static void addNewTypeProposals(ICompilationUnit cu, Name refNode, int kind, int relevance, Collection proposals) throws JavaModelException {
        int rel;
        Name qualifier;
        Name node = refNode;
        do {
            IPackageFragment enclosing;
            boolean isPossibleName;
            String typeName = ASTNodes.getSimpleNameIdentifier((Name)node);
            qualifier = null;
            boolean bl = isPossibleName = UnresolvedElementsSubProcessor.isLikelyTypeName(typeName) || node == refNode;
            if (!isPossibleName) continue;
            IPackageFragment enclosingPackage = null;
            IType enclosingType = null;
            if (node.isSimpleName()) {
                enclosingPackage = (IPackageFragment)cu.getParent();
            } else {
                Name qualifierName = ((QualifiedName)node).getQualifier();
                IBinding binding = qualifierName.resolveBinding();
                if (binding instanceof ITypeBinding) {
                    enclosingType = (IType)binding.getJavaElement();
                } else if (binding instanceof IPackageBinding) {
                    qualifier = qualifierName;
                    enclosingPackage = (IPackageFragment)binding.getJavaElement();
                } else {
                    IJavaElement[] res = cu.codeSelect(qualifierName.getStartPosition(), qualifierName.getLength());
                    if (res != null && res.length > 0 && res[0] instanceof IType) {
                        enclosingType = (IType)res[0];
                    } else {
                        qualifier = qualifierName;
                        enclosingPackage = JavaModelUtil.getPackageFragmentRoot((IJavaElement)cu).getPackageFragment(ASTResolving.getFullName((Name)qualifierName));
                    }
                }
            }
            rel = relevance;
            if (enclosingPackage != null && UnresolvedElementsSubProcessor.isLikelyPackageName(enclosingPackage.getElementName())) {
                rel += 3;
            }
            if ((enclosingPackage == null || enclosingPackage.getCompilationUnit(String.valueOf(typeName) + ".java").exists()) && (enclosingType == null || enclosingType.isReadOnly() || enclosingType.getType(typeName).exists())) continue;
            Object object = enclosing = enclosingPackage != null ? enclosingPackage : enclosingType;
            if ((kind & 2) != 0) {
                proposals.add(new NewCUUsingWizardProposal(cu, node, 1, (IJavaElement)enclosing, rel + 2));
            }
            if ((kind & 4) != 0) {
                proposals.add(new NewCUUsingWizardProposal(cu, node, 2, (IJavaElement)enclosing, rel + 1));
            }
            if ((kind & 0x10) != 0) {
                proposals.add(new NewCUUsingWizardProposal(cu, node, 3, (IJavaElement)enclosing, rel));
            }
            if (kind != 8) continue;
            proposals.add(new NewCUUsingWizardProposal(cu, node, 4, (IJavaElement)enclosing, rel + 4));
        } while ((node = qualifier) != null);
        if (refNode.isSimpleName() && (kind & 0x20) != 0) {
            CompilationUnit root = (CompilationUnit)refNode.getRoot();
            String name = ((SimpleName)refNode).getIdentifier();
            Object declaration = ASTResolving.findParentBodyDeclaration((ASTNode)refNode);
            int baseRel = relevance;
            if (UnresolvedElementsSubProcessor.isLikelyTypeParameterName(name)) {
                baseRel += 4;
            }
            while (declaration != null) {
                IMethodBinding binding = null;
                rel = baseRel;
                if (declaration instanceof MethodDeclaration) {
                    binding = ((MethodDeclaration)declaration).resolveBinding();
                } else if (declaration instanceof TypeDeclaration) {
                    binding = ((TypeDeclaration)declaration).resolveBinding();
                    ++rel;
                }
                if (binding != null) {
                    AddTypeParameterProposal proposal = new AddTypeParameterProposal(cu, (IBinding)binding, root, name, null, rel);
                    proposals.add(proposal);
                }
                declaration = !Modifier.isStatic((int)declaration.getModifiers()) ? ASTResolving.findParentBodyDeclaration((ASTNode)declaration.getParent()) : null;
            }
        }
    }

    public static void getMethodProposals(IInvocationContext context, IProblemLocation problem, boolean isOnlyParameterMismatch, Collection proposals) throws CoreException {
        boolean isSuperInvocation;
        Expression sender;
        List arguments;
        MethodInvocation methodImpl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        SimpleName nameNode = (SimpleName)selectedNode;
        ASTNode invocationNode = nameNode.getParent();
        if (invocationNode instanceof MethodInvocation) {
            methodImpl = (MethodInvocation)invocationNode;
            arguments = methodImpl.arguments();
            sender = methodImpl.getExpression();
            isSuperInvocation = false;
        } else if (invocationNode instanceof SuperMethodInvocation) {
            methodImpl = (SuperMethodInvocation)invocationNode;
            arguments = methodImpl.arguments();
            sender = methodImpl.getQualifier();
            isSuperInvocation = true;
        } else {
            return;
        }
        String methodName = nameNode.getIdentifier();
        int nArguments = arguments.size();
        IBinding[] bindings = new ScopeAnalyzer(astRoot).getDeclarationsInScope(nameNode, 1);
        HashSet<String> suggestedRenames = new HashSet<String>();
        int i = 0;
        while (i < bindings.length) {
            IMethodBinding binding = (IMethodBinding)bindings[i];
            String curr = binding.getName();
            if (!curr.equals(methodName) && binding.getParameterTypes().length == nArguments && NameMatcher.isSimilarName((String)methodName, (String)curr) && suggestedRenames.add(curr)) {
                String label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_changemethod_description, (Object)curr);
                proposals.add(new RenameNodeCorrectionProposal(label, context.getCompilationUnit(), problem.getOffset(), problem.getLength(), curr, 6));
            }
            ++i;
        }
        suggestedRenames = null;
        if (isOnlyParameterMismatch) {
            ArrayList<IMethodBinding> parameterMismatchs = new ArrayList<IMethodBinding>();
            int i2 = 0;
            while (i2 < bindings.length) {
                IMethodBinding binding = (IMethodBinding)bindings[i2];
                if (binding.getName().equals(methodName)) {
                    parameterMismatchs.add(binding);
                }
                ++i2;
            }
            UnresolvedElementsSubProcessor.addParameterMissmatchProposals(context, problem, parameterMismatchs, invocationNode, arguments, proposals);
        }
        UnresolvedElementsSubProcessor.addNewMethodProposals(cu, astRoot, sender, arguments, isSuperInvocation, invocationNode, methodName, proposals);
        if (!isOnlyParameterMismatch && !isSuperInvocation && sender != null) {
            UnresolvedElementsSubProcessor.addMissingCastParentsProposal(cu, (MethodInvocation)invocationNode, proposals);
        }
        if (!isSuperInvocation && sender == null && invocationNode.getParent() instanceof ThrowStatement) {
            String str = "new ";
            String label = CorrectionMessages.UnresolvedElementsSubProcessor_addnewkeyword_description;
            int relevance = Character.isUpperCase(methodName.charAt(0)) ? 7 : 4;
            ReplaceCorrectionProposal proposal = new ReplaceCorrectionProposal(label, cu, invocationNode.getStartPosition(), 0, str, relevance);
            proposals.add(proposal);
        }
    }

    private static void addNewMethodProposals(ICompilationUnit cu, CompilationUnit astRoot, Expression sender, List arguments, boolean isSuperInvocation, ASTNode invocationNode, String methodName, Collection proposals) throws JavaModelException {
        ITypeBinding[] parameterTypes;
        ITypeBinding senderDeclBinding;
        ICompilationUnit targetCU;
        ITypeBinding nodeParentType = Bindings.getBindingOfParentType((ASTNode)invocationNode);
        ITypeBinding binding = null;
        if (sender != null) {
            binding = sender.resolveTypeBinding();
        } else {
            binding = nodeParentType;
            if (isSuperInvocation && binding != null) {
                binding = binding.getSuperclass();
            }
        }
        if (binding != null && binding.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)(senderDeclBinding = binding.getTypeDeclaration()))) != null && (parameterTypes = UnresolvedElementsSubProcessor.getParameterTypes(arguments)) != null) {
            ASTNode anonymDecl;
            Image image;
            String label;
            String sig = ASTResolving.getMethodSignature((String)methodName, (ITypeBinding[])parameterTypes, (boolean)false);
            if (UnresolvedElementsSubProcessor.isUseableTypeInContext(parameterTypes, (IBinding)senderDeclBinding, false)) {
                if (nodeParentType == senderDeclBinding) {
                    label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_createmethod_description, (Object)sig);
                    image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.methpri_obj.gif");
                } else {
                    label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_createmethod_other_description, (Object[])new Object[]{sig, senderDeclBinding.getName()});
                    image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.methpub_obj.gif");
                }
                proposals.add(new NewMethodCorrectionProposal(label, targetCU, invocationNode, arguments, senderDeclBinding, 5, image));
            }
            if (senderDeclBinding.isNested() && cu.equals(targetCU) && sender == null && Bindings.findMethodInHierarchy((ITypeBinding)senderDeclBinding, (String)methodName, null) == null && (anonymDecl = astRoot.findDeclaringNode((IBinding)senderDeclBinding)) != null && !(senderDeclBinding = Bindings.getBindingOfParentType((ASTNode)anonymDecl.getParent())).isAnonymous() && UnresolvedElementsSubProcessor.isUseableTypeInContext(parameterTypes, (IBinding)senderDeclBinding, false)) {
                Object[] args = new String[]{sig, ASTResolving.getTypeSignature((ITypeBinding)senderDeclBinding)};
                label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_createmethod_other_description, (Object[])args);
                image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.methpro_obj.gif");
                proposals.add(new NewMethodCorrectionProposal(label, targetCU, invocationNode, arguments, senderDeclBinding, 5, image));
            }
        }
    }

    public static boolean isUseableTypeInContext(ITypeBinding[] binding, IBinding context, boolean noWildcards) {
        int i = 0;
        while (i < binding.length) {
            if (!ASTResolving.isUseableTypeInContext((ITypeBinding)binding[i], (IBinding)context, (boolean)noWildcards)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void addMissingCastParentsProposal(ICompilationUnit cu, MethodInvocation invocationNode, Collection proposals) {
        Expression sender = invocationNode.getExpression();
        if (sender instanceof ThisExpression) {
            return;
        }
        ITypeBinding senderBinding = sender.resolveTypeBinding();
        if (senderBinding == null || Modifier.isFinal((int)senderBinding.getModifiers())) {
            return;
        }
        if (sender instanceof Name && ((Name)sender).resolveBinding() instanceof ITypeBinding) {
            return;
        }
        ASTNode parent = invocationNode.getParent();
        while (parent instanceof Expression && parent.getNodeType() != 11) {
            parent = parent.getParent();
        }
        boolean hasCastProposal = false;
        if (parent instanceof CastExpression) {
            hasCastProposal = UnresolvedElementsSubProcessor.useExistingParentCastProposal(cu, (CastExpression)parent, sender, invocationNode.getName(), UnresolvedElementsSubProcessor.getArgumentTypes(invocationNode.arguments()), proposals);
        }
        if (!hasCastProposal) {
            String label;
            Expression target = sender;
            while (target instanceof ParenthesizedExpression) {
                target = ((ParenthesizedExpression)target).getExpression();
            }
            if (target.getNodeType() != 11) {
                String targetName = null;
                if (target.getLength() <= 18) {
                    targetName = ASTNodes.asString((ASTNode)target);
                }
                label = targetName == null ? CorrectionMessages.UnresolvedElementsSubProcessor_methodtargetcast_description : Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_methodtargetcast2_description, (Object)targetName);
            } else {
                String targetName = null;
                if (target.getLength() <= 18) {
                    targetName = ASTNodes.asString((ASTNode)((CastExpression)target).getExpression());
                }
                label = targetName == null ? CorrectionMessages.UnresolvedElementsSubProcessor_changemethodtargetcast_description : Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_changemethodtargetcast2_description, (Object)targetName);
            }
            proposals.add(new CastCorrectionProposal(label, cu, target, null, 3));
        }
    }

    private static boolean useExistingParentCastProposal(ICompilationUnit cu, CastExpression expression, Expression accessExpression, SimpleName accessSelector, ITypeBinding[] paramTypes, Collection proposals) {
        ITypeBinding castType = expression.getType().resolveBinding();
        if (castType == null) {
            return false;
        }
        if (paramTypes != null ? Bindings.findMethodInHierarchy((ITypeBinding)castType, (String)accessSelector.getIdentifier(), (ITypeBinding[])paramTypes) == null : Bindings.findFieldInHierarchy((ITypeBinding)castType, (String)accessSelector.getIdentifier()) == null) {
            return false;
        }
        ITypeBinding bindingToCast = accessExpression.resolveTypeBinding();
        if (bindingToCast != null && !bindingToCast.isCastCompatible(castType)) {
            return false;
        }
        IMethodBinding res = Bindings.findMethodInHierarchy((ITypeBinding)castType, (String)accessSelector.getIdentifier(), (ITypeBinding[])paramTypes);
        if (res != null) {
            AST ast = expression.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            CastExpression newCast = ast.newCastExpression();
            newCast.setType((Type)ASTNode.copySubtree((AST)ast, (ASTNode)expression.getType()));
            newCast.setExpression((Expression)rewrite.createCopyTarget((ASTNode)accessExpression));
            ParenthesizedExpression parents = ast.newParenthesizedExpression();
            parents.setExpression((Expression)newCast);
            ASTNode node = rewrite.createCopyTarget((ASTNode)expression.getExpression());
            rewrite.replace((ASTNode)expression, node, null);
            rewrite.replace((ASTNode)accessExpression, (ASTNode)parents, null);
            String label = CorrectionMessages.UnresolvedElementsSubProcessor_missingcastbrackets_description;
            Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_cast.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 8, image);
            proposals.add(proposal);
            return true;
        }
        return false;
    }

    private static void addParameterMissmatchProposals(IInvocationContext context, IProblemLocation problem, List similarElements, ASTNode invocationNode, List arguments, Collection proposals) throws CoreException {
        int nSimilarElements = similarElements.size();
        ITypeBinding[] argTypes = UnresolvedElementsSubProcessor.getArgumentTypes(arguments);
        if (argTypes == null || nSimilarElements == 0) {
            return;
        }
        int i = 0;
        while (i < nSimilarElements) {
            IMethodBinding elem = (IMethodBinding)similarElements.get(i);
            int diff = elem.getParameterTypes().length - argTypes.length;
            if (diff == 0) {
                int nProposals = proposals.size();
                UnresolvedElementsSubProcessor.doEqualNumberOfParameters(context, invocationNode, problem, arguments, argTypes, elem, proposals);
                if (nProposals != proposals.size()) {
                    return;
                }
            } else if (diff > 0) {
                UnresolvedElementsSubProcessor.doMoreParameters(context, problem, invocationNode, arguments, argTypes, elem, proposals);
            } else {
                UnresolvedElementsSubProcessor.doMoreArguments(context, problem, invocationNode, arguments, argTypes, elem, proposals);
            }
            ++i;
        }
    }

    private static void doMoreParameters(IInvocationContext context, IProblemLocation problem, ASTNode invocationNode, List arguments, ITypeBinding[] argTypes, IMethodBinding methodBinding, Collection proposals) throws CoreException {
        ITypeBinding[] paramTypes = methodBinding.getParameterTypes();
        int k = 0;
        int nSkipped = 0;
        int diff = paramTypes.length - argTypes.length;
        int[] indexSkipped = new int[diff];
        int i = 0;
        while (i < paramTypes.length) {
            if (k < argTypes.length && UnresolvedElementsSubProcessor.canAssign(argTypes[k], paramTypes[i])) {
                ++k;
            } else {
                if (nSkipped >= diff) {
                    return;
                }
                indexSkipped[nSkipped++] = i;
            }
            ++i;
        }
        ITypeBinding declaringType = methodBinding.getDeclaringClass();
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        Object[] arg = new String[]{ASTResolving.getMethodSignature((IMethodBinding)methodBinding)};
        String label = diff == 1 ? Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_addargument_description, (Object[])arg) : Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_addarguments_description, (Object[])arg);
        AddArgumentCorrectionProposal proposal = new AddArgumentCorrectionProposal(label, context.getCompilationUnit(), invocationNode, indexSkipped, paramTypes, 8);
        proposal.setImage(JavaPluginImages.get((String)"org.eclipse.jdt.ui.add_correction.gif"));
        proposals.add(proposal);
        if (!declaringType.isFromSource()) {
            return;
        }
        ICompilationUnit targetCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)declaringType);
        if (targetCU != null) {
            IMethodBinding methodDecl = methodBinding.getMethodDeclaration();
            ITypeBinding[] declParameterTypes = methodDecl.getParameterTypes();
            ChangeMethodSignatureProposal.ChangeDescription[] changeDesc = new ChangeMethodSignatureProposal.ChangeDescription[declParameterTypes.length];
            ITypeBinding[] changedTypes = new ITypeBinding[diff];
            int i2 = diff - 1;
            while (i2 >= 0) {
                int idx = indexSkipped[i2];
                changeDesc[idx] = new ChangeMethodSignatureProposal.RemoveDescription();
                changedTypes[i2] = declParameterTypes[idx];
                --i2;
            }
            Object[] arg2 = new String[]{ASTResolving.getMethodSignature((IMethodBinding)methodDecl), UnresolvedElementsSubProcessor.getTypeNames(changedTypes)};
            String label2 = methodDecl.isConstructor() ? (diff == 1 ? Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_removeparam_constr_description, (Object[])arg2) : Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_removeparams_constr_description, (Object[])arg2)) : (diff == 1 ? Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_removeparam_description, (Object[])arg2) : Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_removeparams_description, (Object[])arg2));
            Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.remove_correction.gif");
            ChangeMethodSignatureProposal proposal2 = new ChangeMethodSignatureProposal(label2, targetCU, invocationNode, methodDecl, changeDesc, null, 5, image);
            proposals.add(proposal2);
        }
    }

    private static String getTypeNames(ITypeBinding[] types) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(ASTResolving.getTypeSignature((ITypeBinding)types[i]));
            ++i;
        }
        return buf.toString();
    }

    private static String getArgumentName(ICompilationUnit cu, List arguments, int index) {
        String def = String.valueOf(index + 1);
        ASTNode expr = (ASTNode)arguments.get(index);
        if (expr.getLength() > 18) {
            return def;
        }
        ASTMatcher matcher = new ASTMatcher();
        int i = 0;
        while (i < arguments.size()) {
            if (i != index && matcher.safeSubtreeMatch((Object)expr, arguments.get(i))) {
                return def;
            }
            ++i;
        }
        return String.valueOf('\'') + ASTNodes.asString((ASTNode)expr) + '\'';
    }

    private static void doMoreArguments(IInvocationContext context, IProblemLocation problem, ASTNode invocationNode, List arguments, ITypeBinding[] argTypes, IMethodBinding methodRef, Collection proposals) throws CoreException {
        ITypeBinding[] paramTypes = methodRef.getParameterTypes();
        int k = 0;
        int nSkipped = 0;
        int diff = argTypes.length - paramTypes.length;
        int[] indexSkipped = new int[diff];
        int i = 0;
        while (i < argTypes.length) {
            if (k < paramTypes.length && UnresolvedElementsSubProcessor.canAssign(argTypes[i], paramTypes[k])) {
                ++k;
            } else {
                if (nSkipped >= diff) {
                    return;
                }
                indexSkipped[nSkipped++] = i;
            }
            ++i;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        int i2 = diff - 1;
        while (i2 >= 0) {
            rewrite.remove((ASTNode)((Expression)arguments.get(indexSkipped[i2])), null);
            --i2;
        }
        Object[] arg = new String[]{ASTResolving.getMethodSignature((IMethodBinding)methodRef)};
        String label = diff == 1 ? Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_removeargument_description, (Object[])arg) : Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_removearguments_description, (Object[])arg);
        Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.remove_correction.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 8, image);
        proposals.add(proposal);
        IMethodBinding methodDecl = methodRef.getMethodDeclaration();
        ITypeBinding declaringType = methodDecl.getDeclaringClass();
        if (!declaringType.isFromSource()) {
            return;
        }
        ICompilationUnit targetCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)declaringType);
        if (targetCU != null) {
            boolean bl = !cu.equals(targetCU);
            if (UnresolvedElementsSubProcessor.isImplicitConstructor(methodDecl, targetCU)) {
                return;
            }
            ChangeMethodSignatureProposal.ChangeDescription[] changeDesc = new ChangeMethodSignatureProposal.ChangeDescription[argTypes.length];
            ITypeBinding[] changeTypes = new ITypeBinding[diff];
            int i3 = diff - 1;
            while (i3 >= 0) {
                int idx = indexSkipped[i3];
                Expression arg2 = (Expression)arguments.get(idx);
                String name = arg2 instanceof SimpleName ? ((SimpleName)arg2).getIdentifier() : null;
                ITypeBinding newType = Bindings.normalizeTypeBinding((ITypeBinding)argTypes[idx]);
                if (newType == null) {
                    newType = astRoot.getAST().resolveWellKnownType("java.lang.Object");
                }
                if (newType.isWildcardType()) {
                    newType = ASTResolving.normalizeWildcardType((ITypeBinding)newType, (boolean)true, (AST)astRoot.getAST());
                }
                if (!ASTResolving.isUseableTypeInContext((ITypeBinding)newType, (IBinding)methodDecl, (boolean)false)) {
                    return;
                }
                changeDesc[idx] = new ChangeMethodSignatureProposal.InsertDescription(newType, name);
                changeTypes[i3] = newType;
                --i3;
            }
            Object[] arg3 = new String[]{ASTResolving.getMethodSignature((IMethodBinding)methodDecl), UnresolvedElementsSubProcessor.getTypeNames(changeTypes)};
            String label2 = methodDecl.isConstructor() ? (diff == 1 ? Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_addparam_constr_description, (Object[])arg3) : Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_addparams_constr_description, (Object[])arg3)) : (diff == 1 ? Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_addparam_description, (Object[])arg3) : Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_addparams_description, (Object[])arg3));
            Image image2 = JavaPluginImages.get((String)"org.eclipse.jdt.ui.add_correction.gif");
            ChangeMethodSignatureProposal proposal2 = new ChangeMethodSignatureProposal(label2, targetCU, invocationNode, methodDecl, changeDesc, null, 5, image2);
            proposals.add(proposal2);
        }
    }

    private static boolean isImplicitConstructor(IMethodBinding meth, ICompilationUnit targetCU) {
        return meth.isDefaultConstructor();
    }

    private static ITypeBinding[] getParameterTypes(List args) {
        ITypeBinding[] params = new ITypeBinding[args.size()];
        int i = 0;
        while (i < args.size()) {
            Expression expr = (Expression)args.get(i);
            ITypeBinding curr = Bindings.normalizeTypeBinding((ITypeBinding)expr.resolveTypeBinding());
            if (curr != null && curr.isWildcardType()) {
                curr = ASTResolving.normalizeWildcardType((ITypeBinding)curr, (boolean)true, (AST)expr.getAST());
            }
            if (curr == null) {
                curr = expr.getAST().resolveWellKnownType("java.lang.Object");
            }
            params[i] = curr;
            ++i;
        }
        return params;
    }

    private static void doEqualNumberOfParameters(IInvocationContext context, ASTNode invocationNode, IProblemLocation problem, List arguments, ITypeBinding[] argTypes, IMethodBinding methodBinding, Collection proposals) throws CoreException {
        ChangeMethodSignatureProposal.ChangeDescription[] changeDesc;
        ICompilationUnit targetCU;
        Object[] arg;
        ITypeBinding[] paramTypes = methodBinding.getParameterTypes();
        int[] indexOfDiff = new int[paramTypes.length];
        int nDiffs = 0;
        int n = 0;
        while (n < argTypes.length) {
            if (!UnresolvedElementsSubProcessor.canAssign(argTypes[n], paramTypes[n])) {
                indexOfDiff[nDiffs++] = n;
            }
            ++n;
        }
        ITypeBinding declaringTypeDecl = methodBinding.getDeclaringClass().getTypeDeclaration();
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode nameNode = problem.getCoveringNode(astRoot);
        if (nameNode == null) {
            return;
        }
        if (nDiffs == 0) {
            MethodInvocation inv;
            if (nameNode.getParent() instanceof MethodInvocation && (inv = (MethodInvocation)nameNode.getParent()).getExpression() == null) {
                UnresolvedElementsSubProcessor.addQualifierToOuterProposal(context, inv, methodBinding, proposals);
            }
            return;
        }
        if (nDiffs == 1) {
            int idx = indexOfDiff[0];
            Expression nodeToCast = (Expression)arguments.get(idx);
            ITypeBinding castType = paramTypes[idx];
            if ((castType = Bindings.normalizeTypeBinding((ITypeBinding)castType)).isWildcardType()) {
                castType = ASTResolving.normalizeWildcardType((ITypeBinding)castType, (boolean)false, (AST)nodeToCast.getAST());
            }
            if (castType != null) {
                ITypeBinding binding = nodeToCast.resolveTypeBinding();
                if (binding == null || binding.isCastCompatible(castType)) {
                    ASTRewriteCorrectionProposal proposal = TypeMismatchSubProcessor.createCastProposal((IInvocationContext)context, (ITypeBinding)castType, (Expression)nodeToCast, (int)6);
                    String castTypeName = BindingLabelProvider.getBindingLabel((IBinding)castType, (long)0x200009L);
                    arg = new String[]{UnresolvedElementsSubProcessor.getArgumentName(cu, arguments, idx), castTypeName};
                    proposal.setDisplayName(Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_addargumentcast_description, (Object[])arg));
                    proposals.add(proposal);
                }
                TypeMismatchSubProcessor.addChangeSenderTypeProposals((IInvocationContext)context, (Expression)nodeToCast, (ITypeBinding)castType, (boolean)false, (int)5, (Collection)proposals);
            }
        }
        if (nDiffs == 2) {
            boolean canSwap;
            int idx1 = indexOfDiff[0];
            int idx2 = indexOfDiff[1];
            boolean bl = canSwap = UnresolvedElementsSubProcessor.canAssign(argTypes[idx1], paramTypes[idx2]) && UnresolvedElementsSubProcessor.canAssign(argTypes[idx2], paramTypes[idx1]);
            if (canSwap) {
                ICompilationUnit targetCU2;
                Expression arg1 = (Expression)arguments.get(idx1);
                Expression arg2 = (Expression)arguments.get(idx2);
                ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
                rewrite.replace((ASTNode)arg1, rewrite.createCopyTarget((ASTNode)arg2), null);
                rewrite.replace((ASTNode)arg2, rewrite.createCopyTarget((ASTNode)arg1), null);
                arg = new String[]{UnresolvedElementsSubProcessor.getArgumentName(cu, arguments, idx1), UnresolvedElementsSubProcessor.getArgumentName(cu, arguments, idx2)};
                String label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_swaparguments_description, (Object[])arg);
                Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
                ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 8, image);
                proposals.add(proposal);
                if (declaringTypeDecl.isFromSource() && (targetCU2 = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)declaringTypeDecl)) != null) {
                    ChangeMethodSignatureProposal.ChangeDescription[] changeDesc2 = new ChangeMethodSignatureProposal.ChangeDescription[paramTypes.length];
                    int i = 0;
                    while (i < nDiffs) {
                        changeDesc2[idx1] = new ChangeMethodSignatureProposal.SwapDescription(idx2);
                        ++i;
                    }
                    IMethodBinding methodDecl = methodBinding.getMethodDeclaration();
                    ITypeBinding[] declParamTypes = methodDecl.getParameterTypes();
                    ITypeBinding[] swappedTypes = new ITypeBinding[]{declParamTypes[idx1], declParamTypes[idx2]};
                    Object[] args = new String[]{ASTResolving.getMethodSignature((IMethodBinding)methodDecl), UnresolvedElementsSubProcessor.getTypeNames(swappedTypes)};
                    String label2 = methodDecl.isConstructor() ? Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_swapparams_constr_description, (Object[])args) : Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_swapparams_description, (Object[])args);
                    Image image2 = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
                    ChangeMethodSignatureProposal proposal2 = new ChangeMethodSignatureProposal(label2, targetCU2, invocationNode, methodDecl, changeDesc2, null, 5, image2);
                    proposals.add(proposal2);
                }
                return;
            }
        }
        if (declaringTypeDecl.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)declaringTypeDecl)) != null && (changeDesc = UnresolvedElementsSubProcessor.createSignatureChangeDescription(indexOfDiff, nDiffs, paramTypes, arguments, argTypes)) != null) {
            IMethodBinding methodDecl = methodBinding.getMethodDeclaration();
            ITypeBinding[] declParamTypes = methodDecl.getParameterTypes();
            ITypeBinding[] newParamTypes = new ITypeBinding[changeDesc.length];
            int i = 0;
            while (i < newParamTypes.length) {
                newParamTypes[i] = changeDesc[i] == null ? declParamTypes[i] : ((ChangeMethodSignatureProposal.EditDescription)changeDesc[i]).type;
                ++i;
            }
            Object[] args = new String[]{ASTResolving.getMethodSignature((IMethodBinding)methodDecl), ASTResolving.getMethodSignature((String)methodDecl.getName(), (ITypeBinding[])newParamTypes, (boolean)false)};
            String label = methodDecl.isConstructor() ? Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_changeparamsignature_constr_description, (Object[])args) : Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_changeparamsignature_description, (Object[])args);
            Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
            ChangeMethodSignatureProposal proposal = new ChangeMethodSignatureProposal(label, targetCU, invocationNode, methodDecl, changeDesc, null, 7, image);
            proposals.add(proposal);
        }
    }

    private static ChangeMethodSignatureProposal.ChangeDescription[] createSignatureChangeDescription(int[] indexOfDiff, int nDiffs, ITypeBinding[] paramTypes, List arguments, ITypeBinding[] argTypes) {
        ChangeMethodSignatureProposal.ChangeDescription[] changeDesc = new ChangeMethodSignatureProposal.ChangeDescription[paramTypes.length];
        int i = 0;
        while (i < nDiffs) {
            int diffIndex = indexOfDiff[i];
            Expression arg = (Expression)arguments.get(diffIndex);
            String name = arg instanceof SimpleName ? ((SimpleName)arg).getIdentifier() : null;
            ITypeBinding argType = argTypes[diffIndex];
            if (argType.isWildcardType() && (argType = ASTResolving.normalizeWildcardType((ITypeBinding)argType, (boolean)true, (AST)arg.getAST())) == null) {
                return null;
            }
            changeDesc[diffIndex] = new ChangeMethodSignatureProposal.EditDescription(argType, name);
            ++i;
        }
        return changeDesc;
    }

    private static ITypeBinding[] getArgumentTypes(List arguments) {
        ITypeBinding[] res = new ITypeBinding[arguments.size()];
        int i = 0;
        while (i < res.length) {
            Expression expression = (Expression)arguments.get(i);
            ITypeBinding curr = expression.resolveTypeBinding();
            if (curr == null) {
                return null;
            }
            if (!curr.isNullType() && (curr = Bindings.normalizeTypeBinding((ITypeBinding)curr)) == null) {
                curr = expression.getAST().resolveWellKnownType("java.lang.Object");
            }
            res[i] = curr;
            ++i;
        }
        return res;
    }

    private static void addQualifierToOuterProposal(IInvocationContext context, MethodInvocation invocationNode, IMethodBinding binding, Collection proposals) throws CoreException {
        Name newExpression;
        ITypeBinding parentType;
        ITypeBinding declaringType = binding.getDeclaringClass();
        ITypeBinding currType = parentType = Bindings.getBindingOfParentType((ASTNode)invocationNode);
        boolean isInstanceMethod = !Modifier.isStatic((int)binding.getModifiers());
        while (currType != null && !Bindings.isSuperType((ITypeBinding)declaringType, (ITypeBinding)currType)) {
            if (isInstanceMethod && Modifier.isStatic((int)currType.getModifiers())) {
                return;
            }
            currType = currType.getDeclaringClass();
        }
        if (currType == null || currType == parentType) {
            return;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)invocationNode.getAST());
        String label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_changetoouter_description, (Object)ASTResolving.getTypeSignature((ITypeBinding)currType));
        Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 8, image);
        ImportRewrite imports = proposal.createImportRewrite(context.getASTRoot());
        AST ast = invocationNode.getAST();
        String qualifier = imports.addImport(currType);
        Name name = ASTNodeFactory.newName((AST)ast, (String)qualifier);
        if (isInstanceMethod) {
            ThisExpression expr = ast.newThisExpression();
            expr.setQualifier(name);
            newExpression = expr;
        } else {
            newExpression = name;
        }
        rewrite.set((ASTNode)invocationNode, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)newExpression, null);
        proposals.add(proposal);
    }

    public static void getConstructorProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ITypeBinding targetDecl;
        ICompilationUnit targetCU;
        ITypeBinding typeBinding;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        ITypeBinding targetBinding = null;
        List arguments = null;
        IMethodBinding recursiveConstructor = null;
        int type = selectedNode.getNodeType();
        if (type == 14) {
            ClassInstanceCreation creation = (ClassInstanceCreation)selectedNode;
            targetBinding = creation.getType().resolveBinding();
            arguments = creation.arguments();
        } else if (type == 46) {
            typeBinding = Bindings.getBindingOfParentType((ASTNode)selectedNode);
            if (typeBinding != null && !typeBinding.isAnonymous()) {
                targetBinding = typeBinding.getSuperclass();
                arguments = ((SuperConstructorInvocation)selectedNode).arguments();
            }
        } else if (type == 17 && (typeBinding = Bindings.getBindingOfParentType((ASTNode)selectedNode)) != null && !typeBinding.isAnonymous()) {
            targetBinding = typeBinding;
            arguments = ((ConstructorInvocation)selectedNode).arguments();
            recursiveConstructor = ASTResolving.findParentMethodDeclaration((ASTNode)selectedNode).resolveBinding();
        }
        if (targetBinding == null) {
            return;
        }
        IMethodBinding[] methods = targetBinding.getDeclaredMethods();
        ArrayList<IMethodBinding> similarElements = new ArrayList<IMethodBinding>();
        int i = 0;
        while (i < methods.length) {
            IMethodBinding curr = methods[i];
            if (curr.isConstructor() && recursiveConstructor != curr) {
                similarElements.add(curr);
            }
            ++i;
        }
        UnresolvedElementsSubProcessor.addParameterMissmatchProposals(context, problem, similarElements, selectedNode, arguments, proposals);
        if (targetBinding.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)(targetDecl = targetBinding.getTypeDeclaration()))) != null) {
            Object[] args = new String[]{ASTResolving.getMethodSignature((String)ASTResolving.getTypeSignature((ITypeBinding)targetDecl), (ITypeBinding[])UnresolvedElementsSubProcessor.getParameterTypes(arguments), (boolean)false)};
            String label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_createconstructor_description, (Object[])args);
            Image image = JavaElementImageProvider.getDecoratedImage((ImageDescriptor)JavaPluginImages.DESC_MISC_PUBLIC, (int)512, (Point)JavaElementImageProvider.SMALL_SIZE);
            proposals.add(new NewMethodCorrectionProposal(label, targetCU, selectedNode, arguments, targetDecl, 5, image));
        }
    }

    public static void getAmbiguosTypeReferenceProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        int offset = problem.getOffset();
        int len = problem.getLength();
        IJavaElement[] elements = cu.codeSelect(offset, len);
        int i = 0;
        while (i < elements.length) {
            IJavaElement curr = elements[i];
            if (curr instanceof IType && !TypeFilter.isFiltered((IType)((IType)curr))) {
                String qualifiedTypeName = ((IType)curr).getFullyQualifiedName('.');
                CompilationUnit root = context.getASTRoot();
                String label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_importexplicit_description, (Object)qualifiedTypeName);
                Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.imp_obj.gif");
                ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, ASTRewrite.create((AST)root.getAST()), 5, image);
                ImportRewrite imports = proposal.createImportRewrite(root);
                imports.addImport(qualifiedTypeName);
                proposals.add(proposal);
            }
            ++i;
        }
    }

    public static void getArrayAccessProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        CompilationUnit root = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(root);
        if (!(selectedNode instanceof MethodInvocation)) {
            return;
        }
        MethodInvocation decl = (MethodInvocation)selectedNode;
        SimpleName nameNode = decl.getName();
        String methodName = nameNode.getIdentifier();
        IBinding[] bindings = new ScopeAnalyzer(root).getDeclarationsInScope(nameNode, 1);
        int i = 0;
        while (i < bindings.length) {
            String currName = bindings[i].getName();
            if (NameMatcher.isSimilarName((String)methodName, (String)currName)) {
                String label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_arraychangetomethod_description, (Object)currName);
                proposals.add(new RenameNodeCorrectionProposal(label, context.getCompilationUnit(), nameNode.getStartPosition(), nameNode.getLength(), currName, 6));
            }
            ++i;
        }
        String lengthId = "length";
        String label = CorrectionMessages.UnresolvedElementsSubProcessor_arraychangetolength_description;
        int offset = nameNode.getStartPosition();
        int length = decl.getStartPosition() + decl.getLength() - offset;
        proposals.add(new RenameNodeCorrectionProposal(label, context.getCompilationUnit(), offset, length, lengthId, 7));
    }

    public static void getAnnotationMemberProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit targetCU;
        String memberName;
        Annotation annotation;
        CompilationUnit astRoot = context.getASTRoot();
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode.getLocationInParent() == MemberValuePair.NAME_PROPERTY) {
            if (selectedNode.getParent().getLocationInParent() != NormalAnnotation.VALUES_PROPERTY) {
                return;
            }
            annotation = (Annotation)selectedNode.getParent().getParent();
            memberName = ((SimpleName)selectedNode).getIdentifier();
        } else if (selectedNode.getLocationInParent() == SingleMemberAnnotation.VALUE_PROPERTY) {
            annotation = (Annotation)selectedNode.getParent();
            memberName = "value";
        } else {
            return;
        }
        ITypeBinding annotBinding = annotation.resolveTypeBinding();
        if (annotBinding == null) {
            return;
        }
        if (annotation instanceof NormalAnnotation) {
            IMethodBinding[] otherMembers = annotBinding.getDeclaredMethods();
            int i = 0;
            while (i < otherMembers.length) {
                IMethodBinding binding = otherMembers[i];
                String curr = binding.getName();
                int relevance = NameMatcher.isSimilarName((String)memberName, (String)curr) ? 6 : 3;
                String label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_UnresolvedElementsSubProcessor_changetoattribute_description, (Object)curr);
                proposals.add(new RenameNodeCorrectionProposal(label, cu, problem.getOffset(), problem.getLength(), curr, relevance));
                ++i;
            }
        }
        if (annotBinding.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)annotBinding)) != null) {
            String label = Messages.format((String)CorrectionMessages.UnresolvedElementsSubProcessor_UnresolvedElementsSubProcessor_createattribute_description, (Object)memberName);
            Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.methpub_obj.gif");
            proposals.add(new NewAnnotationMemberProposal(label, targetCU, selectedNode, annotBinding, 5, image));
        }
    }
}

