/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.ui.preferences.PreferencePageBuilder;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.ui.wizards.PathBlockWorkbookPage;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public abstract class PathBlock
implements PreferencePageBuilder.AJDTPathBlockPage {
    protected static final int IDX_ADDJAR = 3;
    protected static final int IDX_ADDEXT = 4;
    protected static final int IDX_ADDVAR = 5;
    protected static final int IDX_ADDFOL = 6;
    protected static final int IDX_ADDCON = 7;
    protected static final int IDX_ADDPRJ = 8;
    protected static final int IDX_EDIT = 9;
    protected static final int IDX_REMOVE = 10;
    static final String RESTRICTED_TO = "Restricted to";
    static final String NO_RESTRICTIONS = "<no restrictions>";
    private int fPageIndex;
    private IJavaProject fCurrJProject;
    private String fUserSettingsTimeStamp;
    protected final IWorkspaceRoot fWorkspaceRoot = AspectJPlugin.getWorkspace().getRoot();
    protected TreeListDialogField fPathList;
    protected IStatusChangeListener fContext;
    protected StatusInfo fPathStatus;
    protected StatusInfo fJavaBuildPathStatus;
    private PathBlockWorkbookPage workbookPage;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_12;

    protected PathBlock(IStatusChangeListener context, int pageToShow) {
        this.fContext = context;
        this.fPageIndex = pageToShow;
        LibrariesAdapter adapter = new LibrariesAdapter();
        String[] stringArray = new String[11];
        stringArray[3] = UIMessages.PathLibrariesWorkbookPage_libraries_addjar_button;
        stringArray[4] = UIMessages.PathLibrariesWorkbookPage_libraries_addextjar_button;
        stringArray[5] = UIMessages.PathLibrariesWorkbookPage_libraries_addvariable_button;
        stringArray[6] = UIMessages.PathLibrariesWorkbookPage_libraries_addclassfolder_button;
        stringArray[7] = UIMessages.PathLibrariesWorkbookPage_libraries_addlibrary_button;
        stringArray[8] = UIMessages.PathLibrariesWorkbookPage_libraries_addproject_button;
        stringArray[9] = UIMessages.PathLibrariesWorkbookPage_libraries_edit_button;
        stringArray[10] = UIMessages.PathLibrariesWorkbookPage_libraries_remove_button;
        String[] buttonLabels = stringArray;
        this.fPathList = new TreeListDialogField((ITreeListAdapter)adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fPathList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fPathList.setRemoveButtonIndex(10);
        this.fPathList.enableButton(10, false);
        this.fPathList.enableButton(9, false);
        this.fCurrJProject = null;
        this.fJavaBuildPathStatus = new StatusInfo();
        this.fPathStatus = new StatusInfo();
        this.workbookPage = new PathBlockWorkbookPage(this.fPathList);
    }

    protected abstract void internalSetProjectPath(List<CPListElement> var1, StringBuffer var2, StringBuffer var3, StringBuffer var4);

    protected abstract String getBlockNote();

    public abstract String getBlockTitle();

    protected abstract String getPathAttributeName();

    protected abstract String getRestrictionPathAttrName();

    public void init() {
        this.initializeTimeStamp();
        this.updatePathStatus();
    }

    private void libaryPageSelectionChanged(DialogField field) {
        List selElements = this.fPathList.getSelectedElements();
        this.fPathList.enableButton(10, this.canRemove(selElements));
        this.fPathList.enableButton(9, this.canEdit(selElements));
    }

    private void libaryPageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject != null) {
            this.updatePathStatus();
            this.doStatusLineUpdate();
        }
    }

    private void libaryPageCustomButtonPressed(DialogField field, int index) {
        Object[] libentries = null;
        switch (index) {
            case 3: {
                libentries = this.openJarFileDialog();
                break;
            }
            case 4: {
                libentries = this.openExtJarFileDialog();
                break;
            }
            case 5: {
                libentries = this.openVariableSelectionDialog();
                break;
            }
            case 6: {
                libentries = this.openClassFolderDialog();
                break;
            }
            case 7: {
                libentries = this.openContainerSelectionDialog();
                break;
            }
            case 8: {
                libentries = this.openProjectSelectionDialog();
                break;
            }
            case 9: {
                this.editRestictions(this.fPathList.getSelectedElements());
                return;
            }
            case 10: {
                this.removeEntry();
                return;
            }
        }
        if (libentries != null) {
            int nElementsChosen = libentries.length;
            List cplist = this.fPathList.getElements();
            ArrayList<CPListElement> elementsToAdd = new ArrayList<CPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                CPListElement curr = libentries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                    curr.setAttribute("sourcepath", (Object)BuildPathSupport.guessSourceAttachment((CPListElement)curr));
                }
                ++i;
            }
            if (!elementsToAdd.isEmpty() && index == 6) {
                this.askForAddingExclusionPatternsDialog(elementsToAdd);
            }
            this.fPathList.addElements(elementsToAdd);
            this.fPathList.postSetSelection((ISelection)new StructuredSelection(libentries));
            this.updatePathStatus();
            this.doStatusLineUpdate();
        }
    }

    void editRestictions(List<?> selectedElements) {
        CPListElementAttribute attr;
        boolean success;
        if (selectedElements == null || selectedElements.size() != 1) {
            return;
        }
        Object o = selectedElements.get(0);
        if (o instanceof CPListElementAttribute && (success = this.workbookPage.editCustomEntry(attr = (CPListElementAttribute)o))) {
            this.fPathList.refresh(o);
        }
    }

    protected void doStatusLineUpdate() {
        if (this.fContext != null) {
            IStatus res = this.findMostSevereStatus();
            this.fContext.statusChanged(res);
        }
    }

    private void updatePathStatus() {
        this.fPathStatus.setOK();
        List elements = this.fPathList.getElements();
        CPListElement entryMissing = null;
        int nEntriesMissing = 0;
        IClasspathEntry[] entries = new IClasspathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPListElement currElement = (CPListElement)elements.get(i);
            entries[i] = currElement.getClasspathEntry();
            if (currElement.isMissing()) {
                ++nEntriesMissing;
                if (entryMissing == null) {
                    entryMissing = currElement;
                }
            }
            --i;
        }
        if (nEntriesMissing > 0) {
            if (nEntriesMissing == 1) {
                this.fPathStatus.setWarning(UIMessages.InPathBlock_warning_EntryMissing);
            } else {
                this.fPathStatus.setWarning(UIMessages.InPathBlock_warning_EntriesMissing);
            }
        }
        this.updateJavaBuildPathStatus();
    }

    protected void updateJavaBuildPathStatus() {
        IPath outPath;
        List elements = this.fPathList.getElements();
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        int i = elements.size() - 1;
        while (i >= 0) {
            CPListElement currElement = (CPListElement)elements.get(i);
            if (!this.inClasspathContainer(currElement)) {
                entries.add(currElement.getClasspathEntry());
            }
            --i;
        }
        try {
            outPath = this.fCurrJProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            outPath = this.fCurrJProject.getPath();
        }
        IClasspathEntry[] entriesArr = entries.toArray(new IClasspathEntry[0]);
        IJavaModelStatus status = JavaConventions.validateClasspath((IJavaProject)this.fCurrJProject, (IClasspathEntry[])entriesArr, (IPath)outPath);
        if (!status.isOK()) {
            this.fJavaBuildPathStatus.setError(status.getMessage());
            return;
        }
        IJavaModelStatus dupStatus = this.checkForDuplicates(this.fCurrJProject, entriesArr);
        if (!dupStatus.isOK()) {
            this.fJavaBuildPathStatus.setError(dupStatus.getMessage());
            return;
        }
        this.fJavaBuildPathStatus.setOK();
    }

    /*
     * Exception decompiling
     */
    private IJavaModelStatus checkForDuplicates(IJavaProject currJProject, IClasspathEntry[] entries) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void removeEntry() {
        List selElements = this.fPathList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                attrib.getParent().setAttribute(attrib.getKey(), null);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fPathList.refresh();
            this.fPathList.dialogFieldChanged();
        } else {
            this.fPathList.removeElements(selElements);
        }
    }

    private boolean canEdit(List<?> selElements) {
        Object o;
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        return elem instanceof CPListElementAttribute && (o = ((CPListElementAttribute)elem).getValue()) != null && o instanceof String;
    }

    private boolean canRemove(List<?> selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            CPListElement curr;
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute ? ((CPListElementAttribute)elem).getValue() == null : elem instanceof CPListElement && this.inClasspathContainer(curr = (CPListElement)elem)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean inClasspathContainer(CPListElement element) {
        IClasspathAttribute[] attributes = element.getClasspathEntry().getExtraAttributes();
        int i = 0;
        while (i < attributes.length) {
            if ((AspectJCorePreferences.isAspectPathAttribute((IClasspathAttribute)attributes[i]) || AspectJCorePreferences.isInPathAttribute((IClasspathAttribute)attributes[i])) && !attributes[i].getValue().equals(attributes[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IClasspathContainer getClasspathContainer(IClasspathEntry classpathEntry) {
        IClasspathAttribute[] attributes = classpathEntry.getExtraAttributes();
        int i = 0;
        while (i < attributes.length) {
            if ((AspectJCorePreferences.isAspectPathAttribute((IClasspathAttribute)attributes[i]) || AspectJCorePreferences.isInPathAttribute((IClasspathAttribute)attributes[i])) && attributes[i].getValue() != null && !attributes[i].getValue().equals(attributes[i].getName())) {
                try {
                    return JavaCore.getClasspathContainer((IPath)new Path(attributes[i].getValue()), (IJavaProject)this.fCurrJProject);
                }
                catch (JavaModelException javaModelException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_6);
                }
            }
            ++i;
        }
        return null;
    }

    private void askForAddingExclusionPatternsDialog(List<CPListElement> newEntries) {
        HashSet modified = new HashSet();
        if (!modified.isEmpty()) {
            String title = UIMessages.InPathLibrariesWorkbookPage_exclusion_added_title;
            String message = UIMessages.InPathLibrariesWorkbookPage_exclusion_added_message;
            MessageDialog.openInformation((Shell)AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
        }
    }

    private CPListElement[] openClassFolderDialog() {
        IPath[] selected = BuildPathDialogAccess.chooseClassFolderEntries((Shell)this.getShell(), (IPath)this.fCurrJProject.getPath(), (IPath[])this.getUsedContainers());
        if (selected != null) {
            ArrayList<CPListElement> res = new ArrayList<CPListElement>();
            int i = 0;
            while (i < selected.length) {
                IPath curr = selected[i];
                IResource resource = this.fWorkspaceRoot.findMember(curr);
                if (resource instanceof IContainer) {
                    res.add(this.newCPLibraryElement(resource));
                }
                ++i;
            }
            return res.toArray(new CPListElement[res.size()]);
        }
        return null;
    }

    private CPListElement[] openJarFileDialog() {
        IPath[] selected = BuildPathDialogAccess.chooseJAREntries((Shell)this.getShell(), (IPath)this.fCurrJProject.getPath(), (IPath[])this.getUsedContainers());
        if (selected != null) {
            ArrayList<CPListElement> res = new ArrayList<CPListElement>();
            int i = 0;
            while (i < selected.length) {
                IPath curr = selected[i];
                IResource resource = this.fWorkspaceRoot.findMember(curr);
                String outJar = AspectJCorePreferences.getProjectOutJar((IProject)this.fCurrJProject.getProject());
                StringBuffer projectOutJar = new StringBuffer();
                projectOutJar.append(this.fCurrJProject.getPath().toString());
                projectOutJar.append("/" + outJar);
                if (resource.getFullPath().toString().equals(projectOutJar.toString())) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)UIMessages.buildpathwarning_title, (String)UIMessages.addtoinpathwarning);
                } else if (resource instanceof IFile) {
                    res.add(this.newCPLibraryElement(resource));
                }
                ++i;
            }
            return res.toArray(new CPListElement[res.size()]);
        }
        return null;
    }

    private CPListElement[] openExtJarFileDialog() {
        IPath[] selected = BuildPathDialogAccess.chooseExternalJAREntries((Shell)this.getShell());
        if (selected != null) {
            ArrayList<CPListElement> res = new ArrayList<CPListElement>();
            int i = 0;
            while (i < selected.length) {
                res.add(new CPListElement(this.fCurrJProject, 1, selected[i], null));
                ++i;
            }
            return res.toArray(new CPListElement[res.size()]);
        }
        return null;
    }

    private CPListElement[] openVariableSelectionDialog() {
        List existingElements = this.fPathList.getElements();
        ArrayList<IPath> existingPaths = new ArrayList<IPath>(existingElements.size());
        int i = 0;
        while (i < existingElements.size()) {
            CPListElement elem = (CPListElement)existingElements.get(i);
            if (elem.getEntryKind() == 4) {
                existingPaths.add(elem.getPath());
            }
            ++i;
        }
        IPath[] existingPathsArray = existingPaths.toArray(new IPath[existingPaths.size()]);
        IPath[] paths = BuildPathDialogAccess.chooseVariableEntries((Shell)this.getShell(), (IPath[])existingPathsArray);
        if (paths != null) {
            ArrayList<CPListElement> result = new ArrayList<CPListElement>();
            int i2 = 0;
            while (i2 < paths.length) {
                CPListElement elem = new CPListElement(this.fCurrJProject, 4, paths[i2], null);
                IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)paths[i2]);
                elem.setIsMissing(resolvedPath == null || !resolvedPath.toFile().exists());
                if (!existingElements.contains(elem)) {
                    result.add(elem);
                }
                ++i2;
            }
            return result.toArray(new CPListElement[result.size()]);
        }
        return null;
    }

    private CPListElement[] openContainerSelectionDialog() {
        IClasspathEntry[] created = BuildPathDialogAccess.chooseContainerEntries((Shell)this.getShell(), (IJavaProject)this.fCurrJProject, (IClasspathEntry[])this.getRawClasspath());
        if (created != null) {
            int i;
            try {
                IClasspathEntry[] existing = this.getJavaProject().getRawClasspath();
                i = 0;
                while (i < created.length) {
                    int j = 0;
                    while (j < existing.length) {
                        if (created[i].getPath().equals((Object)existing[j].getPath())) {
                            created[i] = existing[j];
                        }
                        ++j;
                    }
                    created[i] = AspectJCorePreferences.ensureHasAttribute((IClasspathEntry)created[i], (String)this.getRestrictionPathAttrName(), (String)"");
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_7, (JoinPoint.StaticPart)ajc$tjp_8);
            }
            CPListElement[] res = new CPListElement[created.length];
            i = 0;
            while (i < res.length) {
                res[i] = CPListElement.createFromExisting((IClasspathEntry)created[i], (IJavaProject)this.getJavaProject());
                ++i;
            }
            return res;
        }
        return null;
    }

    private CPListElement[] openProjectSelectionDialog() {
        try {
            ArrayList<IJavaProject> selectable = new ArrayList<IJavaProject>();
            selectable.addAll(Arrays.asList(this.fCurrJProject.getJavaModel().getJavaProjects()));
            selectable.remove(this.fCurrJProject);
            List elements = this.fPathList.getElements();
            int i = 0;
            while (i < elements.size()) {
                CPListElement curr = (CPListElement)elements.get(0);
                if (curr.getEntryKind() == 2) {
                    IJavaProject proj = (IJavaProject)JavaCore.create((IResource)curr.getResource());
                    selectable.remove(proj);
                }
                ++i;
            }
            Object[] selectArr = selectable.toArray();
            new JavaElementComparator().sort(null, selectArr);
            ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), Arrays.asList(selectArr), (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new JavaUILabelProvider(), NewWizardMessages.ProjectsWorkbookPage_chooseProjects_message);
            dialog.setTitle("Select Projects");
            dialog.setHelpAvailable(false);
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                CPListElement[] cpElements = new CPListElement[result.length];
                int i2 = 0;
                while (i2 < result.length) {
                    IJavaProject curr = (IJavaProject)result[i2];
                    cpElements[i2] = new CPListElement(this.fCurrJProject, 2, curr.getPath(), curr.getResource());
                    ++i2;
                }
                return cpElements;
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_9, (JoinPoint.StaticPart)ajc$tjp_10);
        }
        return null;
    }

    private IClasspathEntry[] getRawClasspath() {
        IClasspathEntry[] currEntries = new IClasspathEntry[this.fPathList.getSize()];
        int i = 0;
        while (i < currEntries.length) {
            CPListElement curr = (CPListElement)this.fPathList.getElement(i);
            currEntries[i] = curr.getClasspathEntry();
            ++i;
        }
        return currEntries;
    }

    private CPListElement newCPLibraryElement(IResource res) {
        return new CPListElement(this.fCurrJProject, 1, res.getFullPath(), res);
    }

    private IPath[] getUsedContainers() {
        ArrayList<IPath> res = new ArrayList<IPath>();
        if (this.fCurrJProject.exists()) {
            try {
                IPath outputLocation = this.fCurrJProject.getOutputLocation();
                if (outputLocation != null && outputLocation.segmentCount() > 1) {
                    res.add(outputLocation);
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_11, (JoinPoint.StaticPart)ajc$tjp_12);
            }
        }
        List cplist = this.fPathList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && (resource = elem.getResource()) instanceof IContainer) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    public TabItem tabContent(TabFolder folder) {
        ImageRegistry imageRegistry = JavaPlugin.getDefault().getImageRegistry();
        TabItem item = new TabItem(folder, 0);
        item.setText(this.getBlockTitle());
        item.setImage(imageRegistry.get("org.eclipse.jdt.ui.library_obj.gif"));
        item.setData((Object)this.workbookPage);
        item.setControl(this.workbookPage.getControl((Composite)folder));
        Control control = item.getControl();
        if (control instanceof Composite) {
            Label label = new Label((Composite)control, 16448);
            label.setText(this.getBlockNote());
        }
        return item;
    }

    public void configureJavaProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(NLS.bind((String)UIMessages.PathBlock_operationdesc_java, (Object)this.getBlockTitle()));
        monitor.beginTask("", 10);
        try {
            this.internalConfigureJavaProject(this.fPathList.getElements(), monitor);
            this.initializeTimeStamp();
        }
        finally {
            monitor.done();
        }
    }

    protected StringBuffer removeFinalPathSeparatorChar(StringBuffer buffer) {
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == File.pathSeparatorChar) {
            buffer = buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer;
    }

    protected void internalConfigureJavaProject(List pathElements, IProgressMonitor monitor) throws CoreException, InterruptedException {
        int nEntries = pathElements.size();
        ArrayList<IClasspathEntry> pathEntries = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < nEntries) {
            CPListElement element = (CPListElement)pathElements.get(i);
            if (!this.inClasspathContainer(element)) {
                pathEntries.add(element.getClasspathEntry());
            }
            ++i;
        }
        monitor.worked(2);
        HashMap<IPath, String> inpathRestrictions = new HashMap<IPath, String>();
        HashMap<IPath, String> aspectpathRestrictions = new HashMap<IPath, String>();
        StringBuffer pathBuffer = new StringBuffer();
        StringBuffer contentKindBuffer = new StringBuffer();
        StringBuffer entryKindBuffer = new StringBuffer();
        for (IClasspathEntry pathEntry : pathEntries) {
            String aspectpathRestriction;
            pathBuffer.append(pathEntry.getPath());
            pathBuffer.append(File.pathSeparator);
            contentKindBuffer.append(pathEntry.getContentKind());
            contentKindBuffer.append(File.pathSeparator);
            entryKindBuffer.append(pathEntry.getEntryKind());
            entryKindBuffer.append(File.pathSeparator);
            String inpathRestriction = AspectJCorePreferences.getRestriction((IClasspathEntry)pathEntry, (String)"org.eclipse.ajdt.inpath.restriction");
            if (inpathRestriction != null && inpathRestriction.length() > 0) {
                inpathRestrictions.put(pathEntry.getPath(), inpathRestriction);
            }
            if ((aspectpathRestriction = AspectJCorePreferences.getRestriction((IClasspathEntry)pathEntry, (String)"org.eclipse.ajdt.aspectpath.restriction")) == null || aspectpathRestriction.length() <= 0) continue;
            aspectpathRestrictions.put(pathEntry.getPath(), aspectpathRestriction);
        }
        pathBuffer = this.removeFinalPathSeparatorChar(pathBuffer);
        contentKindBuffer = this.removeFinalPathSeparatorChar(contentKindBuffer);
        entryKindBuffer = this.removeFinalPathSeparatorChar(entryKindBuffer);
        this.internalSetProjectPath(pathElements, pathBuffer, contentKindBuffer, entryKindBuffer);
        if (inpathRestrictions.size() > 0 || aspectpathRestrictions.size() > 0) {
            IClasspathEntry[] entries = this.getJavaProject().getRawClasspath();
            boolean hasChanges = false;
            if (inpathRestrictions.size() > 0) {
                hasChanges |= this.updatePathRestrictions(entries, inpathRestrictions, false);
            }
            if (aspectpathRestrictions.size() > 0) {
                hasChanges |= this.updatePathRestrictions(entries, aspectpathRestrictions, true);
            }
            if (hasChanges) {
                this.getJavaProject().setRawClasspath(entries, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    private boolean updatePathRestrictions(IClasspathEntry[] entries, Map<IPath, String> restrictions, boolean isAspectPath) {
        String restrictionKind = isAspectPath ? "org.eclipse.ajdt.aspectpath.restriction" : "org.eclipse.ajdt.inpath.restriction";
        boolean hasChanges = false;
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 5 && restrictions.containsKey(entries[i].getPath())) {
                String restrictionStr = restrictions.get(entries[i].getPath());
                entries[i] = AspectJCorePreferences.updatePathRestrictions((IClasspathEntry)entries[i], (String)restrictionStr, (String)restrictionKind);
                hasChanges = true;
            }
            ++i;
        }
        return hasChanges;
    }

    protected List<CPListElement> getExistingEntries(IClasspathEntry[] pathEntries) {
        ArrayList<CPListElement> newPath = new ArrayList<CPListElement>();
        int i = 0;
        while (i < pathEntries.length) {
            IClasspathEntry curr = pathEntries[i];
            if (curr.getEntryKind() == 5) {
                curr = AspectJCorePreferences.ensureHasAttribute((IClasspathEntry)curr, (String)this.getRestrictionPathAttrName(), (String)"");
            }
            newPath.add(CPListElement.createFromExisting((IClasspathEntry)curr, (IJavaProject)this.fCurrJProject));
            ++i;
        }
        return newPath;
    }

    protected Shell getShell() {
        return AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getShell();
    }

    protected IJavaProject getJavaProject() {
        return this.fCurrJProject;
    }

    protected void setJavaProject(IJavaProject project) {
        this.fCurrJProject = project;
    }

    protected IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere((IStatus[])new IStatus[]{this.fPathStatus, this.fJavaBuildPathStatus});
    }

    public int getPageIndex() {
        return this.fPageIndex;
    }

    protected String getEncodedSettings() {
        StringBuffer buf = new StringBuffer();
        int nElements = this.fPathList.getSize();
        buf.append('[').append(nElements).append(']');
        int i = 0;
        while (i < nElements) {
            CPListElement elem = (CPListElement)this.fPathList.getElement(i);
            elem.appendEncodedSettings(buf);
            ++i;
        }
        return buf.toString();
    }

    public boolean hasChangesInDialog() {
        String currSettings = this.getEncodedSettings();
        return !currSettings.equals(this.fUserSettingsTimeStamp);
    }

    public void initializeTimeStamp() {
        this.fUserSettingsTimeStamp = this.getEncodedSettings();
    }

    static {
        PathBlock.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PathBlock.java", PathBlock.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.PathBlock", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 384);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "updateJavaBuildPathStatus", "org.eclipse.ajdt.internal.ui.wizards.PathBlock", "", "", "", "void"), 368);
        ajc$tjp_10 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "openProjectSelectionDialog", "org.eclipse.ajdt.internal.ui.wizards.PathBlock", "", "", "", "[Lorg.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;"), 738);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.PathBlock", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 799);
        ajc$tjp_12 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getUsedContainers", "org.eclipse.ajdt.internal.ui.wizards.PathBlock", "", "", "", "[Lorg.eclipse.core.runtime.IPath;"), 790);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.PathBlock", "org.eclipse.jdt.core.JavaModelException", "e"), 497);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "checkForDuplicates", "org.eclipse.ajdt.internal.ui.wizards.PathBlock", "org.eclipse.jdt.core.IJavaProject:[Lorg.eclipse.jdt.core.IClasspathEntry;", "currJProject:entries", "", "org.eclipse.jdt.core.IJavaModelStatus"), 420);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.PathBlock", "org.eclipse.jdt.core.JavaModelException", "e"), 497);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.PathBlock", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 594);
        ajc$tjp_6 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getClasspathContainer", "org.eclipse.ajdt.internal.ui.wizards.PathBlock", "org.eclipse.jdt.core.IClasspathEntry", "classpathEntry", "", "org.eclipse.jdt.core.IClasspathContainer"), 583);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.PathBlock", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 726);
        ajc$tjp_8 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "openContainerSelectionDialog", "org.eclipse.ajdt.internal.ui.wizards.PathBlock", "", "", "", "[Lorg.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;"), 710);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.PathBlock", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 768);
    }

    protected class LibrariesAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        protected LibrariesAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            PathBlock.this.libaryPageDialogFieldChanged(field);
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            PathBlock.this.libaryPageCustomButtonPressed((DialogField)field, index);
        }

        public void doubleClicked(TreeListDialogField field) {
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof CPListElement) {
                CPListElement listElement = (CPListElement)element;
                IClasspathEntry entry = listElement.getClasspathEntry();
                IClasspathContainer container = PathBlock.this.getClasspathContainer(entry);
                if (container != null) {
                    return new Object[]{"From: " + container.getDescription()};
                }
                if (entry.getEntryKind() == 5) {
                    Object[] children = listElement.getChildren(true);
                    int i = 0;
                    while (i < children.length) {
                        if (children[i] instanceof CPListElementAttribute && !((CPListElementAttribute)children[i]).isBuiltIn() && ((CPListElementAttribute)children[i]).getClasspathAttribute().getName().equals(PathBlock.this.getRestrictionPathAttrName())) {
                            return new Object[]{children[i]};
                        }
                        ++i;
                    }
                }
            }
            return null;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            Object[] children = this.getChildren(field, element);
            return children != null && children.length > 0;
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
        }

        public void selectionChanged(TreeListDialogField field) {
            PathBlock.this.libaryPageSelectionChanged((DialogField)field);
        }
    }
}

