/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.autotools.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class AutotoolsBuildConfiguration
extends CBuildConfiguration {
    public static final String AUTOTOOLS_GENERATOR = "autotools.generator";
    public static final String AUTOTOOLS_ARGUMENTS = "autotools.arguments";
    public static final String BUILD_COMMAND = "autotools.command.build";
    public static final String CLEAN_COMMAND = "autotools.command.clean";

    public AutotoolsBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        super(config, name);
    }

    public AutotoolsBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain) {
        super(config, name, toolChain, "run");
    }

    public AutotoolsBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, String launchMode) {
        super(config, name, toolChain, launchMode);
    }

    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        this.executeRemote(List.of("autoreconf", "--install"), project.getLocation(), console, monitor);
        String configure = "./configure";
        java.nio.file.Path cmdPath = java.nio.file.Path.of(project.getLocation().toString(), configure);
        if (cmdPath.toFile().exists()) {
            configure = cmdPath.toAbsolutePath().toString();
        }
        this.executeRemote(List.of(configure), (IPath)new Path(this.getBuildDirectory().toString()), console, monitor);
        this.executeRemote(List.of("make"), (IPath)new Path(this.getBuildDirectory().toString()), console, monitor);
        return new IProject[]{project};
    }

    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        this.executeRemote(List.of("make", "clean"), (IPath)new Path(this.getBuildDirectory().toString()), console, monitor);
    }

    protected void executeRemote(List<String> command, IPath processCwd, IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        String commandJoined = String.join((CharSequence)" ", command);
        try {
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream outStream = console.getOutputStream();
            Throwable throwable = null;
            Object var9_11 = null;
            try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
                epm.setOutputStream((OutputStream)console.getOutputStream());
                IEnvironmentVariable[] env = new IEnvironmentVariable[]{};
                outStream.write("Building in: " + processCwd.toString() + "\n");
                outStream.write("Running: " + commandJoined + "\n");
                Process p = this.startBuildProcess(command, env, processCwd, console, monitor);
                if (p == null) {
                    console.getErrorStream().write("Error executing: " + commandJoined);
                    throw new CoreException(Status.error((String)("Error executing: " + commandJoined)));
                }
                this.watchProcess(new IConsoleParser[]{epm}, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            project.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)("Error executing: " + commandJoined), (Throwable)e));
        }
    }
}

