/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.ui.view;

import java.text.MessageFormat;
import org.eclipse.cdt.testsrunner.internal.TestsRunnerPlugin;
import org.eclipse.cdt.testsrunner.internal.ui.view.UIViewMessages;
import org.eclipse.cdt.testsrunner.model.ITestItem;
import org.eclipse.cdt.testsrunner.model.ITestingSession;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CounterPanel
extends Composite {
    private ITestingSession testingSession;
    private Label failedCounterLabel;
    private Label abortedCounterLabel;
    private Label currentCounterLabel;
    private boolean hasSkipped;
    private final Image errorIcon = TestsRunnerPlugin.createAutoImage("ovr16/failed_counter.gif");
    private final Image failureIcon = TestsRunnerPlugin.createAutoImage("ovr16/aborted_counter.gif");

    public CounterPanel(Composite parent, ITestingSession testingSession) {
        super(parent, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 9;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.currentCounterLabel = this.createLabel(UIViewMessages.CounterPanel_tests_run, null);
        this.abortedCounterLabel = this.createLabel(UIViewMessages.CounterPanel_tests_erred, this.errorIcon);
        this.failedCounterLabel = this.createLabel(UIViewMessages.CounterPanel_tests_failed, this.failureIcon);
        this.setTestingSession(testingSession);
    }

    private Label createLabel(String name, Image image) {
        Label label = new Label((Composite)this, 0);
        if (image != null) {
            image.setBackground(label.getBackground());
            label.setImage(image);
        }
        label.setLayoutData((Object)new GridData(32));
        label = new Label((Composite)this, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData(32));
        Label value = new Label((Composite)this, 8);
        value.setLayoutData((Object)new GridData(800));
        return value;
    }

    public void setTestingSession(ITestingSession testingSession) {
        this.testingSession = testingSession;
        this.hasSkipped = testingSession.getCount(ITestItem.Status.Skipped) != 0;
        this.updateInfoFromSession();
    }

    public void updateInfoFromSession() {
        this.setFailedCounter(this.testingSession.getCount(ITestItem.Status.Failed));
        this.setAbortedCounter(this.testingSession.getCount(ITestItem.Status.Aborted));
        this.setCurrentCounter(this.testingSession.getCurrentCounter(), this.testingSession.getCount(ITestItem.Status.Skipped));
        this.redraw();
    }

    private void setFailedCounter(int newValue) {
        this.failedCounterLabel.setText(Integer.toString(newValue));
    }

    private void setAbortedCounter(int newValue) {
        this.abortedCounterLabel.setText(Integer.toString(newValue));
    }

    private void setCurrentCounter(int currentValue, int skippedValue) {
        if (!this.hasSkipped && skippedValue != 0) {
            this.layout();
        }
        String runString = skippedValue == 0 ? Integer.toString(currentValue) : MessageFormat.format(UIViewMessages.CounterPanel_tests_skipped, currentValue, skippedValue);
        this.currentCounterLabel.setText(runString);
    }
}

